/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.design;

import com.tplus.transform.design.DesignerType;
import com.tplus.transform.design.DesignerTypeCategory;
import com.tplus.transform.design.ValidationHelper;
import com.tplus.transform.lang.Wrapper;
import com.tplus.transform.util.CalendarFormatter;
import com.tplus.transform.util.CalendarParser;
import com.tplus.transform.util.EnumObject;
import com.tplus.transform.util.StringUtils;
import com.tplus.transform.util.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public abstract class DesignerTypeImpl
extends Type
implements DesignerType {
    private static final EnumObject.EnumClassObjectInfo objInfo = new EnumObject.EnumClassObjectInfo(DesignerType.class);
    public static final DesignerType DESIGNER_STRING_TYPE = new DesignerTypeImpl("String"){

        public boolean isValidValue(String value, String format) {
            return true;
        }

        public DesignerTypeCategory getTypeCategory() {
            return DesignerTypeCategory.TEXT;
        }
    };
    static final DesignerType DESIGNER_SCALED_DECIMAL_TYPE = new DesignerTypeImpl("ScaledDecimal"){

        public DesignerTypeCategory getTypeCategory() {
            return DesignerTypeCategory.DECIMAL;
        }

        public boolean isValidValue(String value, String format) {
            try {
                Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                return false;
            }
            return true;
        }

        public boolean isNumeric() {
            return true;
        }
    };
    static final DesignerType DESIGNER_INT_TYPE = new DesignerTypeImpl("Integer"){

        public boolean isValidValue(String value, String format) {
            try {
                Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                return false;
            }
            return true;
        }

        public DesignerTypeCategory getTypeCategory() {
            return DesignerTypeCategory.INTEGRAL;
        }

        public boolean isNumeric() {
            return true;
        }
    };
    static final DesignerType DESIGNER_CHAR_TYPE = new DesignerTypeImpl("Character"){

        public boolean isValidValue(String value, String format) {
            return value.length() == 1;
        }

        public DesignerTypeCategory getTypeCategory() {
            return DesignerTypeCategory.TEXT;
        }
    };
    static final DesignerType DESIGNER_FLOAT_TYPE = new DesignerTypeImpl("Float"){

        public DesignerTypeCategory getTypeCategory() {
            return DesignerTypeCategory.DECIMAL;
        }

        public boolean isValidValue(String value, String format) {
            try {
                Float.parseFloat(value);
            }
            catch (NumberFormatException e) {
                return false;
            }
            return true;
        }

        public boolean isAssignableFrom(DesignerType srcType) {
            return super.isAssignableFrom(srcType) || DESIGNER_INT_TYPE.equals(srcType);
        }

        public boolean isNumeric() {
            return true;
        }
    };
    static final DesignerType DESIGNER_DOUBLE_TYPE = new DesignerTypeImpl("Double"){

        public DesignerTypeCategory getTypeCategory() {
            return DesignerTypeCategory.DECIMAL;
        }

        public boolean isValidValue(String value, String format) {
            try {
                Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                return false;
            }
            return true;
        }

        public boolean isAssignableFrom(DesignerType srcType) {
            return super.isAssignableFrom(srcType) || DESIGNER_INT_TYPE.equals(srcType) || DESIGNER_FLOAT_TYPE.equals(srcType);
        }

        public boolean isNumeric() {
            return true;
        }
    };
    public static final DesignerType DESIGNER_SECTION_TYPE = new DesignerTypeImpl("Section"){

        public DesignerTypeCategory getTypeCategory() {
            return DesignerTypeCategory.MESSAGE;
        }

        public boolean isValidValue(String value, String format) {
            return true;
        }

        public boolean isSectionType() {
            return true;
        }
    };
    static final DesignerType DESIGNER_LONG_TYPE = new DesignerTypeImpl("Long"){

        public DesignerTypeCategory getTypeCategory() {
            return DesignerTypeCategory.INTEGRAL;
        }

        public boolean isValidValue(String value, String format) {
            try {
                Wrapper.parseLong(value);
            }
            catch (NumberFormatException e) {
                return false;
            }
            return true;
        }

        public boolean isAssignableFrom(DesignerType srcType) {
            return super.isAssignableFrom(srcType) || DESIGNER_INT_TYPE.equals(srcType);
        }

        public boolean isNumeric() {
            return true;
        }
    };
    static final DesignerType DESIGNER_BOOLEAN_TYPE = new DesignerTypeImpl("Boolean"){

        public DesignerTypeCategory getTypeCategory() {
            return DesignerTypeCategory.BOOLEAN;
        }

        public boolean isValidValue(String value, String format) {
            return value.equals("true") || value.equals("false");
        }
    };
    static final DesignerType DESIGNER_VOID_TYPE = new DesignerTypeImpl("Void"){

        public DesignerTypeCategory getTypeCategory() {
            return DesignerTypeCategory.VOID;
        }

        public boolean isValidValue(String value, String format) {
            return false;
        }
    };
    static final DesignerType DESIGNER_DATE_TIME_TYPE = new DesignerDateType("DateTime"){

        public String getDefaultFormat() {
            return "yyyyMMdd-HH:mm:ss.SSS";
        }

        public String getCanonicalFormat() {
            return DesignerTypeImpl.ISO_DATE_TIME_FORMAT_NO_TZ;
        }
    };
    static final DesignerType DESIGNER_TIME_ONLY_TYPE = new DesignerDateType("TimeOnly"){

        public String getDefaultFormat() {
            return "HH:mm:ss";
        }

        public String getCanonicalFormat() {
            return DesignerTypeImpl.ISO_TIME_FORMAT_NO_TZ;
        }
    };
    static final DesignerType DESIGNER_DATE_ONLY_TYPE = new DesignerDateType("DateOnly"){

        public String getDefaultFormat() {
            return "yyyyMMdd";
        }

        public String getCanonicalFormat() {
            return DesignerTypeImpl.ISO_DATE_FORMAT_NO_TZ;
        }
    };
    public static final DesignerISODateType DESIGNER_ISO_DATE_TIME_TYPE = new DesignerISODateType("ISODateTime"){

        public String getDefaultFormat() {
            return DesignerTypeImpl.ISO_DATE_TIME_FORMAT;
        }
    };
    public static final DesignerISODateType DESIGNER_ISO_TIME_TYPE = new DesignerISODateType("ISOTime"){

        public String getDefaultFormat() {
            return DesignerTypeImpl.ISO_TIME_FORMAT;
        }
    };
    public static final DesignerISODateType DESIGNER_ISO_DATE_TYPE = new DesignerISODateType("ISODate"){

        public String getDefaultFormat() {
            return DesignerTypeImpl.ISO_DATE_FORMAT;
        }
    };
    static final DesignerType DESIGNER_BINARY_TYPE = new DesignerTypeImpl("Binary"){

        public DesignerTypeCategory getTypeCategory() {
            return DesignerTypeCategory.RAW;
        }

        public boolean isValidValue(String value, String format) {
            if (value.length() % 2 != 0) {
                return false;
            }
            for (int i = 0; i < value.length(); ++i) {
                char c = Character.toUpperCase(value.charAt(i));
                if (Character.isDigit(c) || c >= 'A' && c <= 'F') continue;
                return false;
            }
            return true;
        }
    };
    static final DesignerType DESIGNER_RAW_MESSAGE_TYPE = new DesignerTypeImpl("RawMessage"){

        public DesignerTypeCategory getTypeCategory() {
            return DesignerTypeCategory.RAW;
        }

        public boolean isValidValue(String value, String format) {
            for (int i = 0; i < value.length(); ++i) {
                char c = Character.toUpperCase(value.charAt(i));
                if (Character.isDigit(c) || c >= 'A' && c <= 'F') continue;
                return false;
            }
            return true;
        }
    };
    public static final DesignerType DESIGNER_MAP_TYPE = new DesignerTypeImpl("Map"){

        public DesignerTypeCategory getTypeCategory() {
            return DesignerTypeCategory.MAP;
        }

        public boolean isValidValue(String value, String format) {
            return true;
        }
    };
    static final DesignerType DESIGNER_OBJECT_TYPE = new DesignerTypeImpl("Object"){

        public DesignerTypeCategory getTypeCategory() {
            return DesignerTypeCategory.ANY;
        }

        public boolean isValidValue(String value, String format) {
            return true;
        }
    };
    static final DesignerType DESIGNER_BIG_INT_TYPE = new DesignerTypeImpl("BigInteger"){

        public DesignerTypeCategory getTypeCategory() {
            return DesignerTypeCategory.INTEGRAL;
        }

        public boolean isValidValue(String value, String format) {
            try {
                new BigInteger(value);
            }
            catch (NumberFormatException e) {
                return false;
            }
            return true;
        }

        public boolean isNumeric() {
            return true;
        }
    };
    public static final DesignerType DESIGNER_BIG_DECIMAL_TYPE = new DesignerTypeImpl("BigDecimal"){

        public DesignerTypeCategory getTypeCategory() {
            return DesignerTypeCategory.DECIMAL;
        }

        public boolean isValidValue(String value, String format) {
            try {
                new BigDecimal(value);
            }
            catch (NumberFormatException e) {
                return false;
            }
            return true;
        }

        public boolean isNumeric() {
            return true;
        }
    };
    static final DesignerType DESIGNER_DATAOBJECT_TYPE = new DesignerTypeImpl("DataObject"){

        public DesignerTypeCategory getTypeCategory() {
            return DesignerTypeCategory.MESSAGE;
        }

        public boolean isValidValue(String value, String format) {
            return false;
        }

        public boolean isSectionType() {
            return true;
        }

        public boolean isMessageType() {
            return true;
        }
    };
    static final DesignerListType DESIGNER_BIG_DECIMAL_LIST_TYPE = new DesignerListType(DESIGNER_BIG_DECIMAL_TYPE);
    static final DesignerListType DESIGNER_BIG_INT_LIST_TYPE = new DesignerListType(DESIGNER_BIG_INT_TYPE);
    static final DesignerListType DESIGNER_BINARY_LIST_TYPE = new DesignerListType(DESIGNER_BINARY_TYPE);
    static final DesignerListType DESIGNER_BOOLEAN_LIST_TYPE = new DesignerListType(DESIGNER_BOOLEAN_TYPE);
    static final DesignerListType DESIGNER_CHAR_LIST_TYPE = new DesignerListType(DESIGNER_CHAR_TYPE);
    static final DesignerListType DESIGNER_SCALED_DECIMAL_LIST_TYPE = new DesignerListType(DESIGNER_SCALED_DECIMAL_TYPE);
    static final DesignerListType DESIGNER_DATE_ONLY_LIST_TYPE = new DesignerListType(DESIGNER_DATE_ONLY_TYPE);
    static final DesignerListType DESIGNER_DATE_TIME_LIST_TYPE = new DesignerListType(DESIGNER_DATE_TIME_TYPE);
    static final DesignerListType DESIGNER_DOUBLE_LIST_TYPE = new DesignerListType(DESIGNER_DOUBLE_TYPE);
    static final DesignerListType DESIGNER_FLOAT_LIST_TYPE = new DesignerListType(DESIGNER_FLOAT_TYPE);
    static final DesignerListType DESIGNER_INT_LIST_TYPE = new DesignerListType(DESIGNER_INT_TYPE);
    static final DesignerListType DESIGNER_ISO_DATE_LIST_TYPE = new DesignerListType(DESIGNER_ISO_DATE_TYPE);
    static final DesignerListType DESIGNER_ISO_DATE_TIME_LIST_TYPE = new DesignerListType(DESIGNER_ISO_DATE_TIME_TYPE);
    static final DesignerListType DESIGNER_ISO_TIME_LIST_TYPE = new DesignerListType(DESIGNER_ISO_TIME_TYPE);
    static final DesignerListType DESIGNER_LONG_LIST_TYPE = new DesignerListType(DESIGNER_LONG_TYPE);
    static final DesignerListType DESIGNER_STRING_LIST_TYPE = new DesignerListType(DESIGNER_STRING_TYPE);
    static final DesignerListType DESIGNER_TIME_ONLY_LIST_TYPE = new DesignerListType(DESIGNER_TIME_ONLY_TYPE);
    static final DesignerListType DESIGNER_RAW_MESSAGE_LIST_TYPE = new DesignerListType(DESIGNER_RAW_MESSAGE_TYPE);
    static final DesignerListType DESIGNER_OBJECT_LIST_TYPE = new DesignerListType(DESIGNER_OBJECT_TYPE);
    static final DesignerListType DESIGNER_MAP_LIST_TYPE = new DesignerListType(DESIGNER_MAP_TYPE);
    public static final String ISO_DATE_TIME_FORMAT = "%Y-%M-%DT%h:%m:%s%z";
    public static final String ISO_DATE_FORMAT = "%Y-%M-%D%z";
    public static final String ISO_TIME_FORMAT = "%h:%m:%s%z";
    public static final String ISO_DATE_TIME_FORMAT_NO_TZ = "%Y-%M-%DT%h:%m:%s";
    public static final String ISO_DATE_FORMAT_NO_TZ = "%Y-%M-%D";
    public static final String ISO_TIME_FORMAT_NO_TZ = "%h:%m:%s";

    protected DesignerTypeImpl(String name, int ordinal) {
        super(name, ordinal);
    }

    protected DesignerTypeImpl(String name) {
        super(name);
    }

    public static DesignerType[] values() {
        return (DesignerType[])objInfo.values();
    }

    public static String[] names() {
        return objInfo.names();
    }

    public static DesignerType valueOf(String name) {
        return (DesignerType)((Object)objInfo.valueOf(name));
    }

    public static DesignerType valueOf(int ordinal) {
        return (DesignerType)((Object)objInfo.valueOf(ordinal));
    }

    protected EnumObject.EnumClassObjectInfo getEnumClassObjectInfo() {
        return objInfo;
    }

    public boolean isSectionType() {
        return false;
    }

    public boolean isMessageType() {
        return false;
    }

    public boolean isListType() {
        return false;
    }

    public abstract boolean isValidValue(String var1, String var2);

    public boolean isNumeric() {
        return false;
    }

    public boolean isAssignableFrom(DesignerType srcType) {
        return this.equals(srcType);
    }

    public boolean isValidFormat(String parsingFormat) throws IllegalArgumentException {
        return true;
    }

    public String getDefaultFormat() {
        throw new IllegalArgumentException("Format applicable only for date types; Not a date type - " + this);
    }

    public String getCanonicalFormat() {
        return this.getDefaultFormat();
    }

    public static final class DesignerListType
    extends DesignerTypeImpl {
        private DesignerType componentType;

        protected DesignerListType(DesignerType componentType) {
            super(componentType.getName() + "List");
            this.componentType = componentType;
        }

        public DesignerType getComponentType() {
            return this.componentType;
        }

        public boolean isAssignableFrom(DesignerType srcType) {
            if (srcType instanceof DesignerListType) {
                DesignerListType srcListType = (DesignerListType)srcType;
                return this.componentType.isAssignableFrom(srcListType.componentType);
            }
            return false;
        }

        public boolean isListType() {
            return true;
        }

        public DesignerTypeCategory getTypeCategory() {
            return DesignerTypeCategory.LIST;
        }

        public boolean isValidValue(String value, String format) {
            return false;
        }
    }

    public static abstract class DesignerISODateType
    extends DesignerTypeImpl {
        protected DesignerISODateType(String name) {
            super(name);
        }

        public DesignerTypeCategory getTypeCategory() {
            return DesignerTypeCategory.DATE;
        }

        public abstract String getDefaultFormat();

        protected DesignerISODateType(String name, int ordinal) {
            super(name, ordinal);
        }

        public boolean isValidValue(String value, String format) {
            try {
                DesignerISODateType.parseISODate(value, format);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                return false;
            }
            return true;
        }

        public static Calendar parseISODate(String arg, String format) throws IllegalArgumentException {
            return CalendarParser.parse(format, arg);
        }

        public boolean isAssignableFrom(DesignerType srcType) {
            return srcType instanceof DesignerISODateType;
        }

        public static String formatISODate(Calendar date, String format) {
            return CalendarFormatter.format(format, date);
        }
    }

    static abstract class DesignerDateType
    extends DesignerTypeImpl {
        static final String SIMPLE_DATE_FORMAT = "yyyyMMdd";
        static final String SIMPLE_TIME_FORMAT = "HH:mm:ss";
        static final String SIMPLE_DATE_TIME_FORMAT = "yyyyMMdd-HH:mm:ss.SSS";

        protected DesignerDateType(String name) {
            super(name);
        }

        protected DesignerDateType(String name, int ordinal) {
            super(name, ordinal);
        }

        public boolean isValidFormat(String parsingFormat) throws IllegalArgumentException {
            String designerDataFormat = DesignerDateType.getDesignerDateFormat(parsingFormat);
            ValidationHelper.validateDatePattern(designerDataFormat);
            return true;
        }

        public DesignerTypeCategory getTypeCategory() {
            return DesignerTypeCategory.DATE;
        }

        public boolean isValidValue(String value, String format) {
            try {
                String designerDataFormat = DesignerDateType.getDesignerDateFormat(format);
                DesignerDateType.parseDateFixMillis(value, designerDataFormat);
                return true;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
            catch (ParseException e) {
                return false;
            }
        }

        public static Object[] parseDateAndPatternFixMillis(String arg, String pattern) throws ParseException {
            Date date;
            pattern = DesignerDateType.getDesignerDateFormat(pattern);
            try {
                date = DesignerDateType.parseDate(arg, pattern);
            }
            catch (ParseException e) {
                if (pattern.indexOf(".SSS") != -1) {
                    pattern = StringUtils.replace(pattern, ".SSS", "");
                }
                date = DesignerDateType.parseDate(arg, pattern);
            }
            return new Object[]{date, pattern};
        }

        public static Date parseDateFixMillis(String arg, String pattern) throws ParseException {
            return (Date)DesignerDateType.parseDateAndPatternFixMillis(arg, pattern)[0];
        }

        public static String getPatternFixMillis(String arg, String pattern) throws ParseException {
            return (String)DesignerDateType.parseDateAndPatternFixMillis(arg, pattern)[1];
        }

        private static Date parseDate(String arg, String pattern) throws ParseException {
            if (DesignerDateType.isISOPattern(pattern)) {
                return CalendarParser.parseAsDate(pattern, arg);
            }
            SimpleDateFormat df = (SimpleDateFormat)DateFormat.getDateInstance();
            df.applyPattern(pattern);
            df.setLenient(false);
            ParsePosition position = new ParsePosition(0);
            Date date = df.parse(arg, position);
            if (arg.length() != position.getIndex()) {
                throw new ParseException("Unexpected additional character", position.getIndex());
            }
            return date;
        }

        public boolean isAssignableFrom(DesignerType srcType) {
            return srcType instanceof DesignerDateType;
        }

        public static boolean isISOPattern(String pattern) {
            return pattern.indexOf(37) != -1;
        }

        public static String formatDate(Date date, String pattern) {
            if (DesignerDateType.isISOPattern(pattern)) {
                return CalendarFormatter.format(pattern, date);
            }
            SimpleDateFormat df = (SimpleDateFormat)DateFormat.getDateInstance();
            df.applyPattern(pattern);
            String formattedString = df.format(date);
            return formattedString;
        }

        public static String formatDate(Calendar date, String pattern) {
            if (DesignerDateType.isISOPattern(pattern)) {
                return CalendarFormatter.format(pattern, date);
            }
            SimpleDateFormat df = (SimpleDateFormat)DateFormat.getDateInstance();
            df.applyPattern(pattern);
            String formattedString = df.format(date);
            return formattedString;
        }

        public static String getDesignerDateFormat(String format) {
            if (format.equals("YYYYMMDD")) {
                return SIMPLE_DATE_FORMAT;
            }
            if (format.equals("MM/DD/YYYY")) {
                return "MM/dd/yyyy";
            }
            if (format.equals("DD/MM/YYYY")) {
                return "dd/MM/yyyy";
            }
            return format;
        }

        public static String[] getDesignerDateFormats() {
            return new String[]{SIMPLE_DATE_FORMAT, "MM/dd/yyyy", "dd/MM/yyyy", SIMPLE_TIME_FORMAT, "HH:mm:ss.SSS", "HH:mm", "yyyyMMdd-HH:mm:ss", SIMPLE_DATE_TIME_FORMAT};
        }
    }
}

