/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.design;

import com.tplus.transform.design.DiffMessageListener;
import com.tplus.transform.design.DiffType;

public class DiffHelper {
    public static boolean diffObject(Object obj1, Object obj2, Object location1, Object location2, String property, DiffMessageListener listener, boolean primary) {
        String str2;
        String str1 = obj1 == null ? null : obj1.toString();
        DiffType diffType = DiffHelper.getDiffType(str1, str2 = obj2 == null ? null : obj2.toString(), primary);
        if (diffType != null) {
            listener.diffFound(diffType, obj1, obj2, location1, location2, property);
            return true;
        }
        return false;
    }

    public static boolean diffString(String str1, String str2, Object location1, Object location2, String property, DiffMessageListener listener, boolean primary) {
        DiffType diffType = DiffHelper.getDiffType(str1, str2, primary);
        if (diffType != null) {
            listener.diffFound(diffType, str1, str2, location1, location2, property);
            return true;
        }
        return false;
    }

    public static boolean diffString(boolean str1, boolean str2, Object location1, Object location2, String property, DiffMessageListener listener, boolean primary) {
        DiffType diffType = DiffHelper.getDiffType(DiffHelper.toString(str1), DiffHelper.toString(str2), primary);
        if (diffType != null) {
            listener.diffFound(diffType, DiffHelper.toString(str1), DiffHelper.toString(str2), location1, location2, property);
            return true;
        }
        return false;
    }

    private static String toString(boolean str1) {
        return str1 ? "true" : "false";
    }

    static DiffType getDiffType(String str1, String str2, boolean primary) {
        str1 = DiffHelper.fixEmptyString(str1);
        str2 = DiffHelper.fixEmptyString(str2);
        if (str1 == null || str2 == null) {
            if (str1 == null && str2 == null) {
                return null;
            }
            if (primary) {
                return str1 == null ? DiffType.NEW : DiffType.DELETED;
            }
            return DiffType.MODIFIED;
        }
        if (!str1.equals(str2)) {
            return DiffType.MODIFIED;
        }
        return null;
    }

    static String fixEmptyString(String str) {
        if (str != null && str.length() == 0) {
            str = null;
        }
        return str;
    }

    public static boolean diffBoolean(boolean b1, boolean b2, Object location1, Object location2, String property, DiffMessageListener listener) {
        if (b1 != b2) {
            listener.diffFound(DiffType.MODIFIED, DiffHelper.getBoolean(b1), DiffHelper.getBoolean(b2), location1, location2, property);
            return true;
        }
        return false;
    }

    private static Boolean getBoolean(boolean b1) {
        Boolean bv1 = b1 ? Boolean.TRUE : Boolean.FALSE;
        return bv1;
    }

    public static boolean diffInt(int v1, int v2, String entityName, Object location1, Object location2, DiffMessageListener listener) {
        if (v1 != v2) {
            listener.diffFound(DiffType.MODIFIED, new Integer(v1), new Integer(v2), location1, location2, entityName);
            return true;
        }
        return false;
    }
}

