/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.design;

import com.tplus.transform.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class FieldAttributes
implements Serializable,
Cloneable {
    List attributes;

    protected Object clone() {
        try {
            FieldAttributes fieldAttributes = (FieldAttributes)super.clone();
            if (this.attributes != null) {
                fieldAttributes.attributes = new ArrayList(this.attributes);
            }
            return fieldAttributes;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public List getAttributes() {
        return this.attributes;
    }

    public void removeAll() {
        this.attributes = null;
    }

    public void addAttribute(String name, String value) {
        if (this.attributes == null) {
            this.attributes = new ArrayList();
        }
        this.attributes.add(new FieldAttribute(name, value));
    }

    public void addAttribute(String name, String value, boolean runtime) {
        if (this.attributes == null) {
            this.attributes = new ArrayList();
        }
        FieldAttribute e = new FieldAttribute(name, value);
        e.setRuntime(runtime);
        this.attributes.add(e);
    }

    public boolean removeAttribute(FieldAttribute fieldAttribute) {
        if (this.attributes != null) {
            return this.attributes.remove(fieldAttribute);
        }
        return false;
    }

    public String[] getValuesByName(String attributeName) {
        if (this.attributes != null) {
            int count = 0;
            for (int i = 0; i < this.attributes.size(); ++i) {
                FieldAttribute fieldAttribute = (FieldAttribute)this.attributes.get(i);
                if (!fieldAttribute.getName().equals(attributeName)) continue;
                ++count;
            }
            if (count > 0) {
                String[] toRet = new String[count];
                int index = 0;
                for (int i = 0; i < this.attributes.size(); ++i) {
                    FieldAttribute fieldAttribute = (FieldAttribute)this.attributes.get(i);
                    if (!fieldAttribute.getName().equals(attributeName)) continue;
                    toRet[index++] = fieldAttribute.getValue();
                }
                return toRet;
            }
        }
        return StringUtils.EMPTY_ARRAY;
    }

    public String getFirstValueByName(String attributeName) {
        if (this.attributes != null) {
            boolean count = false;
            for (int i = 0; i < this.attributes.size(); ++i) {
                FieldAttribute fieldAttribute = (FieldAttribute)this.attributes.get(i);
                if (!fieldAttribute.getName().equals(attributeName)) continue;
                return fieldAttribute.getValue();
            }
        }
        return null;
    }

    public String toString() {
        if (this.attributes != null) {
            return this.attributes.toString();
        }
        return "";
    }

    public static class FieldAttribute {
        String name;
        String value;
        boolean runtime;

        FieldAttribute(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.name + "=" + this.value;
        }

        public boolean isRuntime() {
            return this.runtime;
        }

        public void setRuntime(boolean runtime) {
            this.runtime = runtime;
        }
    }
}

