/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.design;

import com.tplus.transform.design.DataField;
import com.tplus.transform.design.DataFieldSection;
import com.tplus.transform.design.DataFormat;
import com.tplus.transform.design.DesignElement;
import com.tplus.transform.design.DesignElementFindProperties;
import com.tplus.transform.design.DiffMessageListener;
import com.tplus.transform.design.FeatureSet;
import com.tplus.transform.design.FindMessageListener;
import com.tplus.transform.design.HeaderFormat;
import com.tplus.transform.design.IDesignElement;
import com.tplus.transform.design.IMessage;
import com.tplus.transform.design.MessageNormalizedFormat;
import com.tplus.transform.design.MessageStructure;
import com.tplus.transform.design.NormalizedExternalFormat;
import com.tplus.transform.design.RecordDataFormat;
import com.tplus.transform.design.TrailerFormat;
import com.tplus.transform.design.ValidationMessageListener;
import com.tplus.transform.design.xml.NamespaceManager;

public class FieldsFormat
extends DesignElement
implements MessageStructure {
    public static final String FORMAT_OPTION_LOCATION = "Format Option";
    NormalizedExternalFormat wrappedObject;
    private String XMLTargetNamespace;
    NamespaceManager xpathNamespaceManager = new NamespaceManager();
    protected FeatureSet features = new FeatureSet();
    private DataFormat headerFormat;
    private DataFormat dataFormat;
    private DataFormat trailerFormat;
    private static final long serialVersionUID = -8087809532704668744L;
    public static final String HEADER_NAME = "Header";
    public static final String DATA_NAME = "Data";
    public static final String TRAILER_NAME = "Trailer";
    static Class ExternalMessageClass;

    public FieldsFormat(String name) {
        super(name);
        this.headerFormat = this.createHeaderFormat();
        this.dataFormat = this.createRecordDataFormat();
        this.trailerFormat = this.createTrailerFormat();
        this.initFormats();
    }

    public FieldsFormat(String name, DataFormat headerFormat, DataFormat dataFormat, DataFormat trailerFormat) {
        super(name);
        this.headerFormat = headerFormat != null ? headerFormat : this.createHeaderFormat();
        this.dataFormat = dataFormat != null ? dataFormat : this.createRecordDataFormat();
        this.trailerFormat = trailerFormat != null ? trailerFormat : this.createTrailerFormat();
        this.initFormats();
    }

    public MessageNormalizedFormat getNormalizedFormat() {
        String messageName = this.getMessageName();
        if (this.wrappedObject == null) {
            this.wrappedObject = new NormalizedExternalFormat(messageName);
            this.wrappedObject.setParent(this.getParent());
            this.createWrappedSections();
        } else {
            this.wrappedObject.setName(messageName);
        }
        return this.wrappedObject;
    }

    public NamespaceManager getXpathNamespaceManager() {
        return this.xpathNamespaceManager;
    }

    private void createWrappedSections() {
        this.wrapInSection(this.wrappedObject, HEADER_NAME, this.getHeaderFormat());
        this.wrapInSection(this.wrappedObject, DATA_NAME, this.getDataFormat());
        this.wrapInSection(this.wrappedObject, TRAILER_NAME, this.getTrailerFormat());
    }

    private void reinitWrappedObject() {
        if (this.wrappedObject != null) {
            this.wrappedObject.removeAllFields();
            this.createWrappedSections();
        }
    }

    public boolean isNodeModified() {
        boolean formatModified;
        boolean bl = formatModified = this.getHeaderFormat().isNodeModified() || this.getDataFormat().isNodeModified() || this.getTrailerFormat().isNodeModified();
        if (formatModified) {
            super.setNodeModified(formatModified);
        }
        return super.isNodeModified();
    }

    public void clearModified(boolean includeChildren) {
        super.clearModified(includeChildren);
        this.getHeaderFormat().clearModified(includeChildren);
        this.getDataFormat().clearModified(includeChildren);
        this.getTrailerFormat().clearModified(includeChildren);
    }

    private DataFieldSection wrapInSection(DataFormat root, String name, DataFormat dataFormat) {
        DataFieldSection section = root.createSection(name, dataFormat);
        section.setRepeating(false);
        section.setOptional(false);
        root.addSection(section);
        dataFormat.setParentSection(null);
        section.setNonRepeatingMessage(true);
        return section;
    }

    private void initFormats() {
        this.headerFormat.setParent(this);
        this.dataFormat.setParent(this);
        this.trailerFormat.setParent(this);
    }

    public boolean isCustomizable() {
        return true;
    }

    public boolean isModifiable() {
        return true;
    }

    public boolean isStandardMessage() {
        return !this.isModifiable();
    }

    public String getMessageName() {
        IMessage message = (IMessage)((Object)this.getParent());
        if (message != null) {
            return message.getMessageName();
        }
        return "";
    }

    public IMessage getMessage() {
        return (IMessage)((Object)this.getParent());
    }

    public DataFormat[] getFormats() {
        return new DataFormat[]{this.headerFormat, this.dataFormat, this.trailerFormat};
    }

    protected DataFormat createHeaderFormat() {
        return new HeaderFormat(HEADER_NAME);
    }

    protected DataFormat createRecordDataFormat() {
        return new RecordDataFormat(DATA_NAME);
    }

    protected DataFormat createTrailerFormat() {
        return new TrailerFormat(TRAILER_NAME);
    }

    public String getFormatName(DataFormat df) {
        if (df == this.getHeaderFormat()) {
            return HEADER_NAME;
        }
        if (df == this.getDataFormat()) {
            return DATA_NAME;
        }
        if (df == this.getTrailerFormat()) {
            return TRAILER_NAME;
        }
        return null;
    }

    public String getContentName() {
        IDesignElement formatElm = this.getParent();
        if (ExternalMessageClass != null && ExternalMessageClass.isInstance(formatElm)) {
            return formatElm.getName() + "Format";
        }
        return "Format";
    }

    public void setHeaderFormat(DataFormat headerFormat) {
        this.headerFormat = headerFormat;
        headerFormat.setParent(this);
        this.reinitWrappedObject();
    }

    public DataFormat getHeaderFormat() {
        return this.headerFormat;
    }

    public void setDataFormat(DataFormat dataFormat) {
        this.dataFormat = dataFormat;
        dataFormat.setParent(this);
        this.reinitWrappedObject();
    }

    public DataFormat getDataFormat() {
        return this.dataFormat;
    }

    public void setTrailerFormat(DataFormat trailerFormat) {
        this.trailerFormat = trailerFormat;
        trailerFormat.setParent(this);
        this.reinitWrappedObject();
    }

    public DataFormat getTrailerFormat() {
        return this.trailerFormat;
    }

    public boolean contains(DataField fld) {
        return this.headerFormat.contains(fld) || this.dataFormat.contains(fld) || this.trailerFormat.contains(fld);
    }

    public boolean contains(DataField fld, boolean checkChildren) {
        return this.headerFormat.contains(fld, checkChildren) || this.dataFormat.contains(fld, checkChildren) || this.trailerFormat.contains(fld, checkChildren);
    }

    public void validate(ValidationMessageListener listener) {
        this.getRootSection().validatePlatformSpecificInfo(listener);
        this.headerFormat.getRootSection().validatePlatformSpecificInfo(listener);
        this.headerFormat.validate(listener);
        this.dataFormat.getRootSection().validatePlatformSpecificInfo(listener);
        this.dataFormat.validate(listener);
        this.trailerFormat.getRootSection().validatePlatformSpecificInfo(listener);
        this.trailerFormat.validate(listener);
    }

    public DataField getField(String name) {
        DataField iField = this.dataFormat.getField(name);
        if (iField == null) {
            iField = this.headerFormat.getField(name);
        }
        if (iField == null) {
            iField = this.trailerFormat.getField(name);
        }
        return iField;
    }

    public DataField getQualifiedField(String name) {
        DataField iField = this.dataFormat.getQualifiedField(name);
        if (iField == null) {
            iField = this.headerFormat.getQualifiedField(name);
        }
        if (iField == null) {
            iField = this.trailerFormat.getQualifiedField(name);
        }
        return iField;
    }

    public DataField getQualifiedField(String name, boolean useMangled) {
        DataField iField = this.dataFormat.getQualifiedField(name, useMangled);
        if (iField == null) {
            iField = this.headerFormat.getQualifiedField(name, useMangled);
        }
        if (iField == null) {
            iField = this.trailerFormat.getQualifiedField(name, useMangled);
        }
        return iField;
    }

    public void find(DesignElementFindProperties findProperties, FindMessageListener listener) {
        this.headerFormat.find(findProperties, listener);
        this.dataFormat.find(findProperties, listener);
        this.trailerFormat.find(findProperties, listener);
    }

    public void diff(IDesignElement with, DiffMessageListener listener) {
        FieldsFormat other = (FieldsFormat)with;
        this.headerFormat.diff(other.headerFormat, listener);
        this.dataFormat.diff(other.dataFormat, listener);
        this.trailerFormat.diff(other.trailerFormat, listener);
    }

    public Object getLocationFromString(String str) {
        DataField location = this.getHeaderFormat().getQualifiedField(str, true);
        if (location == null) {
            location = this.getDataFormat().getQualifiedField(str, true);
        }
        if (location == null) {
            location = this.getTrailerFormat().getQualifiedField(str, true);
        }
        return location;
    }

    public String getStringFromLocation(Object location) {
        if (location instanceof DataField) {
            return ((DataField)location).getQualifiedName();
        }
        return null;
    }

    public void setXMLTargetNamespace(String XMLTargetNamespace) {
        this.XMLTargetNamespace = XMLTargetNamespace;
    }

    public String getXMLTargetNamespace() {
        return this.XMLTargetNamespace;
    }

    public DataFieldSection getRootSection() {
        return this.getNormalizedFormat().getRootSection();
    }

    public static IMessage getMessage(DataFormat df) {
        DataFormat rootFormat = df.getRootFormat();
        if (rootFormat instanceof MessageNormalizedFormat) {
            MessageNormalizedFormat nf = (MessageNormalizedFormat)rootFormat;
            return nf.getMessage();
        }
        IDesignElement parent = rootFormat.getParent();
        if (parent instanceof FieldsFormat) {
            FieldsFormat f = (FieldsFormat)parent;
            return f.getMessage();
        }
        return null;
    }

    public void setFeatures(FeatureSet features) {
        this.features = features;
    }

    public FeatureSet getFeatures() {
        return this.features;
    }

    static {
        try {
            ExternalMessageClass = Class.forName("com.tplus.transform.design.ExternalMessage");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

