/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.design;

import com.tplus.transform.design.DataTypeConstants;
import com.tplus.transform.design.DesignerType;
import com.tplus.transform.design.TypeMapping;
import com.tplus.transform.util.Type;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FormatTypeMappingManager {
    private Map designerTypeMappings = new HashMap();
    private Map formatTypeMappings = new HashMap();
    private List mappings = new ArrayList();
    Class typeClass = Type.class;
    private Type[] formatTypesCache;
    private DesignerType[] designerTypesCache = null;

    public FormatTypeMappingManager() {
    }

    public FormatTypeMappingManager(TypeMapping[] mappings) {
        this(mappings, Type.class);
    }

    public FormatTypeMappingManager(TypeMapping[] mappings, Class typeClass) {
        this.typeClass = typeClass;
        for (int i = 0; i < mappings.length; ++i) {
            TypeMapping mapping = mappings[i];
            this.addMapping(mapping);
        }
    }

    public void addMapping(TypeMapping typeMapping) {
        this.mappings.add(typeMapping);
        this.prepareFormatTypeMapping(typeMapping);
        this.prepareDesignerTypeMapping(typeMapping);
    }

    private void prepareDesignerTypeMapping(TypeMapping typeMapping) {
        ArrayList<TypeMapping> designerMappingList = (ArrayList<TypeMapping>)this.designerTypeMappings.get(typeMapping.getDesignerType());
        if (designerMappingList == null) {
            designerMappingList = new ArrayList<TypeMapping>();
            this.designerTypeMappings.put(typeMapping.getDesignerType(), designerMappingList);
        }
        designerMappingList.add(typeMapping);
    }

    private void prepareFormatTypeMapping(TypeMapping typeMapping) {
        ArrayList<TypeMapping> formatMappingList = (ArrayList<TypeMapping>)this.formatTypeMappings.get(typeMapping.getType());
        if (formatMappingList == null) {
            formatMappingList = new ArrayList<TypeMapping>();
            this.formatTypeMappings.put(typeMapping.getType(), formatMappingList);
        }
        formatMappingList.add(typeMapping);
    }

    public Type getPreferredFormatType(DesignerType designerType) {
        List typeMappings = this.getTypeMappings(designerType);
        TypeMapping mapping = (TypeMapping)typeMappings.get(0);
        return mapping.getType();
    }

    public DesignerType getPreferredDesignerType(Type formatType) {
        List typeMappings = this.getTypeMappings(formatType);
        if (typeMappings.size() > 0) {
            TypeMapping mapping = (TypeMapping)typeMappings.get(0);
            return mapping.getDesignerType();
        }
        return null;
    }

    public Type[] getFormatTypes(DesignerType designerType) {
        List typeMappings = this.getTypeMappings(designerType);
        Type[] formatTypes = this.createTypeArray(typeMappings.size());
        for (int i = 0; i < typeMappings.size(); ++i) {
            TypeMapping typeMapping = (TypeMapping)typeMappings.get(i);
            formatTypes[i] = typeMapping.getType();
        }
        return formatTypes;
    }

    private Type[] createTypeArray(int size) {
        return (Type[])Array.newInstance(this.typeClass, size);
    }

    public DesignerType[] getDesignerTypes(Type formatType) {
        List typeMappings = this.getTypeMappings(formatType);
        DesignerType[] designerTypes = new DesignerType[typeMappings.size()];
        for (int i = 0; i < typeMappings.size(); ++i) {
            TypeMapping typeMapping = (TypeMapping)typeMappings.get(i);
            designerTypes[i] = typeMapping.getDesignerType();
        }
        return designerTypes;
    }

    public Type[] getFormatTypes() {
        if (this.formatTypesCache == null) {
            this.formatTypesCache = this.getFormatTypes0();
        }
        return this.formatTypesCache;
    }

    private Type[] getFormatTypes0() {
        Set typeSet = this.formatTypeMappings.keySet();
        Type[] formatTypes = typeSet.toArray(this.createTypeArray(typeSet.size()));
        Arrays.sort(formatTypes, Type.CASELESS_NAME_COMPARATOR);
        return formatTypes;
    }

    public DesignerType[] getDesignerTypes() {
        if (this.designerTypesCache == null) {
            this.designerTypesCache = this.getDesignerTypes0();
        }
        return this.designerTypesCache;
    }

    private DesignerType[] getDesignerTypes0() {
        Set typeSet = this.designerTypeMappings.keySet();
        DesignerType[] types = typeSet.toArray(new DesignerType[typeSet.size()]);
        Arrays.sort(types, Type.CASELESS_NAME_COMPARATOR);
        return types;
    }

    public List getTypeMappings(Type formatType) {
        List typeMappings = (List)this.formatTypeMappings.get(formatType);
        if (typeMappings != null) {
            return typeMappings;
        }
        throw new IllegalArgumentException("Unrecognized format type '" + formatType + "'");
    }

    public List getTypeMappings(DesignerType designerType) {
        List typeMappings = (List)this.designerTypeMappings.get(designerType);
        if (typeMappings != null) {
            return typeMappings;
        }
        throw new IllegalArgumentException("Unrecognized designer type '" + designerType + "'. Mapping for this type is not available.");
    }

    public DesignerType getDesignerType(String designerTypeStr) {
        designerTypeStr = DataTypeConstants.fixDesignerType(designerTypeStr);
        DesignerType[] designerTypes = this.getDesignerTypes();
        for (int i = 0; i < designerTypes.length; ++i) {
            DesignerType designerType = designerTypes[i];
            if (!designerType.getName().equals(designerTypeStr)) continue;
            return designerType;
        }
        throw new IllegalArgumentException("Unrecognized designer type '" + designerTypeStr + "'");
    }

    public Type getFormatType(String formatTypeStr) {
        Type[] formatTypes = this.getFormatTypes();
        for (int i = 0; i < formatTypes.length; ++i) {
            Type formatType = formatTypes[i];
            if (!formatType.getName().equals(formatTypeStr)) continue;
            return formatType;
        }
        throw new IllegalArgumentException("Unrecognized format type '" + formatTypeStr + "'");
    }

    public TypeMapping getTypeMapping(Type formatType, DesignerType designerType) {
        List typeMappings = this.getTypeMappings(designerType);
        for (int i = 0; i < typeMappings.size(); ++i) {
            TypeMapping typeMapping = (TypeMapping)typeMappings.get(i);
            if (!typeMapping.getType().equals(formatType)) continue;
            return typeMapping;
        }
        return null;
    }
}

