/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.design;

import com.tplus.transform.design.DesignElementChangeListener;
import com.tplus.transform.design.DesignElementEvent;
import com.tplus.transform.design.DesignElementFindProperties;
import com.tplus.transform.design.DiffMessageListener;
import com.tplus.transform.design.FindMessageListener;
import com.tplus.transform.design.ReadWriteEnum;
import com.tplus.transform.design.ValidationMessageListener;
import com.tplus.transform.util.UUID;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface IDesignElement
extends Serializable {
    public String getName();

    public UUID getDesignElementID();

    public IDesignElement findByID(UUID var1, boolean var2);

    public String getDisplayName();

    public String getContentName();

    public void setName(String var1);

    public List children();

    public int getChildCount();

    public IDesignElement getChild(int var1);

    public boolean shouldExpandOnDemand();

    public boolean isNodeModified();

    public boolean isNodeModifiedIgnoreChild();

    public boolean isModified();

    public void setNodeModified(boolean var1);

    public void clearModified(boolean var1);

    public ReadWriteEnum getReadWriteState();

    public boolean isReadOnly();

    public void diff(IDesignElement var1, DiffMessageListener var2);

    public void diffAll(IDesignElement var1, DiffMessageListener var2);

    public void assignParent();

    public boolean delete(IDesignElement var1);

    public boolean canDelete(IDesignElement var1);

    public Map getProperties();

    public Object getProperty(String var1);

    public void setProperty(String var1, Object var2);

    public Map getTransientProperties();

    public Object getTransientProperty(String var1);

    public void setTransientProperty(String var1, Object var2);

    public void fireDesignElementChanged(DesignElementEvent var1);

    public void addDesignElementChangeListener(DesignElementChangeListener var1);

    public void removeDesignElementChangeListener(DesignElementChangeListener var1);

    public void validate(ValidationMessageListener var1);

    public void validateAll(ValidationMessageListener var1);

    public void visitAll(IDesignElementVisitor var1);

    public IDesignElement getRootElement();

    public IDesignElement getRootAncestor();

    public IDesignElement getAncestorElement(Class var1);

    public boolean isChild(IDesignElement var1);

    public String getPath();

    public Object getLocationFromString(String var1);

    public String getStringFromLocation(Object var1);

    public String getPathName();

    public boolean isPathName(String var1);

    public IDesignElement findChildElement(String var1, boolean var2);

    public boolean canImport(String var1);

    public boolean canExport(String var1);

    public boolean isExcluded();

    public void setParent(IDesignElement var1);

    public IDesignElement getParent();

    public void findAll(DesignElementFindProperties var1, FindMessageListener var2);

    public void find(DesignElementFindProperties var1, FindMessageListener var2);

    public boolean isRoot();

    public static class UniqueElementVisitor
    implements IDesignElementVisitor {
        IDesignElementVisitor delegate;
        Set visitedElements = new HashSet();

        public UniqueElementVisitor(IDesignElementVisitor delegate) {
            this.delegate = delegate;
        }

        public boolean notify(IDesignElement elm) {
            if (this.visitedElements.contains(elm)) {
                return false;
            }
            this.visitedElements.add(elm);
            return this.delegate.notify(elm);
        }
    }

    public static interface IDesignElementVisitor {
        public boolean notify(IDesignElement var1);
    }
}

