/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.design;

import com.tplus.transform.design.IMessage;
import com.tplus.transform.design.IPManager;
import java.io.Serializable;
import java.util.Map;

public class MessageFormatInfo
implements Comparable,
Serializable {
    private static final long serialVersionUID = -3940537447502276630L;
    String standard;
    String formatName;
    String detailedName;
    String versionName;
    String releaseQualifier;
    String description;
    String category;
    String group;
    String messageFileName;
    Map additionalOptions;
    String subGroup;
    private IPManager ipManager = new IPManager();

    public MessageFormatInfo(IMessage messageFormat) {
        this.standard = messageFormat.getStandard();
        this.formatName = messageFormat.getStandardName();
        this.versionName = messageFormat.getStandardVersion();
        this.releaseQualifier = messageFormat.getStandardReleaseQualifier();
        this.detailedName = messageFormat.getStandardDetailedName();
        this.description = messageFormat.getDescription();
        this.category = messageFormat.getStandardCategory();
        this.group = messageFormat.getStandardGroup();
        this.subGroup = messageFormat.getStandardSubGroup();
        this.ipManager = messageFormat.getIPManager();
    }

    public MessageFormatInfo(String standard, String formatName, String versionName, String detailedName, String category, String description) {
        this(standard, formatName, versionName, detailedName, category, description, null);
    }

    public MessageFormatInfo(String standard, String formatName, String versionName, String detailedName, String category, String description, String group) {
        this(standard, formatName, versionName, detailedName, category, description, group, null);
    }

    public MessageFormatInfo(String standard, String formatName, String versionName, String detailedName, String category, String description, String group, String subGroup) {
        this.standard = standard;
        this.formatName = MessageFormatInfo.fixNull(formatName);
        this.versionName = MessageFormatInfo.fixNull(versionName);
        this.detailedName = MessageFormatInfo.fixNull(detailedName);
        this.description = MessageFormatInfo.fixNull(description);
        this.category = MessageFormatInfo.fixNull(category);
        this.group = MessageFormatInfo.fixNull(group);
        this.subGroup = MessageFormatInfo.fixNull(subGroup);
    }

    public MessageFormatInfo(String standard, String formatName, String versionName) {
        this.standard = standard;
        this.formatName = MessageFormatInfo.fixNull(formatName);
        this.versionName = MessageFormatInfo.fixNull(versionName);
    }

    public void updateMessageFormatInfo(IMessage messageFormat) {
        messageFormat.setStandard(this.standard);
        messageFormat.setStandardName(this.formatName);
        messageFormat.setStandardVersion(this.versionName);
        messageFormat.setStandardReleaseQualifier(this.releaseQualifier);
        messageFormat.setStandardDetailedName(this.detailedName);
        messageFormat.setDescription(this.description);
        messageFormat.setStandardCategory(this.category);
        messageFormat.setStandardGroup(this.group);
        messageFormat.setStandardSubGroup(this.subGroup);
    }

    public void setStandard(String standard) {
        this.standard = standard;
    }

    public void setFormatName(String formatName) {
        this.formatName = formatName;
    }

    public void setDetailedName(String detailedName) {
        this.detailedName = detailedName;
    }

    public void setVersionName(String versionName) {
        this.versionName = versionName;
    }

    public void setStandardVersion(String versionName) {
        this.versionName = versionName;
    }

    public String getStandardReleaseQualifier() {
        return this.releaseQualifier;
    }

    public void setStandardReleaseQualifier(String versionQualifier) {
        this.releaseQualifier = versionQualifier;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getStandard() {
        return this.standard;
    }

    public String getStandardName() {
        return this.formatName;
    }

    public String getStandardVersion() {
        return this.versionName;
    }

    public String getStandardCategory() {
        return this.category;
    }

    public String getDescription() {
        return this.description;
    }

    public String getStandardDetailedName() {
        return this.detailedName;
    }

    public String toString() {
        return this.formatName;
    }

    public boolean isStandardMessage() {
        return !this.getStandardName().equals("");
    }

    public String toDetailedString() {
        return "Standard = " + this.standard + ", Message=" + this.formatName + ", Version=" + this.versionName;
    }

    public boolean equals(Object o) {
        if (o instanceof MessageFormatInfo) {
            return this.compareTo(o) == 0;
        }
        return false;
    }

    public int hashCode() {
        int result = this.standard != null ? this.standard.hashCode() : 0;
        result = 29 * result + (this.formatName != null ? this.formatName.hashCode() : 0);
        result = 29 * result + (this.versionName != null ? this.versionName.hashCode() : 0);
        return result;
    }

    public int compareTo(Object o) {
        MessageFormatInfo other = (MessageFormatInfo)o;
        int compare = this.standard.compareTo(other.standard);
        if (compare == 0) {
            compare = this.formatName.compareTo(other.formatName);
        }
        if (compare == 0) {
            compare = this.versionName.compareTo(other.versionName);
        }
        return compare;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public static String fixNull(String name) {
        return name == null ? "" : name;
    }

    public String getMessageFileName() {
        return this.messageFileName;
    }

    public void setMessageFileName(String messageFileName) {
        this.messageFileName = messageFileName;
    }

    public IPManager getIPManager() {
        return this.ipManager;
    }

    public void setIPManager(IPManager ipManager) {
        this.ipManager = ipManager;
    }

    public Map getAdditionalOptions() {
        return this.additionalOptions;
    }

    public void setAdditionalOptions(Map additionalOptions) {
        this.additionalOptions = additionalOptions;
    }

    public String getSubGroup() {
        return this.subGroup;
    }

    public void setSubGroup(String subGroup) {
        this.subGroup = subGroup;
    }
}

