/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.design;

import com.tplus.transform.design.DataField;
import com.tplus.transform.design.DataTypeConstants;
import com.tplus.transform.design.DesignerType;
import com.tplus.transform.design.DiffHelper;
import com.tplus.transform.design.DiffMessageListener;
import com.tplus.transform.design.DiffType;
import com.tplus.transform.design.platform.PlatformSpecificInfo;
import java.util.HashSet;
import java.util.Map;

public class NormalizedField
extends DataField {
    public static final String MAXIMUM_LENGTH = "Length";
    int length;
    private static final long serialVersionUID = -8087809532704668774L;

    public NormalizedField(String name, DesignerType type) {
        super(name, type);
        if (type.equals(DataTypeConstants.DESIGNER_STRING_TYPE)) {
            this.length = -1;
        }
    }

    public int getMaximumLength() {
        if (!this.getType().equals(DataTypeConstants.DESIGNER_STRING_TYPE)) {
            this.length = -1;
        }
        return this.length;
    }

    public Object getMaximumLengthObject() {
        if (!this.getType().equals(DataTypeConstants.DESIGNER_STRING_TYPE)) {
            return null;
        }
        return new Integer(this.length);
    }

    public void setMaximumLength(int length) {
        this.length = length;
    }

    public String getFormat() {
        if (DataTypeConstants.isDateOrTimeType(this.getType())) {
            return DataTypeConstants.getDefaultDateFormat(this.getType());
        }
        return null;
    }

    public void diff(DataField other, DiffMessageListener listener) {
        super.diff(other, listener);
        NormalizedField otherField = (NormalizedField)other;
        NormalizedField otherNormalizedField = (NormalizedField)other;
        DiffHelper.diffString(Integer.toString(this.getMaximumLength()), Integer.toString(otherNormalizedField.getMaximumLength()), (Object)this, (Object)other, MAXIMUM_LENGTH, listener, false);
        Map platformInfos = this.getPlatformSpecificInfos();
        Map otherPlatformInfos = otherField.getPlatformSpecificInfos();
        HashSet allKeys = new HashSet(platformInfos.keySet());
        allKeys.addAll(otherPlatformInfos.keySet());
        for (String pname : allKeys) {
            PlatformSpecificInfo platformSpecificInfo = (PlatformSpecificInfo)platformInfos.get(pname);
            PlatformSpecificInfo otherPlatformSpecificInfo = (PlatformSpecificInfo)otherPlatformInfos.get(pname);
            if (platformSpecificInfo != null && otherPlatformSpecificInfo != null) {
                platformSpecificInfo.diff(otherPlatformSpecificInfo, this, other, listener);
            }
            if (platformSpecificInfo == null && otherPlatformSpecificInfo != null) {
                listener.diffFound(DiffType.NEW, null, null, null, other, "Platform Specific Info");
            }
            if (platformSpecificInfo == null || otherPlatformSpecificInfo != null) continue;
            listener.diffFound(DiffType.DELETED, null, null, this, null, "Platform Specific Info");
        }
    }
}

