/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.design;

import com.tplus.transform.design.DataField;
import com.tplus.transform.design.DataFieldSection;
import com.tplus.transform.design.DataFormat;
import com.tplus.transform.design.DataTypeConstants;
import com.tplus.transform.design.DesignElementFindProperties;
import com.tplus.transform.design.DesignerType;
import com.tplus.transform.design.FindMessageListener;
import com.tplus.transform.design.NormalizedField;
import com.tplus.transform.design.ValidationMessageListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;

public class NormalizedFormat
extends DataFormat {
    public static final String PLATFORM_SPECIFIC_INFO = "Platform Specific Info";
    static DesignerType[] normalizedTypes;
    private static final long serialVersionUID = -8087809532704668764L;

    public NormalizedFormat(String name) {
        super(name);
        this.setSectionSupported(true);
    }

    public String getDisplayName() {
        return "Internal Format";
    }

    public DesignerType[] getTypes() {
        return NormalizedFormat.getDataTypes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DesignerType[] getDataTypes() {
        if (normalizedTypes != null) return normalizedTypes;
        Class<NormalizedFormat> clazz = NormalizedFormat.class;
        synchronized (NormalizedFormat.class) {
            ArrayList<DesignerType> paramTypeList = new ArrayList<DesignerType>(Arrays.asList(DataTypeConstants.getFieldDataTypes()));
            paramTypeList.add(DataTypeConstants.DESIGNER_RAW_MESSAGE_TYPE);
            DesignerType[] dataTypes = paramTypeList.toArray(new DesignerType[paramTypeList.size()]);
            normalizedTypes = dataTypes;
            // ** MonitorExit[var0] (shouldn't be in output)
            return normalizedTypes;
        }
    }

    private void readObject(ObjectInputStream oos) throws IOException, ClassNotFoundException {
        oos.defaultReadObject();
        this.setSectionSupported(true);
    }

    public void validate(ValidationMessageListener listener) {
        super.validate(listener);
        int count = this.getFieldCountAvailable();
        for (int i = 0; i < count; ++i) {
            String defValue;
            DataField fld = this.getField(i);
            if (DataTypeConstants.isSectionType(fld.getType()) || (defValue = fld.getDefaultValue()) == null || (defValue = defValue.trim()).length() <= 0) continue;
            DesignerType type = fld.getType();
            String format = fld.getFormat();
        }
    }

    public DataField createField(String name, DesignerType type) {
        return new NormalizedField(name, type);
    }

    public DataFieldSection createSection(String name) {
        DataFieldSection nf = new DataFieldSection(name, new NormalizedFormat(name));
        return nf;
    }

    public void find(DesignElementFindProperties findProperties, FindMessageListener listener) {
        super.find(findProperties, listener);
    }
}

