/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.design;

import com.tplus.transform.design.ValidationMessageListener;
import com.tplus.transform.util.StringUtils;

public class ValidationHelper {
    private ValidationHelper() {
    }

    public static int skipChar(String pattern, int start, char p) {
        char c;
        int count = 0;
        for (int i = start; i < pattern.length() && (c = pattern.charAt(i)) == p; ++i) {
            ++count;
        }
        return count;
    }

    public static boolean isISOPattern(String pattern) {
        return pattern.indexOf(37) != -1;
    }

    public static void validateDatePattern(String pattern) {
        if (StringUtils.isEmpty(pattern)) {
            throw new IllegalArgumentException("Date/Time format cannot be empty.");
        }
        if (ValidationHelper.isISOPattern(pattern)) {
            return;
        }
        int count = 0;
        block10: for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            switch (c) {
                case 'y': {
                    count = ValidationHelper.skipChar(pattern, i, 'y');
                    if (count != 2 && count != 3 && count != 4) {
                        throw new IllegalArgumentException("Invalid years pattern  '" + pattern.substring(i, i + count) + "'  in data/time '" + pattern + "'.");
                    }
                    i += count - 1;
                    continue block10;
                }
                case 'M': {
                    count = ValidationHelper.skipChar(pattern, i, 'M');
                    if (count != 1 && count != 2 && count != 3 && count != 4) {
                        throw new IllegalArgumentException("Invalid months pattern  '" + pattern.substring(i, i + count) + "'  in data/time '" + pattern + "'.");
                    }
                    i += count - 1;
                    continue block10;
                }
                case 'd': {
                    count = ValidationHelper.skipChar(pattern, i, 'd');
                    if (count != 1 && count != 2) {
                        throw new IllegalArgumentException("Invalid days pattern  '" + pattern.substring(i, i + count) + "'  in data/time '" + pattern + "'.");
                    }
                    i += count - 1;
                    continue block10;
                }
                case 'H': {
                    count = ValidationHelper.skipChar(pattern, i, 'H');
                    if (count != 2) {
                        throw new IllegalArgumentException("Invalid hours pattern  '" + pattern.substring(i, i + count) + "'  in data/time '" + pattern + "'.");
                    }
                    i += count - 1;
                    continue block10;
                }
                case 'm': {
                    count = ValidationHelper.skipChar(pattern, i, 'm');
                    if (count != 2) {
                        throw new IllegalArgumentException("Invalid minutes pattern  '" + pattern.substring(i, i + count) + "'  in data/time '" + pattern + "'.");
                    }
                    i += count - 1;
                    continue block10;
                }
                case 's': {
                    count = ValidationHelper.skipChar(pattern, i, 's');
                    if (count != 2) {
                        throw new IllegalArgumentException("Invalid seconds pattern  '" + pattern.substring(i, i + count) + "'  in data/time '" + pattern + "'.");
                    }
                    i += count - 1;
                    continue block10;
                }
                case 'S': {
                    count = ValidationHelper.skipChar(pattern, i, 'S');
                    if (count > 3) {
                        throw new IllegalArgumentException("Invalid date/time pattern '" + pattern + "'. Unsupported pattern character set 'SSSS'");
                    }
                    i += count - 1;
                    continue block10;
                }
                case ' ': 
                case '$': 
                case '%': 
                case '\'': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case ';': 
                case '@': 
                case 'T': 
                case '\\': 
                case '_': 
                case 't': {
                    continue block10;
                }
                default: {
                    throw new IllegalArgumentException("Invalid date/time pattern '" + pattern + "'. Unsupported pattern character '" + c + "'");
                }
            }
        }
    }

    public static boolean checkValidServiceName(String value, ValidationMessageListener listener, String name, Object location, String property) {
        if (!ValidationHelper.isServiceName(value)) {
            listener.validationError("DN1003", name + " (" + value + ") does not conform to service name (no dot, should not start with numeric value etc.)", location, property);
            return false;
        }
        return true;
    }

    private static boolean isServiceName(String value) {
        return value.indexOf(".") == -1;
    }

    public static boolean checkJavaIdentifier(String value, ValidationMessageListener listener, String name, String property) {
        return ValidationHelper.checkJavaIdentifier(value, listener, name, null, property);
    }

    public static boolean checkJavaIdentifier(String value, ValidationMessageListener listener, String name, Object location, String property) {
        if (!ValidationHelper.isJavaIdentifier(value)) {
            listener.validationError("DN1003", name + " (" + value + ") does not conform to identifier rules (no spaces, should not start with numeric value etc.)", location, property);
            return false;
        }
        return true;
    }

    public static boolean isJavaIdentifier(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(name.charAt(0))) {
            return false;
        }
        for (int i = 1; i < name.length(); ++i) {
            if (Character.isJavaIdentifierPart(name.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

