/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.design;

import java.io.Serializable;
import java.util.StringTokenizer;

public class VersionInfo
implements Serializable,
Comparable {
    private int majorVersion;
    private int minorVersion;
    private int patchNumber;
    private String versionStr;
    private static final long serialVersionUID = -8087809532704668123L;

    public VersionInfo(String versionStr) throws IllegalArgumentException {
        this.versionStr = versionStr;
        this.parseVersion(versionStr);
    }

    void parseVersion(String strIn) throws IllegalArgumentException {
        char c;
        String str = new String();
        for (int i = 0; i < strIn.length() && (Character.isDigit(c = strIn.charAt(i)) || c == '.'); ++i) {
            str = str + c;
        }
        this.patchNumber = 0;
        this.minorVersion = 0;
        this.majorVersion = 0;
        StringTokenizer stk = new StringTokenizer(str, ".");
        if (!stk.hasMoreTokens()) {
            throw new IllegalArgumentException(strIn + " not a legal version number");
        }
        this.majorVersion = Integer.parseInt(stk.nextToken());
        if (stk.hasMoreTokens()) {
            this.minorVersion = Integer.parseInt(stk.nextToken());
            if (stk.hasMoreTokens()) {
                this.patchNumber = Integer.parseInt(stk.nextToken());
            }
        }
    }

    public VersionInfo(int majorVersion, int minorVersion, int patchNumber) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.patchNumber = patchNumber;
        this.versionStr = majorVersion + "." + minorVersion + "." + patchNumber;
    }

    public boolean isVersionGreaterOrEqualThan(VersionInfo info) {
        if (this.majorVersion > info.majorVersion) {
            return true;
        }
        if (this.majorVersion == info.majorVersion) {
            return this.minorVersion >= info.minorVersion;
        }
        return false;
    }

    public int compareTo(Object o) {
        VersionInfo info = (VersionInfo)o;
        if (this.majorVersion == info.majorVersion) {
            return this.minorVersion - info.minorVersion;
        }
        return this.majorVersion - info.majorVersion;
    }

    public int compareTo(VersionInfo info, boolean withPatch) {
        if (this.majorVersion != info.majorVersion) {
            return this.majorVersion - info.majorVersion;
        }
        if (this.minorVersion != info.minorVersion) {
            return this.minorVersion - info.minorVersion;
        }
        if (withPatch) {
            return this.patchNumber - info.patchNumber;
        }
        return 0;
    }

    public String toString() {
        return this.versionStr;
    }
}

