/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.design.formula;

import com.tplus.transform.design.DataFormat;
import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.collection.ValueList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class FormulaType {
    public static final String NULLABLE_SUFFIX = "?";
    private static HashMap primaryToNullable;
    public static final boolean useVariant = false;
    String name;
    static List basicTypes;
    public static final FormulaType INT_TYPE;
    public static final FormulaType NULLABLE_INT_TYPE;
    public static final FormulaType FLOAT_TYPE;
    public static final FormulaType NULLABLE_FLOAT_TYPE;
    public static final FormulaType DOUBLE_TYPE;
    public static final FormulaType NULLABLE_DOUBLE_TYPE;
    public static final FormulaType BOOLEAN_TYPE;
    public static final FormulaType NULLABLE_BOOLEAN_TYPE;
    public static final FormulaType DATE_TYPE;
    public static final FormulaType NULLABLE_DATE_TYPE;
    public static final FormulaType STRING_TYPE;
    public static final FormulaType NULLABLE_STRING_TYPE;
    public static final FormulaType CHAR_TYPE;
    public static final FormulaType NULLABLE_CHAR_TYPE;
    public static final FormulaType LONG_TYPE;
    public static final FormulaType NULLABLE_LONG_TYPE;
    public static final FormulaType BINARY_TYPE;
    public static final FormulaType NULLABLE_BINARY_TYPE;
    public static final FormulaType VOID_TYPE;
    public static final FormulaType BIG_INTEGER_TYPE;
    public static final FormulaType NULLABLE_BIG_INTEGER_TYPE;
    public static final FormulaType BIG_DECIMAL_TYPE;
    public static final FormulaType NULLABLE_BIG_DECIMAL_TYPE;
    public static final FormulaType SCALED_DECIMAL_TYPE;
    public static final FormulaType NULLABLE_SCALED_DECIMAL_TYPE;
    public static final FormulaType ISO_DATE_TYPE;
    public static final FormulaType NULLABLE_ISO_DATE_TYPE;
    public static final FormulaType RAW_MESSAGE_TYPE;
    public static final FormulaType NULLABLE_RAW_MESSAGE_TYPE;
    public static final FormulaType STRING_BUFFER_TYPE;
    public static final FormulaType PROPERTY_MAP_TYPE;
    public static final FormulaType OBJECT_TYPE;
    public static final FormulaType MAP_TYPE;
    public static final Object UNKNOWN_TYPE;

    protected FormulaType(String name) {
        this.name = name;
        basicTypes.add(this);
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public static FormulaType valueOf(String name) {
        for (int i = 0; i < basicTypes.size(); ++i) {
            FormulaType formulaType = (FormulaType)basicTypes.get(i);
            if (!formulaType.getName().equals(name)) continue;
            return formulaType;
        }
        throw new IllegalArgumentException("unknown formula type " + name);
    }

    public FormulaType toPrimaryType() {
        return this;
    }

    public static Object toPrimaryType(Object formulaType) {
        if (formulaType instanceof FormulaType) {
            return ((FormulaType)formulaType).toPrimaryType();
        }
        return formulaType;
    }

    public static boolean isNullableType(Object type) {
        return type instanceof NullableFormulaType || type instanceof Class && (ValueList.class.isAssignableFrom((Class)type) || DataObject.class.isAssignableFrom((Class)type)) || type instanceof DataFormat || type == OBJECT_TYPE;
    }

    public static Object toNullableType(Object primaryType) {
        FormulaType.prepareTypeMap();
        Object nullableType = primaryToNullable.get(primaryType);
        if (nullableType != null) {
            return nullableType;
        }
        return primaryType;
    }

    public static List getBasicTypes() {
        return basicTypes;
    }

    private static synchronized void prepareTypeMap() {
        if (primaryToNullable == null) {
            primaryToNullable = new HashMap();
            List basicTypes = FormulaType.getBasicTypes();
            FormulaType[] types = basicTypes.toArray(new FormulaType[basicTypes.size()]);
            for (int i = 0; i < types.length; ++i) {
                FormulaType type = types[i];
                FormulaType primType = type.toPrimaryType();
                if (type == primType) continue;
                primaryToNullable.put(primType, type);
            }
        }
    }

    static {
        basicTypes = new ArrayList();
        INT_TYPE = new FormulaType("int");
        NULLABLE_INT_TYPE = new NullableFormulaType(INT_TYPE);
        FLOAT_TYPE = new FormulaType("float");
        NULLABLE_FLOAT_TYPE = new NullableFormulaType(FLOAT_TYPE);
        DOUBLE_TYPE = new FormulaType("double");
        NULLABLE_DOUBLE_TYPE = new NullableFormulaType(DOUBLE_TYPE);
        BOOLEAN_TYPE = new FormulaType("boolean");
        NULLABLE_BOOLEAN_TYPE = new NullableFormulaType(BOOLEAN_TYPE);
        DATE_TYPE = new FormulaType("Date");
        NULLABLE_DATE_TYPE = new NullableFormulaType(DATE_TYPE);
        STRING_TYPE = new FormulaType("String");
        NULLABLE_STRING_TYPE = new NullableFormulaType(STRING_TYPE);
        CHAR_TYPE = new FormulaType("char");
        NULLABLE_CHAR_TYPE = new NullableFormulaType(CHAR_TYPE);
        LONG_TYPE = new FormulaType("long");
        NULLABLE_LONG_TYPE = new NullableFormulaType(LONG_TYPE);
        BINARY_TYPE = new FormulaType("binary");
        NULLABLE_BINARY_TYPE = new NullableFormulaType(BINARY_TYPE);
        VOID_TYPE = new FormulaType("void");
        BIG_INTEGER_TYPE = new FormulaType("biginteger");
        NULLABLE_BIG_INTEGER_TYPE = new NullableFormulaType(BIG_INTEGER_TYPE);
        BIG_DECIMAL_TYPE = new FormulaType("bigdecimal");
        NULLABLE_BIG_DECIMAL_TYPE = new NullableFormulaType(BIG_DECIMAL_TYPE);
        SCALED_DECIMAL_TYPE = new FormulaType("ScaledDecimal");
        NULLABLE_SCALED_DECIMAL_TYPE = new NullableFormulaType(SCALED_DECIMAL_TYPE);
        ISO_DATE_TYPE = new FormulaType("isodate");
        NULLABLE_ISO_DATE_TYPE = new NullableFormulaType(ISO_DATE_TYPE);
        RAW_MESSAGE_TYPE = new FormulaType("raw");
        NULLABLE_RAW_MESSAGE_TYPE = new NullableFormulaType(RAW_MESSAGE_TYPE);
        STRING_BUFFER_TYPE = new FormulaType("StringBuffer");
        PROPERTY_MAP_TYPE = new FormulaType("PropertyMap");
        OBJECT_TYPE = new FormulaType("object");
        MAP_TYPE = new FormulaType("map");
        UNKNOWN_TYPE = new FormulaType("Unknown");
    }

    static class NullableFormulaType
    extends FormulaType {
        private FormulaType baseType;

        NullableFormulaType(FormulaType baseType) {
            super(baseType.getName() + FormulaType.NULLABLE_SUFFIX);
            this.baseType = baseType;
        }

        public FormulaType toPrimaryType() {
            return this.baseType;
        }
    }
}

