/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.design.loader;

import com.tplus.transform.design.DataField;
import com.tplus.transform.design.DataFieldSection;
import com.tplus.transform.design.DataFormat;
import com.tplus.transform.design.DesignerType;
import com.tplus.transform.design.FieldsFormat;
import com.tplus.transform.design.serial.SerializationContext;
import com.tplus.transform.runtime.DataObjectMetaInfo;
import com.tplus.transform.runtime.DataObjectMetaInfoImpl;
import com.tplus.transform.runtime.ExternalObject;
import com.tplus.transform.runtime.ExternalObjectImpl;
import com.tplus.transform.runtime.FieldMetaInfo;
import com.tplus.transform.runtime.FieldMetaInfoImpl;
import com.tplus.transform.runtime.SectionMetaInfoImpl;
import com.tplus.transform.runtime.SimpleGenericDataObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.WeakHashMap;

public class FormatManager {
    static Map classLoaderMap = new WeakHashMap();
    static Map formatTable = new HashMap();
    static Map cachedMetaData = new Hashtable();

    public static FieldsFormat getCachedFormat(Class callerClass, String name) {
        FieldsFormat fieldsFormat = (FieldsFormat)FormatManager.getFormatTable(callerClass).get(name);
        return fieldsFormat;
    }

    public static void putCachedFormat(Class callerClass, String name, FieldsFormat fieldsFormat) {
        FormatManager.getFormatTable(callerClass).put(name, fieldsFormat);
    }

    public static Map getFormatTable(Class callerClass) {
        ClassLoader classLoader = callerClass.getClassLoader();
        Hashtable formatMap = (Hashtable)classLoaderMap.get(classLoader);
        if (formatMap == null) {
            formatMap = new Hashtable();
            classLoaderMap.put(classLoader, formatMap);
        }
        return formatMap;
    }

    public static ExternalObject createExternalObject(FieldsFormat fieldsFormat) {
        SimpleGenericDataObject headerObj = FormatManager.createHeaderObject(fieldsFormat);
        SimpleGenericDataObject dataObj = FormatManager.createDataObject(fieldsFormat);
        SimpleGenericDataObject trailerObj = FormatManager.createTrailerObject(fieldsFormat);
        return new ExternalObjectImpl("", headerObj, dataObj, trailerObj);
    }

    public static SimpleGenericDataObject createTrailerObject(FieldsFormat fieldsFormat) {
        DataObjectMetaInfo trailerMetaInfo = FormatManager.createGenericMetaInfoWithCache(fieldsFormat.getTrailerFormat());
        SimpleGenericDataObject trailerObj = new SimpleGenericDataObject(trailerMetaInfo);
        return trailerObj;
    }

    public static SimpleGenericDataObject createDataObject(FieldsFormat fieldsFormat) {
        DataObjectMetaInfo dataMetaInfo = FormatManager.createGenericMetaInfoWithCache(fieldsFormat.getDataFormat());
        SimpleGenericDataObject dataObj = new SimpleGenericDataObject(dataMetaInfo);
        return dataObj;
    }

    public static SimpleGenericDataObject createHeaderObject(FieldsFormat fieldsFormat) {
        DataObjectMetaInfo headerMetaInfo = FormatManager.createGenericMetaInfoWithCache(fieldsFormat.getHeaderFormat());
        SimpleGenericDataObject headerObj = new SimpleGenericDataObject(headerMetaInfo);
        return headerObj;
    }

    public static DataObjectMetaInfo createGenericMetaInfoWithCache(DataFormat format) {
        DataObjectMetaInfo genericMetaInfo = (DataObjectMetaInfo)cachedMetaData.get(format);
        if (genericMetaInfo == null) {
            genericMetaInfo = FormatManager.createGenericMetaInfo(format);
            cachedMetaData.put(format, genericMetaInfo);
        }
        return genericMetaInfo;
    }

    private static DataObjectMetaInfo createGenericMetaInfo(DataFormat format) {
        ArrayList<FieldMetaInfoImpl> metaDataList = new ArrayList<FieldMetaInfoImpl>();
        for (int i = 0; i < format.getFieldCount(); ++i) {
            DataField field = format.getField(i);
            String name = field.getName();
            DesignerType type = field.getType();
            if (field instanceof DataFieldSection) {
                DataFieldSection section = (DataFieldSection)field;
                DataObjectMetaInfo sectionFormatMetaInfo = FormatManager.createGenericMetaInfo(section.getSectionFormat());
                SectionMetaInfoImpl fieldMetaInfo = new SectionMetaInfoImpl(sectionFormatMetaInfo, name, section.getMinOccurs(), section.getMaxOccurs());
                metaDataList.add(fieldMetaInfo);
                continue;
            }
            FieldMetaInfoImpl fieldMetaInfo = new FieldMetaInfoImpl(name, type.getName(), field.isOptional());
            metaDataList.add(fieldMetaInfo);
        }
        return new DataObjectMetaInfoImpl(format.getName(), null, metaDataList.toArray(new FieldMetaInfo[metaDataList.size()]));
    }

    public static class SimpleSerializationContext
    implements SerializationContext {
        public void onError(String error) {
        }

        public void onMessage(String message) {
        }

        public int getErrorCount() {
            return 0;
        }

        public void setProperty(String name, String value) {
        }

        public String getProperty(String name) {
            return null;
        }

        public void setValue(String name, Object value) {
        }

        public Object getValue(String name) {
            return null;
        }
    }
}

