/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.design.platform;

import com.tplus.transform.design.DataField;
import com.tplus.transform.design.DiffHelper;
import com.tplus.transform.design.DiffMessageListener;
import com.tplus.transform.design.ValidationHelper;
import com.tplus.transform.design.ValidationMessageListener;
import com.tplus.transform.design.persistence.SQLTypes;
import com.tplus.transform.design.platform.PlatformInfoProvider;
import com.tplus.transform.design.platform.PlatformSpecificInfo;
import com.tplus.transform.util.sql.SQLType;
import java.util.Map;

public class DatabasePlatformSpecificFieldInfo
extends PlatformSpecificInfo {
    public static final String DATABASE_PLATFORM_NAME = "Database";
    public static final String SQL_TYPE = "sqltype";
    public static final String MAX_LENGTH = "length";
    public static final String MAX_DECIMAL_LENGTH = "decimallength";
    public static final String PRIMARY_KEY = "primarykey";
    public static final String REQUIRED = "required";
    public static final String FOREIGN_KEY = "foreignkey";
    public static final String FOREIGN_KEY_TABLE = "referencedtable";
    public static final String FOREIGN_KEY_COLUMN = "referencedcolumn";
    public static final String AUTO_GENERATE = "autogenerate";
    public static final String stdDBPrefix = "F_";
    public static final String CAPTION_COLUMN_NAME = "Column Name";
    public static final String CAPTION_SQL_TYPE = "SQL Type";
    public static final String CAPTION_MAX_LENGTH = "Database Platform Length";
    public static final String CAPTION_MAX_DECIMAL_LENGTH = "Decimal Length";
    public static final String CAPTION_PRIMARY_KEY = "Primary Key";
    public static final String CAPTION_NOT_NULL = "Not Null";
    public static final String CAPTION_FOREIGN_KEY = "Foreign Key";
    public static final String CAPTION_FOREIGN_KEY_TABLE = "Foreign Key Table";
    public static final String CAPTION_FOREIGN_KEY_COLUMN = "Foreign Key Column";
    public static final String CAPTION_AUTO_GENERATE = "Auto Generate";
    boolean primaryKey;
    boolean autoGenerate;
    boolean foreignKey;
    boolean nullable;
    String foreignKeyColumn;
    String foreignKeyTable;
    SQLType sqlType;
    int length;
    int decimalLength;
    private static final long serialVersionUID = 4582983798964634118L;

    public DatabasePlatformSpecificFieldInfo() {
        super(DATABASE_PLATFORM_NAME);
    }

    public int getMaximumLength() {
        return this.length;
    }

    public int getDecimalLength() {
        return this.decimalLength;
    }

    public void setDecimalLength(int decimalLength) {
        this.decimalLength = decimalLength;
    }

    public void setMaximumLength(int length) {
        this.length = length;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(boolean primaryKey) {
        this.primaryKey = primaryKey;
    }

    public boolean isForeignKey() {
        return this.foreignKey;
    }

    public void setForeignKey(boolean foreignKey) {
        this.foreignKey = foreignKey;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setAutoGenerate(boolean autoGenerate) {
        this.autoGenerate = autoGenerate;
    }

    public boolean isAutoGenerate() {
        return this.autoGenerate;
    }

    public void setForeignKeyTable(String foreignKeyTable) {
        this.foreignKeyTable = foreignKeyTable;
    }

    public void setForeignKeyColumn(String foreignKeyColumn) {
        this.foreignKeyColumn = foreignKeyColumn;
    }

    public String getForeignKeyColumn() {
        return this.foreignKeyColumn;
    }

    public String getForeignKeyTable() {
        return this.foreignKeyTable;
    }

    public void setType(String type) {
        this.sqlType = SQLTypes.getSQLType(type);
        this.length = SQLTypes.getDefaultLength(this.sqlType);
        this.decimalLength = SQLTypes.getDefaultDecimal(this.sqlType);
    }

    public void setSQLType(SQLType sqlType) {
        this.sqlType = sqlType;
    }

    public SQLType getSQLType() {
        return this.sqlType;
    }

    public static DatabasePlatformSpecificFieldInfo createDBFieldInfo(DataField fld) {
        DatabasePlatformSpecificFieldInfo dbInfo = new DatabasePlatformSpecificFieldInfo();
        dbInfo.createDefault(fld);
        return dbInfo;
    }

    public void createDefault(DataField fld) {
        SQLType sqlType = SQLTypes.designerToSQLType(fld.getType());
        this.setSQLType(sqlType);
        this.setPlatformSpecificName(DatabasePlatformSpecificFieldInfo.getDBColumnName(fld.getName()));
        this.setNullable(fld.isOptional());
        if (sqlType == SQLType.VARCHAR) {
            this.setMaximumLength(fld.getMaximumLength());
            if (this.length == -1) {
                this.length = 100;
            }
        }
        if (this.getMaximumLength() == 0) {
            this.setMaximumLength(SQLTypes.getDefaultLength(sqlType));
        }
        if (this.getMaximumLength() == 0) {
            this.setMaximumLength(SQLTypes.getDefaultLength(sqlType));
            this.setDecimalLength(SQLTypes.getDefaultDecimal(sqlType));
        }
    }

    public static String getDBColumnName(String name) {
        return DatabasePlatformSpecificFieldInfo.getDBName(name);
    }

    public static String getDBName(String name) {
        if (!ValidationHelper.isJavaIdentifier(name)) {
            StringBuffer out = new StringBuffer();
            if (name.length() > 0 && !Character.isJavaIdentifierStart(name.charAt(0))) {
                out.append(stdDBPrefix);
            }
            for (int i = 0; i < name.length(); ++i) {
                char c = name.charAt(i);
                if (!Character.isJavaIdentifierPart(c)) {
                    c = '_';
                }
                out.append(c);
            }
            return out.toString();
        }
        return name;
    }

    public void setProperties(Map props) {
        super.setProperties(props);
        this.length = DatabasePlatformSpecificFieldInfo.getIntProperty(props, MAX_LENGTH, 0);
        this.decimalLength = DatabasePlatformSpecificFieldInfo.getIntProperty(props, MAX_DECIMAL_LENGTH, 0);
        this.sqlType = SQLType.valueOf(DatabasePlatformSpecificFieldInfo.getIntProperty(props, SQL_TYPE, 0));
        this.primaryKey = DatabasePlatformSpecificFieldInfo.getBooleanProperty(props, PRIMARY_KEY, false);
        this.nullable = !DatabasePlatformSpecificFieldInfo.getBooleanProperty(props, REQUIRED, false);
        this.autoGenerate = DatabasePlatformSpecificFieldInfo.getBooleanProperty(props, AUTO_GENERATE, false);
        this.foreignKey = DatabasePlatformSpecificFieldInfo.getBooleanProperty(props, FOREIGN_KEY, false);
        if (this.foreignKey) {
            this.foreignKeyTable = (String)props.get(FOREIGN_KEY_TABLE);
            this.foreignKeyColumn = (String)props.get(FOREIGN_KEY_COLUMN);
        } else {
            this.foreignKeyColumn = null;
            this.foreignKeyTable = null;
        }
    }

    public void getProperties(Map props) {
        super.getProperties(props);
        props.put(MAX_LENGTH, Integer.toString(this.length));
        props.put(MAX_DECIMAL_LENGTH, Integer.toString(this.decimalLength));
        props.put(SQL_TYPE, Integer.toString(this.sqlType.getSQLType()));
        DatabasePlatformSpecificFieldInfo.putBooleanProperty(props, REQUIRED, !this.nullable);
        if (this.primaryKey) {
            DatabasePlatformSpecificFieldInfo.putBooleanProperty(props, PRIMARY_KEY, this.primaryKey);
        }
        if (this.autoGenerate) {
            DatabasePlatformSpecificFieldInfo.putBooleanProperty(props, AUTO_GENERATE, this.autoGenerate);
        }
        if (this.foreignKey) {
            DatabasePlatformSpecificFieldInfo.putBooleanProperty(props, FOREIGN_KEY, this.foreignKey);
            props.put(FOREIGN_KEY_TABLE, this.foreignKeyTable);
            props.put(FOREIGN_KEY_COLUMN, this.foreignKeyColumn);
        }
    }

    public void diff(PlatformSpecificInfo other, Object location1, Object location2, DiffMessageListener listener) {
        DatabasePlatformSpecificFieldInfo otherInfo = (DatabasePlatformSpecificFieldInfo)other;
        DiffHelper.diffString(this.getPlatformSpecificName(), otherInfo.getPlatformSpecificName(), location1, location2, CAPTION_COLUMN_NAME, listener, false);
        DiffHelper.diffString(SQLTypes.getSQLTypeName(this.getSQLType()), SQLTypes.getSQLTypeName(otherInfo.getSQLType()), location1, location2, CAPTION_SQL_TYPE, listener, false);
        DiffHelper.diffString(Integer.toString(this.getMaximumLength()), Integer.toString(otherInfo.getMaximumLength()), location1, location2, CAPTION_MAX_LENGTH, listener, false);
        DiffHelper.diffString(Integer.toString(this.getDecimalLength()), Integer.toString(otherInfo.getDecimalLength()), location1, location2, CAPTION_MAX_DECIMAL_LENGTH, listener, false);
        DiffHelper.diffBoolean(!this.isNullable(), !otherInfo.isNullable(), location1, location2, CAPTION_NOT_NULL, listener);
        DiffHelper.diffBoolean(this.isPrimaryKey(), otherInfo.isPrimaryKey(), location1, location2, CAPTION_PRIMARY_KEY, listener);
        DiffHelper.diffBoolean(this.isAutoGenerate(), otherInfo.isAutoGenerate(), location1, location2, CAPTION_AUTO_GENERATE, listener);
        DiffHelper.diffBoolean(this.isForeignKey(), otherInfo.isForeignKey(), location1, location2, CAPTION_FOREIGN_KEY, listener);
        DiffHelper.diffString(this.getForeignKeyTable(), otherInfo.getForeignKeyTable(), location1, location2, CAPTION_FOREIGN_KEY_TABLE, listener, false);
        DiffHelper.diffString(this.getForeignKeyColumn(), otherInfo.getForeignKeyColumn(), location1, location2, CAPTION_FOREIGN_KEY_COLUMN, listener, false);
    }

    public void validate(PlatformInfoProvider provider, ValidationMessageListener listener) {
    }
}

