/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.design.platform;

import com.tplus.transform.design.DataField;
import com.tplus.transform.design.DataFieldSection;
import com.tplus.transform.design.DiffHelper;
import com.tplus.transform.design.DiffMessageListener;
import com.tplus.transform.design.ValidationMessageListener;
import com.tplus.transform.design.platform.DatabasePlatformSpecificFieldInfo;
import com.tplus.transform.design.platform.PlatformInfoProvider;
import com.tplus.transform.design.platform.PlatformSpecificInfo;
import java.util.Map;

public class DatabasePlatformSpecificTableInfo
extends PlatformSpecificInfo {
    public static final String DATABASE_PLATFORM_NAME = "Database";
    public static final String SCHEMA_NAME = "schema";
    public static final String CAPTION_TABLE_NAME = "Table Name";
    public static final String CAPTION_SCHEMA_NAME = "Schema";
    String schema;
    private static final long serialVersionUID = 4112983711964634118L;

    public DatabasePlatformSpecificTableInfo() {
        super(DATABASE_PLATFORM_NAME);
    }

    public String getTableName() {
        return this.getPlatformSpecificName();
    }

    public void setTableName(String tableName) {
        super.setPlatformSpecificName(tableName);
    }

    public String getSchemaName() {
        return this.schema;
    }

    public void setSchemaName(String schema) {
        this.schema = schema;
    }

    public void createDefault(DataField nf) {
        this.setTableName(DatabasePlatformSpecificFieldInfo.getDBName(nf.getName()));
    }

    public void setProperties(Map props) {
        super.setProperties(props);
        this.schema = (String)props.get(SCHEMA_NAME);
    }

    public void getProperties(Map props) {
        super.getProperties(props);
        props.put(SCHEMA_NAME, this.schema);
    }

    public static DatabasePlatformSpecificTableInfo createDBTableInfo(DataFieldSection nf) {
        DatabasePlatformSpecificTableInfo dbInfo = new DatabasePlatformSpecificTableInfo();
        dbInfo.createDefault(nf);
        return dbInfo;
    }

    public void diff(PlatformSpecificInfo other, Object location1, Object location2, DiffMessageListener listener) {
        DatabasePlatformSpecificTableInfo otherInfo = (DatabasePlatformSpecificTableInfo)other;
        DiffHelper.diffString(this.getTableName(), otherInfo.getTableName(), location1, location2, CAPTION_TABLE_NAME, listener, false);
        DiffHelper.diffString(this.getSchemaName(), otherInfo.getSchemaName(), location1, location2, CAPTION_SCHEMA_NAME, listener, false);
    }

    public void validate(PlatformInfoProvider provider, ValidationMessageListener listener) {
    }
}

