/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.design.platform;

import com.tplus.transform.design.DataField;
import com.tplus.transform.design.DiffMessageListener;
import com.tplus.transform.design.ValidationMessageListener;
import com.tplus.transform.design.platform.PlatformInfoProvider;
import java.io.Serializable;
import java.util.Map;

public abstract class PlatformSpecificInfo
implements Serializable {
    public static final String PLATFORM_SPECIFIC_NAME = "name";
    public static final String PLATFORM_SPECIFIC_TYPE = "type";
    private String platformName;
    private String platformSpecificName;
    private String platformSpecificType;
    private static final long serialVersionUID = 4582983798964634778L;

    public PlatformSpecificInfo(String platformName) {
        this.platformName = platformName;
    }

    public PlatformSpecificInfo(String platformName, String platformSpecificName, String platformSpecificType) {
        this.platformName = platformName;
        this.platformSpecificName = platformSpecificName;
        this.platformSpecificType = platformSpecificType;
    }

    public abstract void createDefault(DataField var1);

    public String getPlatformName() {
        return this.platformName;
    }

    public String getPlatformSpecificName() {
        return this.platformSpecificName;
    }

    public String getPlatformSpecificType() {
        return this.platformSpecificType;
    }

    public void setPlatformSpecificName(String platformSpecificName) {
        this.platformSpecificName = platformSpecificName;
    }

    public void setPlatformSpecificType(String platformSpecificType) {
        this.platformSpecificType = platformSpecificType;
    }

    public void setProperties(Map props) {
        this.platformSpecificName = (String)props.get(PLATFORM_SPECIFIC_NAME);
        this.platformSpecificType = (String)props.get(PLATFORM_SPECIFIC_TYPE);
    }

    public void getProperties(Map props) {
        props.put(PLATFORM_SPECIFIC_NAME, this.platformSpecificName);
        props.put(PLATFORM_SPECIFIC_TYPE, this.platformSpecificType);
    }

    protected static final void putBooleanProperty(Map props, String propName, boolean value) {
        props.put(propName, new Boolean(value));
    }

    protected static final boolean getBooleanProperty(Map props, String propName, boolean defValue) {
        Object propValue = props.get(propName);
        if (propValue instanceof Boolean) {
            return (Boolean)propValue;
        }
        if (propValue instanceof String) {
            return propValue.equals("true");
        }
        return defValue;
    }

    protected static final int getIntProperty(Map props, String propName, int defValue) {
        Object propValue = props.get(propName);
        if (propValue instanceof Integer) {
            return (Integer)propValue;
        }
        if (propValue instanceof String) {
            return Integer.parseInt((String)propValue);
        }
        return defValue;
    }

    public void diff(PlatformSpecificInfo other, Object location1, Object location2, DiffMessageListener listener) {
    }

    public abstract void validate(PlatformInfoProvider var1, ValidationMessageListener var2);
}

