/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.design.platform;

import com.tplus.transform.design.DataField;
import com.tplus.transform.design.DataFormat;
import com.tplus.transform.design.DiffHelper;
import com.tplus.transform.design.DiffMessageListener;
import com.tplus.transform.design.FieldsFormat;
import com.tplus.transform.design.IDesignElement;
import com.tplus.transform.design.MessageNormalizedFormat;
import com.tplus.transform.design.ValidationMessageListener;
import com.tplus.transform.design.platform.PlatformInfoProvider;
import com.tplus.transform.design.platform.PlatformSpecificInfo;
import com.tplus.transform.design.xml.XMLFieldType;
import com.tplus.transform.util.StringUtils;
import java.util.Map;

public class XMLPlatformSpecificFieldInfo
extends PlatformSpecificInfo {
    public static final String XML_PLATFORM_NAME = "XML";
    private static final String XML_NAME = "xml-name";
    private static final String NAMESPACE = "namespace";
    private static final String XMLFIELD_TYPE = "XMLFieldType";
    String xmlName;
    String namespace = "targetnamespace";
    XMLFieldType xmlFieldType = XMLFieldType.ELEMENT;
    public static final String TARGET_NAMESPACE = "targetnamespace";

    public XMLPlatformSpecificFieldInfo() {
        super(XML_PLATFORM_NAME);
    }

    public String getXMLName() {
        return this.xmlName;
    }

    public void setXMLName(String xmlName) {
        this.xmlName = xmlName;
    }

    public String getPlatformSpecificName() {
        return this.xmlName;
    }

    public void setPlatformSpecificName(String platformSpecificName) {
        this.xmlName = platformSpecificName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public XMLFieldType getXmlFieldType() {
        return this.xmlFieldType;
    }

    public void setXmlFieldType(XMLFieldType xmlFieldType) {
        this.xmlFieldType = xmlFieldType;
    }

    public void createDefault(DataField fld) {
        this.xmlName = fld.getMangledName();
        this.namespace = TARGET_NAMESPACE;
        this.xmlFieldType = XMLFieldType.ELEMENT;
    }

    public void setProperties(Map props) {
        super.setProperties(props);
        this.xmlName = (String)props.get(XML_NAME);
        this.namespace = (String)props.get(NAMESPACE);
        String s = (String)props.get(XMLFIELD_TYPE);
        this.xmlFieldType = s != null ? XMLFieldType.valueOf(s) : XMLFieldType.ELEMENT;
    }

    public void getProperties(Map props) {
        super.getProperties(props);
        props.put(XML_NAME, this.xmlName);
        props.put(NAMESPACE, this.namespace);
        props.put(XMLFIELD_TYPE, this.xmlFieldType.getName());
    }

    public void validate(PlatformInfoProvider provider, ValidationMessageListener listener) {
        if (StringUtils.isEmpty(this.getXMLName())) {
            listener.validationError("PXML100", "XML Name for field cannot be empty", provider, "XML Name");
        } else if (!this.isValidXMLName(this.getXMLName())) {
            listener.validationError("PXML101", "XML Name for field is not valid", provider, "XML Name");
        }
    }

    private boolean isValidXMLName(String xmlName) {
        for (int i = 0; i < xmlName.length(); ++i) {
            char c = xmlName.charAt(i);
            if (!Character.isLetterOrDigit(c) && c != '-' && c != '_' && c != '.') {
                return false;
            }
            if (i != 0 || !Character.isDigit(c) && c != '-' && c != '.') continue;
            return false;
        }
        return true;
    }

    public static String getTargetNamespace(DataFormat df) {
        DataFormat rootFormat = df.getRootFormat();
        return XMLPlatformSpecificFieldInfo.getTargetNamespace0(rootFormat);
    }

    private static String getTargetNamespace0(DataFormat rootFormat) {
        if (rootFormat instanceof MessageNormalizedFormat) {
            MessageNormalizedFormat messageNormalizedFormat = (MessageNormalizedFormat)rootFormat;
            return messageNormalizedFormat.getXMLTargetNamespace();
        }
        IDesignElement designElement = rootFormat.getParent();
        if (designElement instanceof FieldsFormat) {
            FieldsFormat parentFormat = (FieldsFormat)designElement;
            return parentFormat.getXMLTargetNamespace();
        }
        return null;
    }

    public String getResolvedNamespace(DataFormat df) {
        String ns = this.getNamespace();
        if (TARGET_NAMESPACE.equals(ns)) {
            ns = XMLPlatformSpecificFieldInfo.getTargetNamespace(df);
        }
        return ns;
    }

    public String getResolvedNamespace(DataField fld) {
        String ns = this.getNamespace();
        if (TARGET_NAMESPACE.equals(ns)) {
            ns = XMLPlatformSpecificFieldInfo.getTargetNamespace(fld.getRootFormat());
        }
        return ns;
    }

    public void diff(PlatformSpecificInfo other, Object location1, Object location2, DiffMessageListener listener) {
        XMLPlatformSpecificFieldInfo otherInfo = (XMLPlatformSpecificFieldInfo)other;
        DiffHelper.diffString(this.getNamespace(), otherInfo.getNamespace(), location1, location2, NAMESPACE, listener, false);
        DiffHelper.diffString(this.getXMLName(), otherInfo.getXMLName(), location1, location2, XML_NAME, listener, false);
        DiffHelper.diffObject(this.getXmlFieldType(), otherInfo.getXmlFieldType(), location1, location2, XMLFIELD_TYPE, listener, false);
    }
}

