/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.design.serial;

import com.tplus.transform.design.IDesignElement;
import com.tplus.transform.design.serial.SerialException;
import com.tplus.transform.design.serial.SerializationContext;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

public abstract class DesignElementSerial {
    public static final String MESSAGE_FILE_TYPE = "vmf";
    public static final String XML_FILE_TYPE = "xml";
    protected String fileName = null;
    public static final String FILENAME_PROPERY = "serial.filename";
    Map properties = new HashMap();

    public void setProperty(String prop, Object value) {
        this.properties.put(prop, value);
    }

    public Object getProperty(String prop) {
        return this.properties.get(prop);
    }

    public void setProperties(Map props) {
        if (props != null) {
            this.properties.putAll(props);
        }
    }

    protected String getFileName() {
        return this.fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(IDesignElement designElement, String fileName, SerializationContext cxt) throws SerialException {
        try {
            BufferedInputStream reader = new BufferedInputStream(new FileInputStream(fileName));
            if (fileName != null && cxt != null) {
                cxt.setProperty(FILENAME_PROPERY, fileName);
            }
            try {
                this.fileName = fileName;
                this.read(designElement, reader, cxt);
            }
            finally {
                this.fileName = null;
                ((InputStream)reader).close();
            }
        }
        catch (IOException e) {
            throw new SerialException("I/O error " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(IDesignElement designElement, String fileName, SerializationContext cxt) throws SerialException {
        try {
            BufferedOutputStream writer = new BufferedOutputStream(new FileOutputStream(fileName));
            if (fileName != null && cxt != null) {
                cxt.setProperty(FILENAME_PROPERY, fileName);
            }
            try {
                this.write(designElement, writer, cxt);
            }
            finally {
                ((OutputStream)writer).close();
            }
        }
        catch (IOException e) {
            throw new SerialException("I/O error " + e.getMessage());
        }
    }

    public abstract void read(IDesignElement var1, InputStream var2, SerializationContext var3) throws SerialException;

    public abstract void write(IDesignElement var1, OutputStream var2, SerializationContext var3) throws SerialException;
}

