/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.design.serial.xml;

import com.tplus.transform.design.DataFormat;
import com.tplus.transform.design.FieldAttributes;
import com.tplus.transform.design.platform.PlatformInfoProvider;
import com.tplus.transform.design.platform.PlatformSpecificInfo;
import com.tplus.transform.design.serial.SerialException;
import com.tplus.transform.design.serial.SerializationContext;
import com.tplus.transform.design.serial.xml.DesignElementXML;
import com.tplus.transform.design.xml.NamespaceInfo;
import com.tplus.transform.design.xml.NamespaceManager;
import com.tplus.transform.util.SequencedHashMap;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class DataFormatXML
extends DesignElementXML {
    public static final String DATA_FORMAT_TAG = "dataformat";
    public static final String ALIAS_NAME_TAG = "aliasname";
    public static final String NAME_TAG = "name";
    public static final String TYPE_TAG = "type";
    public static final String HIDDEN_TAG = "hidden";
    public static final String NOT_NULL_TAG = "notnull";
    public static final String REQUIRED_TAG = "required";
    public static final String LENGTH_TAG = "length";
    public static final String DEFAULT_VALUE_TAG = "defaultvalue";
    public static final String MIN_OCCURS_TAG = "minoccurs";
    public static final String MAX_OCCURS_TAG = "maxoccurs";
    public static final String PLATFORM_INFO_TAG = "platforminfo";
    public static final String PLATFORM_TAG = "platform";
    public static final String ENABLED_TAG = "enabled";
    public static final String FIELD_TAG = "field";
    public static final String FIELDS_TAG = "fields";
    public static final String DATE_FORMAT_TAG = "dateformat";
    private static final String TARGET_NAMESPACE = "target-namespace";
    private static final String FIELD_ATTRIBUTES_TAG = "field-attributes";
    private static final String FIELD_ATTRIBUTE_TAG = "field-attribute";
    public static final String NAMESPACE_ATTR = "namespace";
    private static final String PREFIX_ATTR = "prefix";
    private static final String VALUE_ATTR = "value";
    public static final String XPATH_NAMESPACES = "xpath-namespaces";
    public static final String XSI_TYPE_ATTR = "xsi:type";
    public static final String RUNTIME = "runtime";
    public static boolean ADD_XSI_TYPE = true;

    public abstract void writeDataFormat(DataFormat var1, StringBuffer var2, SerializationContext var3);

    public abstract void readDataFormat(DataFormat var1, Element var2, SerializationContext var3) throws SerialException;

    public boolean readFieldsSpecial(DataFormat df, Reader reader, SerializationContext cxt) throws SerialException {
        try {
            Document doc = DataFormatXML.createDocumentFromReader(reader);
            Element elm = doc.getDocumentElement();
            return this.readFieldsSpecial(df, elm, cxt);
        }
        catch (Exception e) {
            this.handleDocumentException(e);
            return false;
        }
    }

    protected String readTargetNamespace(Element nd) {
        return DataFormatXML.getSingleChildElementValue(nd, TARGET_NAMESPACE);
    }

    protected void writeTargetNamespace(String namespace, StringBuffer toRet) {
        toRet.append(this.tagValue(TARGET_NAMESPACE, namespace));
    }

    protected void writeFieldTag(StringBuffer toRet) {
        DataFormatXML.writeFieldTag(this, toRet, this.getFieldXSDType());
    }

    public static void writeFieldTag(DesignElementXML designElementXML, StringBuffer toRet, String xsiType) {
        if (xsiType != null && ADD_XSI_TYPE) {
            toRet.append(designElementXML.startTagWithAttr(FIELD_TAG, XSI_TYPE_ATTR, xsiType));
        } else {
            toRet.append(designElementXML.startTag(FIELD_TAG));
        }
    }

    protected void writeSectionTag(StringBuffer toRet) {
        DataFormatXML.writeSectionTag(this, toRet, this.getSectionXSDType());
    }

    public static void writeSectionTag(DesignElementXML designElementXML, StringBuffer toRet, String xsiType) {
        if (xsiType != null && ADD_XSI_TYPE) {
            toRet.append(designElementXML.startTagWithAttr(FIELD_TAG, XSI_TYPE_ATTR, xsiType));
        } else {
            toRet.append(designElementXML.startTag(FIELD_TAG));
        }
    }

    protected String getSectionXSDType() {
        return "SectionType";
    }

    protected String getFieldXSDType() {
        return "FieldType";
    }

    public boolean readFieldsSpecial(DataFormat df, Element nd, SerializationContext cxt) throws SerialException {
        this.checkRootTag(nd, DATA_FORMAT_TAG, cxt);
        String type = nd.getAttribute(TYPE_TAG);
        if (type.equals(this.getRootTag())) {
            this.readDataFormat(df, nd, cxt);
            return true;
        }
        return false;
    }

    public StringBuffer writeFieldsSpecial(DataFormat df, SerializationContext cxt) throws SerialException {
        StringBuffer toRet = new StringBuffer();
        toRet.append(this.startTagWithAttr(DATA_FORMAT_TAG, TYPE_TAG, this.getRootTag()));
        this.writeDataFormat(df, toRet, cxt);
        toRet.append(this.endTag(DATA_FORMAT_TAG));
        return toRet;
    }

    public static void flush(Writer writer, StringBuffer buffer) throws SerialException {
        try {
            writer.write(buffer.toString());
            buffer.setLength(0);
        }
        catch (IOException e) {
            throw new SerialException("Unexpected IOExceptiom", e);
        }
    }

    public static void readPlatformInfo(PlatformInfoProvider provider, Element nd, SerializationContext cxt) {
        Element fieldAttributesElm;
        Element platformInfoElm = DataFormatXML.getSingleChildElement(nd, PLATFORM_INFO_TAG);
        if (platformInfoElm != null) {
            NodeList platformList = DataFormatXML.getChildElementsByTagName(platformInfoElm, PLATFORM_TAG);
            for (int i = 0; i < platformList.getLength(); ++i) {
                Element platformElm = (Element)platformList.item(i);
                String platformName = platformElm.getAttribute(NAME_TAG);
                PlatformSpecificInfo info = provider.createPlatformSpecificInfo(platformName);
                SequencedHashMap props = new SequencedHashMap();
                DataFormatXML.readProperties(platformElm, props);
                info.setProperties(props);
                provider.setPlatformSpecificInfo(info);
            }
        }
        if ((fieldAttributesElm = DataFormatXML.getSingleChildElement(nd, FIELD_ATTRIBUTES_TAG)) != null) {
            NodeList fieldAttribList = DataFormatXML.getChildElementsByTagName(fieldAttributesElm, FIELD_ATTRIBUTE_TAG);
            FieldAttributes fieldAttributes = provider.getFieldAttributes();
            fieldAttributes.removeAll();
            for (int i = 0; i < fieldAttribList.getLength(); ++i) {
                Element fieldAttribElm = (Element)fieldAttribList.item(i);
                String attribName = fieldAttribElm.getAttribute(NAME_TAG);
                boolean runtime = Boolean.valueOf(fieldAttribElm.getAttribute(RUNTIME));
                fieldAttributes.addAttribute(attribName, DataFormatXML.getElementText(fieldAttribElm), runtime);
            }
        }
    }

    public void readNamespacePrefixes(Element elm, NamespaceManager namespaceManager, String tag) {
        Element nd = DataFormatXML.getSingleChildElement(elm, tag);
        namespaceManager.clear();
        if (nd != null) {
            NodeList nodeList = DataFormatXML.getChildElementsByTagName(nd, NAMESPACE_ATTR);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element namespaceElm = (Element)nodeList.item(i);
                String prefix = namespaceElm.getAttribute(PREFIX_ATTR);
                String namespace = namespaceElm.getAttribute(VALUE_ATTR);
                namespaceManager.addNamespace(new NamespaceInfo(namespace, prefix));
            }
        }
    }

    public void writeNamespacePrefixes(NamespaceManager namespaceManager, String tag, StringBuffer buffer, SerializationContext cxt) {
        List namespaces = namespaceManager.getNamespaces();
        if (namespaces.size() > 0) {
            buffer.append(this.startTag(tag));
            for (int i = 0; i < namespaces.size(); ++i) {
                NamespaceInfo namespaceInfo = (NamespaceInfo)namespaces.get(i);
                buffer.append(this.tagWithAttr(NAMESPACE_ATTR, VALUE_ATTR, namespaceInfo.getNamespace(), PREFIX_ATTR, namespaceInfo.getPrefix()));
            }
            buffer.append(this.endTag(tag));
        }
    }

    public void writePlatformInfo(PlatformInfoProvider provider, StringBuffer buffer, SerializationContext cxt) {
        FieldAttributes fieldAttributes;
        List list;
        String[] platforms = provider.getDefinedPlatforms();
        if (platforms.length > 0) {
            buffer.append(this.startTag(PLATFORM_INFO_TAG));
            for (int j = 0; j < platforms.length; ++j) {
                String platform = platforms[j];
                buffer.append(this.startTagWithAttr(PLATFORM_TAG, NAME_TAG, platform));
                PlatformSpecificInfo info = provider.getPlatformSpecificInfo(platform);
                SequencedHashMap props = new SequencedHashMap();
                info.getProperties(props);
                this.writeProperties(buffer, props);
                buffer.append(this.endTag(PLATFORM_TAG));
            }
            buffer.append(this.endTag(PLATFORM_INFO_TAG));
        }
        if ((list = (fieldAttributes = provider.getFieldAttributes()).getAttributes()) != null && list.size() > 0) {
            buffer.append(this.startTag(FIELD_ATTRIBUTES_TAG));
            for (int j = 0; j < list.size(); ++j) {
                FieldAttributes.FieldAttribute fieldAttribute = (FieldAttributes.FieldAttribute)list.get(j);
                if (fieldAttribute.isRuntime()) {
                    buffer.append(this.tagValueWithAttrib(FIELD_ATTRIBUTE_TAG, fieldAttribute.getValue(), NAME_TAG, fieldAttribute.getName()));
                    continue;
                }
                buffer.append(this.tagValueWithAttrib(FIELD_ATTRIBUTE_TAG, fieldAttribute.getValue(), NAME_TAG, fieldAttribute.getName(), RUNTIME, Boolean.toString(fieldAttribute.isRuntime())));
            }
            buffer.append(this.endTag(FIELD_ATTRIBUTES_TAG));
        }
    }
}

