/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.design.serial.xml;

import com.tplus.transform.design.IDesignElement;
import com.tplus.transform.design.PropertyCollection;
import com.tplus.transform.design.serial.DesignElementSerialText;
import com.tplus.transform.design.serial.SerialException;
import com.tplus.transform.design.serial.SerializationContext;
import com.tplus.transform.util.SequencedHashMap;
import com.tplus.transform.util.log.Log;
import com.tplus.transform.util.log.LogFactory;
import com.tplus.transform.util.xml.DOMUtil;
import com.tplus.transform.util.xml.XMLUtils;
import com.tplus.transform.util.xml.XMLWriterUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class DesignElementXML
extends DesignElementSerialText {
    public static final String XML_ENCODING = "UTF-8";
    public static final String PROPERTY_TAG = "property";
    public static final String PROP_VALUE_ATTR = "value";
    public static final String PROP_NAME_ATTR = "name";
    public static final String DESIGN_ELEMENT_TYPE_ATTR = "type";
    public static final String NAME_ATTR = "name";
    public static final String UID_ATTR = "uid";
    public static final String VERSION_ATTR = "version";
    public static final String PROPERTY_MAP_TAG = "propertymap";
    public static final String PROPERTY_LIST_TAG = "propertylist";
    public static final String PROP_COLLECTION_ATTR = "type";
    public static final String VALUE_TAG = "value";
    public static final String VERSION_TAG = "version";
    public static final String DESIGN_ELEMENT_PROPERTIES_TAG = "elementproperties";
    public static final String DETAILED_NAME_TAG = "detailed-name";
    public static final String DESCRIPTION_TAG = "description";
    public static final String DESCRIPTION_TAG2 = "Description";
    public static Log log = LogFactory.getLog("com.tplus.transform.design.serial.xml");
    String encoding = "UTF-8";
    public static boolean USE_DEFAULT_ENCODING = false;
    private static final String tempIndent = "\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t";
    protected static final String fullindent = "\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t";
    public static final String type = "xml";
    public static final String outputType = "xml";
    private int indent = 0;
    DocumentBuilder docBuilder;
    XMLWriterUtil xmlWriterUtil = new XMLWriterUtil();

    static InputSource createInputSource(InputStream stream, boolean defaultEncoding) {
        if (USE_DEFAULT_ENCODING || defaultEncoding) {
            return new InputSource(new InputStreamReader(stream));
        }
        return new InputSource(stream);
    }

    static InputSource createInputSource(InputStream stream) {
        return DesignElementXML.createInputSource(stream, false);
    }

    OutputStreamWriter createOutputStreamWriter(OutputStream writer) throws UnsupportedEncodingException {
        if (USE_DEFAULT_ENCODING) {
            return new OutputStreamWriter(writer);
        }
        return new OutputStreamWriter(writer, this.getEncoding());
    }

    protected static void logassert(boolean bl, String message) {
        if (!bl) {
            log.error("Assertion failed. " + message);
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void readDesignElementProperties(IDesignElement designElm, Element elm, SerializationContext cxt) throws SerialException {
        Element designElmProps;
        Element designElmPropsRoot = DesignElementXML.getSingleChildElement(elm, DESIGN_ELEMENT_PROPERTIES_TAG);
        if (designElmPropsRoot != null && (designElmProps = DesignElementXML.getSingleChildElement(designElmPropsRoot, PROPERTY_MAP_TAG)) != null) {
            Map propertiesMap = (Map)this.readProperties(designElmProps, cxt);
            for (Map.Entry entry : propertiesMap.entrySet()) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                designElm.setProperty((String)key, value);
            }
        }
    }

    protected Object readProperties(Element propertiesElm, SerializationContext cxt) throws SerialException {
        Map tempMap;
        String className = propertiesElm.getAttribute("type");
        PropertyCollection collection = null;
        if (DesignElementXML.isEmpty(className)) {
            tempMap = new SequencedHashMap();
        } else {
            Object obj = DesignElementXML.createInstance(className, cxt);
            if (obj instanceof Map) {
                tempMap = (Map)obj;
            } else if (obj instanceof PropertyCollection) {
                collection = (PropertyCollection)obj;
                tempMap = new SequencedHashMap();
            } else {
                log.error("Cannot read properties. Unexpected type " + obj);
                return null;
            }
        }
        NodeList properties = DesignElementXML.getChildElementsByTagName(propertiesElm, PROPERTY_TAG);
        for (int i = 0; i < properties.getLength(); ++i) {
            Element prop = (Element)properties.item(i);
            String propName = prop.getAttribute("name");
            String propValue = prop.getAttribute("value");
            if (prop.getAttributeNode("value") == null) {
                Object compoundValue;
                Element valueElm = DesignElementXML.getSingleChildElement(prop, "value");
                if (valueElm == null || (compoundValue = this.readCompoundValue(valueElm, cxt)) == null) continue;
                tempMap.put(propName, compoundValue);
                continue;
            }
            tempMap.put(propName, propValue);
        }
        if (collection != null) {
            collection.setAsProperties(tempMap);
            return collection;
        }
        return tempMap;
    }

    private Object readCompoundValue(Element valueElm, SerializationContext cxt) throws SerialException {
        NodeList elements = DesignElementXML.getChildElements(valueElm);
        Object collectionType = null;
        if (elements.getLength() == 1) {
            Element valueObjectElm = (Element)elements.item(0);
            String nodeName = valueObjectElm.getNodeName();
            if (nodeName.equals(PROPERTY_MAP_TAG)) {
                return this.readProperties(valueObjectElm, cxt);
            }
            if (nodeName.equals(PROPERTY_LIST_TAG)) {
                return this.readList(valueObjectElm, cxt);
            }
            if (nodeName.equals("value")) {
                String simpleValue = valueObjectElm.getAttribute("value");
                return simpleValue;
            }
            log.error("unrecognized value elm tag " + nodeName);
        } else if (elements.getLength() == 0) {
            String text = DesignElementXML.getElementText(valueElm);
            return text;
        }
        log.error("More than one value element");
        return null;
    }

    private Object readList(Element listElm, SerializationContext cxt) throws SerialException {
        String className = listElm.getAttribute("type");
        List<Object> tempList = null;
        if (DesignElementXML.isEmpty(className)) {
            tempList = new ArrayList();
        } else {
            Object obj = DesignElementXML.createInstance(className, cxt);
            if (obj instanceof List) {
                tempList = (List)obj;
            } else {
                return tempList;
            }
        }
        NodeList listElms = DesignElementXML.getChildElementsByTagName(listElm, "value");
        for (int i = 0; i < listElms.getLength(); ++i) {
            Element valueElm = (Element)listElms.item(i);
            String propValue = valueElm.getAttribute("value");
            if (propValue == null || propValue.length() == 0) {
                tempList.add(this.readCompoundValue(valueElm, cxt));
                continue;
            }
            tempList.add(propValue);
        }
        return tempList;
    }

    private static Object createInstance(String className, SerializationContext cxt) throws SerialException {
        try {
            Class<?> cls = Class.forName(className);
            Object obj = cls.newInstance();
            return obj;
        }
        catch (Exception e) {
            throw new SerialException("Error instantiating class", e);
        }
    }

    public StringBuffer writeDesignElementProperties(IDesignElement elm, SerializationContext cxt) throws SerialException {
        StringBuffer propertiesBuffer = new StringBuffer();
        Map properties = elm.getProperties();
        if (properties != null) {
            propertiesBuffer.append(this.startTag(DESIGN_ELEMENT_PROPERTIES_TAG));
            this.writeProperties(properties, propertiesBuffer, "");
            propertiesBuffer.append(this.endTag(DESIGN_ELEMENT_PROPERTIES_TAG));
        }
        return propertiesBuffer;
    }

    protected void writeProperties(Map propertiesMap, StringBuffer propertiesBuffer, String collectionType) {
        if (collectionType != null && collectionType.length() > 0) {
            propertiesBuffer.append(this.startTagWithAttr(PROPERTY_MAP_TAG, "type", collectionType));
        } else {
            propertiesBuffer.append(this.startTag(PROPERTY_MAP_TAG));
        }
        for (Map.Entry entry : propertiesMap.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            this.writeKeyValue(key, value, propertiesBuffer);
        }
        propertiesBuffer.append(this.endTag(PROPERTY_MAP_TAG));
    }

    private void writeKeyValue(Object key, Object value, StringBuffer propertiesBuffer) {
        if (value == null) {
            return;
        }
        if (!(key instanceof String)) {
            return;
        }
        if (value instanceof String) {
            this.writeSimpleProperty((String)key, (String)value, propertiesBuffer);
            return;
        }
        propertiesBuffer.append(this.startTagWithAttr(PROPERTY_TAG, "name", (String)key));
        propertiesBuffer.append(this.startTag("value"));
        this.writeCompoundValue(value, propertiesBuffer);
        propertiesBuffer.append(this.endTag("value"));
        propertiesBuffer.append(this.endTag(PROPERTY_TAG));
    }

    private void writeSimpleProperty(String key, String value, StringBuffer toWrite) {
        if (value != null && value.indexOf(10) != -1) {
            toWrite.append(this.startTagWithAttr(PROPERTY_TAG, "name", key));
            if (value.indexOf(60) != -1 && value.indexOf("]]>") == -1) {
                toWrite.append(this.tagCDATAValue("value", value));
            } else {
                toWrite.append(this.tagValue("value", value));
            }
            toWrite.append(this.endTag(PROPERTY_TAG));
        } else {
            toWrite.append(this.tagWithAttr(PROPERTY_TAG, "name", key, "value", value));
        }
    }

    void writeProperty(StringBuffer toWrite, String key, String value) {
        toWrite.append(this.tagWithAttr(PROPERTY_TAG, "name", key, "value", value));
    }

    private void writeList(List propertiesList, StringBuffer propertiesBuffer, String collectionType) {
        if (collectionType != null && collectionType.length() > 0) {
            propertiesBuffer.append(this.startTagWithAttr(PROPERTY_LIST_TAG, "type", collectionType));
        } else {
            propertiesBuffer.append(this.startTag(PROPERTY_LIST_TAG));
        }
        for (int i = 0; i < propertiesList.size(); ++i) {
            Object value = propertiesList.get(i);
            this.writeValue(value, propertiesBuffer);
        }
        propertiesBuffer.append(this.endTag(PROPERTY_LIST_TAG));
    }

    private void writeValue(Object value, StringBuffer propertiesBuffer) {
        if (value instanceof String) {
            this.writeSimpleValue((String)value, propertiesBuffer);
        } else {
            propertiesBuffer.append(this.startTag("value"));
            this.writeCompoundValue(value, propertiesBuffer);
            propertiesBuffer.append(this.endTag("value"));
        }
    }

    private void writeSimpleValue(String value, StringBuffer propertiesBuffer) {
        propertiesBuffer.append(this.tagWithAttr("value", "value", value));
    }

    private void writeCompoundValue(Object value, StringBuffer propertiesBuffer) {
        String collectionType = null;
        if (value instanceof PropertyCollection) {
            PropertyCollection propCollection = (PropertyCollection)value;
            collectionType = value.getClass().getName();
            value = propCollection.getAsProperties();
        }
        if (value instanceof Map) {
            Map propertiesMap = (Map)value;
            this.writeProperties(propertiesMap, propertiesBuffer, collectionType);
        } else if (value instanceof List) {
            List valueList = (List)value;
            this.writeList(valueList, propertiesBuffer, collectionType);
        } else {
            log.error("Cannot write " + value.getClass().getName());
        }
    }

    public void read(Object obj, Reader reader, SerializationContext cxt) throws SerialException {
        try {
            Document doc = DesignElementXML.createDocumentFromReader(reader);
            Element elm = doc.getDocumentElement();
            this.read(obj, elm, cxt);
        }
        catch (SAXException e) {
            log.debug("Stack Trace : " + e.getMessage(), e);
            throw new SerialException("XML read error", e);
        }
        catch (IOException e) {
            log.debug("Stack Trace : " + e.getMessage(), e);
            throw new SerialException("XML read error", e);
        }
        catch (ParserConfigurationException e) {
            log.debug("Stack Trace : " + e.getMessage(), e);
            throw new SerialException("XML read error", e);
        }
    }

    public abstract String getRootTag();

    public String getAliasRootTag() {
        return null;
    }

    public void inheritFrom(DesignElementXML source) {
        this.setIndent(source.getIndent());
        this.setProperty("line.separator", source.getLineSeparator());
    }

    protected void checkRootTag(Element nd, SerializationContext cxt) throws SerialException {
        this.check(nd);
        String tagName = nd.getTagName();
        if (!(tagName.equals(this.getRootTag()) || tagName.equals(this.getAliasRootTag()) || this.isRootTagAcceptable(tagName))) {
            throw new SerialException("The root tag name should be '" + this.getRootTag() + "'" + " found '" + tagName + "'.");
        }
    }

    protected void check(Element nd) throws SerialException {
        if (nd == null) {
            throw new SerialException("The root tag name should be '" + this.getRootTag() + "'" + " found '" + "" + "'.");
        }
    }

    protected boolean isRootTagAcceptable(String tagName) {
        return false;
    }

    protected void checkRootTag(Element nd, String rootTag, SerializationContext cxt) throws SerialException {
        this.check(nd);
        if (!nd.getTagName().equals(rootTag)) {
            throw new SerialException("The root tag name should be '" + rootTag + "'" + " found " + nd.getTagName());
        }
    }

    protected void checkRootTag(Element nd, String rootTag1, String rootTag2, SerializationContext cxt) throws SerialException {
        this.check(nd);
        if (!nd.getTagName().equals(rootTag1) && !nd.getTagName().equals(rootTag2)) {
            throw new SerialException("The root tag name should be '" + rootTag1 + "'" + " found " + nd.getTagName());
        }
    }

    public void read(Object obj, Element nd, SerializationContext cxt) throws SerialException {
        if (obj instanceof IDesignElement) {
            this.read((IDesignElement)obj, nd, cxt);
        }
    }

    void handleSAXParseException(SAXParseException e) throws SerialException {
        log.debug("Stack Trace : " + e.getMessage(), e);
        int line = e.getLineNumber();
        int col = e.getColumnNumber();
        throw new SerialException("[" + line + "," + col + "]- XML read error", e);
    }

    public void read(IDesignElement designElement, InputStream is, SerializationContext cxt) throws SerialException {
        try {
            Document doc = DesignElementXML.createDocument(is);
            Element elm = doc.getDocumentElement();
            this.read(designElement, elm, cxt);
        }
        catch (Exception e) {
            this.handleDocumentException(e);
        }
    }

    public void read(IDesignElement designElement, Reader reader, SerializationContext cxt) throws SerialException {
        try {
            Document doc = DesignElementXML.createDocumentFromReader(reader);
            Element elm = doc.getDocumentElement();
            this.read(designElement, elm, cxt);
        }
        catch (Exception e) {
            this.handleDocumentException(e);
        }
    }

    protected void handleDocumentException(Exception e) throws SerialException {
        if (e instanceof SerialException) {
            throw (SerialException)e;
        }
        if (e instanceof SAXParseException) {
            this.handleSAXParseException((SAXParseException)e);
        } else {
            if (e instanceof SAXException) {
                SAXException saxException = (SAXException)e;
                if (saxException.getException() instanceof SAXParseException) {
                    this.handleSAXParseException((SAXParseException)saxException.getException());
                }
                log.debug("Stack Trace : " + e.getMessage(), e);
                throw new SerialException("XML read error", e);
            }
            if (e instanceof IOException) {
                log.debug("Stack Trace : " + e.getMessage(), e);
                throw new SerialException("XML read error", e);
            }
            if (e instanceof ParserConfigurationException) {
                log.debug("Stack Trace : " + e.getMessage(), e);
                throw new SerialException("XML read error", e);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
        }
        throw new SerialException("XML read error", e);
    }

    public void write(IDesignElement elm, OutputStream writer, SerializationContext cxt) throws SerialException {
        try {
            OutputStreamWriter streamWriter = this.createOutputStreamWriter(writer);
            this.write(elm, (Writer)streamWriter, cxt);
        }
        catch (UnsupportedEncodingException e) {
            throw new SerialException("Encoding error", e);
        }
    }

    public void write(IDesignElement elm, Writer writer, SerializationContext cxt) throws SerialException {
        PrintWriter pw = new PrintWriter(writer);
        if (!"false".equalsIgnoreCase(cxt.getProperty("xmlDecl"))) {
            pw.println("<?xml version=\"1.0\" encoding=\"" + this.encoding + "\" ?>");
        }
        this.writeNode(elm, pw, cxt);
        pw.flush();
    }

    protected void writeNode(IDesignElement elm, PrintWriter pw, SerializationContext cxt) throws SerialException {
        StringBuffer nodeStr = this.writeNode(elm, cxt);
        pw.println(nodeStr);
    }

    protected final StringBuffer writeNodeHelper(IDesignElement elm, SerializationContext cxt) throws SerialException {
        StringWriter writer = new StringWriter();
        PrintWriter pw = new PrintWriter(writer);
        this.writeNode(elm, pw, cxt);
        return writer.getBuffer();
    }

    public void read(IDesignElement designElement, Element nd, SerializationContext cxt) throws SerialException {
    }

    public void readPass1(IDesignElement designElement, Element nd, SerializationContext cxt) throws SerialException {
    }

    public void readPass2(IDesignElement designElement, Element nd, SerializationContext cxt) throws SerialException {
        this.read(designElement, nd, cxt);
    }

    public StringBuffer writeNode(IDesignElement elm, SerializationContext cxt) throws SerialException {
        return new StringBuffer();
    }

    protected void writeProperty(StringBuffer toWrite, String name, Object value) {
        if (value instanceof String) {
            this.writeProperty(toWrite, name, (String)value);
        }
        if (value instanceof Boolean) {
            this.writeProperty(toWrite, name, (Boolean)value != false ? "true" : "false");
        }
        if (value instanceof Number) {
            this.writeProperty(toWrite, name, value.toString());
        }
    }

    protected Object readProperty(Element elm, String name, Class cls) {
        String valueStr = this.readProperty(elm, name);
        if (valueStr == null || valueStr.length() == 0) {
            return null;
        }
        if (cls == String.class) {
            return valueStr;
        }
        if (cls == Integer.class) {
            return new Integer(Integer.parseInt(valueStr));
        }
        if (cls == Boolean.class) {
            return valueStr.equals("true") ? Boolean.TRUE : Boolean.FALSE;
        }
        throw new IllegalArgumentException("Unsupported property type " + cls);
    }

    protected void writeProperties(StringBuffer buffer, Map props) {
        for (Map.Entry entry : props.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            this.writeProperty(buffer, key, value);
        }
    }

    protected static void readProperties(Element elm, Map props) {
        NodeList properties = DesignElementXML.getChildElementsByTagName(elm, PROPERTY_TAG);
        for (int i = 0; i < properties.getLength(); ++i) {
            Element prop = (Element)properties.item(i);
            String propName = prop.getAttribute("name");
            String propValue = prop.getAttribute("value");
            if (propValue == null || propValue.length() == 0) {
                Attr attr = prop.getAttributeNode("value");
                if (attr == null) continue;
                props.put(propName, "");
                continue;
            }
            props.put(propName, propValue);
        }
    }

    protected String readProperty(Element elm, String name) {
        NodeList properties = DesignElementXML.getChildElementsByTagName(elm, PROPERTY_TAG);
        for (int i = 0; i < properties.getLength(); ++i) {
            Element prop = (Element)properties.item(i);
            String propName = prop.getAttribute("name");
            if (!propName.equals(name)) continue;
            String value = prop.getAttribute("value");
            if (value == null || value.length() == 0) {
                value = DesignElementXML.getElementText(prop);
            }
            return value;
        }
        return null;
    }

    protected static Document createDocumentFromReader(Reader reader) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        InputSource inputSource = new InputSource(reader);
        Document doc = docBuilder.parse(inputSource);
        return doc;
    }

    protected static Document createDocumentNSFromReader(Reader reader) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setNamespaceAware(true);
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        InputSource inputSource = new InputSource(reader);
        Document doc = docBuilder.parse(inputSource);
        return doc;
    }

    public Document createDocumentCached(InputStream is) throws SAXException, IOException, ParserConfigurationException {
        if (this.docBuilder == null) {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            this.docBuilder = docBuilderFactory.newDocumentBuilder();
        }
        InputSource inputSource = DesignElementXML.createInputSource(is);
        Document doc = this.docBuilder.parse(inputSource);
        return doc;
    }

    public static Document createDocument(InputStream is) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        InputSource inputSource = DesignElementXML.createInputSource(is);
        Document doc = docBuilder.parse(inputSource);
        return doc;
    }

    public static Document createDocumentNS(InputStream is) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setNamespaceAware(true);
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        InputSource inputSource = DesignElementXML.createInputSource(is);
        Document doc = docBuilder.parse(inputSource);
        return doc;
    }

    public static Document createDocument(String fileName) throws SAXException, IOException, ParserConfigurationException {
        return XMLUtils.createDocument(fileName);
    }

    public static int getSingleChildElementIntValue(Element parent, String tagName, int defaultValue) {
        return XMLUtils.getSingleChildElementIntValue(parent, tagName, defaultValue);
    }

    public static boolean getSingleChildElementBooleanValue(Element parent, String tagName, boolean defaultValue) {
        return XMLUtils.getSingleChildElementBooleanValue(parent, tagName, defaultValue);
    }

    public static String getSingleChildElementValue(Element parent, String tagName, String defaultValue) {
        return XMLUtils.getSingleChildElementValue(parent, tagName, defaultValue);
    }

    public static String normalize(String clsName) {
        return XMLUtils.normalize(clsName);
    }

    public static String getNormalizedSingleChildElementValue(Element parent, String tagName) {
        return XMLUtils.getNormalizedSingleChildElementValue(parent, tagName);
    }

    public static String getSingleChildElementValue(Element parent, String tagName) {
        return XMLUtils.getSingleChildElementValue(parent, tagName);
    }

    public static String getSingleChildElementValueWithAlias(Element parent, String tagName1, String tagName2) {
        return XMLUtils.getSingleChildElementValueWithAlias(parent, tagName1, tagName2);
    }

    public static String getElementText(Node text) {
        return XMLUtils.getElementText(text);
    }

    public static Element getSingleChildElement(Element parent, String tagName, String tagName2) {
        return XMLUtils.getSingleChildElement(parent, tagName, tagName2);
    }

    public static Element getSingleChildElement(Element parent, String tagName) {
        return XMLUtils.getSingleChildElement(parent, tagName);
    }

    public static void checkExistence(Object tag, String tagName) throws SerialException {
        if (tag == null) {
            throw new SerialException("Error in XML: '" + tagName + "' tag not found.");
        }
    }

    public static void checkTagValue(String tagValue, String tagName) throws SerialException {
        if (tagValue == null || tagValue.trim().equals("")) {
            throw new SerialException("Error in XML: value for '" + tagName + "' tag not found.");
        }
    }

    public static NodeList getChildElementsIgnoreSpecial(Element elm, Set knownSet) {
        XMLUtils.SimpleNodeList nodeList = new XMLUtils.SimpleNodeList();
        NodeList lst = elm.getChildNodes();
        int length = lst.getLength();
        for (int i = 0; i < length; ++i) {
            Element childElm;
            Node nd = lst.item(i);
            if (!(nd instanceof Element) || knownSet.contains((childElm = (Element)nd).getTagName())) continue;
            nodeList.add(childElm);
        }
        return nodeList;
    }

    public static NodeList getChildElements(Element elm) {
        return XMLUtils.getChildElements(elm);
    }

    public static NodeList getChildElementsByTagName(Element elm, String tag) {
        return XMLUtils.getChildElementsByTagName(elm, tag);
    }

    public static NodeList getChildElementsByTagNameNS(Element elm, String tag, String namespace) {
        return XMLUtils.getChildElementsByTagNameNS(elm, tag, namespace);
    }

    public static NodeList getChildElementsByTagName(Element elm, String tag, String tag2) {
        return XMLUtils.getChildElementsByTagName(elm, tag, tag2);
    }

    public static NodeList getChildElementsByTagName(Element elm, String[] tags) {
        return XMLUtils.getChildElementsByTagName(elm, tags);
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static String getXMLFragment(Element elm) {
        return DOMUtil.convertElementToXML(elm);
    }

    public String tagValue(String tagName, String value) {
        return this.xmlWriterUtil.tagValue(tagName, value);
    }

    public String tagValueIgnoreEmpty(String tagName, String value) {
        return this.xmlWriterUtil.tagValueIgnoreEmpty(tagName, value);
    }

    public String tagValue(String tagName, boolean value) {
        return this.xmlWriterUtil.tagValue(tagName, value);
    }

    public String tagValue(String tagName, int value) {
        return this.xmlWriterUtil.tagValue(tagName, value);
    }

    public String tagCDATAValue(String tagName, String value) {
        return this.xmlWriterUtil.tagCDATAValue(tagName, value);
    }

    public String tagCDATAValueIgnoreEmpty(String tagName, String value) {
        return this.xmlWriterUtil.tagCDATAValueIgnoreEmpty(tagName, value);
    }

    public String insertComment(String value) {
        return this.xmlWriterUtil.comment(value);
    }

    public String tagValueWithAttrib(String tagName, String value, String attrName, String attrVal) {
        return this.xmlWriterUtil.tagValueWithAttrib(tagName, value, attrName, attrVal);
    }

    public String tagValueWithAttrib(String tagName, String value, String attrName, String attrVal, String attr2Name, String attr2Val) {
        return this.xmlWriterUtil.tagValueWithAttrib(tagName, value, attrName, attrVal, attr2Name, attr2Val);
    }

    public String tagValueWithAttrib(String tagName, String value, String[] attribs) {
        return this.xmlWriterUtil.tagValueWithAttrib(tagName, value, attribs);
    }

    public String tagWithAttr(String tagName, String attrName, String attrVal) {
        return this.xmlWriterUtil.tagWithAttr(tagName, attrName, attrVal);
    }

    public String tagWithAttr(String tagName, String attr1Name, String attr1Val, String attr2Name, String attr2Val) {
        return this.xmlWriterUtil.tagWithAttr(tagName, attr1Name, attr1Val, attr2Name, attr2Val);
    }

    public String tagWithAttr(String tagName, String attr1Name, String attr1Val, String attr2Name, String attr2Val, String attr3Name, String attr3Val) {
        return this.xmlWriterUtil.tagWithAttr(tagName, attr1Name, attr1Val, attr2Name, attr2Val, attr3Name, attr3Val);
    }

    public String tagWithAttr(String tagName, String attr1Name, String attr1Val, String attr2Name, String attr2Val, String attr3Name, String attr3Val, String attr4Name, String attr4Val) {
        return this.xmlWriterUtil.tagWithAttr(tagName, attr1Name, attr1Val, attr2Name, attr2Val, attr3Name, attr3Val, attr4Name, attr4Val);
    }

    public String tagWithAttr(String tagName, String[] attrNameVal) {
        return this.xmlWriterUtil.tagWithAttr(tagName, attrNameVal);
    }

    public String tagWithAttrIgnoreEmpty(String tagName, String[] attrNameVal) {
        return this.xmlWriterUtil.tagWithAttrIgnoreEmpty(tagName, attrNameVal);
    }

    public String startTagWithAttr(String tagName, String attrName, String attrVal) {
        return this.xmlWriterUtil.startTagWithAttr(tagName, attrName, attrVal);
    }

    public String startTagWithAttr(String tagName, String attr1Name, String attr1Val, String attr2Name, String attr2Val) {
        return this.xmlWriterUtil.startTagWithAttr(tagName, attr1Name, attr1Val, attr2Name, attr2Val);
    }

    public String startTagWithAttr(String tagName, String attr1Name, String attr1Val, String attr2Name, String attr2Val, String attr3Name, String attr3Val) {
        return this.xmlWriterUtil.startTagWithAttr(tagName, attr1Name, attr1Val, attr2Name, attr2Val, attr3Name, attr3Val);
    }

    public String startTagWithAttr(String tagName, String attr1Name, String attr1Val, String attr2Name, String attr2Val, String attr3Name, String attr3Val, String attr4Name, String attr4Val) {
        return this.xmlWriterUtil.startTagWithAttr(tagName, attr1Name, attr1Val, attr2Name, attr2Val, attr3Name, attr3Val, attr4Name, attr4Val);
    }

    public String startTagWithAttr(String tagName, String[] attrNameVal) {
        return this.xmlWriterUtil.startTagWithAttr(tagName, attrNameVal);
    }

    public String startTagWithAttrIgnoreEmpty(String tagName, String[] attrNameVal) {
        return this.xmlWriterUtil.startTagWithAttrIgnoreEmpty(tagName, attrNameVal);
    }

    public String startTagWithAttr(String tagName, String attr1Name, String attr1Val, String attr2Name, boolean attr2Val) {
        return this.xmlWriterUtil.startTagWithAttr(tagName, attr1Name, attr1Val, attr2Name, attr2Val);
    }

    public String fixNullValue(String tagValue) throws SerialException {
        return XMLWriterUtil.fixNullValue(tagValue);
    }

    public String fixAttrib(String str) {
        return XMLWriterUtil.fixAttrib(str);
    }

    public int getIndent() {
        return this.xmlWriterUtil.getIndent();
    }

    public void setIndent(int newIndent) {
        this.xmlWriterUtil.setIndent(newIndent);
    }

    public String startTag(String tagName) {
        return this.xmlWriterUtil.startTag(tagName);
    }

    public String startTagCont(String tagName) {
        return this.xmlWriterUtil.startTagCont(tagName);
    }

    public String endTag(String tagName) {
        return this.xmlWriterUtil.endTag(tagName);
    }

    public String endTagCont(String tagName) {
        return this.xmlWriterUtil.endTagCont(tagName);
    }

    public String toValueString(String value) {
        return XMLWriterUtil.toValueString(value);
    }

    public String CDATAValue(String toWrite) {
        return XMLWriterUtil.CDATAValue(toWrite);
    }

    public String fixXMLAttribute(String str) {
        return XMLWriterUtil.fixXMLAttribute(str);
    }

    public String fixXMLCharData(String str) {
        return XMLWriterUtil.fixXMLCharData(str);
    }

    public String indentStr(int val) {
        return this.xmlWriterUtil.indentStr(val);
    }

    public void setProperty(String prop, Object value) {
        super.setProperty(prop, value);
        if (prop.equals("line.separator")) {
            this.xmlWriterUtil.setLineSeparator(this.lineseparator);
        }
    }
}

