/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.design.serial.xml;

import com.tplus.transform.design.CommentInfo;
import com.tplus.transform.design.DataField;
import com.tplus.transform.design.DataFieldSection;
import com.tplus.transform.design.DataFormat;
import com.tplus.transform.design.DataTypeConstants;
import com.tplus.transform.design.DesignerType;
import com.tplus.transform.design.FieldsFormat;
import com.tplus.transform.design.IDesignElement;
import com.tplus.transform.design.serial.SerialException;
import com.tplus.transform.design.serial.SerializationContext;
import com.tplus.transform.design.serial.xml.CommentXML;
import com.tplus.transform.design.serial.xml.IFieldsFormatXML;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class FieldsFormatXML
extends IFieldsFormatXML {
    public static final String HEADER_FIELDS_TAG = "headerfields";
    public static final String DATA_FIELDS_TAG = "datafields";
    public static final String TRAILER_FIELDS_TAG = "trailerfields";
    public static final String DATA_TYPE_TAG = "datatype";

    public void read(IDesignElement designElement, Element nd, SerializationContext cxt) throws SerialException {
        FieldsFormat fieldsFormat = (FieldsFormat)designElement;
        this.readXMLInfo(nd, fieldsFormat);
        FieldsFormatXML.readPlatformInfo(fieldsFormat.getRootSection(), nd, cxt);
        DataFormat hdrFormat = fieldsFormat.getHeaderFormat();
        DataFormat recdataFormat = fieldsFormat.getDataFormat();
        DataFormat tlrFormat = fieldsFormat.getTrailerFormat();
        hdrFormat.removeAllFields();
        recdataFormat.removeAllFields();
        tlrFormat.removeAllFields();
        Element hdrFieldsElm = FieldsFormatXML.getSingleChildElement(nd, HEADER_FIELDS_TAG);
        if (hdrFieldsElm == null) {
            throw new SerialException("Error in xml: 'headerfields' tag not found");
        }
        Element dataFieldsElm = FieldsFormatXML.getSingleChildElement(nd, DATA_FIELDS_TAG);
        if (dataFieldsElm == null) {
            throw new SerialException("Error in xml: 'datafields' tag not found");
        }
        Element tlrFieldsElm = FieldsFormatXML.getSingleChildElement(nd, TRAILER_FIELDS_TAG);
        if (tlrFieldsElm == null) {
            throw new SerialException("Error in xml: 'trailerfields' tag not found");
        }
        FieldsFormatXML.readPlatformInfo(hdrFormat.getRootSection(), hdrFieldsElm, cxt);
        FieldsFormatXML.readPlatformInfo(recdataFormat.getRootSection(), dataFieldsElm, cxt);
        FieldsFormatXML.readPlatformInfo(tlrFormat.getRootSection(), tlrFieldsElm, cxt);
        this.readDataFormat(hdrFormat, hdrFieldsElm, cxt);
        this.readDataFormat(recdataFormat, dataFieldsElm, cxt);
        this.readDataFormat(tlrFormat, tlrFieldsElm, cxt);
    }

    public void readXMLInfo(Element nd, FieldsFormat fieldsFormat) {
        fieldsFormat.setXMLTargetNamespace(this.readTargetNamespace(nd));
        this.readNamespacePrefixes(nd, fieldsFormat.getXpathNamespaceManager(), "xpath-namespaces");
    }

    public void readDataFormat(DataFormat dataFmt, Element fieldsElm, SerializationContext cxt) throws SerialException {
        if (dataFmt == null) {
            return;
        }
        NodeList fieldList = FieldsFormatXML.getChildElementsByTagName(fieldsElm, "field");
        for (int i = 0; i < fieldList.getLength(); ++i) {
            Element fieldElm = (Element)fieldList.item(i);
            this.readField(dataFmt, fieldElm, cxt);
        }
    }

    public void readField(DataFormat dataFmt, Element fieldElm, SerializationContext cxt) throws SerialException {
        String fldName = FieldsFormatXML.getNormalizedSingleChildElementValue(fieldElm, "name");
        boolean enabled = FieldsFormatXML.getSingleChildElementBooleanValue(fieldElm, "enabled", true);
        String type = FieldsFormatXML.getNormalizedSingleChildElementValue(fieldElm, DATA_TYPE_TAG);
        DesignerType designerType = dataFmt.getDesignerType(type);
        String description = FieldsFormatXML.getSingleChildElementValue(fieldElm, "description");
        String detailedName = FieldsFormatXML.getSingleChildElementValue(fieldElm, "detailed-name");
        String aliasName = FieldsFormatXML.getNormalizedSingleChildElementValue(fieldElm, "aliasname");
        CommentInfo comment = CommentXML.readComment(this, fieldElm);
        if (designerType.isSectionType()) {
            String minOccurs = FieldsFormatXML.getNormalizedSingleChildElementValue(fieldElm, "minoccurs");
            String maxOccurs = FieldsFormatXML.getNormalizedSingleChildElementValue(fieldElm, "maxoccurs");
            DataFieldSection section = this.createSection(dataFmt, fldName.trim(), fieldElm);
            dataFmt.addField(section);
            section.setEnabled(enabled);
            if (aliasName != null && !aliasName.equals("")) {
                section.setAliasName(aliasName);
            }
            section.setComment(comment);
            if (description != null && !description.equals("")) {
                section.setDescription(description.trim());
            }
            section.setDetailedName(detailedName);
            if (minOccurs != null && !minOccurs.equals("")) {
                section.setMinOccurs(Integer.parseInt(minOccurs));
            }
            if (maxOccurs != null && !maxOccurs.equals("")) {
                section.setMaxOccurs(Integer.parseInt(maxOccurs));
            }
            this.readAdditionalFieldInfo(section, fieldElm);
            Element fields = FieldsFormatXML.getSingleChildElement(fieldElm, "fields");
            this.readDataFormat(section.getSectionFormat(), fields, cxt);
            this.readSectionAdditionalFieldInfo(section, fieldElm);
            FieldsFormatXML.readPlatformInfo(section, fieldElm, cxt);
        } else {
            String required = FieldsFormatXML.getNormalizedSingleChildElementValue(fieldElm, "required");
            String defaultvalue = FieldsFormatXML.getSingleChildElementValue(fieldElm, "defaultvalue");
            String dateformat = FieldsFormatXML.getNormalizedSingleChildElementValue(fieldElm, "dateformat");
            DataField fld = this.createField(dataFmt, fldName, designerType, fieldElm);
            dataFmt.addField(fld);
            fld.setEnabled(enabled);
            if (aliasName != null && !aliasName.equals("")) {
                fld.setAliasName(aliasName);
            }
            fld.setComment(comment);
            if (description != null) {
                fld.setDescription(description);
            }
            fld.setDetailedName(detailedName);
            if (required != null) {
                boolean requiredBool;
                if (!required.equals("true") && !required.equals("false")) {
                    required = "true";
                }
                fld.setNullable(!(requiredBool = Boolean.valueOf(required).booleanValue()));
            }
            if (defaultvalue != null) {
                fld.setDefaultValue(defaultvalue);
            }
            if (dateformat != null && DataTypeConstants.isDateOrTimeType(designerType)) {
                fld.setFormat(dateformat);
            }
            this.readAdditionalFieldInfo(fld, fieldElm);
            FieldsFormatXML.readPlatformInfo(fld, fieldElm, cxt);
        }
    }

    protected void writeNode(IDesignElement elm, StringBuffer toRet, SerializationContext cxt) {
        FieldsFormat fieldsFormat = (FieldsFormat)elm;
        DataFormat header = fieldsFormat.getHeaderFormat();
        DataFormat record = fieldsFormat.getDataFormat();
        DataFormat trailer = fieldsFormat.getTrailerFormat();
        this.writeTargetNamespace(fieldsFormat.getXMLTargetNamespace(), toRet);
        this.writeNamespacePrefixes(fieldsFormat.getXpathNamespaceManager(), "xpath-namespaces", toRet, cxt);
        this.writePlatformInfo(fieldsFormat.getRootSection(), toRet, cxt);
        toRet.append(this.startTag(HEADER_FIELDS_TAG));
        this.writePlatformInfo(header.getRootSection(), toRet, cxt);
        this.writeDataFormat(header, toRet, cxt);
        toRet.append(this.endTag(HEADER_FIELDS_TAG));
        toRet.append(this.startTag(DATA_FIELDS_TAG));
        this.writePlatformInfo(record.getRootSection(), toRet, cxt);
        this.writeDataFormat(record, toRet, cxt);
        toRet.append(this.endTag(DATA_FIELDS_TAG));
        toRet.append(this.startTag(TRAILER_FIELDS_TAG));
        this.writePlatformInfo(trailer.getRootSection(), toRet, cxt);
        this.writeDataFormat(trailer, toRet, cxt);
        toRet.append(this.endTag(TRAILER_FIELDS_TAG));
    }

    public void writeDataFormat(DataFormat format, StringBuffer toRet, SerializationContext cxt) {
        if (format != null) {
            int fieldsCount = format.getFieldCount();
            for (int i = 0; i < fieldsCount; ++i) {
                DataField fld = format.getField(i);
                if (fld instanceof DataFieldSection) {
                    this.writeDataFieldSection((DataFieldSection)fld, toRet, cxt);
                    continue;
                }
                this.writeField(fld, toRet, cxt);
            }
        }
    }

    public void writeField(DataField fld, StringBuffer toRet, SerializationContext cxt) {
        this.writeFieldTag(toRet);
        this.writeBasicFieldProperties(fld, toRet);
        toRet.append(this.tagValue("required", "" + !fld.isNullable()));
        toRet.append(this.tagCDATAValueIgnoreEmpty("defaultvalue", fld.getDefaultValue()));
        if (fld.getFormat() != null) {
            toRet.append(this.tagValue("dateformat", fld.getFormat()));
        }
        this.writeAdditionalFieldInfo(fld, toRet);
        this.writePlatformInfo(fld, toRet, cxt);
        toRet.append(this.endTag("field"));
    }

    public void writeDataFieldSection(DataFieldSection fld, StringBuffer toRet, SerializationContext cxt) {
        this.writeSectionTag(toRet);
        this.writeBasicFieldProperties(fld, toRet);
        DataFieldSection sec = fld;
        DataFormat dataformat = sec.getSectionFormat();
        toRet.append(this.tagValue("minoccurs", sec.getMinOccurs()));
        toRet.append(this.tagValue("maxoccurs", sec.getMaxOccurs()));
        this.writeAdditionalFieldInfo(sec, toRet);
        toRet.append(this.startTag("fields"));
        this.writeDataFormat(dataformat, toRet, cxt);
        toRet.append(this.endTag("fields"));
        this.writeSectionAdditionalFieldInfo(sec, toRet);
        this.writePlatformInfo(fld, toRet, cxt);
        toRet.append(this.endTag("field"));
    }

    private void writeBasicFieldProperties(DataField fld, StringBuffer toRet) {
        toRet.append(this.tagValue("name", fld.getName()));
        if (!fld.isEnabled()) {
            toRet.append(this.tagValue("enabled", "false"));
        }
        toRet.append(this.tagValue(DATA_TYPE_TAG, fld.getType().toString()));
        toRet.append(this.tagCDATAValueIgnoreEmpty("detailed-name", fld.getDetailedName()));
        toRet.append(this.tagCDATAValueIgnoreEmpty("description", fld.getDescription()));
        if (fld.getAliasName() != null) {
            toRet.append(this.tagValue("aliasname", fld.getAliasName()));
        }
        CommentXML.writeComment(this, fld.getComment(), toRet);
    }

    protected void writeAdditionalFieldInfo(DataField fld, StringBuffer toRet) {
    }

    protected void writeSectionAdditionalFieldInfo(DataFieldSection fld, StringBuffer toRet) {
    }

    protected void readAdditionalFieldInfo(DataField fld, Element fieldElm) {
    }

    protected void readSectionAdditionalFieldInfo(DataFieldSection fld, Element fieldElm) {
    }

    protected DataField createField(DataFormat df, String fldName, DesignerType type, Element fieldElm) {
        return df.createField(fldName, type);
    }

    protected DataFieldSection createSection(DataFormat df, String secName, Element fieldElm) {
        return df.createSection(secName);
    }
}

