/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.design.serial.xml;

import com.tplus.transform.design.CommentInfo;
import com.tplus.transform.design.DataField;
import com.tplus.transform.design.DataFieldSection;
import com.tplus.transform.design.DataFormat;
import com.tplus.transform.design.DataTypeConstants;
import com.tplus.transform.design.DesignerType;
import com.tplus.transform.design.IDesignElement;
import com.tplus.transform.design.MessageNormalizedFormat;
import com.tplus.transform.design.NormalizedField;
import com.tplus.transform.design.NormalizedFormat;
import com.tplus.transform.design.serial.SerialException;
import com.tplus.transform.design.serial.SerializationContext;
import com.tplus.transform.design.serial.xml.CommentXML;
import com.tplus.transform.design.serial.xml.DataFormatXML;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class NormalizedFormatXML
extends DataFormatXML {
    public static final String NORMALIZED_FORMAT_TAG = "normalizedformat";
    public static final String FIELDS_TAG_OLD = "nfields";
    public static final String FIELD_TAG_OLD = "nfield";
    public static final String FIELDS_TAG = "fields";
    public static final String FIELD_TAG = "field";

    public String getRootTag() {
        return NORMALIZED_FORMAT_TAG;
    }

    public void read(IDesignElement designElement, Element nd, SerializationContext cxt) throws SerialException {
        this.read(designElement, nd, NORMALIZED_FORMAT_TAG, cxt);
    }

    public void read(IDesignElement designElement, Element nd, String rootName, SerializationContext cxt) throws SerialException {
        String name = nd.getNodeName();
        if (name == null || !name.equals(rootName)) {
            throw new SerialException("Error importing from XML. Expected tag '" + rootName + "' found '" + name + "'");
        }
        MessageNormalizedFormat nf = (MessageNormalizedFormat)designElement;
        nf.removeAllFields();
        nf.setXMLTargetNamespace(this.readTargetNamespace(nd));
        this.readNamespacePrefixes(nd, nf.getXpathNamespaceManager(), "xpath-namespaces");
        NormalizedFormatXML.readPlatformInfo(nf.getRootSection(), nd, cxt);
        this.readDataFormat(nf, nd, cxt);
    }

    public void readDataFormat(DataFormat nf, Element nd, SerializationContext cxt) throws SerialException {
        Element fields;
        if (nf instanceof NormalizedFormat) {
            // empty if block
        }
        if ((fields = NormalizedFormatXML.getSingleChildElement(nd, FIELDS_TAG, FIELDS_TAG_OLD)) == null) {
            throw new SerialException("Error importing from XML. Expected tag 'fields' under tag 'normalizedformat'");
        }
        NodeList fieldList = NormalizedFormatXML.getChildElementsByTagName(fields, FIELD_TAG, FIELD_TAG_OLD);
        for (int i = 0; i < fieldList.getLength(); ++i) {
            Boolean bl;
            Element fieldElm = (Element)fieldList.item(i);
            String fldName = NormalizedFormatXML.getNormalizedSingleChildElementValue(fieldElm, "name");
            String aliasName = NormalizedFormatXML.getNormalizedSingleChildElementValue(fieldElm, "aliasname");
            CommentInfo comment = CommentXML.readComment(this, fieldElm);
            String type = NormalizedFormatXML.getNormalizedSingleChildElementValue(fieldElm, "type");
            String description = NormalizedFormatXML.getSingleChildElementValue(fieldElm, "description");
            String detailedName = NormalizedFormatXML.getSingleChildElementValue(fieldElm, "detailed-name");
            String hiddenStr = NormalizedFormatXML.getNormalizedSingleChildElementValue(fieldElm, "hidden");
            if (fldName == null || type == null) continue;
            DesignerType designerType = nf.getDesignerType(type);
            if (designerType.isSectionType()) {
                String minOccurs = NormalizedFormatXML.getNormalizedSingleChildElementValue(fieldElm, "minoccurs");
                String maxOccurs = NormalizedFormatXML.getNormalizedSingleChildElementValue(fieldElm, "maxoccurs");
                DataFieldSection section = nf.addSection(fldName.trim());
                if (aliasName != null && !aliasName.equals("")) {
                    section.setAliasName(aliasName);
                }
                section.setComment(comment);
                if (description != null && !description.equals("")) {
                    section.setDescription(description.trim());
                }
                section.setDetailedName(detailedName);
                if (hiddenStr != null) {
                    Boolean bl2 = Boolean.valueOf(hiddenStr);
                    section.setHidden(bl2);
                }
                if (minOccurs != null && !minOccurs.equals("")) {
                    section.setMinOccurs(Integer.parseInt(minOccurs));
                }
                if (maxOccurs != null && !maxOccurs.equals("")) {
                    section.setMaxOccurs(Integer.parseInt(maxOccurs));
                }
                section.setParentFormat(nf);
                this.readAdditionalSectionInfo(section, fieldElm, cxt);
                this.readDataFormat(section.getSectionFormat(), fieldElm, cxt);
                NormalizedFormatXML.readPlatformInfo(section, fieldElm, cxt);
                continue;
            }
            String notnullStr = NormalizedFormatXML.getNormalizedSingleChildElementValue(fieldElm, "notnull");
            String defaultValue = NormalizedFormatXML.getSingleChildElementValue(fieldElm, "defaultvalue");
            String lengthStr = NormalizedFormatXML.getNormalizedSingleChildElementValue(fieldElm, "length");
            NormalizedField nfld = (NormalizedField)nf.addField(fldName.trim(), designerType);
            if (aliasName != null && !aliasName.equals("")) {
                nfld.setAliasName(aliasName);
            }
            nfld.setComment(comment);
            if (description != null && !description.equals("")) {
                nfld.setDescription(description.trim());
            }
            nfld.setDetailedName(detailedName);
            if (defaultValue != null && !defaultValue.equals("")) {
                nfld.setDefaultValue(defaultValue);
            }
            if (notnullStr != null) {
                bl = Boolean.valueOf(notnullStr);
                nfld.setNullable(bl == false);
            }
            if (hiddenStr != null) {
                bl = Boolean.valueOf(hiddenStr);
                nfld.setHidden(bl);
            }
            if (lengthStr != null) {
                try {
                    int length = Integer.parseInt(lengthStr);
                    nfld.setMaximumLength(length);
                }
                catch (NumberFormatException e) {
                    nfld.setMaximumLength(100);
                }
            }
            this.readAdditionalFieldInfo(nfld, fieldElm, cxt);
            NormalizedFormatXML.readPlatformInfo(nfld, fieldElm, cxt);
        }
    }

    protected void readAdditionalFieldInfo(DataField nfld, Element fieldElm, SerializationContext cxt) {
    }

    protected void readAdditionalSectionInfo(DataFieldSection section, Element fieldElm, SerializationContext cxt) throws SerialException {
    }

    public StringBuffer writeNode(IDesignElement elm, SerializationContext cxt) {
        return this.writeNode(elm, NORMALIZED_FORMAT_TAG, cxt);
    }

    public StringBuffer writeNode(IDesignElement elm, String rootName, SerializationContext cxt) {
        StringBuffer toRet = new StringBuffer();
        MessageNormalizedFormat nf = (MessageNormalizedFormat)elm;
        toRet.append(this.startTag(rootName));
        this.writeTargetNamespace(nf.getXMLTargetNamespace(), toRet);
        this.writeNamespacePrefixes(nf.getXpathNamespaceManager(), "xpath-namespaces", toRet, cxt);
        this.writePlatformInfo(nf.getRootSection(), toRet, cxt);
        this.writeDataFormat(nf, toRet, cxt);
        toRet.append(this.endTag(rootName));
        return toRet;
    }

    public void writeDataFormat(DataFormat nf, StringBuffer toRet, SerializationContext cxt) {
        toRet.append(this.startTag(FIELDS_TAG));
        int fieldsCount = nf.getFieldCountAvailable();
        for (int i = 0; i < fieldsCount; ++i) {
            DataField fld = nf.getField(i);
            if (fld.isInherited()) continue;
            if (fld instanceof DataFieldSection) {
                DataFieldSection sec = (DataFieldSection)fld;
                this.writeDataFieldSection(sec, toRet, true, cxt);
                continue;
            }
            this.writeField(fld, toRet, cxt);
        }
        toRet.append(this.endTag(FIELDS_TAG));
    }

    protected String getSectionXSDType() {
        return "InternalMessageSectionType";
    }

    protected String getFieldXSDType() {
        return "InternalMessageFieldType";
    }

    public void writeField(DataField fld, StringBuffer toRet, SerializationContext cxt) {
        this.writeFieldTag(toRet);
        toRet.append(this.tagValue("name", fld.getName()));
        toRet.append(this.tagValue("type", fld.getType().toString()));
        toRet.append(this.tagValueIgnoreEmpty("aliasname", fld.getAliasName()));
        CommentXML.writeComment(this, fld.getComment(), toRet);
        toRet.append(this.tagCDATAValueIgnoreEmpty("detailed-name", fld.getDetailedName()));
        toRet.append(this.tagCDATAValueIgnoreEmpty("description", fld.getDescription()));
        if (fld.getDefaultValue() != null && !fld.getDefaultValue().equals("")) {
            toRet.append(this.tagValue("defaultvalue", fld.getDefaultValue()));
        }
        if (fld.isHidden()) {
            toRet.append(this.tagValue("hidden", fld.isHidden()));
        }
        toRet.append(this.tagValue("notnull", !fld.isNullable()));
        if (fld.getType().equals(DataTypeConstants.DESIGNER_STRING_TYPE)) {
            toRet.append(this.tagValue("length", fld.getMaximumLength()));
        }
        this.writeAdditionalFieldInfo(fld, toRet, cxt);
        this.writePlatformInfo(fld, toRet, cxt);
        toRet.append(this.endTag(FIELD_TAG));
    }

    public void writeDataFieldSection(DataFieldSection sec, StringBuffer toRet, SerializationContext cxt) {
        this.writeDataFieldSection(sec, toRet, true, cxt);
    }

    public void writeDataFieldSection(DataFieldSection sec, StringBuffer toRet, boolean includeDataFormat, SerializationContext cxt) {
        this.writeSectionTag(toRet);
        toRet.append(this.tagValue("name", sec.getName()));
        toRet.append(this.tagValue("type", sec.getType().toString()));
        if (sec.getAliasName() != null) {
            toRet.append(this.tagValue("aliasname", sec.getAliasName()));
        }
        CommentXML.writeComment(this, sec.getComment(), toRet);
        toRet.append(this.tagCDATAValueIgnoreEmpty("detailed-name", sec.getDetailedName()));
        toRet.append(this.tagCDATAValueIgnoreEmpty("description", sec.getDescription()));
        if (sec.isHidden()) {
            toRet.append(this.tagValue("hidden", sec.isHidden()));
        }
        toRet.append(this.tagValue("minoccurs", sec.getMinOccurs()));
        toRet.append(this.tagValue("maxoccurs", sec.getMaxOccurs()));
        this.writeAdditionalSectionInfo(sec, toRet, cxt);
        this.writePlatformInfo(sec, toRet, cxt);
        if (includeDataFormat) {
            this.writeDataFormat((NormalizedFormat)sec.getSectionFormat(), toRet, cxt);
        }
        toRet.append(this.endTag(FIELD_TAG));
    }

    protected void writeAdditionalFieldInfo(DataField fld, StringBuffer toRet, SerializationContext cxt) {
    }

    protected void writeAdditionalSectionInfo(DataFieldSection sec, StringBuffer toRet, SerializationContext cxt) {
    }
}

