/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.io;

import com.tplus.transform.security.ValidationException;
import java.io.File;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SafeFile
extends File {
    private static final long serialVersionUID = 1L;
    private static final Pattern PERCENTS_PAT = Pattern.compile("(%)([0-9a-fA-F])([0-9a-fA-F])");
    private static final Pattern FILE_BLACKLIST_PAT = Pattern.compile("([\\\\/:*?<>|])");
    private static final Pattern DIR_BLACKLIST_PAT = Pattern.compile("([*?<>|])");

    public SafeFile(String path) throws ValidationException {
        super(path);
        SafeFile.doDirCheck(this.getParent());
        SafeFile.doFileNameCheck(this.getName());
    }

    public SafeFile(String parent, String child) throws ValidationException {
        super(parent, child);
        SafeFile.doDirCheck(this.getParent());
        SafeFile.doFileNameCheck(this.getName());
    }

    public SafeFile(File parent, String child) throws ValidationException {
        super(parent, child);
        SafeFile.doDirCheck(this.getParent());
        SafeFile.doFileNameCheck(this.getName());
    }

    public SafeFile(URI uri) throws ValidationException {
        super(uri);
        SafeFile.doDirCheck(this.getParent());
        SafeFile.doFileNameCheck(this.getName());
    }

    public static void doDirCheck(String path) throws ValidationException {
        if (path == null) {
            return;
        }
        Matcher m1 = DIR_BLACKLIST_PAT.matcher(path);
        if (m1.find()) {
            throw new ValidationException("Invalid directory", "Directory path (" + path + ") contains illegal character: " + m1.group());
        }
        Matcher m2 = PERCENTS_PAT.matcher(path);
        if (m2.find()) {
            throw new ValidationException("Invalid directory", "Directory path (" + path + ") contains encoded characters: " + m2.group());
        }
        int ch = SafeFile.containsUnprintableCharacters(path);
        if (ch != -1) {
            throw new ValidationException("Invalid directory", "Directory path (" + path + ") contains unprintable character: " + ch);
        }
    }

    public static void doFileCheck(String name) throws ValidationException {
        File file = new File(name);
        String parent = file.getParent();
        if (parent != null) {
            SafeFile.doDirCheck(parent);
        }
        SafeFile.doFileNameCheck(file.getName());
    }

    private static void doFileNameCheck(String name) throws ValidationException {
        Matcher m1 = FILE_BLACKLIST_PAT.matcher(name);
        if (m1.find()) {
            throw new ValidationException("Invalid directory", "Directory path (" + name + ") contains illegal character: " + m1.group());
        }
        Matcher m2 = PERCENTS_PAT.matcher(name);
        if (m2.find()) {
            throw new ValidationException("Invalid file", "File path (" + name + ") contains encoded characters: " + m2.group());
        }
        int ch = SafeFile.containsUnprintableCharacters(name);
        if (ch != -1) {
            throw new ValidationException("Invalid file", "File path (" + name + ") contains unprintable character: " + ch);
        }
    }

    private static int containsUnprintableCharacters(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch >= ' ') continue;
            return ch;
        }
        return -1;
    }
}

