/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.io;

import com.tplus.transform.io.Base64Binary;
import com.tplus.transform.io.SafeFile;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class SecurityTool {
    public static final String PUBLIC_DER = "-public.der";
    public static final String PRIVATE_DER = "-private.der";
    public static final String PUBLIC_PEM = "-public.pem";
    public static final String PRIVATE_PEM = "-private.pem";
    public static final String PUBLIC_KEY = "PUBLIC KEY";
    public static final String PRIVATE_KEY = "PRIVATE KEY";
    public static final String CIPHER_PARAM_ALTERNATE = "RSA/ECB/PKCS1PADDING";
    public static final String CIPHER_PARAM_DEFAULT = "RSA/ECB/OAEPWithSHA-1AndMGF1Padding";
    private static final String PEM_ENCODING = "iso-8859-1";

    public static String encrypt(String text) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        return SecurityTool.encrypt(SecurityTool.readPublicKeyFromResource("volante"), text);
    }

    public static String encrypt(PublicKey publicKey, String text) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        Cipher cipher = Cipher.getInstance(CIPHER_PARAM_DEFAULT);
        cipher.init(1, publicKey);
        byte[] cipherData = cipher.doFinal(text.getBytes("utf-8"));
        String decryptedText = Base64Binary.fromBinary(cipherData);
        return decryptedText;
    }

    public static String decrypt(String text) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        return SecurityTool.decrypt(SecurityTool.readPrivateKeyFromResource("volante"), text);
    }

    public static String decrypt(PrivateKey privateKey, String text) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        try {
            return SecurityTool.decrypt(privateKey, text, CIPHER_PARAM_DEFAULT);
        }
        catch (BadPaddingException e) {
            return SecurityTool.decrypt(privateKey, text, CIPHER_PARAM_ALTERNATE);
        }
    }

    public static String decrypt(PrivateKey privateKey, String text, String cipherParam) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        Cipher cipher = Cipher.getInstance(cipherParam);
        cipher.init(2, privateKey);
        byte[] encryptedData = Base64Binary.toBinary(text);
        byte[] decryptedData = cipher.doFinal(encryptedData);
        String encryptedText = new String(decryptedData, "utf-8");
        return encryptedText;
    }

    public static PublicKey readPublicKeyFromResource(String name) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException {
        String path = "/" + name + PUBLIC_PEM;
        InputStream publicStream = SecurityTool.class.getResourceAsStream(path);
        if (publicStream == null) {
            throw new IOException("Missing Public key resource " + path);
        }
        return SecurityTool.readPublicKey(publicStream);
    }

    public static PublicKey readPublicKeyFromFile(String name) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException {
        SafeFile.doFileCheck(name);
        FileInputStream publicStream = new FileInputStream(name + PUBLIC_PEM);
        return SecurityTool.readPublicKey(publicStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PublicKey readPublicKey(InputStream publicStream) throws NoSuchAlgorithmException, IOException, InvalidKeySpecException {
        KeyFactory kf = KeyFactory.getInstance("RSA");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(publicStream, PEM_ENCODING));
        try {
            PublicKey publicKey;
            byte[] publicBytes = SecurityTool.readPEM(bufferedReader, PUBLIC_KEY);
            X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(publicBytes);
            PublicKey publicKey2 = publicKey = kf.generatePublic(publicKeySpec);
            return publicKey2;
        }
        finally {
            bufferedReader.close();
        }
    }

    public static PrivateKey readPrivateKeyFromResource(String name) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException {
        String path = "/" + name + PRIVATE_PEM;
        InputStream privateStream = SecurityTool.class.getResourceAsStream(path);
        if (privateStream == null) {
            throw new IOException("Missing Public key resource " + path);
        }
        return SecurityTool.readPrivateKey(privateStream);
    }

    public static PrivateKey readPrivateKeyFromFile(String name) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException {
        SafeFile.doFileCheck(name);
        FileInputStream privateStream = new FileInputStream(name + PRIVATE_PEM);
        return SecurityTool.readPrivateKey(privateStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PrivateKey readPrivateKey(InputStream privateStream) throws NoSuchAlgorithmException, IOException, InvalidKeySpecException {
        KeyFactory kf = KeyFactory.getInstance("RSA");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(privateStream, PEM_ENCODING));
        try {
            PrivateKey privateKey;
            byte[] privateBytes = SecurityTool.readPEM(bufferedReader, PRIVATE_KEY);
            PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(privateBytes);
            PrivateKey privateKey2 = privateKey = kf.generatePrivate(privateKeySpec);
            return privateKey2;
        }
        finally {
            bufferedReader.close();
        }
    }

    public static void main(String[] args) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException, IOException, IllegalBlockSizeException, InvalidKeyException, NoSuchPaddingException, BadPaddingException {
        if (args.length == 0) {
            SecurityTool.showSyntax();
            return;
        }
        String task = args[0];
        String name = args[1];
        if (task.equals("keypair")) {
            SecurityTool.generateKeyPair(name);
            System.out.println("Generated key pair");
        }
        if (task.equals("encrypt")) {
            String output;
            if (args[1].equals("-key")) {
                String keyLocation = args[2];
                PublicKey publicKey = SecurityTool.readPublicKeyFromFile(keyLocation);
                String text = args[3];
                output = SecurityTool.encrypt(publicKey, text);
            } else {
                String text = args[1];
                output = SecurityTool.encrypt(text);
            }
            System.out.println(output);
        } else if (task.equals("decrypt")) {
            String output;
            if (args[1].equals("-key")) {
                String keyLocation = args[2];
                PrivateKey privateKey = SecurityTool.readPrivateKeyFromFile(keyLocation);
                String text = args[3];
                output = SecurityTool.decrypt(privateKey, text);
            } else {
                String text = args[1];
                output = SecurityTool.decrypt(text);
            }
            System.out.println(output);
        }
    }

    private static void showSyntax() {
        System.out.println("syntax: security command [options] parameter...");
        System.out.println("> security keypair name");
        System.out.println("   Generates private key and public key pair");
        System.out.println("   name -  file name of the key pair");
        System.out.println("   example : security keypair volante");
        System.out.println("> security encrypt [-key keyLocation] text");
        System.out.println("   Encrypts the text and displays the encrypted text");
        System.out.println("   -key keyLocation -  Location where key file is present, if not provided key files should be made available as resource");
        System.out.println("   text -  text to encrypt");
        System.out.println("   example : security encrypt -key volante ABCD");
        System.out.println("> security decrypt [-key keyLocation] text");
        System.out.println("   Decrypts the text and displays the unencrypted text");
        System.out.println("   -key keyLocation -  Location where key file is present, if not provided key files should be made available as resource");
        System.out.println("   text -  text to decrypt");
        System.out.println("   example : security decrypt -key volante KTq4ZrQ5maPPXaKTDqPj+mbnHuYI0OxsaNWlqB5P0wrlTV6DpzGsk+Jel/ee7nFc");
    }

    private static void generateKeyPair(String arg) throws NoSuchAlgorithmException, IOException {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        keyGen.initialize(2048);
        KeyPair keyPair = keyGen.genKeyPair();
        PublicKey publicKey = keyPair.getPublic();
        byte[] publicEncoded = publicKey.getEncoded();
        PrivateKey privateKey = keyPair.getPrivate();
        byte[] privateEncoded = privateKey.getEncoded();
        String name = arg;
        PrintWriter fos1 = new PrintWriter(new FileWriter(name + PUBLIC_PEM));
        SecurityTool.writePEM(fos1, PUBLIC_KEY, publicEncoded);
        fos1.close();
        PrintWriter fos2 = new PrintWriter(new FileWriter(name + PRIVATE_PEM));
        SecurityTool.writePEM(fos2, PRIVATE_KEY, privateEncoded);
        fos2.close();
    }

    private static void writePEM(PrintWriter printWriter, String name, byte[] encoded) {
        String str = Base64Binary.fromBinary(encoded);
        printWriter.println("-----BEGIN " + name + "-----");
        for (int i = 0; i < str.length(); i += 64) {
            String line = str.substring(i, Math.min(i + 64, str.length()));
            printWriter.println(line);
        }
        printWriter.println("-----END " + name + "-----");
    }

    private static byte[] readPEM(BufferedReader reader, String name) throws IOException {
        String line;
        boolean started = false;
        StringBuffer text = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("-") && line.indexOf("BEGIN " + name) != -1) {
                started = true;
                continue;
            }
            if (!started) continue;
            if (line.startsWith("-") && line.indexOf("END " + name) != -1) break;
            text.append(line);
        }
        byte[] bytes = Base64Binary.toBinary(text.toString());
        return bytes;
    }
}

