/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.io;

import com.tplus.transform.io.FilenameUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.util.List;

public class WildcardFilter
implements FilenameFilter {
    private String[] wildcards = null;

    public WildcardFilter(String wildcard) {
        if (wildcard == null) {
            throw new IllegalArgumentException();
        }
        this.wildcards = new String[]{wildcard};
    }

    public WildcardFilter(String[] wildcards) {
        if (wildcards == null) {
            throw new IllegalArgumentException();
        }
        this.wildcards = wildcards;
    }

    public WildcardFilter(List wildcards) {
        if (wildcards == null) {
            throw new IllegalArgumentException();
        }
        this.wildcards = wildcards.toArray(new String[wildcards.size()]);
    }

    public boolean accept(File dir, String name) {
        if (dir != null && new File(dir, name).isDirectory()) {
            return false;
        }
        for (int i = 0; i < this.wildcards.length; ++i) {
            if (!FilenameUtils.wildcardMatch(name, this.wildcards[i])) continue;
            return true;
        }
        return false;
    }

    public boolean accept(File file) {
        if (file.isDirectory()) {
            return false;
        }
        for (int i = 0; i < this.wildcards.length; ++i) {
            if (!FilenameUtils.wildcardMatch(file.getName(), this.wildcards[i])) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        File dir = new File(".");
        WildcardFilter fileFilter = new WildcardFilter("*test*.java~*~");
        String[] names = dir.list(fileFilter);
        for (int i = 0; i < names.length; ++i) {
            System.out.println(new File(dir, names[i]));
        }
    }
}

