/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.lang;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public class BeanManager {
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    Map beanMap = new WeakHashMap();

    public Object getProperty(Object object, String name) throws IntrospectionException, InvocationTargetException, IllegalAccessException {
        BeanData.PropertyInfo propertyDescriptor = this.getPropertyDescriptor(object, name);
        if (propertyDescriptor != null) {
            Method readMethod = propertyDescriptor.getReadMethod();
            if (readMethod == null) {
                throw new IntrospectionException("No getter method for property " + name);
            }
            Object value = readMethod.invoke(object, EMPTY_OBJECT_ARRAY);
            return value;
        }
        return null;
    }

    public void setProperty(Object object, String name, Object value) throws IntrospectionException, InvocationTargetException, IllegalAccessException {
        BeanData.PropertyInfo propertyDescriptor = this.getPropertyDescriptor(object, name);
        if (propertyDescriptor != null) {
            Method writeMethod = propertyDescriptor.getWriteMethod();
            if (writeMethod == null) {
                throw new IntrospectionException("No setter for property " + name);
            }
            writeMethod.invoke(object, value);
        }
    }

    private BeanData.PropertyInfo getPropertyDescriptor(Object object, String name) throws IntrospectionException {
        BeanData data = this.getBeanData(object);
        return data.getPropertyDescriptor(name);
    }

    private synchronized BeanData getBeanData(Object object) throws IntrospectionException {
        Class<?> cls = object.getClass();
        WeakReference ref = (WeakReference)this.beanMap.get(cls);
        BeanData data = null;
        if (ref != null) {
            data = (BeanData)ref.get();
        }
        if (data == null) {
            data = new BeanData(cls);
            this.beanMap.put(cls, new WeakReference<BeanData>(data));
        }
        return data;
    }

    static class BeanData {
        BeanInfo beanInfo;
        Class cls;
        Map propertyInfoMap = new HashMap();

        BeanData(Class cls) throws IntrospectionException {
            this.cls = cls;
            this.beanInfo = Introspector.getBeanInfo(cls);
            this.prepare();
        }

        void prepare() throws IntrospectionException {
            PropertyDescriptor[] propertyDescriptors = this.beanInfo.getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptors.length; ++i) {
                PropertyDescriptor propertyDescriptor = propertyDescriptors[i];
                this.propertyInfoMap.put(propertyDescriptor.getName(), new PropertyInfo(propertyDescriptor));
            }
        }

        PropertyInfo getPropertyDescriptor(String name) throws IntrospectionException {
            PropertyInfo propertyInfo = (PropertyInfo)this.propertyInfoMap.get(name);
            if (propertyInfo == null) {
                throw new IntrospectionException("No property by name " + name + " in class " + this.cls);
            }
            return propertyInfo;
        }

        static class PropertyInfo {
            PropertyDescriptor propertyDescriptor;
            Method readMethod;
            Method writeMethod;

            PropertyInfo(PropertyDescriptor propertyDescriptor) {
                this.propertyDescriptor = propertyDescriptor;
                this.readMethod = propertyDescriptor.getReadMethod();
                this.writeMethod = propertyDescriptor.getWriteMethod();
            }

            public PropertyDescriptor getPropertyDescriptor() {
                return this.propertyDescriptor;
            }

            public Method getReadMethod() {
                return this.readMethod;
            }

            public Method getWriteMethod() {
                return this.writeMethod;
            }
        }
    }
}

