/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.lang;

import com.tplus.transform.lang.StackFrame;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public class CallStack {
    List frames = new ArrayList();

    public CallStack() {
        this.prepare(new Exception());
    }

    public CallStack(Throwable e) {
        this.prepare(e);
    }

    public boolean containsClass(String name) {
        for (int i = 0; i < this.frames.size(); ++i) {
            StackFrame frame = (StackFrame)this.frames.get(i);
            if (!frame.getSimpleClassName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private void add(StackFrame frame) {
        this.frames.add(frame);
    }

    public StackFrame callerFrame() {
        return (StackFrame)this.frames.get(1);
    }

    public final void dump() {
        this.dump(System.out);
    }

    public void dump(PrintStream out) {
        this.dump(out, Integer.MAX_VALUE);
    }

    public void dump(PrintStream out, int till) {
        for (int i = 0; i < till && i < this.frames.size(); ++i) {
            StackFrame frame = (StackFrame)this.frames.get(i);
            out.print("  ");
            out.println(frame.toString());
        }
    }

    public String toString() {
        StringBuffer toRet = new StringBuffer();
        for (int i = 0; i < this.frames.size(); ++i) {
            StackFrame frame = (StackFrame)this.frames.get(i);
            toRet.append("  ");
            toRet.append(frame.toString()).append("\n");
        }
        return toRet.toString();
    }

    void prepare(Throwable e) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(bos);
        e.printStackTrace(ps);
        ps.close();
        ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
        BufferedReader reader = new BufferedReader(new InputStreamReader(bis));
        try {
            String line;
            boolean lineNum = false;
            while ((line = reader.readLine()) != null) {
                StackFrame frame;
                if (line.indexOf("at ") == -1 || (frame = new StackFrame(line)).getSimpleClassName().equals("CallStack")) continue;
                this.add(frame);
            }
        }
        catch (IOException e1) {
            // empty catch block
        }
    }

    public static void cmtmain(String[] args) {
        new CallStack().dump(System.out, 5);
    }
}

