/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.lang;

public class ClassUtil {
    public static String getSimpleName(Class cls) {
        int index;
        if (cls.isArray()) {
            return ClassUtil.getSimpleName(cls.getComponentType()) + "[]";
        }
        String simpleName = ClassUtil.getSimpleBinaryName(cls);
        if (simpleName == null) {
            simpleName = cls.getName();
            return simpleName.substring(simpleName.lastIndexOf(".") + 1);
        }
        int length = simpleName.length();
        if (length < 1 || simpleName.charAt(0) != '$') {
            throw new InternalError("Malformed class name");
        }
        for (index = 1; index < length && ClassUtil.isAsciiDigit(simpleName.charAt(index)); ++index) {
        }
        return simpleName.substring(index);
    }

    private static boolean isAsciiDigit(char c) {
        return '0' <= c && c <= '9';
    }

    private static String getSimpleBinaryName(Class cls) {
        Class enclosingClass = null;
        if (enclosingClass == null) {
            return null;
        }
        try {
            return cls.getName().substring(enclosingClass.getName().length());
        }
        catch (IndexOutOfBoundsException ex) {
            throw new InternalError("Malformed class name");
        }
    }

    public static void cmtmain(String[] args) {
        System.out.println(ClassUtil.getSimpleName(ClassUtil.class));
    }

    public static String getPackageName(String className) {
        if (className != null && className.length() > 0) {
            return className.substring(0, className.lastIndexOf("."));
        }
        return null;
    }
}

