/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.lang;

import com.tplus.transform.lang.DoubleUtils;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

public class Wrapper {
    static Method toPlainStringMethod;
    static BigDecimalConverter bigDecimalConverter;
    private static final int MAX_INT_CACHE = 1024;
    private static final int MIN_INT_CACHE = -16;
    private static String[] positiveIntStringCache;
    private static Integer[] positiveIntIntegerCache;
    private static String[] negativeIntStringCache;
    private static Integer[] negativeIntIntegerCache;
    private static final char MAX_CHAR_CACHE = '\u0080';
    private static Character[] charCache;
    private static BigDecimal[] positiveBigDecimalIntegerCache;
    private static BigDecimal[] negativeBigDecimalIntegerCache;
    public static final BigDecimal ZERO_BIG_DECIMAL;
    static final Map PRIMITIVES_TO_WRAPPERS;

    public static int parseInt(String arg) {
        if (arg != null && arg.length() > 0 && arg.charAt(0) == '+') {
            arg = arg.substring(1);
        }
        return Integer.parseInt(arg);
    }

    public static long parseLong(String arg) {
        if (arg.length() > 0 && arg.charAt(0) == '+') {
            arg = arg.substring(1);
        }
        return Long.parseLong(arg);
    }

    public static BigInteger parseBigInteger(String arg) {
        if (arg.length() > 0 && arg.charAt(0) == '+') {
            arg = arg.substring(1);
        }
        return new BigInteger(arg);
    }

    public static BigDecimal parseBigDecimal(String arg) {
        if (arg.length() > 0 && arg.charAt(0) == '+') {
            arg = arg.substring(1);
        }
        return new BigDecimal(arg);
    }

    public static BigDecimal toBigDecimal(BigInteger val) {
        return new BigDecimal(val);
    }

    public static BigDecimal toBigDecimal(int val) {
        if (val >= 0) {
            if (val < 1024) {
                return positiveBigDecimalIntegerCache[val];
            }
        } else if (val < 0 && val > -16) {
            return negativeBigDecimalIntegerCache[-val];
        }
        return BigDecimal.valueOf(val);
    }

    public static BigDecimal toBigDecimal(double arg) {
        if (arg == 0.0) {
            return ZERO_BIG_DECIMAL;
        }
        return bigDecimalConverter.valueOf(arg);
    }

    public static BigDecimal toBigDecimal(String arg) {
        return new BigDecimal(arg);
    }

    public static Integer box(int val) {
        return Wrapper.toInteger(val);
    }

    public static Integer boxInt(int val) {
        return Wrapper.box(val);
    }

    public static Integer boxInt(Integer val) {
        return val;
    }

    public static Long box(long val) {
        return new Long(val);
    }

    public static Long boxLong(long val) {
        return Wrapper.box(val);
    }

    public static Long boxLong(Integer val) {
        return val == null ? null : Wrapper.boxLong((long)val.intValue());
    }

    public static Long boxLong(Long val) {
        return val;
    }

    public static Float box(float val) {
        return new Float(val);
    }

    public static Float boxFloat(Integer val) {
        return val == null ? null : Wrapper.boxFloat((float)val.intValue());
    }

    public static Float boxFloat(float val) {
        return Wrapper.box(val);
    }

    public static Double box(double val) {
        return new Double(val);
    }

    public static Double boxDouble(Double val) {
        return val;
    }

    public static Double boxDouble(Integer val) {
        return val == null ? null : Wrapper.boxDouble((double)val.intValue());
    }

    public static Double boxDouble(Float val) {
        return val == null ? null : Wrapper.boxDouble((double)val.floatValue());
    }

    public static Double boxDouble(Long val) {
        return val == null ? null : Wrapper.boxDouble((double)val.longValue());
    }

    public static Double boxDouble(double val) {
        return Wrapper.box(val);
    }

    public static Short box(short val) {
        return new Short(val);
    }

    public static Byte box(byte val) {
        return new Byte(val);
    }

    public static Character box(char val) {
        return Wrapper.toCharacter(val);
    }

    public static Character boxCharacter(char val) {
        return Wrapper.box(val);
    }

    public static Boolean box(boolean val) {
        return val ? Boolean.TRUE : Boolean.FALSE;
    }

    public static Boolean boxBoolean(boolean val) {
        return Wrapper.box(val);
    }

    public static String toString(int val) {
        if (val >= 0) {
            if (val < 1024) {
                return positiveIntStringCache[val];
            }
        } else if (val < 0 && val > -16) {
            return negativeIntStringCache[-val];
        }
        return Integer.toString(val);
    }

    public static String toString(BigDecimal val) {
        String toRet = Wrapper.toStringImpl(val);
        toRet = Wrapper.removeTrailingDecimalZeros(toRet);
        return toRet;
    }

    public static String toString(BigDecimal val, String format) {
        String toRet = Wrapper.toStringImpl(val);
        if (format != null) {
            toRet = Wrapper.removeTrailingDecimalZeros(toRet);
        }
        return toRet;
    }

    public static String toString(BigDecimal val, DoubleUtils.NumberFormatInfo numberFormatInfo) {
        String toRet = Wrapper.toStringImpl(val);
        toRet = Wrapper.removeTrailingDecimalZeros(toRet);
        if (numberFormatInfo.isAlwaysUseDecimalPoint()) {
            if (toRet.indexOf(46) == -1) {
                toRet = toRet + ".";
            }
        } else if (numberFormatInfo.isAlwaysUseDecimalPoint() && toRet.endsWith(".0")) {
            toRet = toRet.substring(0, toRet.length() - 2);
        }
        if (!numberFormatInfo.isAlwaysUseDecimalComponent() && toRet.endsWith(".0")) {
            toRet = toRet.substring(0, toRet.length() - 1);
        }
        if (numberFormatInfo.getDecimalPoint() != '.') {
            toRet = toRet.replace('.', numberFormatInfo.getDecimalPoint());
        }
        return toRet;
    }

    private static String toStringImpl(BigDecimal val) {
        return bigDecimalConverter.toString(val);
    }

    private static String removeTrailingDecimalZeros(String toRet) {
        int length = toRet.length();
        int lastTrailingZero = -1;
        boolean nonZeroSeen = false;
        for (int i = length - 1; i >= 0; --i) {
            char c = toRet.charAt(i);
            if (c == '0' && !nonZeroSeen) {
                lastTrailingZero = i;
                continue;
            }
            if (c == '.') {
                if (i >= length - 2 || lastTrailingZero <= 0) continue;
                lastTrailingZero = Math.max(lastTrailingZero, i + 2);
                return toRet.substring(0, lastTrailingZero);
            }
            nonZeroSeen = true;
        }
        return toRet;
    }

    public static Integer toInteger(int val) {
        if (val >= 0) {
            if (val < 1024) {
                return positiveIntIntegerCache[val];
            }
        } else if (val < 0 && val > -16) {
            return negativeIntIntegerCache[-val];
        }
        return new Integer(val);
    }

    public static Character toCharacter(char val) {
        if (val >= '\u0000' && val < '\u0080') {
            return charCache[val];
        }
        return new Character(val);
    }

    public static Class getWrapperClass(Class primitive) {
        return (Class)PRIMITIVES_TO_WRAPPERS.get(primitive);
    }

    public static void main(String[] args) {
        System.out.println(Wrapper.removeTrailingDecimalZeros("1212121.100000000000000000000000000000"));
        System.out.println(Wrapper.removeTrailingDecimalZeros("1212121.00"));
        System.out.println(Wrapper.removeTrailingDecimalZeros("1212121.01010"));
        System.out.println(Wrapper.toStringImpl(new BigDecimal("020.310000")));
    }

    static {
        int i;
        bigDecimalConverter = new BigDecimalConverter();
        try {
            toPlainStringMethod = BigDecimal.class.getMethod("toPlainString", new Class[0]);
            bigDecimalConverter = new BigDecimalConverterJRE15();
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        positiveIntStringCache = new String[1024];
        positiveIntIntegerCache = new Integer[1024];
        for (i = 0; i < 1024; ++i) {
            Wrapper.positiveIntStringCache[i] = Integer.toString(i).intern();
            Wrapper.positiveIntIntegerCache[i] = new Integer(i);
        }
        negativeIntStringCache = new String[16];
        negativeIntIntegerCache = new Integer[16];
        for (i = 0; i < 16; ++i) {
            Wrapper.negativeIntStringCache[i] = Integer.toString(-i).intern();
            Wrapper.negativeIntIntegerCache[i] = new Integer(-i);
        }
        charCache = new Character[128];
        for (i = 0; i < 128; i = (int)((char)(i + 1))) {
            Wrapper.charCache[i] = new Character((char)i);
        }
        positiveBigDecimalIntegerCache = new BigDecimal[1024];
        for (i = 0; i < 1024; ++i) {
            Wrapper.positiveBigDecimalIntegerCache[i] = BigDecimal.valueOf(i);
        }
        negativeBigDecimalIntegerCache = new BigDecimal[16];
        for (i = 0; i < 16; ++i) {
            Wrapper.negativeBigDecimalIntegerCache[i] = BigDecimal.valueOf(i);
        }
        ZERO_BIG_DECIMAL = BigDecimal.valueOf(0L);
        PRIMITIVES_TO_WRAPPERS = new HashMap();
        PRIMITIVES_TO_WRAPPERS.put(Boolean.TYPE, Boolean.class);
        PRIMITIVES_TO_WRAPPERS.put(Byte.TYPE, Byte.class);
        PRIMITIVES_TO_WRAPPERS.put(Character.TYPE, Character.class);
        PRIMITIVES_TO_WRAPPERS.put(Double.TYPE, Double.class);
        PRIMITIVES_TO_WRAPPERS.put(Float.TYPE, Float.class);
        PRIMITIVES_TO_WRAPPERS.put(Integer.TYPE, Integer.class);
        PRIMITIVES_TO_WRAPPERS.put(Long.TYPE, Long.class);
        PRIMITIVES_TO_WRAPPERS.put(Short.TYPE, Short.class);
        PRIMITIVES_TO_WRAPPERS.put(Void.TYPE, Void.class);
    }

    static class BigDecimalConverterJRE15
    extends BigDecimalConverter {
        BigDecimalConverterJRE15() {
        }

        public String toString(BigDecimal val) {
            return val.toPlainString();
        }
    }

    static class BigDecimalConverter {
        BigDecimalConverter() {
        }

        public BigDecimal valueOf(double d) {
            return new BigDecimal(Double.toString(d));
        }

        public String toString(BigDecimal val) {
            return val.toString();
        }
    }
}

