/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.AbstractExternalMessage;
import com.tplus.transform.runtime.AbstractMessage;
import com.tplus.transform.runtime.AbstractOutputFormat;
import com.tplus.transform.runtime.AbstractRawMessage;
import com.tplus.transform.runtime.AbstractServiceElement;
import com.tplus.transform.runtime.BaseMessage;
import com.tplus.transform.runtime.BatchMessage;
import com.tplus.transform.runtime.BatchOutputWriter;
import com.tplus.transform.runtime.BatchParser;
import com.tplus.transform.runtime.BatchWriter;
import com.tplus.transform.runtime.BatchWriterImpl;
import com.tplus.transform.runtime.ByteArrayInputSource;
import com.tplus.transform.runtime.CascadedOperation;
import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DataObjectSection;
import com.tplus.transform.runtime.DataObjectSectionImpl2;
import com.tplus.transform.runtime.DeviceInfo;
import com.tplus.transform.runtime.ExceptionHandler;
import com.tplus.transform.runtime.ExternalMessageValidationRules;
import com.tplus.transform.runtime.ExternalObject;
import com.tplus.transform.runtime.InputSource;
import com.tplus.transform.runtime.MessageHandler;
import com.tplus.transform.runtime.MessageInfo;
import com.tplus.transform.runtime.OperationExecutor;
import com.tplus.transform.runtime.OperationNode;
import com.tplus.transform.runtime.OutputDevice;
import com.tplus.transform.runtime.PhasedParser;
import com.tplus.transform.runtime.PhasedWriter;
import com.tplus.transform.runtime.RawMessage;
import com.tplus.transform.runtime.Result;
import com.tplus.transform.runtime.TransformContext;
import com.tplus.transform.runtime.TransformContextImpl;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.TransformRuntimeException;
import com.tplus.transform.runtime.Validator;
import com.tplus.transform.runtime.io.OutputMessageDevice;
import com.tplus.transform.runtime.log.LogFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractBatchMessage
extends BaseMessage
implements BatchMessage {
    protected BatchParser parser;
    protected ExternalMessageValidationRules defaultValidator;
    Map validators = new HashMap();
    protected BatchOutputWriter writer;
    String messageName;
    MessageInfo messageInfo;

    protected AbstractBatchMessage(String messageName) {
        super(messageName, "External Message");
        this.messageName = messageName;
        this.setLogger(LogFactory.getMessageLog(this, messageName));
    }

    protected void setMessageInfo(MessageInfo messageInfo) {
        this.messageInfo = messageInfo;
    }

    public MessageInfo getMessageInfo() {
        return this.messageInfo;
    }

    public void addValidator(String name, ExternalMessageValidationRules validator) {
        this.validators.put(name, validator);
    }

    protected Collection getValidators() {
        return this.validators.values();
    }

    protected OperationNode getParserNode() {
        return (OperationNode)((Object)this.parser);
    }

    public DataObject createObject() {
        return this.createExternalObject();
    }

    public abstract ExternalObject createExternalObject(DataObject var1, DataObject var2, DataObject var3);

    public DataObject[] parseBatch(InputSource is, TransformContext cxt) throws TransformException {
        this.onStartOperation();
        return this.parseBatchImpl(is, ExceptionHandler.DRACONIAN_EXCEPTION_HANDLER, cxt);
    }

    public Result parseBatch2(final InputSource is, final TransformContext cxt) throws TransformException, RemoteException {
        return OperationExecutor.execute(this, new CascadedOperation(){

            public Object run(ExceptionHandler exceptionHandler) throws TransformException, RemoteException {
                return AbstractBatchMessage.this.parseBatchImpl(is, ExceptionHandler.DRACONIAN_EXCEPTION_HANDLER, cxt);
            }
        });
    }

    public DataObject[] parseBatchImpl(InputSource is, ExceptionHandler exceptionHandler, TransformContext cxt) throws TransformException {
        try {
            DataObjectSection section = AbstractBatchMessage.parse(this, is, exceptionHandler, cxt);
            return section.toArray(new DataObject[section.size()]);
        }
        catch (RemoteException e) {
            throw new TransformException(e.getMessage(), e);
        }
    }

    public RawMessage serializeBatch(DataObject[] messageObject, TransformContext cxt) throws TransformException, RemoteException {
        this.onStartOperation();
        return this.serializeBatchImpl(messageObject, ExceptionHandler.DRACONIAN_EXCEPTION_HANDLER, cxt);
    }

    RawMessage serializeBatchImpl(DataObject[] messageObject, ExceptionHandler exceptionHandler, TransformContext cxt) throws TransformException, RemoteException {
        TransformContextImpl tcxt = new TransformContextImpl();
        OutputMessageDevice device = new OutputMessageDevice(new DeviceInfo("", "", "", null));
        BatchWriter writer = this.getBatchWriter();
        writer.startBatch(device, tcxt);
        for (int i = 0; i < messageObject.length; ++i) {
            DataObject dataObject = messageObject[i];
            writer.writeMessage((ExternalObject)dataObject, device, tcxt);
        }
        writer.endBatch(device, tcxt);
        device.close();
        return device.getMessage();
    }

    public Result serializeBatch2(final DataObject[] messageObject, final TransformContext cxt) throws TransformException, RemoteException {
        return OperationExecutor.execute(this, new CascadedOperation(){

            public Object run(ExceptionHandler exceptionHandler) throws TransformException, RemoteException {
                return AbstractBatchMessage.this.serializeBatchImpl(messageObject, exceptionHandler, cxt);
            }
        });
    }

    public void parse(InputSource source, MessageHandler messageHandler, TransformContext cxt) throws TransformException {
        this.onStartOperation();
        this.parse(source, messageHandler, ExceptionHandler.DRACONIAN_EXCEPTION_HANDLER, cxt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputSource source, MessageHandler messageHandler, ExceptionHandler exceptionHandler, TransformContext cxt) throws TransformException {
        this.onStartOperation();
        this.trace("parse");
        this.onOperationEnter(this.parseOperationInfo, "input", source, cxt);
        try {
            this.parser.parseBatch(source, messageHandler, exceptionHandler, cxt);
        }
        finally {
            this.onOperationExit(this.parseOperationInfo);
        }
    }

    public static DataObjectSection parse(BatchMessage batchMessage, InputSource source, TransformContext cxt) throws TransformException, RemoteException {
        return AbstractBatchMessage.parse(batchMessage, source, ExceptionHandler.DRACONIAN_EXCEPTION_HANDLER, cxt);
    }

    public static DataObjectSection parse(BatchMessage batchMessage, InputSource source, ExceptionHandler exceptionHandler, TransformContext cxt) throws TransformException, RemoteException {
        final DataObjectSectionImpl2 sec = new DataObjectSectionImpl2(null, "ExternalObjects");
        BatchParser parser1 = batchMessage.getBatchParser();
        parser1.parseBatch(source, new MessageHandler(){

            public boolean handleMessage(DataObject obj, TransformContext cxt) {
                obj.setParentSection(sec);
                sec.addElement(obj);
                return true;
            }
        }, exceptionHandler, cxt);
        return sec;
    }

    public DataObject parse(InputSource source, TransformContext cxt) throws TransformException {
        final ArrayList objects = new ArrayList();
        this.parse(source, new MessageHandler(){

            public boolean handleMessage(DataObject obj, TransformContext cxt) throws TransformException {
                objects.add(obj);
                return true;
            }
        }, cxt);
        return (DataObject)this.getFirstElement(objects);
    }

    private Object getFirstElement(List objects) {
        return objects.size() > 0 ? objects.get(0) : null;
    }

    public DataObject parse(byte[] source, TransformContext cxt) throws TransformException {
        return this.parse(new ByteArrayInputSource(source), cxt);
    }

    public Result parse2(final InputSource source, final TransformContext cxt) throws RemoteException {
        final ExceptionHandler.CascadingExceptionHandler cascadingExceptionHandler = new ExceptionHandler.CascadingExceptionHandler();
        return OperationExecutor.execute(this, new CascadedOperation(){

            public Object run(ExceptionHandler exceptionHandler) throws TransformException {
                final ArrayList objects = new ArrayList();
                AbstractBatchMessage.this.parse(source, new MessageHandler(){

                    public boolean handleMessage(DataObject obj, TransformContext cxt) throws TransformException {
                        objects.add(obj);
                        return true;
                    }
                }, cascadingExceptionHandler, cxt);
                return AbstractBatchMessage.this.getFirstElement(objects);
            }
        });
    }

    public Result parse2(byte[] source, TransformContext cxt) throws RemoteException {
        return this.parse2(new ByteArrayInputSource(source), cxt);
    }

    public abstract ExternalObject createExternalObject();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void validate(DataObject obj, TransformContext cxt) throws TransformException {
        this.onStartOperation();
        this.trace("validate");
        this.onOperationEnter(this.validateOperationInfo, "messageObj", obj, cxt);
        try {
            this.validate(obj, ExceptionHandler.DRACONIAN_EXCEPTION_HANDLER, cxt);
        }
        finally {
            this.onOperationExit(this.validateOperationInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void validate(String name, DataObject obj, TransformContext cxt) throws TransformException {
        this.onStartOperation();
        this.trace("validate");
        this.onOperationEnter(this.validateOperationInfo, "messageObj", obj, cxt);
        try {
            this.validate(name, obj, ExceptionHandler.DRACONIAN_EXCEPTION_HANDLER, cxt);
        }
        finally {
            this.onOperationExit(this.validateOperationInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] serializeImpl(DataObject obj, TransformContext cxt) throws TransformException, RemoteException {
        this.onStartOperation();
        this.trace("serialize");
        this.onOperationEnter(this.serializeOperationInfo, "messageObj", obj, cxt);
        try {
            String messageFormat = (String)cxt.getProperty("message.format");
            if ("xml".equalsIgnoreCase(messageFormat)) {
                byte[] byArray = obj.toXMLString().getBytes();
                return byArray;
            }
            ExternalObject externalObject = AbstractExternalMessage.toExternalObject(obj);
            Object headerPart = this.serializeHeader(externalObject.getHeader(), cxt);
            Object dataPart = this.serializeData(externalObject.getData(), cxt);
            Object trailerPart = this.serializeTrailer(externalObject.getTrailer(), cxt);
            Object[] output = new Object[]{headerPart, dataPart, trailerPart};
            OutputMessageDevice device = new OutputMessageDevice(AbstractBatchMessage.createDeviceInfo(cxt, this.getEncoding(cxt)));
            AbstractOutputFormat.writeToDevice(output, device);
            device.close();
            byte[] byArray = device.getMessage().getAsBytes();
            return byArray;
        }
        finally {
            this.onOperationExit(this.serializeOperationInfo);
        }
    }

    public byte[] serialize(DataObject obj, TransformContext cxt) throws TransformException, RemoteException {
        this.onStartOperation();
        this.trace("serialize");
        return this.serializeImpl(obj, cxt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result serialize2(final DataObject obj, final TransformContext cxt) throws RemoteException {
        this.onStartOperation();
        this.trace("serialize", "2");
        Result result = OperationExecutor.execute(this, new CascadedOperation(){

            public Object run(ExceptionHandler exceptionHandler) throws TransformException, RemoteException {
                return AbstractBatchMessage.this.serializeImpl(obj, cxt);
            }
        });
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(DataObject obj, OutputDevice outputDevice, TransformContext cxt) throws TransformException, RemoteException {
        this.onOperationEnter(this.serializeOperationInfo, "messageObj", obj, cxt);
        try {
            ExternalObject externalObject = AbstractExternalMessage.toExternalObject(obj);
            Object headerPart = this.serializeHeader(externalObject.getHeader(), cxt);
            Object dataPart = this.serializeData(externalObject.getData(), cxt);
            Object trailerPart = this.serializeTrailer(externalObject.getTrailer(), cxt);
            Object[] output = new Object[]{headerPart, dataPart, trailerPart};
            OutputMessageDevice device = new OutputMessageDevice(AbstractBatchMessage.createDeviceInfo(cxt, this.getEncoding(cxt)));
            AbstractOutputFormat.writeToDevice(output, device);
        }
        finally {
            this.onOperationExit(this.serializeOperationInfo);
        }
    }

    public byte[] getResource(String name) throws TransformException, RemoteException {
        return AbstractMessage.getResource(this.getClass(), name);
    }

    public Object startBatch(DataObject obj, TransformContext cxt) throws TransformException {
        ExternalObject externalObject = AbstractExternalMessage.toExternalObject(obj);
        Object headerPart = this.serializeHeader(externalObject.getHeader(), cxt);
        return new Object[]{headerPart};
    }

    public Object endBatch(DataObject obj, TransformContext cxt) throws TransformException {
        ExternalObject externalObject = AbstractExternalMessage.toExternalObject(obj);
        Object trailerPart = this.serializeTrailer(externalObject.getTrailer(), cxt);
        return new Object[]{trailerPart};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result validate2(final DataObject obj, final TransformContext cxt) throws RemoteException {
        this.onStartOperation();
        this.trace("validate", "2");
        this.onOperationEnter(this.validateOperationInfo, "messageObj", obj, cxt);
        try {
            Result result = OperationExecutor.execute(this, new CascadedOperation(){

                public Object run(ExceptionHandler exceptionHandler) throws TransformException {
                    AbstractBatchMessage.this.validate(obj, exceptionHandler, cxt);
                    return null;
                }
            });
            return result;
        }
        finally {
            this.onOperationExit(this.validateOperationInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result validate2(final String name, final DataObject obj, final TransformContext cxt) throws RemoteException {
        this.onStartOperation();
        this.trace("validate", "2");
        this.onOperationEnter(this.validateOperationInfo, "messageObj", obj, cxt);
        try {
            Result result = OperationExecutor.execute(this, new CascadedOperation(){

                public Object run(ExceptionHandler exceptionHandler) throws TransformException {
                    AbstractBatchMessage.this.validate(name, obj, exceptionHandler, cxt);
                    return null;
                }
            });
            return result;
        }
        finally {
            this.onOperationExit(this.validateOperationInfo);
        }
    }

    public Object serializeHeader(DataObject header, TransformContext cxt) throws TransformException {
        Object[] messageParts = new Object[]{this.writer.writeStartMessage(), this.writer.writeHeader(header, cxt), this.writer.writeBodyStart()};
        return messageParts;
    }

    public Object serializeTrailer(DataObject trailer, TransformContext cxt) throws TransformException {
        Object[] messageParts = new Object[]{this.writer.writeBodyEnd(), this.writer.writeTrailer(trailer, cxt), this.writer.writeEndMessage()};
        return messageParts;
    }

    public BatchWriter getBatchWriter() {
        this.onStartOperation();
        try {
            Class<?> writerClass = this.writer.getClass();
            Constructor<?> constructor = writerClass.getConstructor(AbstractServiceElement.class);
            BatchOutputWriter newWriter = (BatchOutputWriter)constructor.newInstance(this);
            return new BatchWriterImpl(newWriter, this.getDefaultEncoding());
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return new BatchWriterImpl(this.writer, this.getDefaultEncoding());
    }

    public BatchParser getBatchParser() {
        try {
            Class<?> parserClass = this.parser.getClass();
            Constructor<?> constructor = parserClass.getConstructor(AbstractServiceElement.class);
            BatchParser newParser = (BatchParser)constructor.newInstance(this);
            return newParser;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return this.parser;
    }

    protected Object serializeData(DataObject record, TransformContext cxt) throws TransformException {
        return this.writer.writeData(record, cxt);
    }

    protected void validate(DataObject obj, ExceptionHandler exceptionHandler, TransformContext cxt) throws TransformException {
        ExternalObject externalObject = AbstractExternalMessage.toExternalObject(obj);
        AbstractExternalMessage.executeValidation(this.defaultValidator, externalObject, exceptionHandler, cxt);
    }

    protected void validate(String name, DataObject obj, ExceptionHandler exceptionHandler, TransformContext cxt) throws TransformException {
        ExternalObject externalObject = AbstractExternalMessage.toExternalObject(obj);
        Validator validator = (Validator)this.validators.get(name);
        if (validator == null) {
            throw new TransformRuntimeException("Validator by name '" + name + "' is not defined for the message '" + this.getMessageName() + "'");
        }
        AbstractExternalMessage.executeValidation(validator, externalObject, exceptionHandler, cxt);
    }

    private void checkWriter() {
        if (this.writer == null) {
            throw TransformRuntimeException.createFormatted("SRT662", this.getMessageName());
        }
    }

    protected static DeviceInfo createDeviceInfo(TransformContext tcxt, String encoding) throws TransformException {
        return AbstractOutputFormat.createDeviceInfo(tcxt, encoding);
    }

    protected String getEncoding(TransformContext cxt) {
        String encoding = (String)cxt.getProperty("encoding");
        if (encoding == null) {
            encoding = this.getDefaultEncoding();
        }
        return encoding;
    }

    protected String getDefaultEncoding() {
        return null;
    }

    public String getMessageName() {
        return this.messageName;
    }

    public static RawMessage serialize(BatchMessage batchMessage, DataObjectSection sec, TransformContext cxt) throws TransformException, RemoteException {
        cxt.setProperty("output.device", "");
        DeviceInfo deviceInfo = AbstractBatchMessage.createDeviceInfo(cxt, null);
        OutputMessageDevice device = new OutputMessageDevice(deviceInfo);
        AbstractBatchMessage.serialize(batchMessage, sec, device, cxt);
        return device.getMessage();
    }

    public static Result serialize2(BatchMessage batchMessage, DataObjectSection sec, TransformContext cxt) throws TransformException, RemoteException {
        cxt.setProperty("output.device", "");
        DeviceInfo deviceInfo = AbstractBatchMessage.createDeviceInfo(cxt, null);
        OutputMessageDevice device = new OutputMessageDevice(deviceInfo);
        AbstractBatchMessage.serialize(batchMessage, sec, device, cxt);
        return new Result(device.getMessage(), null);
    }

    public static void serialize(BatchMessage batchMessage, DataObjectSection sec, OutputDevice device, TransformContext cxt) throws TransformException, RemoteException {
        BatchWriter writer = batchMessage.getBatchWriter();
        writer.startBatch(device, cxt);
        for (int i = 0; i < sec.getElementCount(); ++i) {
            ExternalObject element = (ExternalObject)sec.getElement(i);
            writer.writeMessage(element, device, cxt);
        }
        writer.endBatch(device, cxt);
        device.close();
    }

    public RawMessage serializeMessage(DataObject obj, TransformContext cxt) throws TransformException, RemoteException {
        ExternalObject externalObject = AbstractExternalMessage.toExternalObject(obj);
        Object headerPart = this.serializeHeader(externalObject.getHeader(), cxt);
        Object dataPart = this.serializeData(externalObject.getData(), cxt);
        Object trailerPart = this.serializeTrailer(externalObject.getTrailer(), cxt);
        Object[] output = new Object[]{headerPart, dataPart, trailerPart};
        return AbstractExternalMessage.convertOutputToMessage(output, cxt, this.getEncoding(cxt));
    }

    public void serializeMessage(DataObject obj, RawMessage outputRawMessage, TransformContext cxt) throws TransformException, RemoteException {
        ExternalObject externalObject = AbstractExternalMessage.toExternalObject(obj);
        Object headerPart = this.serializeHeader(externalObject.getHeader(), cxt);
        Object dataPart = this.serializeData(externalObject.getData(), cxt);
        Object trailerPart = this.serializeTrailer(externalObject.getTrailer(), cxt);
        Object[] output = new Object[]{headerPart, dataPart, trailerPart};
        AbstractRawMessage.writeObject(outputRawMessage, output);
    }

    public Result serializeMessage2(final DataObject obj, final TransformContext cxt) throws RemoteException {
        this.onStartOperation();
        this.trace("serialize", "2");
        return OperationExecutor.execute(this, new CascadedOperation(){

            public Object run(ExceptionHandler exceptionHandler) throws TransformException, RemoteException {
                return AbstractBatchMessage.this.serializeMessage(obj, cxt);
            }
        });
    }

    public Result serializeMessage2(final DataObject obj, final RawMessage output, final TransformContext cxt) throws RemoteException {
        this.onStartOperation();
        this.trace("serialize", "2");
        return OperationExecutor.execute(this, new CascadedOperation(){

            public Object run(ExceptionHandler exceptionHandler) throws TransformException, RemoteException {
                AbstractBatchMessage.this.serializeMessage(obj, output, cxt);
                return null;
            }
        });
    }

    public PhasedParser getPhasedParser() throws RemoteException {
        throw new RemoteException("Phased parsing is not supported");
    }

    public PhasedWriter getPhasedWriter() throws RemoteException {
        throw new RemoteException("Phased serialization is not supported");
    }
}

