/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.AbstractOutputFormat;
import com.tplus.transform.runtime.BatchContext;
import com.tplus.transform.runtime.BatchOutputWriter;
import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DeviceInfo;
import com.tplus.transform.runtime.ExceptionHandler;
import com.tplus.transform.runtime.NormalizedObject;
import com.tplus.transform.runtime.OutputDevice;
import com.tplus.transform.runtime.OutputProtocol;
import com.tplus.transform.runtime.OutputWriter;
import com.tplus.transform.runtime.TransformContext;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.TransformRuntimeException;
import com.tplus.transform.runtime.io.OutputMessageDevice;
import java.rmi.RemoteException;

public abstract class AbstractBatchOutputFormat
extends AbstractOutputFormat {
    protected static final String TRAILER_PROPERTY = "output.trailer";
    protected static final String BATCH_STARTED_PROPERTY = "batchstarted";

    private BatchOutputWriter getBatchOutputWriter() throws TransformException {
        OutputWriter writer = this.getOutputWriter();
        if (writer instanceof BatchOutputWriter) {
            return (BatchOutputWriter)writer;
        }
        throw TransformException.createFormatted("SRT350");
    }

    public void writeBatchStart(TransformContext tcxt) throws TransformException, RemoteException {
    }

    public void write(NormalizedObject no, TransformContext tcxt) throws TransformException, RemoteException {
        this.write(no, ExceptionHandler.DRACONIAN_EXCEPTION_HANDLER, tcxt);
    }

    public void write(NormalizedObject no, ExceptionHandler exceptionHandler, TransformContext tcxt) throws TransformException, RemoteException {
        try {
            String outputName = AbstractBatchOutputFormat.getOutputName(tcxt);
            BatchContext batchContext = (BatchContext)tcxt.getProperty("input.batch.context");
            if (batchContext != null) {
                boolean firstRecord = false;
                DataObject trailer = (DataObject)batchContext.getBatchProperty(outputName + TRAILER_PROPERTY);
                if (trailer == null) {
                    trailer = this.createTrailer();
                    batchContext.setBatchProperty(outputName + TRAILER_PROPERTY, trailer);
                    firstRecord = true;
                }
                DataObject header = null;
                if (firstRecord) {
                    Object batchRecordStartOutput;
                    OutputProtocol outputProtocol = this.getOutputProtocol(tcxt);
                    DeviceInfo deviceInfo = this.createDeviceInfo(tcxt);
                    OutputDevice device = outputProtocol.createDevice(deviceInfo, tcxt);
                    batchContext.addOutputDevice(outputName, device);
                    Object batchStartOutput = this.writeStartMessage();
                    if (batchStartOutput != null) {
                        batchContext.writeToDevice(outputName, batchStartOutput);
                    }
                    batchContext.setBatchProperty(outputName + BATCH_STARTED_PROPERTY, Boolean.TRUE);
                    header = this.createHeader();
                    this.mapHeader(no, header, tcxt);
                    Object batchHeaderOutput = this.writeHeader(header, exceptionHandler, tcxt);
                    if (batchHeaderOutput != null) {
                        batchContext.writeToDevice(outputName, batchHeaderOutput);
                    }
                    if ((batchRecordStartOutput = this.writeBodyStart()) != null) {
                        batchContext.writeToDevice(outputName, batchRecordStartOutput);
                    }
                }
                DataObject recordData = this.createRecordData();
                this.mapData(no, header, recordData, tcxt);
                Object dataOutput = this.writeData(recordData, exceptionHandler, tcxt);
                batchContext.writeToDevice(outputName, dataOutput);
                this.mapTrailer(no, recordData, trailer, tcxt);
                batchContext.setBatchProperty(outputName + TRAILER_PROPERTY, trailer);
            } else {
                Object output = this.prepareOutput(no, exceptionHandler, tcxt);
                DeviceInfo deviceInfo = this.createDeviceInfo(tcxt);
                OutputProtocol outputProtocol = this.getOutputProtocol(tcxt);
                OutputDevice device = outputProtocol.createDevice(deviceInfo, tcxt);
                AbstractBatchOutputFormat.writeOutput(output, device);
            }
        }
        catch (TransformException e) {
            e.setErrorPhase("Output");
            throw e;
        }
        catch (TransformRuntimeException re) {
            TransformException e = TransformException.createFormatted("SRT216", new Object[]{re.getMessage()});
            e.setDetail(re);
            e.setErrorPhase("Output");
            throw e;
        }
        catch (RemoteException e) {
            throw new RemoteException("Processing error in output format " + e.getMessage(), e);
        }
        catch (Exception re) {
            TransformException e = TransformException.createFormatted("SRT216", new Object[]{re.getMessage()});
            e.setDetail(re);
            e.setErrorPhase("Output");
            log.unexpectedError(re);
            throw e;
        }
    }

    public void writeBatchEnd(TransformContext tcxt) throws TransformException, RemoteException {
        this.writeBatchEnd(ExceptionHandler.DRACONIAN_EXCEPTION_HANDLER, tcxt);
    }

    public void writeBatchEnd(ExceptionHandler exceptionHandler, TransformContext tcxt) throws TransformException, RemoteException {
        try {
            String outputName = AbstractBatchOutputFormat.getOutputName(tcxt);
            BatchContext batchContext = (BatchContext)tcxt.getProperty("input.batch.context");
            boolean batchStarted = false;
            if (batchContext != null) {
                Boolean batchStartedBool = (Boolean)batchContext.getBatchProperty(outputName + BATCH_STARTED_PROPERTY);
                boolean bl = batchStarted = batchStartedBool != null && batchStartedBool != false;
            }
            if (batchStarted) {
                Object batchEndOutput;
                DataObject trailer = (DataObject)batchContext.getBatchProperty(outputName + TRAILER_PROPERTY);
                Object batchRecordEndOutput = this.writeBodyEnd();
                if (batchRecordEndOutput != null) {
                    batchContext.writeToDevice(outputName, batchRecordEndOutput);
                }
                Object batchTrailerOutput = null;
                if (trailer != null) {
                    batchTrailerOutput = this.writeTrailer(trailer, exceptionHandler, tcxt);
                }
                if (batchTrailerOutput != null) {
                    batchContext.writeToDevice(outputName, batchTrailerOutput);
                }
                if ((batchEndOutput = this.writeEndMessage()) != null) {
                    batchContext.writeToDevice(outputName, batchEndOutput);
                }
                batchContext.closeDevice(outputName);
            }
        }
        catch (TransformException e) {
            e.setErrorPhase("Output");
            throw e;
        }
        catch (RemoteException e) {
            throw new RemoteException("Processing error in output format " + e.getMessage());
        }
        catch (Exception re) {
            TransformException e = TransformException.createFormatted("SRT216", new Object[]{re.getMessage()});
            e.setDetail(re);
            e.setErrorPhase("Output");
            throw e;
        }
    }

    protected Object writeData(DataObject record, ExceptionHandler exceptionHandler, TransformContext cxt) throws TransformException {
        BatchOutputWriter writer = this.getBatchOutputWriter();
        return writer.writeData(record, cxt);
    }

    protected Object writeHeader(DataObject header, ExceptionHandler exceptionHandler, TransformContext cxt) throws TransformException {
        BatchOutputWriter writer = this.getBatchOutputWriter();
        return writer.writeHeader(header, cxt);
    }

    protected Object writeTrailer(DataObject trailer, ExceptionHandler exceptionHandler, TransformContext cxt) throws TransformException {
        BatchOutputWriter writer = this.getBatchOutputWriter();
        return writer.writeTrailer(trailer, cxt);
    }

    protected Object writeBodyStart() throws TransformException {
        BatchOutputWriter writer = this.getBatchOutputWriter();
        return writer.writeBodyStart();
    }

    protected Object writeBodyEnd() throws TransformException {
        BatchOutputWriter writer = this.getBatchOutputWriter();
        return writer.writeBodyEnd();
    }

    protected Object writeStartMessage() throws TransformException {
        BatchOutputWriter writer = this.getBatchOutputWriter();
        return writer.writeStartMessage();
    }

    protected Object writeEndMessage() throws TransformException {
        BatchOutputWriter writer = this.getBatchOutputWriter();
        return writer.writeEndMessage();
    }

    public Object map(NormalizedObject no, TransformContext tcxt) throws TransformException, RemoteException {
        return this.map(no, ExceptionHandler.DRACONIAN_EXCEPTION_HANDLER, tcxt);
    }

    public Object map(NormalizedObject no, ExceptionHandler exceptionHandler, TransformContext tcxt) throws TransformException, RemoteException {
        tcxt.setProperty("output.device", "local");
        Object output = this.prepareOutput(no, exceptionHandler, tcxt);
        OutputMessageDevice device = new OutputMessageDevice(this.createDeviceInfo(tcxt));
        AbstractBatchOutputFormat.writeOutput(output, device);
        return device.getAsBytes();
    }

    private Object prepareOutput(NormalizedObject no, ExceptionHandler exceptionHandler, TransformContext tcxt) throws TransformException, RemoteException {
        Object[] outputs = new Object[7];
        DataObject header = this.createHeader();
        this.mapHeader(no, header, tcxt);
        DataObject recordData = this.createRecordData();
        this.mapData(no, header, recordData, tcxt);
        DataObject trailer = this.createTrailer();
        this.mapTrailer(no, recordData, trailer, tcxt);
        outputs[0] = this.writeStartMessage();
        outputs[1] = this.writeHeader(header, exceptionHandler, tcxt);
        outputs[2] = this.writeBodyStart();
        outputs[3] = this.writeData(recordData, exceptionHandler, tcxt);
        outputs[4] = this.writeBodyEnd();
        outputs[5] = this.writeTrailer(trailer, exceptionHandler, tcxt);
        outputs[6] = this.writeEndMessage();
        return outputs;
    }
}

