/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.AbstractDataObjectBase;
import com.tplus.transform.runtime.DataObjectSection;
import com.tplus.transform.runtime.FieldNotFoundException;
import com.tplus.transform.runtime.TransformNullValueException;

public abstract class AbstractDataObject
extends AbstractDataObjectBase {
    private int[] nonNullFields;

    protected AbstractDataObject() {
    }

    protected AbstractDataObject(DataObjectSection parentSection) {
        super(parentSection);
    }

    public final boolean isNull(int index) {
        this.checkIndex(index);
        return (this.getPMapInt(index) & 1 << index % 32) == 0;
    }

    protected void copyPresenceMap(AbstractDataObjectBase cloned) {
        AbstractDataObject cl = (AbstractDataObject)cloned;
        cl.nonNullFields = (int[])this.nonNullFields.clone();
    }

    public final boolean isNullValue(int index) {
        this.checkIndex(index);
        return (this.getPMapInt(index) & 1 << index % 32) == 0;
    }

    public final boolean isNotNull(int index) {
        this.checkIndex(index);
        return (this.getPMapInt(index) & 1 << index % 32) != 0;
    }

    protected void checkIndex(int index) {
        if (index >= this.getFieldCount()) {
            throw FieldNotFoundException.createFieldNotFoundExceptionFormatted("SRT166", String.valueOf(index));
        }
    }

    protected final void ensureNotNull(int index) throws TransformNullValueException {
        if ((this.getPMapInt(index) & 1 << index % 32) == 0) {
            this.throwNullValueAccessException(index);
        }
    }

    public final void setNull(int index) {
        this.setNullValue(index);
    }

    public final void setNull(int index, boolean bl) {
        if (bl) {
            this.setNull(index);
        } else {
            this.setNotNull(index);
        }
    }

    protected void initPMap(int fldCount) {
        this.nonNullFields = new int[(fldCount + 32 - 1) / 32];
    }

    private int getPMapInt(int index) {
        return this.nonNullFields[index / 32];
    }

    protected final void setNotNullImpl(int index) {
        this.setNotNull(index);
    }

    public final void setNotNull(int index) {
        int n = index / 32;
        this.nonNullFields[n] = this.nonNullFields[n] | 1 << index % 32;
    }

    public final void setNullValue(int index) {
        int n = index / 32;
        this.nonNullFields[n] = this.nonNullFields[n] & ~(1 << index % 32);
    }

    protected void setAllFieldsToNull() {
        for (int i = 0; i < this.nonNullFields.length; ++i) {
            this.nonNullFields[i] = 0;
        }
    }
}

