/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DataObjectBase;
import com.tplus.transform.runtime.DataObjectMetaInfo;
import com.tplus.transform.runtime.DataObjectSection;
import com.tplus.transform.runtime.DesignerType;
import com.tplus.transform.runtime.FieldNotFoundException;
import com.tplus.transform.runtime.FieldNullException;
import com.tplus.transform.runtime.FieldTypeMismatchException;
import com.tplus.transform.runtime.LocationInfo;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.TransformNullValueException;

public abstract class AbstractDataObjectBase
extends DataObjectBase {
    DataObjectSection parentSection;
    private LocationInfo locationInfo;
    protected static final int BITS = 32;
    private static final long serialVersionUID = 1L;

    protected AbstractDataObjectBase() {
        this(null);
    }

    protected AbstractDataObjectBase(DataObjectSection parentSection) {
        this.parentSection = parentSection;
        int fldCount = this.getMetaInfo().getFieldCount();
        this.initPMap(fldCount);
    }

    public String getQualifiedName(int index) throws FieldNotFoundException {
        String name = this.getMetaInfo().getFieldName(index);
        if (this.parentSection != null) {
            name = this.parentSection.getQualifiedName() + "." + name;
        }
        return name;
    }

    public String getMangledName(String fieldName) throws FieldNotFoundException {
        return this.getMetaInfo().getMangledName(fieldName);
    }

    public Object getField(int index) throws FieldNotFoundException {
        if (this.isNull(index)) {
            return null;
        }
        return this.getField0(index);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setField(int index, Object value) throws FieldNotFoundException, FieldTypeMismatchException {
        if (value == null) {
            this.setNull(index);
            try {
                DesignerType fieldDesignerType = this.getFieldDesignerType(index);
                if (fieldDesignerType.getValueClass() != fieldDesignerType.getValueObjectClass()) return;
                this.setField0(index, value);
                return;
            }
            catch (ClassCastException e) {
                FieldTypeMismatchException ftme = FieldTypeMismatchException.createFieldTypeMismatchExceptionFormatted("SRT580A", this.getFieldName(index));
                ftme.setDetail(e);
                throw ftme;
            }
        }
        this.setNotNullImpl(index);
        try {
            this.setField0(index, value);
            return;
        }
        catch (ClassCastException e) {
            FieldTypeMismatchException ftme = FieldTypeMismatchException.createFieldTypeMismatchExceptionFormatted("SRT580A", this.getFieldName(index));
            ftme.setDetail(e);
            throw ftme;
        }
    }

    public void resetToNull() {
        int fldCount = this.getMetaInfo().getFieldCount();
        for (int i = 0; i < fldCount; ++i) {
            try {
                this.setFieldToNull(i);
                continue;
            }
            catch (FieldNotFoundException fieldNotFoundException) {
                // empty catch block
            }
        }
    }

    public void setFieldToNull(int index) throws FieldNotFoundException, FieldTypeMismatchException {
        DesignerType fieldDesignerType = this.getMetaInfo().getFieldDesignerType(index);
        this.setNull(index);
        if (fieldDesignerType.getValueClass() != fieldDesignerType.getValueObjectClass()) {
            return;
        }
        try {
            this.setField0(index, null);
        }
        catch (ClassCastException e) {
            FieldTypeMismatchException ftme = FieldTypeMismatchException.createFieldTypeMismatchExceptionFormatted("SRT580A", this.getFieldName(index));
            ftme.setDetail(e);
            throw ftme;
        }
    }

    protected void throwTypeMismatch(int index) {
        FieldTypeMismatchException ftme = FieldTypeMismatchException.createFieldTypeMismatchExceptionFormatted("SRT580A", this.getFieldName(index));
        throw ftme;
    }

    protected abstract void setNotNullImpl(int var1);

    protected Object getField0(int index) throws FieldNotFoundException {
        throw FieldNotFoundException.createFieldNotFoundExceptionFormatted("SRT166", String.valueOf(index));
    }

    protected void setField0(int index, Object value) throws FieldNotFoundException {
        throw FieldNotFoundException.createFieldNotFoundExceptionFormatted("SRT166", String.valueOf(index));
    }

    protected abstract void initPMap(int var1);

    protected void throwNullValueAccessException(int index) {
        try {
            throw TransformNullValueException.createTransformNullValueExceptionFormatted("SRT500", this.getQualifiedName(index));
        }
        catch (FieldNotFoundException fieldNotFoundException) {
            return;
        }
    }

    protected void throwNotNullCheckFailedException(int index) throws FieldNullException {
        FieldNullException fne = FieldNullException.createFieldNullExceptionFormatted("SRT600", this.getQualifiedName(index));
        fne.setField(this, index, null);
        throw fne;
    }

    public void reset() {
        this.setAllFieldsToNull();
    }

    public DataObjectSection getParentSection() {
        return this.parentSection;
    }

    public void setParentSection(DataObjectSection parentSection) {
        this.parentSection = parentSection;
    }

    public DataObject getRootDataObject() {
        if (this.parentSection != null) {
            return this.parentSection.getRootDataObject();
        }
        return this;
    }

    public boolean isEmpty() {
        int count = this.getFieldCount();
        for (int i = 0; i < count; ++i) {
            if (this.isNull(i)) continue;
            try {
                Object obj = this.getField(i);
                if (!(obj instanceof DataObjectSection ? !((DataObjectSection)obj).isEmpty() : !this.getMetaInfo().isSynthesized(i))) continue;
                return false;
            }
            catch (FieldNotFoundException fieldNotFoundException) {
                // empty catch block
            }
        }
        return true;
    }

    public Object clone() {
        AbstractDataObjectBase cloned = (AbstractDataObjectBase)super.clone();
        this.copyPresenceMap(cloned);
        cloned.parentSection = null;
        AbstractDataObjectBase.cloneFields(this, cloned, false);
        return cloned;
    }

    protected abstract void copyPresenceMap(AbstractDataObjectBase var1);

    public LocationInfo getLocationInfo() {
        this.locationInfo = this.getOrCreateLocationInfo(this.locationInfo);
        return this.locationInfo;
    }

    public abstract DataObjectMetaInfo getMetaInfo();

    public final void assertNotNull(int index) throws TransformException {
        if (this.isNull(index)) {
            this.throwNotNullCheckFailedException(index);
        }
    }
}

