/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DataObjectConverter;
import com.tplus.transform.runtime.DataObjectSection;
import com.tplus.transform.runtime.DataObjectXML;
import com.tplus.transform.runtime.FieldNotFoundException;
import com.tplus.transform.runtime.SectionConstraintException;
import com.tplus.transform.runtime.SectionMetaInfo;
import com.tplus.transform.runtime.SectionMetaInfoImpl;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.collection.AbstractValueList;
import java.util.List;

public abstract class AbstractDataObjectSection
extends AbstractValueList
implements DataObjectSection {
    private transient SectionMetaInfo metaInfo;
    int maxOccurs;
    int minOccurs;
    DataObject parent;
    String sectionName;
    static final long serialVersionUID = 5053794282503561001L;

    public AbstractDataObjectSection(DataObject parent, SectionMetaInfo metaInfo) {
        this(parent, metaInfo.getName(), metaInfo.getMinOccurs(), metaInfo.getMaxOccurs(), metaInfo);
    }

    protected AbstractDataObjectSection(DataObject parent, String sectionName, int minOccurs, int maxOccurs) {
        this(parent, sectionName, minOccurs, maxOccurs, new SectionMetaInfoImpl(null, sectionName, minOccurs, maxOccurs));
    }

    protected AbstractDataObjectSection(DataObject parent, String sectionName, int minOccurs, int maxOccurs, SectionMetaInfo metaInfo) {
        this.parent = parent;
        this.sectionName = sectionName;
        this.minOccurs = minOccurs;
        this.maxOccurs = maxOccurs;
        this.metaInfo = metaInfo;
    }

    public SectionMetaInfo getSectionMetaInfo() {
        DataObject parent;
        if (this.metaInfo == null && (parent = this.getParent()) != null) {
            this.metaInfo = (SectionMetaInfo)parent.getMetaInfo().getFieldMetaInfo(this.sectionName);
        }
        return this.metaInfo;
    }

    public DataObject getParent() {
        return this.parent;
    }

    public void setParent(DataObject parent) {
        this.parent = parent;
    }

    public String getSectionName() {
        return this.sectionName;
    }

    public boolean removeLastElement() throws FieldNotFoundException {
        return this.removeElement(this.getElementCount() - 1);
    }

    public DataObject createElement() {
        if (this.parent != null) {
            if (this.metaInfo == null) {
                this.getSectionMetaInfo();
            }
            if (this.metaInfo == null) {
                return this.parent.createSectionElement(this.sectionName, (DataObjectSection)this);
            }
            return this.parent.createSectionElement(this.metaInfo.getIndex(), (DataObjectSection)this);
        }
        throw FieldNotFoundException.createFieldNotFoundExceptionFormatted("SRT167");
    }

    public String getName() {
        return this.sectionName;
    }

    public String getQualifiedName() {
        DataObjectSection parentSection;
        String name = this.sectionName;
        if (this.parent != null && (parentSection = this.parent.getParentSection()) != null) {
            name = parentSection.getQualifiedName() + "." + name;
        }
        return name;
    }

    public DataObject getRootDataObject() {
        if (this.parent != null) {
            return this.parent.getRootDataObject();
        }
        return null;
    }

    public void assertConstraints() throws SectionConstraintException {
        if (this.getElementCount() < this.minOccurs) {
            if (this.getElementCount() == 0 && this.minOccurs == 1) {
                SectionConstraintException sce = SectionConstraintException.createSectionConstraintExceptionFormatted("SRT300", new Object[]{this.getQualifiedName()});
                sce.setSection(this);
                throw sce;
            }
            SectionConstraintException sce = SectionConstraintException.createSectionConstraintExceptionFormatted("SRT301", new Object[]{this.getQualifiedName(), String.valueOf(this.minOccurs)});
            sce.setSection(this);
            throw sce;
        }
        if (this.maxOccurs != -1 && this.getElementCount() > this.maxOccurs) {
            SectionConstraintException sce = SectionConstraintException.createSectionConstraintExceptionFormatted("SRT302", new Object[]{String.valueOf(this.getElementCount()), this.getQualifiedName(), String.valueOf(this.maxOccurs)});
            sce.setSection(this);
            throw sce;
        }
    }

    public void fromList(List list) throws TransformException {
        DataObjectConverter.fromList(this, list);
    }

    public String toXMLString() {
        return this.toXMLString(1);
    }

    public String toXMLString(int indent) {
        return DataObjectXML.toXMLString(this, indent);
    }

    public boolean isEmpty() {
        if (this.getElementCount() == 0) {
            return true;
        }
        for (int i = 0; i < this.getElementCount(); ++i) {
            try {
                DataObject obj = this.getElement(i);
                if (obj.isEmpty()) continue;
                return false;
            }
            catch (FieldNotFoundException fieldNotFoundException) {
                // empty catch block
            }
        }
        return true;
    }

    public String getID() {
        String parentId;
        DataObject parentObject = this.getParent();
        if (parentObject != null && (parentId = parentObject.getID()).length() > 0) {
            return parentId + "." + this.sectionName;
        }
        return this.sectionName;
    }

    public int getMinOccurs() {
        return this.minOccurs;
    }

    public void setMinOccurs(int minOccurs) {
        this.minOccurs = minOccurs;
    }

    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    public void reset() {
        this.clear();
    }

    public void setMaxOccurs(int maxOccurs) {
        this.maxOccurs = maxOccurs;
    }

    public Object clone() {
        return super.clone();
    }

    public boolean add(Object elm) {
        this.addElement((DataObject)elm);
        return true;
    }

    public DataObject addNewElement() {
        DataObject element = this.createElement();
        this.addElement(element);
        return element;
    }

    public void add(int index, Object element) {
        this.addElement(index, element);
    }

    public Object set(int index, Object element) {
        DataObject object = this.getElement(index);
        this.setElement(index, element);
        return object;
    }

    protected abstract void addElement(int var1, Object var2);

    protected abstract void setElement(int var1, Object var2);

    public Object remove(int index) {
        DataObject element = this.getElement(index);
        this.removeElement(index);
        return element;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractDataObjectSection)) {
            return false;
        }
        AbstractDataObjectSection abstractDataObjectSection = (AbstractDataObjectSection)o;
        if (this.maxOccurs != abstractDataObjectSection.maxOccurs) {
            return false;
        }
        if (this.minOccurs != abstractDataObjectSection.minOccurs) {
            return false;
        }
        return this.sectionName.equals(abstractDataObjectSection.sectionName);
    }

    public int hashCode() {
        int result = this.maxOccurs;
        result = 29 * result + this.minOccurs;
        result = 29 * result + this.sectionName.hashCode();
        return result;
    }

    public Object get(int index) {
        DataObject element = this.getElement(index);
        return element;
    }

    public int size() {
        return this.getElementCount();
    }

    public String toString() {
        return this.toXMLString();
    }

    protected DataObject throwFieldNotFound(int index) {
        throw FieldNotFoundException.createFieldNotFoundExceptionFormatted("SRT162", new Object[]{this.getQualifiedName(), String.valueOf(this.getElementCount()), String.valueOf(index)});
    }
}

