/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.lang.FastStringBuffer;
import com.tplus.transform.runtime.AbstractMessage;
import com.tplus.transform.runtime.AbstractOutputFormat;
import com.tplus.transform.runtime.AbstractRawMessage;
import com.tplus.transform.runtime.AbstractServiceElement;
import com.tplus.transform.runtime.BatchParser;
import com.tplus.transform.runtime.ByteArrayInputSource;
import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DeviceInfo;
import com.tplus.transform.runtime.ExceptionHandler;
import com.tplus.transform.runtime.ExternalMessage;
import com.tplus.transform.runtime.ExternalMessageValidationRules;
import com.tplus.transform.runtime.ExternalObject;
import com.tplus.transform.runtime.InputParser;
import com.tplus.transform.runtime.InputSource;
import com.tplus.transform.runtime.LookupContext;
import com.tplus.transform.runtime.LookupContextFactory;
import com.tplus.transform.runtime.MemoryRawOutputMessage;
import com.tplus.transform.runtime.MessageValidation;
import com.tplus.transform.runtime.MessageXMLSupport;
import com.tplus.transform.runtime.OperationNode;
import com.tplus.transform.runtime.OutputDevice;
import com.tplus.transform.runtime.PhasedParser;
import com.tplus.transform.runtime.PhasedWriter;
import com.tplus.transform.runtime.RawMessage;
import com.tplus.transform.runtime.SimpleOutputWriter;
import com.tplus.transform.runtime.SimpleOutputWriter2;
import com.tplus.transform.runtime.StringInputSource;
import com.tplus.transform.runtime.TransformContext;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.TransformRuntimeException;
import com.tplus.transform.runtime.Validator;
import com.tplus.transform.runtime.io.DataObjectIO;
import com.tplus.transform.runtime.json.MessageJSONSupport;
import com.tplus.transform.util.StringUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.naming.NamingException;

public abstract class AbstractExternalMessage
extends AbstractMessage
implements ExternalMessage {
    public static final String MESSAGE_VALIDATION_SEPARATOR = "__";
    protected InputParser parser;
    protected ExternalMessageValidationRules defaultValidator;
    Map validators = new HashMap();
    protected SimpleOutputWriter writer;
    MessageXMLSupport messageXMLSupport = new MessageXMLSupport(this);
    MessageJSONSupport messageJSONSupport = new MessageJSONSupport(this);

    protected AbstractExternalMessage(String messageName) {
        super(messageName, "External Message");
    }

    protected OperationNode getParserNode() {
        return (OperationNode)((Object)this.parser);
    }

    public void addValidator(String name, ExternalMessageValidationRules validator) {
        this.validators.put(name, validator);
    }

    protected Collection getValidators() {
        return this.validators.values();
    }

    public DataObject createObject() {
        return this.createExternalObject();
    }

    public BatchParser getBatchParser() {
        return (BatchParser)((Object)this.getParserCopy());
    }

    public PhasedParser getPhasedParser() throws RemoteException {
        return (PhasedParser)((Object)this.getParserCopy());
    }

    public PhasedWriter getPhasedWriter() throws RemoteException {
        return (PhasedWriter)((Object)this.getWriterCopy());
    }

    public InputParser getParserCopy() {
        try {
            Class<?> parserClass = this.parser.getClass();
            Constructor<?> constructor = parserClass.getConstructor(AbstractServiceElement.class);
            InputParser newParser = (InputParser)constructor.newInstance(this);
            return newParser;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return this.parser;
    }

    public SimpleOutputWriter getWriterCopy() {
        this.onStartOperation();
        try {
            Class<?> writerClass = this.writer.getClass();
            Constructor<?> constructor = writerClass.getConstructor(AbstractServiceElement.class);
            SimpleOutputWriter newWriter = (SimpleOutputWriter)constructor.newInstance(this);
            return newWriter;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    public abstract ExternalObject createExternalObject();

    public abstract ExternalObject createExternalObject(DataObject var1, DataObject var2, DataObject var3);

    protected DataObject parse(InputSource source, ExceptionHandler handler, TransformContext cxt) throws TransformException {
        ExternalObject obj;
        String messageFormat = (String)cxt.getProperty("message.format");
        if (messageFormat == null) {
            obj = this.parser.parse(source, handler, cxt);
        } else if ("xml".equalsIgnoreCase(messageFormat)) {
            obj = this.createExternalObject();
            this.messageXMLSupport.parse(obj, handler, source, cxt);
        } else if ("json".equalsIgnoreCase(messageFormat)) {
            obj = this.createExternalObject();
            this.messageJSONSupport.parse(obj, handler, source, cxt);
        } else if (this.isVolanteFormat(messageFormat)) {
            obj = this.createExternalObject();
            DataObjectIO.parse(obj, source.getAsBytes());
        } else {
            obj = this.parser.parse(source, handler, cxt);
        }
        return obj;
    }

    public static ExternalObject toExternalObject(DataObject obj) {
        if (obj instanceof ExternalObject) {
            return (ExternalObject)obj;
        }
        if (obj == null) {
            throw TransformRuntimeException.createFormatted("SRT660");
        }
        throw TransformRuntimeException.createFormatted("SRT661", obj.getClass().getName());
    }

    protected void validate(DataObject obj, ExceptionHandler exceptionHandler, TransformContext cxt) throws TransformException {
        ExternalObject externalObject = AbstractExternalMessage.toExternalObject(obj);
        AbstractExternalMessage.executeValidation(this.defaultValidator, externalObject, exceptionHandler, cxt);
    }

    protected void validate(String name, DataObject obj, ExceptionHandler exceptionHandler, TransformContext cxt) throws TransformException {
        ExternalObject externalObject = AbstractExternalMessage.toExternalObject(obj);
        Validator validator = this.getValidatorByName(name);
        AbstractExternalMessage.executeValidation(validator, externalObject, exceptionHandler, cxt);
    }

    public static void executeValidation(Validator validator, ExternalObject externalObject, ExceptionHandler exceptionHandler, TransformContext cxt) throws TransformException {
        try {
            validator.validate(externalObject, exceptionHandler, cxt);
        }
        catch (RemoteException e) {
            throw new TransformException(e.getMessage(), e);
        }
    }

    private Validator getValidatorByName(String name) {
        Validator validator = (Validator)this.validators.get(name);
        if (validator == null) {
            validator = AbstractExternalMessage.lookupValidator(this.getMessageName(), name);
            if (validator != null) {
                this.validators.put(name, validator);
            } else {
                throw new TransformRuntimeException("Validator by name '" + name + "' is not defined for the message '" + this.getMessageName() + "'");
            }
        }
        return validator;
    }

    static Validator lookupValidator(String messageName, String name) {
        try {
            LookupContext lookupContext = LookupContextFactory.getLookupContext();
            MessageValidation abstractValidationRules = lookupContext.lookupValidation(AbstractExternalMessage.getMessageValidationName(messageName, name));
            return abstractValidationRules;
        }
        catch (NamingException e) {
            return null;
        }
    }

    static String getMessageValidationName(String messageName, String ruleName) {
        return messageName + MESSAGE_VALIDATION_SEPARATOR + ruleName;
    }

    public void serialize(DataObject obj, OutputDevice device, TransformContext cxt) throws RemoteException, TransformException {
        RawMessage rawInputMessage = this.serializeMessage(obj, DRACONIAN_EXCEPTION_HANDLER, cxt);
        device.write(rawInputMessage);
        device.close();
    }

    protected RawMessage serializeMessage(DataObject obj, ExceptionHandler exceptionHandler, TransformContext cxt) throws TransformException {
        ExternalObject externalObject = AbstractExternalMessage.toExternalObject(obj);
        String messageFormat = (String)cxt.getProperty("message.format");
        if (messageFormat == null) {
            return this.serializeMessageImpl(externalObject, exceptionHandler, cxt);
        }
        if ("xml".equalsIgnoreCase(messageFormat)) {
            RawMessage rawOutputMessage = this.messageXMLSupport.write(obj, exceptionHandler, cxt);
            return rawOutputMessage;
        }
        if ("json".equalsIgnoreCase(messageFormat)) {
            RawMessage rawOutputMessage = this.messageJSONSupport.write(obj, exceptionHandler, cxt);
            return rawOutputMessage;
        }
        if (this.isVolanteFormat(messageFormat)) {
            return new ByteArrayInputSource(DataObjectIO.serialize(obj));
        }
        return this.serializeMessageImpl(externalObject, exceptionHandler, cxt);
    }

    protected void serializeMessage(DataObject obj, RawMessage rawMessage, ExceptionHandler exceptionHandler, TransformContext cxt) throws TransformException {
        ExternalObject externalObject = AbstractExternalMessage.toExternalObject(obj);
        String messageFormat = (String)cxt.getProperty("message.format");
        if (messageFormat == null) {
            this.serializeMessageImpl(externalObject, rawMessage, exceptionHandler, cxt);
        } else if ("xml".equalsIgnoreCase(messageFormat)) {
            this.messageXMLSupport.write(obj, rawMessage, exceptionHandler, cxt);
        } else if ("json".equalsIgnoreCase(messageFormat)) {
            this.messageJSONSupport.write(obj, rawMessage, exceptionHandler, cxt);
        } else if (this.isVolanteFormat(messageFormat)) {
            rawMessage.append(DataObjectIO.serialize(obj));
        } else {
            this.serializeMessageImpl(externalObject, rawMessage, exceptionHandler, cxt);
        }
    }

    private RawMessage serializeMessageImpl(ExternalObject externalObject, ExceptionHandler exceptionHandler, TransformContext cxt) throws TransformException {
        this.checkWriter();
        this.checkMessageType(externalObject);
        Object output = this.writer.write(externalObject, exceptionHandler, cxt);
        return AbstractExternalMessage.convertOutputToMessage(output, cxt, this.getEncoding(cxt));
    }

    private void serializeMessageImpl(ExternalObject externalObject, RawMessage rawMessage, ExceptionHandler exceptionHandler, TransformContext cxt) throws TransformException {
        this.checkWriter();
        this.checkMessageType(externalObject);
        if (this.writer instanceof SimpleOutputWriter2) {
            SimpleOutputWriter2 simpleOutputWriter2 = (SimpleOutputWriter2)this.writer;
            simpleOutputWriter2.write(externalObject, rawMessage, exceptionHandler, cxt);
        } else {
            Object output = this.writer.write(externalObject, exceptionHandler, cxt);
            AbstractExternalMessage.convertOutputToMessage(output, rawMessage, cxt, this.getEncoding(cxt));
        }
    }

    void checkMessageType(ExternalObject externalObject) throws TransformException {
        String messageName = externalObject.getMessageName();
        if (!this.getMessageName().equals(messageName)) {
            throw TransformException.createFormatted("SRT663", new Object[]{messageName, this.getMessageName()});
        }
    }

    public static void convertOutputToMessage(Object output, RawMessage outputMessage, TransformContext cxt, String encoding) throws TransformException {
        if (StringUtils.isNotEmpty(encoding)) {
            outputMessage.setEncoding(encoding);
        }
        AbstractRawMessage.writeObject(outputMessage, output);
    }

    public static RawMessage convertOutputToMessage(Object output, TransformContext cxt, String encoding) throws TransformException {
        RawMessage toRet;
        if (output instanceof Object[]) {
            MemoryRawOutputMessage memoryRawOutputMessage = new MemoryRawOutputMessage(encoding);
            Object[] messageParts = (Object[])output;
            AbstractExternalMessage.writeParts(messageParts, memoryRawOutputMessage);
            toRet = memoryRawOutputMessage;
        } else {
            if (output instanceof byte[]) {
                toRet = new ByteArrayInputSource((byte[])output);
            } else if (output instanceof String) {
                toRet = new StringInputSource((String)output);
            } else if (output instanceof StringBuffer || output instanceof FastStringBuffer) {
                toRet = new StringInputSource(output.toString());
            } else if (output instanceof char[]) {
                toRet = new StringInputSource(new String((char[])output));
            } else if (output instanceof RawMessage) {
                toRet = (RawMessage)output;
            } else {
                throw TransformException.createFormatted("SRT425", output.getClass().getName());
            }
            if (StringUtils.isNotEmpty(encoding)) {
                toRet.setEncoding(encoding);
            }
        }
        return toRet;
    }

    private static void writeParts(Object[] messageParts, MemoryRawOutputMessage memoryRawOutputMessage) throws TransformException {
        for (int i = 0; i < messageParts.length; ++i) {
            if (messageParts[i] == null) continue;
            Object subPart = messageParts[i];
            if (subPart instanceof Object[]) {
                AbstractExternalMessage.writeParts((Object[])subPart, memoryRawOutputMessage);
                continue;
            }
            memoryRawOutputMessage.write(subPart);
        }
    }

    private void checkWriter() {
        if (this.writer == null) {
            throw TransformRuntimeException.createFormatted("SRT662", this.getMessageName());
        }
    }

    protected DeviceInfo createDeviceInfo(TransformContext tcxt) throws TransformException {
        return AbstractOutputFormat.createDeviceInfo(tcxt, this.getEncoding(tcxt));
    }

    protected final String getEncoding(TransformContext tcxt) {
        String encoding = (String)tcxt.getProperty("encoding");
        if (encoding == null) {
            encoding = this.getDefaultEncoding();
        }
        return encoding;
    }

    protected String getDefaultEncoding() {
        return null;
    }
}

