/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.AbstractServiceElement;
import com.tplus.transform.runtime.BatchContext;
import com.tplus.transform.runtime.BusinessTransaction;
import com.tplus.transform.runtime.ByteArrayInputSource;
import com.tplus.transform.runtime.ExceptionHandler;
import com.tplus.transform.runtime.ExternalMessageValidationRules;
import com.tplus.transform.runtime.ExternalObject;
import com.tplus.transform.runtime.InputFormat;
import com.tplus.transform.runtime.InputMappingRules;
import com.tplus.transform.runtime.InputParser;
import com.tplus.transform.runtime.InputSource;
import com.tplus.transform.runtime.NormalizedObject;
import com.tplus.transform.runtime.TransformContext;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.TransformRuntimeException;
import java.rmi.RemoteException;
import javax.naming.NamingException;

public abstract class AbstractInputFormat
extends AbstractServiceElement
implements InputFormat {
    private BusinessTransaction businessTransaction;
    protected String btLookupName;
    protected boolean batchMode = false;
    protected InputParser parser;
    protected InputMappingRules mappingRules;
    protected ExternalMessageValidationRules validator;

    protected AbstractInputFormat() {
        super("", "");
    }

    public NormalizedObject[] handleInput(InputSource is, TransformContext cxt) throws TransformException {
        ExternalObject[] inputObjects = this.parser.parseBatch(is, cxt);
        return this.handleInput(inputObjects, cxt);
    }

    public NormalizedObject handleInput(ExternalObject externalObject, TransformContext cxt) throws TransformException {
        NormalizedObject nobj = this.createNormalizedObject();
        this.validator.validateData(externalObject.getHeader(), externalObject.getData(), externalObject, ExceptionHandler.DRACONIAN_EXCEPTION_HANDLER, cxt);
        this.mappingRules.mapFields(externalObject, nobj, cxt);
        return nobj;
    }

    protected abstract NormalizedObject createNormalizedObject();

    protected ExternalMessageValidationRules getFieldsValidationRules() {
        return this.validator;
    }

    private void initBusinessTransaction() throws TransformException {
        if (this.businessTransaction == null) {
            try {
                this.businessTransaction = this.getLookupContext().lookupBusinessTransaction(this.btLookupName);
            }
            catch (NamingException e) {
                TransformException ex = TransformException.createFormatted("SRT275", new Object[]{this.btLookupName, e.getMessage()});
                ex.setDetail(e);
                throw ex;
            }
        }
    }

    public void processInput(ExternalObject input, TransformContext tcxt) throws TransformException, RemoteException {
        this.initBusinessTransaction();
        NormalizedObject nobj = this.handleInput(input, tcxt);
        this.businessTransaction.handleNormalizedObject(nobj, tcxt);
    }

    public void processInput(ExternalObject[] input, TransformContext tcxt) throws TransformException, RemoteException {
        TransformException e;
        int i;
        this.initBusinessTransaction();
        TransformException rootException = null;
        TransformException currentException = null;
        NormalizedObject[] nobjects = new NormalizedObject[input.length];
        if (input.length == 1) {
            ExternalObject externalObject = input[0];
            this.getFieldsValidationRules().validateHeader(externalObject.getHeader(), externalObject, ExceptionHandler.DRACONIAN_EXCEPTION_HANDLER, tcxt);
            this.getFieldsValidationRules().validateTrailer(externalObject.getTrailer(), externalObject, ExceptionHandler.DRACONIAN_EXCEPTION_HANDLER, tcxt);
        }
        for (i = 0; i < input.length; ++i) {
            try {
                if (input[i] == null) continue;
                nobjects[i] = this.handleInput(input[i], tcxt);
                continue;
            }
            catch (Exception ex) {
                e = null;
                if (ex instanceof TransformException) {
                    e = (TransformException)ex;
                    if (e.getErrorPhase() == null) {
                        e.setErrorPhase("Input");
                    }
                } else {
                    e = TransformException.createFormatted("SRT625", ex.getMessage());
                    e.setDetail(ex);
                    e.setErrorPhase("Input");
                    if (ex instanceof TransformRuntimeException) {
                        e.setErrorCode(((TransformRuntimeException)ex).getErrorCode());
                        e.setContextProperty("Internal-Code", (String)((TransformRuntimeException)ex).getContextProperty("Internal-Code"));
                    }
                }
                e.setContextProperty("Error-Record", input[i].getData());
                if (rootException == null) {
                    rootException = e;
                } else {
                    currentException.setNextException(e);
                }
                currentException = e;
            }
        }
        for (i = 0; i < nobjects.length; ++i) {
            try {
                if (nobjects[i] == null) continue;
                this.businessTransaction.handleNormalizedObject(nobjects[i], tcxt);
                continue;
            }
            catch (Exception ex) {
                e = null;
                if (ex instanceof TransformException) {
                    e = (TransformException)ex;
                    if (e.getErrorPhase() == null) {
                        e.setErrorPhase("Input");
                    }
                } else {
                    e = TransformException.createFormatted("SRT625", ex.getMessage());
                    e.setDetail(ex);
                    e.setErrorPhase("Input");
                }
                if (rootException == null) {
                    rootException = e;
                } else {
                    currentException.setNextException(e);
                }
                currentException = e;
            }
        }
        if (rootException != null) {
            throw rootException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processInput(Object input, TransformContext tcxt) throws TransformException, RemoteException {
        if (input instanceof ExternalObject[]) {
            this.processInput((ExternalObject[])input, tcxt);
            return;
        }
        this.initBusinessTransaction();
        NormalizedObject[] nobjects = this.handleInput(input, tcxt);
        BatchContext sourceBC = (BatchContext)tcxt.getProperty("input.batch.context");
        boolean startBatch = this.isBatchMode();
        try {
            if (startBatch) {
                try {
                    tcxt.createBatchContext();
                }
                catch (Exception e) {
                    TransformException te = TransformException.createFormatted("SRT277");
                    te.setDetail(e);
                    throw te;
                }
                this.onBatchStart(tcxt);
            }
            for (int i = 0; i < nobjects.length; ++i) {
                this.businessTransaction.handleNormalizedObject(nobjects[i], tcxt);
            }
        }
        finally {
            if (startBatch) {
                this.onBatchEnd(tcxt);
            }
        }
    }

    public NormalizedObject[] handleInput(Object input, TransformContext tcxt) throws TransformException, RemoteException {
        if (input instanceof byte[]) {
            byte[] bytes = (byte[])input;
            ByteArrayInputSource bis = new ByteArrayInputSource(bytes);
            return this.handleInput(bis, tcxt);
        }
        if (input instanceof InputSource) {
            InputSource source = (InputSource)input;
            return this.handleInput(source, tcxt);
        }
        if (input instanceof ExternalObject[]) {
            ExternalObject[] source = (ExternalObject[])input;
            return this.handleInput(source, tcxt);
        }
        throw TransformException.createFormatted("SRT276");
    }

    public NormalizedObject[] handleInput(ExternalObject[] input, TransformContext tcxt) throws TransformException {
        if (input.length == 1) {
            ExternalObject externalObject = input[0];
            this.getFieldsValidationRules().validateHeader(externalObject.getHeader(), externalObject, ExceptionHandler.DRACONIAN_EXCEPTION_HANDLER, tcxt);
            this.getFieldsValidationRules().validateTrailer(externalObject.getTrailer(), externalObject, ExceptionHandler.DRACONIAN_EXCEPTION_HANDLER, tcxt);
        }
        NormalizedObject[] nobjects = new NormalizedObject[input.length];
        for (int i = 0; i < input.length; ++i) {
            nobjects[i] = this.handleInput(input[i], tcxt);
        }
        return nobjects;
    }

    public void onBatchStart(TransformContext tcxt) throws TransformException, RemoteException {
        this.initBusinessTransaction();
        this.businessTransaction.onBatchStart(tcxt);
    }

    public void onBatchEnd(TransformContext tcxt) throws TransformException, RemoteException {
        this.initBusinessTransaction();
        this.businessTransaction.onBatchEnd(tcxt);
    }

    public boolean isBatchMode() {
        return this.batchMode;
    }

    public InputParser getInputParser() {
        return this.parser;
    }
}

