/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.AbstractServiceElement;
import com.tplus.transform.runtime.BatchParser;
import com.tplus.transform.runtime.ByteArrayInputSource;
import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.ExceptionHandler;
import com.tplus.transform.runtime.ExternalObject;
import com.tplus.transform.runtime.ExternalObjectImpl;
import com.tplus.transform.runtime.FieldNotFoundException;
import com.tplus.transform.runtime.FieldParsingException;
import com.tplus.transform.runtime.InputParser;
import com.tplus.transform.runtime.InputSource;
import com.tplus.transform.runtime.MessageHandler;
import com.tplus.transform.runtime.OperationNode;
import com.tplus.transform.runtime.PhasedParser;
import com.tplus.transform.runtime.RawMessage;
import com.tplus.transform.runtime.SectionListener;
import com.tplus.transform.runtime.SectionNameMatcher;
import com.tplus.transform.runtime.SectionWatcher;
import com.tplus.transform.runtime.StreamInputSource;
import com.tplus.transform.runtime.StringInputSource;
import com.tplus.transform.runtime.TransformContext;
import com.tplus.transform.runtime.TransformErrorHandler;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.TransformRuntimeException;
import com.tplus.transform.runtime.log.LogFactory;
import com.tplus.transform.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringBufferInputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.List;

public abstract class AbstractInputParser
extends OperationNode
implements InputParser,
BatchParser,
PhasedParser,
Serializable {
    private transient TransformErrorHandler errorHandler;
    private transient ExceptionHandler exceptionHandler = ExceptionHandler.DRACONIAN_EXCEPTION_HANDLER;
    private TransformContext transformContext;
    SectionWatcher sectionWatcher;
    private DataObject currentObject;
    private int currentFieldIndex;

    protected AbstractInputParser(AbstractServiceElement serviceElement) {
        super(serviceElement);
        if (serviceElement != null) {
            String name = serviceElement.getEntityName();
            this.setLogger(LogFactory.getParserLog(name));
        } else {
            this.setLogger(LogFactory.getRuntimeLog());
        }
    }

    protected ExternalObject createExternalObjectBase(DataObject header, DataObject data, DataObject trailer) {
        return new ExternalObjectImpl(this.getEntityName(), header, data, trailer);
    }

    public abstract ExternalObject createExternalObject(DataObject var1, DataObject var2, DataObject var3);

    public TransformContext getTransformContext() {
        return this.transformContext;
    }

    protected void setup(TransformContext cxt) {
        this.transformContext = cxt;
    }

    protected void teardown(TransformContext cxt) {
        this.transformContext = null;
    }

    public void setErrorHandler(TransformErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public TransformErrorHandler getErrorHandler(TransformErrorHandler errorHandler) {
        return errorHandler;
    }

    public static String getSpecifiedEncoding(TransformContext tcxt) {
        String encoding = (String)tcxt.getProperty("encoding");
        return encoding;
    }

    public static String getSpecifiedEncoding(TransformContext tcxt, String defaultVaue) {
        String encoding = (String)tcxt.getProperty("encoding");
        if (encoding == null) {
            encoding = defaultVaue;
        }
        return encoding;
    }

    public static String getMessageEncoding(InputSource is) {
        return AbstractInputParser.getMessageEncoding(is, RawMessage.PLATFORM_DEFAULT_ENCODING);
    }

    public static String getMessageEncoding(InputSource is, String defaultEncoding) {
        String messageEncoding = null;
        if (is instanceof RawMessage) {
            RawMessage raw = (RawMessage)is;
            messageEncoding = raw.getSpecifiedEncoding();
        }
        if (messageEncoding == null) {
            messageEncoding = defaultEncoding;
        }
        return messageEncoding;
    }

    public static String getPreferredEncoding(InputSource is, TransformContext tcxt, String defaultEncoding) {
        String toRet = AbstractInputParser.getSpecifiedEncoding(tcxt);
        if (toRet == null) {
            toRet = AbstractInputParser.getMessageEncoding(is, null);
        }
        if (toRet == null) {
            toRet = defaultEncoding;
        }
        return toRet;
    }

    public static String getPreferredEncoding(InputSource is, TransformContext tcxt) {
        return AbstractInputParser.getPreferredEncoding(is, tcxt, RawMessage.PLATFORM_DEFAULT_ENCODING);
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    protected void handleError(TransformException e, TransformContext cxt) throws TransformException {
        if (this.errorHandler != null) {
            this.errorHandler.onError(e, cxt);
            return;
        }
        throw e;
    }

    protected abstract ExternalObject doParse(InputSource var1, TransformContext var2) throws TransformException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExternalObject parse(InputSource is, ExceptionHandler exceptionHandler, TransformContext cxt) throws TransformException {
        this.initParser();
        try {
            this.setup(cxt);
            this.exceptionHandler = exceptionHandler;
            ExternalObject externalObject = this.doParse(is, cxt);
            return externalObject;
        }
        finally {
            this.teardown(cxt);
        }
    }

    private void initParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(ExternalObject obj, InputSource is, ExceptionHandler exceptionHandler, TransformContext cxt) throws TransformException {
        this.initParser();
        try {
            this.setup(cxt);
            this.exceptionHandler = exceptionHandler;
            this.doParse(is, cxt);
        }
        finally {
            this.teardown(cxt);
        }
    }

    public final ExternalObject parse(InputStream is, TransformContext cxt) throws TransformException {
        try {
            return this.doParse(new StreamInputSource(is), cxt);
        }
        catch (Exception ex) {
            throw this.updateException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseBatch(InputSource is, MessageHandler messageHandler, ExceptionHandler exceptionHandler, TransformContext tcxt) throws TransformException {
        try {
            this.setup(tcxt);
            this.exceptionHandler = exceptionHandler;
            this.parseBatch0(is, messageHandler, tcxt);
        }
        finally {
            this.teardown(tcxt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseBatch(InputSource is, MessageHandler messageHandler, TransformContext tcxt) throws TransformException {
        try {
            this.setup(tcxt);
            this.exceptionHandler = ExceptionHandler.DRACONIAN_EXCEPTION_HANDLER;
            this.parseBatch0(is, messageHandler, tcxt);
        }
        finally {
            this.teardown(tcxt);
        }
    }

    protected void onSectionStart(DataObject obj) {
        if (this.sectionWatcher != null) {
            ExceptionHandler exceptionHandler = this.getExceptionHandler();
            List exceptions = null;
            if (exceptionHandler instanceof ExceptionHandler.CascadingExceptionHandler) {
                exceptions = ((ExceptionHandler.CascadingExceptionHandler)exceptionHandler).getExceptions();
            }
            this.sectionWatcher.onSectionStart(obj.getMetaInfo().getName(), null, obj, exceptions);
        }
    }

    protected boolean onSectionEnd(DataObject obj) throws TransformException {
        if (this.sectionWatcher != null) {
            ExceptionHandler exceptionHandler = this.getExceptionHandler();
            List exceptions = null;
            if (exceptionHandler instanceof ExceptionHandler.CascadingExceptionHandler) {
                exceptions = ((ExceptionHandler.CascadingExceptionHandler)exceptionHandler).getExceptions();
            }
            return this.sectionWatcher.onSectionEnd(obj.getMetaInfo().getName(), null, obj, exceptions);
        }
        return true;
    }

    public SectionWatcher getSectionWatcher() {
        return this.sectionWatcher;
    }

    public void setSectionWatcher(SectionWatcher sectionWatcher) {
        this.sectionWatcher = sectionWatcher;
    }

    public void parsePhased(InputSource is, MessageHandler messageHandler, ExceptionHandler exceptionHandler, TransformContext tcxt) throws TransformException {
        this.exceptionHandler = exceptionHandler;
        this.parsePhased(is, messageHandler, tcxt);
    }

    public void parsePhased(InputSource is, MessageHandler messageHandler, TransformContext tcxt) throws TransformException {
        this.exceptionHandler = new ExceptionHandler.CascadingExceptionHandler();
        String batchedSections = (String)tcxt.getProperty("batch-sections");
        this.getLogger().debug("Batched section " + batchedSections);
        boolean finishCallback = true;
        this.parsePhased(is, batchedSections, true, messageHandler, tcxt);
    }

    private void parsePhased(InputSource is, String batchedSections, boolean finishCallback, final MessageHandler messageHandler, final TransformContext tcxt) throws TransformException {
        SectionWatcher sectionWatcher = null;
        if (batchedSections != null) {
            String[] names = AbstractInputParser.getBatchSectionNames(batchedSections);
            final SectionWatcher finalSectionWatcher = sectionWatcher = this.createSectionWatcher(Arrays.asList(names));
            sectionWatcher.setSectionListener(new SectionListener(){

                public boolean sectionCompleted(String sectionName, DataObject obj, List exceptions) throws TransformException {
                    ExternalObject externalObject = (ExternalObject)finalSectionWatcher.getMessageObject();
                    return AbstractInputParser.this.callbackHandler("batch-section", sectionName, externalObject, obj, exceptions, messageHandler, tcxt);
                }
            });
        }
        ExternalObject eObj = this.parsePhased(is, sectionWatcher, tcxt);
        if (finishCallback) {
            this.callbackHandler("finished", null, eObj, null, null, messageHandler, tcxt);
        }
    }

    public static String[] getBatchSectionNames(String batchedSections) {
        String[] names = StringUtils.split(batchedSections, ",");
        for (int i = 0; i < names.length; ++i) {
            names[i] = names[i].trim();
        }
        return names;
    }

    private boolean callbackHandler(String callbackType, String sectionName, DataObject messageObject, DataObject batchObj, List exceptions, MessageHandler messageHandler, TransformContext tcxt) throws TransformException {
        TransformException ex = null;
        if (exceptions != null && exceptions.size() > 0) {
            ex = new TransformException(exceptions);
        }
        if (messageObject == null && ex != null) {
            throw ex;
        }
        messageObject.setProperty("cascaded-exceptions", ex);
        messageObject.setProperty("batch-object", batchObj);
        messageObject.setProperty("event-type", callbackType);
        messageObject.setProperty("batch-section", sectionName);
        return messageHandler.handleMessage(messageObject, tcxt);
    }

    protected ExternalObject parsePhased(InputSource is, SectionWatcher sectionWatcher, TransformContext tcxt) throws TransformException {
        return this.parse(is, ExceptionHandler.DRACONIAN_EXCEPTION_HANDLER, tcxt);
    }

    private SectionWatcher createSectionWatcher(List callbackNames) {
        SectionWatcher sectionWatcher = new SectionWatcher();
        if (callbackNames.size() > 0) {
            for (int i = 0; i < callbackNames.size(); ++i) {
                String callbackName = (String)callbackNames.get(i);
                sectionWatcher.addSectionMatcher(new SectionNameMatcher(callbackName));
            }
        }
        return sectionWatcher;
    }

    protected void parseBatch0(InputSource is, MessageHandler messageHandler, TransformContext tcxt) throws TransformException {
        ExternalObject[] records = this.doParseBatch(is, tcxt);
        for (int i = 0; i < records.length; ++i) {
            ExternalObject record = records[i];
            messageHandler.handleMessage(record, tcxt);
        }
    }

    public final ExternalObject[] parseBatch(InputSource is, TransformContext cxt) throws TransformException {
        this.initParser();
        return this.doParseBatch(is, cxt);
    }

    public final ExternalObject[] parseBatch(InputStream is, TransformContext cxt) throws TransformException {
        this.initParser();
        try {
            return this.doParseBatch(new StreamInputSource(is), cxt);
        }
        catch (Exception ex) {
            throw this.updateException(ex);
        }
    }

    protected ExternalObject[] doParseBatch(InputSource is, TransformContext cxt) throws TransformException {
        try {
            ExternalObject obj = this.doParse(is, cxt);
            return new ExternalObject[]{obj};
        }
        catch (Exception ex) {
            throw this.updateException(ex);
        }
    }

    public ExternalObject parse(Object input, TransformContext cxt) throws TransformException {
        if (input instanceof byte[]) {
            return this.parse(new ByteArrayInputSource((byte[])input), cxt);
        }
        if (input instanceof InputStream) {
            return this.parse((InputStream)input, cxt);
        }
        TransformException ex = TransformException.createFormatted("SRT130", input.getClass().getName());
        throw this.updateException(ex);
    }

    public ExternalObject[] parseBatch(Object input, TransformContext cxt) throws TransformException {
        try {
            if (input instanceof byte[]) {
                return this.parseBatch(new ByteArrayInputStream((byte[])input), cxt);
            }
            if (input instanceof String) {
                return this.parseBatch(new StringBufferInputStream((String)input), cxt);
            }
            if (input instanceof InputStream) {
                return this.parseBatch((InputStream)input, cxt);
            }
            TransformException ex = TransformException.createFormatted("SRT130", input.getClass().getName());
            throw ex;
        }
        catch (Exception e) {
            throw this.updateException(e);
        }
    }

    protected void ensureNotNull(String value, DataObject object, int index, TransformContext cxt) throws TransformException {
        if (value == null || value.length() == 0) {
            try {
                String fldName = object.getFieldName(index);
                FieldParsingException e = FieldParsingException.createFieldParsingExceptionFormatted("SRT129", fldName);
                e.setFieldName(fldName);
                e.setErrorType("Required");
                throw e;
            }
            catch (FieldNotFoundException e) {
                throw FieldParsingException.createFormatted("SRT128");
            }
        }
    }

    protected void ensureNotNull(String value, String fldName, TransformContext cxt) throws TransformException {
        if (value == null || value.length() == 0) {
            FieldParsingException e = FieldParsingException.createFieldParsingExceptionFormatted("SRT129", fldName);
            e.setFieldName(fldName);
            e.setErrorType("Required");
            throw e;
        }
    }

    protected void ensureNotNull(String value, DataObject object, int index) throws TransformException {
        if (value == null || value.length() == 0) {
            try {
                String fldName = object.getFieldName(index);
                FieldParsingException e = FieldParsingException.createFieldParsingExceptionFormatted("SRT129", fldName);
                e.setFieldName(fldName);
                e.setErrorType("Required");
                throw e;
            }
            catch (FieldNotFoundException e) {
                throw FieldParsingException.createFieldParsingExceptionFormatted("SRT129");
            }
        }
    }

    protected void ensureNotNull(String value, String fldName) throws TransformException {
        if (value == null || value.length() == 0) {
            FieldParsingException e = FieldParsingException.createFieldParsingExceptionFormatted("SRT129", fldName);
            e.setFieldName(fldName);
            e.setErrorType("Required");
            throw e;
        }
    }

    protected boolean isNull(String value) throws FieldParsingException {
        return value == null || value.length() == 0;
    }

    private TransformException updateException(Exception e) {
        TransformException ex = null;
        if (e instanceof TransformException) {
            ex = (TransformException)e;
            ex.setErrorPhase("Input");
            ex.setErrorType("Parsing");
        } else {
            ex = TransformException.createFormatted("SRT131");
            ex.setDetail(e);
            ex.setErrorPhase("Input");
            ex.setErrorType("Parsing");
        }
        return ex;
    }

    public static Reader createReader(InputSource source, String encoding) throws TransformRuntimeException, TransformException {
        return AbstractInputParser.createReader(source.getAsStream(), encoding);
    }

    public static Reader createReader(InputStream stream, String encoding) throws TransformRuntimeException {
        if (encoding == null) {
            return new InputStreamReader(stream);
        }
        try {
            return new InputStreamReader(stream, encoding);
        }
        catch (UnsupportedEncodingException e) {
            TransformRuntimeException tre = TransformRuntimeException.createFormatted("SRT458");
            tre.setDetail(e);
            throw tre;
        }
    }

    public static String createString(InputSource is, String encoding) throws TransformException {
        if (is instanceof StringInputSource) {
            return (String)((RawMessage)is).getAsObject();
        }
        return AbstractInputParser.createString(is.getAsBytes(), encoding);
    }

    public static String createString(byte[] bytes, String encoding) {
        if (encoding == null) {
            return new String(bytes);
        }
        try {
            return new String(bytes, encoding);
        }
        catch (UnsupportedEncodingException e) {
            TransformRuntimeException tre = TransformRuntimeException.createFormatted("SRT458");
            tre.setDetail(e);
            throw tre;
        }
    }

    public void setCurrentField(DataObject currentObject, int currentFieldIndex) {
        this.currentObject = currentObject;
        this.currentFieldIndex = currentFieldIndex;
        if (this.isTraceEnabled() && currentObject != null && currentFieldIndex != -1 && currentObject.getFieldCount() > currentFieldIndex) {
            this.getLogger().trace("Parsing " + currentObject.getFieldID(currentFieldIndex));
        }
        if (currentObject == null || currentFieldIndex == -1 || currentObject.getFieldCount() > currentFieldIndex) {
            // empty if block
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        if (this.serviceElement != null) {
            this.setLogger(LogFactory.getParserLog(this.serviceElement.getEntityName()));
        } else {
            this.setLogger(LogFactory.getParserLog(""));
        }
        this.exceptionHandler = ExceptionHandler.DRACONIAN_EXCEPTION_HANDLER;
    }
}

