/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.AbstractRawMessage;
import com.tplus.transform.runtime.Binary;
import com.tplus.transform.runtime.ByteArrayInputSource;
import com.tplus.transform.runtime.RawMessage;
import com.tplus.transform.runtime.StandardRuntimeResource;
import com.tplus.transform.runtime.TransformException;
import java.io.IOException;
import java.io.InputStream;

public abstract class AbstractInputSource
extends AbstractRawMessage {
    Binary binary;

    protected AbstractInputSource(Binary binary) {
        this.binary = binary;
    }

    protected AbstractInputSource(byte[] bytes) {
        this.binary = new Binary(bytes);
    }

    protected AbstractInputSource(byte[] bytes, String inputSourceName) {
        this(bytes);
        this.messageName = inputSourceName;
    }

    protected AbstractInputSource(InputStream is) throws IOException {
        this(AbstractInputSource.readStream(is));
    }

    protected AbstractInputSource(InputStream is, String inputSourceName) throws IOException {
        this(AbstractInputSource.readStream(is));
        this.messageName = inputSourceName;
    }

    public InputStream getAsStream() throws TransformException {
        return this.binary.getAsStream();
    }

    public int getByte(long at) throws TransformException {
        try {
            return this.binary.getByte(at);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            IOException srt676 = StandardRuntimeResource.createEOFExceptionFormatted("SRT676", new Object[]{String.valueOf(at), String.valueOf(this.getLength())});
            throw new TransformException(srt676.getMessage(), srt676);
        }
    }

    public int getLength() {
        return this.binary.getLength();
    }

    public Object getAsObject() {
        return this.binary;
    }

    public RawMessage subMessage(long start_index, int num_chars) throws TransformException {
        if (num_chars == -1) {
            num_chars = (int)((long)this.binary.getLength() - start_index);
        }
        Binary subBytes = this.binary.sub((int)start_index, (int)start_index + num_chars);
        return new ByteArrayInputSource(subBytes);
    }

    public static byte[] readStream(InputStream is) throws IOException {
        int read;
        int total = 0;
        int alloc = 2048;
        byte[] bytes = new byte[alloc];
        while ((read = is.read(bytes, total, alloc - total)) != -1) {
            if (alloc - (total += read) != 0) continue;
            byte[] expandedBytes = new byte[alloc *= 2];
            System.arraycopy(bytes, 0, expandedBytes, 0, total);
            bytes = expandedBytes;
        }
        byte[] bytesRead = new byte[total];
        System.arraycopy(bytes, 0, bytesRead, 0, total);
        return bytesRead;
    }

    public static byte[] readStream(InputStream is, int length) throws IOException {
        int read;
        byte[] bytes = new byte[length];
        for (int total = 0; total < length && (read = is.read(bytes, total, length - total)) != -1; total += read) {
        }
        return bytes;
    }

    public void dispose() throws TransformException {
        super.dispose();
        this.binary = null;
    }
}

