/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.AbstractExternalMessage;
import com.tplus.transform.runtime.AbstractMessage;
import com.tplus.transform.runtime.AbstractValidationRules;
import com.tplus.transform.runtime.BatchParser;
import com.tplus.transform.runtime.BusinessProcessingRules;
import com.tplus.transform.runtime.BusinessTransaction;
import com.tplus.transform.runtime.ByteArrayInputSource;
import com.tplus.transform.runtime.CascadedOperation;
import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.ExceptionHandler;
import com.tplus.transform.runtime.InputSource;
import com.tplus.transform.runtime.InternalMessage;
import com.tplus.transform.runtime.InternalMessageValidationRules;
import com.tplus.transform.runtime.LookupContext;
import com.tplus.transform.runtime.LookupContextFactory;
import com.tplus.transform.runtime.MessageValidation;
import com.tplus.transform.runtime.MessageXMLSupport;
import com.tplus.transform.runtime.NormalizedObject;
import com.tplus.transform.runtime.OperationExecutor;
import com.tplus.transform.runtime.OperationNode;
import com.tplus.transform.runtime.OutputDevice;
import com.tplus.transform.runtime.PersistenceManager;
import com.tplus.transform.runtime.PhasedParser;
import com.tplus.transform.runtime.PhasedWriter;
import com.tplus.transform.runtime.RawMessage;
import com.tplus.transform.runtime.Result;
import com.tplus.transform.runtime.TransformContext;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.TransformRuntimeException;
import com.tplus.transform.runtime.TriggerContextFactoryImpl;
import com.tplus.transform.runtime.Triggers;
import com.tplus.transform.runtime.Validator;
import com.tplus.transform.runtime.io.DataObjectIO;
import com.tplus.transform.runtime.json.MessageJSONSupport;
import com.tplus.transform.runtime.vm.EntityInfo;
import com.tplus.transform.runtime.vm.OperationInfo;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.NamingException;

public abstract class AbstractInternalMessage
extends AbstractMessage
implements InternalMessage,
BusinessTransaction {
    private BusinessTransaction businessTransactionObject = this;
    private boolean triggerInitialized;
    private boolean alwaysPersist = false;
    protected InternalMessageValidationRules defaultValidator;
    Map validators = new HashMap();
    Map processingMap = new HashMap();
    MessageXMLSupport messageXMLSupport = new MessageXMLSupport(this);
    MessageJSONSupport messageJSONSupport = new MessageJSONSupport(this);
    public static final String PREPROCESSING_NODE_NAME = "Preprocess";
    public static final String POSTPROCESSING_NODE_NAME = "Postprocess";
    protected String pmLookupName;
    private Triggers triggers;
    private PersistenceManager persistenceManager;
    private OperationInfo processOperationInfo;
    private static final String PROCESS_OPERATION = "process";

    protected AbstractInternalMessage(String messageName) {
        super(messageName, "Internal Message");
    }

    protected OperationNode getParserNode() {
        return this.messageXMLSupport.getParser();
    }

    public void addValidator(String name, AbstractValidationRules validator) {
        this.validators.put(name, validator);
    }

    protected Collection getValidators() {
        return this.validators.values();
    }

    protected Collection getProcessingRules() {
        return this.processingMap.values();
    }

    public void addProcessing(String name, BusinessProcessingRules businessProcessingRules) {
        this.processingMap.put(name, businessProcessingRules);
    }

    private BusinessProcessingRules getBusinessProcessingRules(String name) {
        return (BusinessProcessingRules)this.processingMap.get(name);
    }

    public void setInternalMessageObject(BusinessTransaction businessTransactionObject) {
        this.businessTransactionObject = businessTransactionObject;
    }

    public BatchParser getBatchParser() {
        return null;
    }

    public PhasedParser getPhasedParser() throws RemoteException {
        return null;
    }

    public PhasedWriter getPhasedWriter() throws RemoteException {
        return null;
    }

    public DataObject createObject() throws RemoteException {
        return this.createNormalizedObject();
    }

    public PersistenceManager getPersistenceManager() throws TransformException {
        this.initPersistenceManager();
        return this.persistenceManager;
    }

    protected void setPersistenceManagerName(String pmLookupName) {
        this.pmLookupName = pmLookupName;
    }

    private void initPersistenceManager() throws TransformException {
        if (this.persistenceManager == null && this.pmLookupName != null) {
            try {
                this.persistenceManager = this.getLookupContext().lookupPersistenceManager(this.pmLookupName);
            }
            catch (NamingException e) {
                TransformException te = TransformException.createFormatted("SRT326", this.pmLookupName);
                te.setDetail(e);
                throw te;
            }
        }
    }

    public DataObject parse(InputSource source, ExceptionHandler exceptionHandler, TransformContext cxt) throws TransformException, RemoteException {
        NormalizedObject nObj = this.createNormalizedObject();
        String messageFormat = (String)cxt.getProperty("message.format");
        if (this.isVolanteFormat(messageFormat)) {
            DataObjectIO.parse(nObj, source.getAsBytes());
        } else if ("json".equalsIgnoreCase(messageFormat)) {
            this.messageJSONSupport.parse(nObj, exceptionHandler, source, cxt);
        } else {
            this.messageXMLSupport.parse(nObj, exceptionHandler, source, cxt);
        }
        return nObj;
    }

    public void validate(DataObject obj, ExceptionHandler exceptionHandler, TransformContext cxt) throws TransformException {
        AbstractInternalMessage.executeValidation(this.defaultValidator, obj, exceptionHandler, cxt);
    }

    protected void validate(String name, DataObject obj, ExceptionHandler exceptionHandler, TransformContext cxt) throws TransformException {
        Validator validator = this.getValidatorByName(name);
        AbstractInternalMessage.executeValidation(validator, obj, exceptionHandler, cxt);
    }

    private Validator getValidatorByName(String name) {
        Validator validator = (Validator)this.validators.get(name);
        if (validator == null) {
            validator = AbstractInternalMessage.lookupValidator(this.getMessageName(), name);
            if (validator != null) {
                this.validators.put(name, validator);
            } else {
                throw new TransformRuntimeException("Validator by name '" + name + "' is not defined for the message '" + this.getMessageName() + "'");
            }
        }
        return validator;
    }

    static Validator lookupValidator(String messageName, String name) {
        try {
            LookupContext lookupContext = LookupContextFactory.getLookupContext();
            MessageValidation abstractValidationRules = lookupContext.lookupValidation(AbstractExternalMessage.getMessageValidationName(messageName, name));
            return abstractValidationRules;
        }
        catch (NamingException e) {
            return null;
        }
    }

    public static void executeValidation(Validator validator, DataObject externalObject, ExceptionHandler exceptionHandler, TransformContext cxt) throws TransformException {
        try {
            validator.validate(externalObject, exceptionHandler, cxt);
        }
        catch (RemoteException e) {
            throw new TransformException(e.getMessage(), e);
        }
    }

    public void serialize(DataObject obj, OutputDevice device, TransformContext cxt) throws TransformException, RemoteException {
        String messageFormat = (String)cxt.getProperty("message.format");
        if (this.isVolanteFormat(messageFormat)) {
            device.write(DataObjectIO.serialize(obj));
        } else if ("json".equalsIgnoreCase(messageFormat)) {
            RawMessage rawOutputMessage = this.messageJSONSupport.write(obj, DRACONIAN_EXCEPTION_HANDLER, cxt);
            device.write(rawOutputMessage);
        } else {
            RawMessage rawOutputMessage = this.messageXMLSupport.write(obj, DRACONIAN_EXCEPTION_HANDLER, cxt);
            device.write(rawOutputMessage);
        }
    }

    public RawMessage serializeMessage(DataObject obj, ExceptionHandler exceptionHandler, TransformContext cxt) throws TransformException, RemoteException {
        String messageFormat = (String)cxt.getProperty("message.format");
        if (this.isVolanteFormat(messageFormat)) {
            return new ByteArrayInputSource(DataObjectIO.serialize(obj));
        }
        if ("json".equalsIgnoreCase(messageFormat)) {
            RawMessage rawOutputMessage = this.messageJSONSupport.write(obj, exceptionHandler, cxt);
            return rawOutputMessage;
        }
        RawMessage rawOutputMessage = this.messageXMLSupport.write(obj, exceptionHandler, cxt);
        return rawOutputMessage;
    }

    public void serializeMessage(DataObject obj, RawMessage rawMessage, ExceptionHandler exceptionHandler, TransformContext cxt) throws TransformException, RemoteException {
        String messageFormat = (String)cxt.getProperty("message.format");
        if (this.isVolanteFormat(messageFormat)) {
            rawMessage.append(DataObjectIO.serialize(obj));
        } else if ("json".equalsIgnoreCase(messageFormat)) {
            this.messageJSONSupport.write(obj, rawMessage, exceptionHandler, cxt);
        } else {
            this.messageXMLSupport.write(obj, rawMessage, exceptionHandler, cxt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataObject process(String name, DataObject obj, TransformContext tcxt) throws TransformException {
        this.trace(PROCESS_OPERATION, "", name);
        this.onOperationEnter(this.processOperationInfo, "messageObj", obj, tcxt);
        try {
            DataObject dataObject = this.process(name, obj, DRACONIAN_EXCEPTION_HANDLER, tcxt);
            return dataObject;
        }
        catch (Throwable e) {
            this.handleTransformException(e);
            DataObject dataObject = null;
            return dataObject;
        }
        finally {
            this.onOperationExit(this.processOperationInfo);
        }
    }

    private BusinessProcessingRules getProcessingRuleByName(String name) {
        BusinessProcessingRules validator = (BusinessProcessingRules)this.processingMap.get(name);
        if (validator == null) {
            throw new TransformRuntimeException("Processing Rule by name '" + name + "' is not defined for the message '" + this.getMessageName() + "'");
        }
        return validator;
    }

    private boolean processingRuleExists(String name) {
        BusinessProcessingRules validator = (BusinessProcessingRules)this.processingMap.get(name);
        return validator != null;
    }

    private DataObject process(String name, DataObject obj, ExceptionHandler exceptionHandler, TransformContext cxt) throws TransformException {
        BusinessProcessingRules businessProcessingRules = this.getProcessingRuleByName(name);
        businessProcessingRules.process((NormalizedObject)obj, exceptionHandler, cxt);
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result process2(final String name, final DataObject obj, final TransformContext tcxt) throws TransformException, RemoteException {
        try {
            this.trace(PROCESS_OPERATION, "2", name);
            this.onOperationEnter(this.processOperationInfo, "messageObj", obj, tcxt);
            Result result = OperationExecutor.execute(this, new CascadedOperation(){

                public Object run(ExceptionHandler exceptionHandler) throws TransformException, RemoteException {
                    AbstractInternalMessage.this.process(name, obj, exceptionHandler, tcxt);
                    return obj;
                }
            });
            return result;
        }
        finally {
            this.onOperationExit(this.processOperationInfo);
        }
    }

    public DataObject preprocess(DataObject obj, TransformContext tcxt) throws TransformException {
        if (this.processingRuleExists(PREPROCESSING_NODE_NAME)) {
            return this.process(PREPROCESSING_NODE_NAME, obj, tcxt);
        }
        return obj;
    }

    public Result preprocess2(DataObject obj, TransformContext tcxt) throws TransformException, RemoteException {
        if (this.processingRuleExists(PREPROCESSING_NODE_NAME)) {
            return this.process2(PREPROCESSING_NODE_NAME, obj, tcxt);
        }
        return new Result(obj, new ArrayList());
    }

    public DataObject postprocess(DataObject obj, TransformContext tcxt) throws TransformException {
        if (this.processingRuleExists(POSTPROCESSING_NODE_NAME)) {
            return this.process(POSTPROCESSING_NODE_NAME, obj, DRACONIAN_EXCEPTION_HANDLER, tcxt);
        }
        return obj;
    }

    public Result postprocess2(DataObject obj, TransformContext tcxt) throws TransformException, RemoteException {
        if (this.processingRuleExists(POSTPROCESSING_NODE_NAME)) {
            return this.process2(POSTPROCESSING_NODE_NAME, obj, tcxt);
        }
        return new Result(obj, new ArrayList());
    }

    public NormalizedObject processNormalizedObject(NormalizedObject obj, TransformContext tcxt) throws TransformException, RemoteException {
        return this.processNormalizedObject(obj, DRACONIAN_EXCEPTION_HANDLER, tcxt);
    }

    public Result processNormalizedObject2(final NormalizedObject obj, final TransformContext tcxt) throws TransformException, RemoteException {
        return OperationExecutor.execute(this, new CascadedOperation(){

            public Object run(ExceptionHandler exceptionHandler) throws TransformException {
                AbstractInternalMessage.this.processNormalizedObject(obj, exceptionHandler, tcxt);
                return obj;
            }
        });
    }

    public NormalizedObject processNormalizedObject(NormalizedObject obj, ExceptionHandler exceptionHandler, TransformContext cxt) throws TransformException {
        this.processAll(obj, cxt);
        return obj;
    }

    public void handleNormalizedObject(NormalizedObject obj, TransformContext tcxt) throws TransformException {
        try {
            this.getTriggers();
            this.processAll(obj, tcxt);
            if (this.getPersistenceManager() != null && this.alwaysPersist) {
                try {
                    obj = this.getPersistenceManager().persist(obj);
                }
                catch (RemoteException e) {
                    TransformException te = TransformException.createFormatted("SRT325");
                    te.setDetail(e);
                    throw te;
                }
            }
            if (this.triggers != null) {
                this.triggers.onNewMessage(obj, tcxt);
            }
        }
        catch (TransformRuntimeException re) {
            TransformException e = TransformException.createFormatted("SRT216", re.getMessage());
            e.setErrorPhase("Internal Message");
            e.setContextProperty("Error-Record", obj);
            e.setDetail(re);
            throw e;
        }
        catch (TransformException e) {
            if (e.getErrorPhase() == null) {
                e.setErrorPhase("Internal Message");
            }
            e.setContextProperty("Error-Record", obj);
            throw e;
        }
        catch (Exception re) {
            TransformException e = TransformException.createFormatted("SRT216", re.getMessage());
            e.setErrorPhase("Internal Message");
            e.setContextProperty("Error-Record", obj);
            e.setDetail(re);
            throw e;
        }
    }

    protected Triggers getTriggers() throws TransformException {
        if (this.triggers != null && !this.triggerInitialized) {
            try {
                LookupContext lookupContext = this.getLookupContext();
                this.triggers.setTriggerContextFactory(new TriggerContextFactoryImpl(lookupContext, this.businessTransactionObject));
                this.triggerInitialized = true;
            }
            catch (NamingException e) {
                TransformException ex = TransformException.createFormatted("SRT275", new Object[]{"", e.getMessage()});
                ex.setDetail(e);
                throw ex;
            }
        }
        return this.triggers;
    }

    protected void setTriggers(Triggers triggers) {
        this.triggers = triggers;
    }

    public void onBatchStart(TransformContext cxt) throws TransformException, RemoteException {
        Triggers triggers = this.getTriggers();
        if (triggers != null) {
            triggers.onBatchStart(cxt);
        }
    }

    public void onBatchEnd(TransformContext cxt) throws TransformException, RemoteException {
        Triggers triggers = this.getTriggers();
        if (triggers != null) {
            this.getTriggers().onBatchEnd(cxt);
        }
    }

    public Object invokeTrigger(Properties props) throws TransformException, RemoteException {
        Triggers triggers = this.getTriggers();
        if (triggers != null) {
            return this.getTriggers().invokeTrigger(props);
        }
        return null;
    }

    protected void processAll(NormalizedObject inputObj, TransformContext cxt) throws TransformException {
        if (this.processingRuleExists(PREPROCESSING_NODE_NAME)) {
            this.preprocess(inputObj, cxt);
        }
        if (this.processingRuleExists(POSTPROCESSING_NODE_NAME)) {
            this.postprocess(inputObj, cxt);
        }
        this.validate(inputObj, cxt);
    }

    protected void prepareOperations(EntityInfo entityInfo) {
        super.prepareOperations(entityInfo);
        OperationInfo processOperationInfo = new OperationInfo(entityInfo, PROCESS_OPERATION);
        entityInfo.addOperation(processOperationInfo);
        Collection processingRules = this.getProcessingRules();
        for (BusinessProcessingRules businessProcessingRules : processingRules) {
            List validateLocations = businessProcessingRules.getLocations();
            processOperationInfo.addLocations(validateLocations);
        }
        entityInfo.addOperation(processOperationInfo);
    }

    protected void loadOperations(EntityInfo entityInfo) {
        super.loadOperations(entityInfo);
        this.processOperationInfo = entityInfo.getOperationInfo(PROCESS_OPERATION);
    }
}

