/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.BaseMessage;
import com.tplus.transform.runtime.ByteArrayInputSource;
import com.tplus.transform.runtime.CascadedOperation;
import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DataObjectSection;
import com.tplus.transform.runtime.ExceptionHandler;
import com.tplus.transform.runtime.InputSource;
import com.tplus.transform.runtime.Message;
import com.tplus.transform.runtime.MessageInfo;
import com.tplus.transform.runtime.OperationExecutor;
import com.tplus.transform.runtime.RawMessage;
import com.tplus.transform.runtime.Result;
import com.tplus.transform.runtime.TransformContext;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.log.LogFactory;
import com.tplus.transform.runtime.metrics.MetricItem;
import com.tplus.transform.runtime.metrics.MetricType;
import com.tplus.transform.util.IOUtil;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;

public abstract class AbstractMessage
extends BaseMessage
implements Message {
    protected static final ExceptionHandler DRACONIAN_EXCEPTION_HANDLER = ExceptionHandler.DRACONIAN_EXCEPTION_HANDLER;
    private String messageName;
    private String type;
    MessageInfo messageInfo;
    public static final MetricItem PARSE_METRIC_ITEM = new MetricItem("parse", MetricType.ACTIVITY);
    public static final MetricItem SERIALIZE_METRIC_ITEM = new MetricItem("serialize", MetricType.ACTIVITY);

    protected AbstractMessage(String messageName, String type) {
        super(messageName, type);
        this.messageName = messageName;
        this.type = type;
        this.setLogger(LogFactory.getMessageLog(this, messageName));
    }

    protected void setMessageInfo(MessageInfo messageInfo) {
        this.messageInfo = messageInfo;
    }

    public MessageInfo getMessageInfo() {
        return this.messageInfo;
    }

    public String getMessageName() {
        return this.messageName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final DataObject parse(InputSource source, TransformContext cxt) throws TransformException {
        this.onStartOperation();
        this.trace("parse");
        this.onOperationEnter(this.parseOperationInfo, "input", source, "messageObj", null, cxt);
        try {
            DataObject dataObject = this.parse(source, DRACONIAN_EXCEPTION_HANDLER, cxt);
            return dataObject;
        }
        catch (Throwable e) {
            this.handleTransformException(e);
            DataObject dataObject = null;
            return dataObject;
        }
        finally {
            this.onOperationExit(this.parseOperationInfo);
            AbstractMessage.onParse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final DataObject parse(byte[] source, TransformContext cxt) throws TransformException {
        this.onStartOperation();
        this.trace("parse");
        this.onOperationEnter(this.parseOperationInfo, "input", source, "messageObj", null, cxt);
        try {
            DataObject dataObject = this.parse(new ByteArrayInputSource(source), DRACONIAN_EXCEPTION_HANDLER, cxt);
            return dataObject;
        }
        catch (Throwable e) {
            this.handleTransformException(e);
            DataObject dataObject = null;
            return dataObject;
        }
        finally {
            this.onOperationExit(this.parseOperationInfo);
            AbstractMessage.onParse();
        }
    }

    public static void onParse() {
        PARSE_METRIC_ITEM.notifyMetricEvent();
    }

    public static void onSerialize() {
        SERIALIZE_METRIC_ITEM.notifyMetricEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void validate(DataObject obj, TransformContext cxt) throws TransformException {
        this.onStartOperation();
        this.trace("validate");
        this.onOperationEnter(this.validateOperationInfo, "messageObj", obj, cxt);
        try {
            this.validate(obj, DRACONIAN_EXCEPTION_HANDLER, cxt);
        }
        catch (Throwable e) {
            this.handleTransformException(e);
        }
        finally {
            this.onOperationExit(this.validateOperationInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void validate(String name, DataObject obj, TransformContext cxt) throws TransformException {
        this.onStartOperation();
        this.trace("validate", "", name);
        this.onOperationEnter(this.validateOperationInfo, "messageObj", obj, cxt);
        try {
            this.validate(name, obj, DRACONIAN_EXCEPTION_HANDLER, cxt);
        }
        catch (Throwable e) {
            this.handleTransformException(e);
        }
        finally {
            this.onOperationExit(this.validateOperationInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final byte[] serialize(DataObject obj, TransformContext cxt) throws TransformException {
        this.onStartOperation();
        this.trace("serialize");
        this.onOperationEnter(this.serializeOperationInfo, "messageObj", obj, cxt);
        try {
            byte[] byArray = this.serialize(obj, DRACONIAN_EXCEPTION_HANDLER, cxt);
            return byArray;
        }
        catch (Throwable e) {
            this.handleTransformException(e);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            this.onOperationExit(this.serializeOperationInfo);
            AbstractMessage.onSerialize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RawMessage serializeMessage(DataObject obj, TransformContext cxt) throws TransformException {
        this.onStartOperation();
        this.trace("serialize");
        this.onOperationEnter(this.serializeOperationInfo, "messageObj", obj, cxt);
        try {
            RawMessage rawMessage = this.serializeMessage(obj, DRACONIAN_EXCEPTION_HANDLER, cxt);
            return rawMessage;
        }
        catch (Throwable e) {
            this.handleTransformException(e);
            RawMessage rawMessage = null;
            return rawMessage;
        }
        finally {
            this.onOperationExit(this.serializeOperationInfo);
            AbstractMessage.onSerialize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serializeMessage(DataObject obj, RawMessage output, TransformContext cxt) throws TransformException, RemoteException {
        this.onStartOperation();
        this.trace("serialize");
        this.onOperationEnter(this.serializeOperationInfo, "messageObj", obj, cxt);
        try {
            this.serializeMessage(obj, output, DRACONIAN_EXCEPTION_HANDLER, cxt);
        }
        catch (Throwable e) {
            this.handleTransformException(e);
        }
        finally {
            this.onOperationExit(this.serializeOperationInfo);
            AbstractMessage.onSerialize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Result parse2(byte[] source, TransformContext cxt) throws RemoteException {
        this.onStartOperation();
        this.trace("parse", "2");
        this.onOperationEnter(this.parseOperationInfo, "input", source, "messageObj", null, cxt);
        try {
            Result result = OperationExecutor.execute(this, new ParseOperation(source, cxt));
            return result;
        }
        finally {
            this.onOperationExit(this.parseOperationInfo);
            AbstractMessage.onParse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Result parse2(final InputSource source, final TransformContext cxt) throws RemoteException {
        this.onStartOperation();
        this.trace("parse", "2");
        this.onOperationEnter(this.parseOperationInfo, "input", source, "messageObj", null, cxt);
        try {
            Result result = OperationExecutor.execute(this, new CascadedOperation(){

                public Object run(ExceptionHandler exceptionHandler) throws TransformException, RemoteException {
                    return AbstractMessage.this.parse(source, exceptionHandler, cxt);
                }
            });
            return result;
        }
        finally {
            this.onOperationExit(this.parseOperationInfo);
            AbstractMessage.onParse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Result validate2(final DataObject obj, final TransformContext cxt) throws RemoteException {
        this.onStartOperation();
        this.trace("validate", "2");
        this.onOperationEnter(this.validateOperationInfo, "messageObj", obj, cxt);
        try {
            Result result = OperationExecutor.execute(this, new CascadedOperation(){

                public Object run(ExceptionHandler exceptionHandler) throws TransformException, RemoteException {
                    AbstractMessage.this.validate(obj, exceptionHandler, cxt);
                    return null;
                }
            });
            return result;
        }
        finally {
            this.onOperationExit(this.validateOperationInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Result validate2(final String name, final DataObject obj, final TransformContext cxt) throws RemoteException {
        this.onStartOperation();
        this.trace("validate", "2", name);
        this.onOperationEnter(this.validateOperationInfo, "messageObj", obj, cxt);
        try {
            Result result = OperationExecutor.execute(this, new CascadedOperation(){

                public Object run(ExceptionHandler exceptionHandler) throws TransformException, RemoteException {
                    AbstractMessage.this.validate(name, obj, exceptionHandler, cxt);
                    return null;
                }
            });
            return result;
        }
        finally {
            this.onOperationExit(this.validateOperationInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Result serialize2(final DataObject obj, final TransformContext cxt) throws RemoteException {
        this.onStartOperation();
        this.trace("serialize", "2");
        this.onOperationEnter(this.serializeOperationInfo, "messageObj", obj, cxt);
        try {
            Result result = OperationExecutor.execute(this, new CascadedOperation(){

                public Object run(ExceptionHandler exceptionHandler) throws TransformException, RemoteException {
                    return AbstractMessage.this.serialize(obj, exceptionHandler, cxt);
                }
            });
            return result;
        }
        finally {
            this.onOperationExit(this.serializeOperationInfo);
            AbstractMessage.onSerialize();
        }
    }

    protected abstract DataObject parse(InputSource var1, ExceptionHandler var2, TransformContext var3) throws TransformException, RemoteException;

    protected abstract void validate(DataObject var1, ExceptionHandler var2, TransformContext var3) throws TransformException, RemoteException;

    protected abstract void validate(String var1, DataObject var2, ExceptionHandler var3, TransformContext var4) throws TransformException, RemoteException;

    protected byte[] serialize(DataObject obj, ExceptionHandler exceptionHandler, TransformContext cxt) throws RemoteException, TransformException {
        return this.serializeMessage(obj, exceptionHandler, cxt).getAsBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result serializeMessage2(final DataObject obj, final TransformContext cxt) throws RemoteException {
        this.onStartOperation();
        this.trace("serialize", "2");
        this.onOperationEnter(this.serializeOperationInfo, "messageObj", obj, cxt);
        try {
            Result result = OperationExecutor.execute(this, new CascadedOperation(){

                public Object run(ExceptionHandler exceptionHandler) throws TransformException, RemoteException {
                    return AbstractMessage.this.serializeMessage(obj, exceptionHandler, cxt);
                }
            });
            return result;
        }
        finally {
            this.onOperationExit(this.serializeOperationInfo);
            AbstractMessage.onSerialize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result serializeMessage2(final DataObject obj, final RawMessage output, final TransformContext cxt) throws RemoteException {
        this.onStartOperation();
        this.trace("serialize", "2");
        this.onOperationEnter(this.serializeOperationInfo, "messageObj", obj, cxt);
        try {
            Result result = OperationExecutor.execute(this, new CascadedOperation(){

                public Object run(ExceptionHandler exceptionHandler) throws TransformException, RemoteException {
                    AbstractMessage.this.serializeMessage(obj, output, exceptionHandler, cxt);
                    return null;
                }
            });
            return result;
        }
        finally {
            this.onOperationExit(this.serializeOperationInfo);
            AbstractMessage.onSerialize();
        }
    }

    public byte[] getResource(String name) throws TransformException, RemoteException {
        return AbstractMessage.getResource(this.getClass(), name);
    }

    public static byte[] getResource(Class cls, String name) throws TransformException, RemoteException {
        InputStream asStream = cls.getResourceAsStream(name);
        if (asStream != null) {
            try {
                return IOUtil.readStream(asStream);
            }
            catch (IOException e) {
                throw new TransformException("Error reading resource " + name, e);
            }
        }
        throw new TransformException("No resource by name " + name);
    }

    protected abstract RawMessage serializeMessage(DataObject var1, ExceptionHandler var2, TransformContext var3) throws TransformException, RemoteException;

    protected abstract void serializeMessage(DataObject var1, RawMessage var2, ExceptionHandler var3, TransformContext var4) throws TransformException, RemoteException;

    protected boolean isVolanteFormat(String messageFormat) {
        return "volante".equalsIgnoreCase(messageFormat);
    }

    protected static void addMessageInfoAttribute(MessageInfo messageInfo, String name, String value) {
        DataObjectSection attributes = messageInfo.getAttributes();
        MessageInfo.Attributes element = (MessageInfo.Attributes)attributes.createElement();
        element.setName(name);
        element.setValue(value);
        attributes.addElement(element);
    }

    private class ParseOperation
    implements CascadedOperation {
        private final byte[] source;
        private final TransformContext cxt;

        public ParseOperation(byte[] source, TransformContext cxt) {
            this.source = source;
            this.cxt = cxt;
        }

        public Object run(ExceptionHandler exceptionHandler) throws TransformException, RemoteException {
            return AbstractMessage.this.parse(new ByteArrayInputSource(this.source), exceptionHandler, this.cxt);
        }
    }
}

