/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.AbstractMessageMapping;
import com.tplus.transform.runtime.AbstractNormalizedObject;
import com.tplus.transform.runtime.AbstractServiceElement;
import com.tplus.transform.runtime.BatchMessage;
import com.tplus.transform.runtime.BatchWriter;
import com.tplus.transform.runtime.Callable;
import com.tplus.transform.runtime.CustomExternalClassSupport;
import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DataObjectMetaInfo;
import com.tplus.transform.runtime.DesignerType;
import com.tplus.transform.runtime.DeviceInfo;
import com.tplus.transform.runtime.DisposableCache;
import com.tplus.transform.runtime.ExceptionHandler;
import com.tplus.transform.runtime.ExternalMessage;
import com.tplus.transform.runtime.ExternalObject;
import com.tplus.transform.runtime.FieldMetaInfo;
import com.tplus.transform.runtime.IDisposable;
import com.tplus.transform.runtime.InputSource;
import com.tplus.transform.runtime.InternalMessage;
import com.tplus.transform.runtime.InvocationObject;
import com.tplus.transform.runtime.LifeCycle;
import com.tplus.transform.runtime.LookupCache;
import com.tplus.transform.runtime.Message;
import com.tplus.transform.runtime.MessageFlow;
import com.tplus.transform.runtime.MessageMapping;
import com.tplus.transform.runtime.NormalizedObject;
import com.tplus.transform.runtime.OperationNode;
import com.tplus.transform.runtime.OutputDevice;
import com.tplus.transform.runtime.OutputPortDef;
import com.tplus.transform.runtime.OutputProtocol;
import com.tplus.transform.runtime.PersistenceManager;
import com.tplus.transform.runtime.PhasedWriter;
import com.tplus.transform.runtime.RawMessage;
import com.tplus.transform.runtime.Result;
import com.tplus.transform.runtime.SimpleGenericDataObject;
import com.tplus.transform.runtime.TransformContext;
import com.tplus.transform.runtime.TransformContextImpl;
import com.tplus.transform.runtime.TransformContextWrapper;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.TransformNullValueException;
import com.tplus.transform.runtime.TransformRuntimeException;
import com.tplus.transform.runtime.WeakClassLocal;
import com.tplus.transform.runtime.io.DeviceOutputMessage;
import com.tplus.transform.runtime.log.LogFactory;
import com.tplus.transform.runtime.metrics.MetricItem;
import com.tplus.transform.runtime.metrics.MetricType;
import com.tplus.transform.runtime.vm.EntityInfo;
import com.tplus.transform.runtime.vm.LocationManager;
import com.tplus.transform.runtime.vm.OperationInfo;
import com.tplus.transform.util.log.Log;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;

public abstract class AbstractMessageFlow
extends AbstractServiceElement
implements MessageFlow,
LifeCycle {
    public static final MetricItem FLOW_METRIC_ITEM = new MetricItem("Flow", MetricType.FLOW);
    public static final String SCOPE_PROPERTY = "scope";
    public static final String IN_SCOPE = "IN";
    public static final String OUT_SCOPE = "OUT";
    public static final String IN_OUT_SCOPE = "IN/OUT";
    public static final String LOCAL_SCOPE = "LOCAL";
    public static final String CACHED_SCOPE = "CACHED";
    public static final String STATEFUL_SCOPE = "STATEFUL";
    private static final String RUN_OPERATION = "run";
    private static final String ACTIVITY_STATEMENT = "activity";
    private static final String TOPLEVEL_FLOW_PROPERTY = "volante.toplevelflow";
    private LookupCache lookupCache;
    Map batchedData = new HashMap();
    protected final DisposableCache $disposableCache = new DisposableCache();
    protected List outputPorts = new ArrayList();
    ExceptionHandler exceptionHandler = ExceptionHandler.DRACONIAN_EXCEPTION_HANDLER;
    private String messageFlowName;
    TransformContext transformContext;
    private String currentActivityName;
    private String currentActivityLabel;
    boolean poolActivities = false;
    private boolean exceptionalExit;
    MessageFlowStateManager messageFlowStateManager = new MessageFlowStateManager();
    protected CustomExternalClassSupport customExternalClassSupport;
    private LocationManager instanceLocationManager;
    OperationInfo runOperationInfo;
    MessageFlow thisObject = this;
    static WeakClassLocal staticEntityInfo = new WeakClassLocal();

    protected AbstractMessageFlow(String messageFlowName) {
        super(messageFlowName, "Message Flow");
        this.messageFlowName = messageFlowName;
        this.setLogger(this.createLog());
        this.instanceLocationManager = this.getLocationManager();
        this.prepareEntityInfo();
    }

    protected MessageFlow getMessageFlow() {
        return this.thisObject;
    }

    public void setThisObject(MessageFlow thisObject) {
        this.thisObject = thisObject;
    }

    protected LocationManager getLocationManager() {
        return LocationManager.EMPTY;
    }

    protected void addOutputPort(String name, String protocol, String outputDevice) {
        this.outputPorts.add(new OutputPortDef(name, protocol, outputDevice));
    }

    public List getOutputPorts() {
        return Collections.unmodifiableList(this.outputPorts);
    }

    public void init() throws TransformException {
        try {
            this.getLookupContext();
            this.messageFlowStateManager.computeVariableScopes(this.getVariables());
            this.onFlow();
        }
        catch (NamingException e) {
            throw TransformException.createFormatted("SRT626");
        }
    }

    private void onFlow() {
        Object isTopLevelFlow = this.transformContext.getProperty(TOPLEVEL_FLOW_PROPERTY);
        if (isTopLevelFlow == null) {
            this.transformContext.setProperty(TOPLEVEL_FLOW_PROPERTY, "true");
            FLOW_METRIC_ITEM.notifyMetricEvent();
        }
    }

    private void onStartMessageFlow(TransformContext transformContext, ExceptionHandler exceptionHandler) {
        this.currentActivityLabel = null;
        this.currentActivityName = null;
        this.exceptionalExit = false;
        this.onStartOperation();
        if (this.isTraceEnabled()) {
            this.trace("Message Flow " + this.messageFlowName + " started");
        }
        if (transformContext == null) {
            transformContext = new TransformContextImpl();
        }
        this.setup(transformContext);
        this.setExceptionHandler(exceptionHandler);
        this.onOperationEnter(this.runOperationInfo, "Compound", this.getVariables(), transformContext);
    }

    private void onEndMessageFlow(boolean exceptionOccurred) {
        this.finishActivity();
        this.transformContext.setProperty(TOPLEVEL_FLOW_PROPERTY, null);
        this.teardown();
        this.setExceptionHandler(ExceptionHandler.DRACONIAN_EXCEPTION_HANDLER);
        if (this.isTraceEnabled()) {
            this.trace("Message Flow " + this.messageFlowName + " completed" + (exceptionOccurred ? " with exception" : ""));
        }
        this.onOperationExit(this.runOperationInfo);
    }

    protected abstract Object[] run0(Object[] var1, TransformContext var2) throws TransformException, RemoteException;

    protected abstract DataObject run0(DataObject var1, TransformContext var2) throws TransformException, RemoteException;

    protected abstract DataObject getVariables();

    public Object call(Callable callable) throws RemoteException, Exception {
        return callable.call();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object[] run(Object[] processArgs, TransformContext cxt) throws TransformException, RemoteException {
        boolean exceptionOccurred = false;
        this.onStartMessageFlow(cxt, ExceptionHandler.DRACONIAN_EXCEPTION_HANDLER);
        try {
            Object[] objectArray = this.run0(processArgs, cxt);
            return objectArray;
        }
        catch (TransformException e) {
            exceptionOccurred = true;
            this.addTraceToException(e);
            throw e;
        }
        catch (TransformRuntimeException e) {
            exceptionOccurred = true;
            this.addTraceToException(e);
            throw e;
        }
        catch (Throwable e) {
            exceptionOccurred = true;
            this.handleTransformException(e);
            Object[] objectArray = null;
            return objectArray;
        }
        finally {
            this.onEndMessageFlow(exceptionOccurred);
        }
    }

    public final Object[] run(InputSource input, TransformContext cxt) throws TransformException, RemoteException {
        return this.run(new Object[]{input}, cxt);
    }

    public final Result run2(Object[] processArgs, TransformContext cxt) throws RemoteException {
        boolean exceptionOccurred = false;
        ExceptionHandler.CascadingExceptionHandler cascadingExceptionHandler = new ExceptionHandler.CascadingExceptionHandler();
        this.onStartMessageFlow(cxt, cascadingExceptionHandler);
        try {
            Object[] output = this.run0(processArgs, cxt);
            Result result = new Result(output, this.updateExceptionTrace(cascadingExceptionHandler.getExceptions()));
            return result;
        }
        catch (TransformException e) {
            exceptionOccurred = true;
            ArrayList allExceptions = new ArrayList(cascadingExceptionHandler.getExceptions());
            allExceptions.addAll(e.getExceptionsAsList());
            Result result = new Result(null, this.updateExceptionTrace(allExceptions));
            return result;
        }
        catch (TransformRuntimeException e) {
            exceptionOccurred = true;
            this.addTraceToException(e);
            throw e;
        }
        catch (Throwable e) {
            exceptionOccurred = true;
            TransformRuntimeException tre = TransformRuntimeException.createFormatted("SRT625", e.getMessage());
            tre.setDetail(e);
            throw tre;
        }
        finally {
            this.onEndMessageFlow(exceptionOccurred);
        }
    }

    protected TransformContext getTransformContext() {
        return this.transformContext;
    }

    protected void setup(TransformContext cxt) {
        this.transformContext = cxt;
        this.messageFlowStateManager.loadState(cxt);
    }

    protected void teardown() {
        this.messageFlowStateManager.saveState(this.transformContext);
        this.transformContext = null;
        this.$disposableCache.disposeAll();
        this.clearVariables();
        this.batchedData.clear();
    }

    protected void addToCache(IDisposable disposable) {
        this.$disposableCache.add(disposable);
    }

    public String getActiveElementName() {
        return this.getActivityTraceName(this.currentActivityName, this.currentActivityLabel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final DataObject run(DataObject processArgs, TransformContext cxt) throws TransformException, RemoteException {
        boolean exceptionOccurred = false;
        this.onStartMessageFlow(cxt, ExceptionHandler.DRACONIAN_EXCEPTION_HANDLER);
        try {
            DataObject dataObject = this.run0(processArgs, cxt);
            return dataObject;
        }
        catch (Throwable e) {
            exceptionOccurred = true;
            this.handleTransformException(e);
            DataObject dataObject = null;
            return dataObject;
        }
        finally {
            this.onEndMessageFlow(exceptionOccurred);
        }
    }

    public final Result run2(DataObject input, TransformContext cxt) throws RemoteException {
        boolean exceptionOccurred = false;
        ExceptionHandler.CascadingExceptionHandler cascadingExceptionHandler = new ExceptionHandler.CascadingExceptionHandler();
        this.onStartMessageFlow(cxt, cascadingExceptionHandler);
        try {
            DataObject output = this.run0(input, cxt);
            Result result = new Result(output, this.updateExceptionTrace(cascadingExceptionHandler.getExceptions()));
            return result;
        }
        catch (TransformException e) {
            exceptionOccurred = true;
            this.addTraceToException(e);
            Result result = new Result(null, this.updateExceptionTrace(e.getExceptionsAsList()));
            return result;
        }
        catch (TransformRuntimeException e) {
            exceptionOccurred = true;
            this.addTraceToException(e);
            throw e;
        }
        catch (Throwable e) {
            exceptionOccurred = true;
            TransformRuntimeException tre = TransformRuntimeException.createFormatted("SRT625", e.getMessage());
            tre.setDetail(e);
            throw tre;
        }
        finally {
            this.onEndMessageFlow(exceptionOccurred);
        }
    }

    protected void ensureVariableNotNull(int index) throws TransformException {
        DataObject variables = this.getVariables();
        if (variables.isNull(index)) {
            throw TransformNullValueException.createTransformNullValueExceptionFormatted("SRT500", variables.getQualifiedName(index));
        }
    }

    protected void ensureInputVariableNotNull(int index) throws TransformException {
        DataObject variables = this.getVariables();
        if (variables.isNull(index)) {
            throw TransformNullValueException.createTransformNullValueExceptionFormatted("SRT502", new Object[]{variables.getQualifiedName(index), this.messageFlowName});
        }
    }

    protected void ensureOutputVariableNotNull(int index) throws TransformException {
        DataObject variables;
        if (!this.exceptionalExit && (variables = this.getVariables()).isNull(index)) {
            throw TransformNullValueException.createTransformNullValueExceptionFormatted("SRT503", new Object[]{variables.getQualifiedName(index), this.messageFlowName});
        }
    }

    protected void handleExceptionResult(Result result) throws TransformException {
        if (result.hasException()) {
            List list = result.getExceptions();
            this.handleExceptionList(list);
        }
    }

    private void handleExceptionList(List list) throws TransformException {
        Object thrownEx;
        if (list.size() == 1 && (thrownEx = list.get(0)) instanceof TransformException) {
            throw (TransformException)thrownEx;
        }
        throw new TransformException(list);
    }

    protected void handleException(Exception e) throws TransformException, RemoteException {
        this.exceptionalExit = true;
        if (!(e instanceof TransformException)) {
            if (e instanceof NamingException) {
                TransformRuntimeException tre = TransformRuntimeException.createFormatted("SRT111", e.getMessage());
                tre.setDetail(e);
                throw tre;
            }
            if (e instanceof TransformRuntimeException) {
                throw (TransformRuntimeException)e;
            }
            TransformRuntimeException tre = TransformRuntimeException.createFormatted("SRT625", e.getMessage());
            tre.setDetail(e);
            throw tre;
        }
        this.onException((TransformException)e);
    }

    private void onException(TransformException e) throws TransformException {
        this.getExceptionHandler().onException(e);
    }

    public static TransformException toTransformException(Exception e) {
        if (e instanceof TransformRuntimeException) {
            TransformRuntimeException transformRuntimeException = (TransformRuntimeException)e;
            TransformException te = new TransformException(transformRuntimeException.getMessage(), e);
            te.setType("TransformRuntimeException");
            String code = transformRuntimeException.getErrorCode();
            if (code != null) {
                te.setErrorCode(code);
            }
            te.setSeverity("fatal");
            return te;
        }
        TransformException te = new TransformException(e.getMessage(), e);
        te.setType("TransformRuntimeException");
        te.setSeverity("fatal");
        return te;
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public Message lookupMessage(String name) throws NamingException {
        return this.getLookupCache().lookupMessage(name);
    }

    public Object createServiceObject(String name, String className) throws NamingException, RemoteException {
        return this.getLookupCache().createServiceObject(name, className);
    }

    public ExternalMessage lookupExternalMessage(String name) throws NamingException {
        return this.getLookupCache().lookupExternalMessage(name);
    }

    public BatchMessage lookupBatchMessage(String name) throws NamingException {
        return this.getLookupCache().lookupBatchMessage(name);
    }

    public InternalMessage lookupInternalMessage(String name) throws NamingException {
        return this.getLookupCache().lookupInternalMessage(name);
    }

    public Object lookupReport(String name) throws NamingException {
        return this.getLookupCache().lookupInternalMessage(name);
    }

    public MessageMapping lookupMessageMapping(String name) throws NamingException {
        return this.getLookupCache().lookupMessageMapping(name);
    }

    public MessageFlow lookupMessageFlow(String name) throws NamingException {
        return this.getLookupCache().lookupMessageFlow(name);
    }

    public PersistenceManager lookupPersistenceManager(String name) throws NamingException {
        return this.getLookupCache().lookupPersistenceManager(name);
    }

    public OutputProtocol lookupOutputProtocol(String name, TransformContext cxt) throws NamingException {
        return this.getLookupCache().lookupOutputProtocol(name);
    }

    protected void trace(String str) {
        this.getLogger().trace(str);
    }

    protected void activityEnteredTrace(String activityName, String label) {
        this.currentActivityName = activityName;
        this.currentActivityLabel = label;
        if (this.isTraceEnabled()) {
            this.getLogger().trace("Executing activity " + this.messageFlowName + "." + this.getActivityTraceName(activityName, label));
        }
        this.finishActivity();
        this.onActivityCallStart(this.currentActivityName, this.currentActivityLabel);
    }

    private void finishActivity() {
        if (this.currentActivityName != null) {
            this.onActivityCallEnd(this.currentActivityName, this.currentActivityLabel);
        }
    }

    protected void onActivityCallStart(String activityName, String label) {
    }

    protected void onActivityCallEnd(String activityName, String label) {
    }

    protected void onLocation(int index) {
        this.instanceLocationManager.onLocation(index, this);
    }

    protected void onLocation2(int index, String[] names, Object[] values) {
        this.instanceLocationManager.onLocation2(index, names, values, this);
    }

    protected void onLocation2(int index) {
        this.instanceLocationManager.onLocation2(index, OperationNode.EMPTY_NAMES, OperationNode.EMPTY_OBJECTS, this);
    }

    protected void onLocationDelta(int index) {
        this.instanceLocationManager.onLocationDelta(index, this);
    }

    protected void onLocationDelta(int index, String[] names, Object[] values) {
        this.instanceLocationManager.onLocationDelta(index, names, values, this);
    }

    private Log createLog() {
        return LogFactory.getMessageFlowLog(this, this.messageFlowName);
    }

    private String getActivityTraceName(String activityName, String label) {
        if (activityName != null) {
            return activityName + "(" + label + ")";
        }
        return null;
    }

    protected TransformContext createNewContext() {
        TransformContextWrapper newCxt = new TransformContextWrapper(this.transformContext);
        return newCxt;
    }

    public static DeviceInfo createDeviceInfo(String deviceName, String encoding, TransformContext cxt) {
        String messageIdentifier = (String)cxt.getProperty("input.source");
        DeviceInfo deviceInfo = new DeviceInfo(deviceName, messageIdentifier, null, encoding);
        return deviceInfo;
    }

    protected void sendToDevice(String protocolName, String deviceName, byte[] rawOut, TransformContext cxt) throws RemoteException, TransformException, NamingException {
        this.sendImpl(protocolName, deviceName, rawOut, cxt);
    }

    protected void sendToDevice(String protocolName, String deviceName, String rawOut, TransformContext cxt) throws RemoteException, TransformException, NamingException {
        this.sendImpl(protocolName, deviceName, rawOut, cxt);
    }

    protected void sendToDevice(String protocolName, String deviceName, RawMessage rawOut, TransformContext cxt) throws RemoteException, TransformException, NamingException {
        this.sendImpl(protocolName, deviceName, rawOut, cxt);
    }

    private void sendImpl(String protocolName, String deviceName, Object rawOut, TransformContext cxt) throws NamingException, RemoteException, TransformException {
        OutputProtocol protocol = this.lookupOutputProtocol(protocolName, cxt);
        String encoding = null;
        if (rawOut instanceof RawMessage) {
            encoding = ((RawMessage)rawOut).getEncoding();
        }
        if (encoding == null) {
            encoding = (String)cxt.getProperty("encoding");
        }
        DeviceInfo deviceInfo = AbstractMessageFlow.createDeviceInfo(deviceName, encoding, cxt);
        protocol.send(rawOut, deviceInfo, cxt);
    }

    protected void sendToPort(String portName, byte[] rawOut, TransformContext cxt) throws RemoteException, TransformException, NamingException {
        this.sendImpl(portName, rawOut, cxt);
    }

    protected void sendToPort(String portName, String rawOut, TransformContext cxt) throws RemoteException, TransformException, NamingException {
        this.sendImpl(portName, rawOut, cxt);
    }

    protected void sendToPort(String portName, RawMessage rawOut, TransformContext cxt) throws RemoteException, TransformException, NamingException {
        this.sendImpl(portName, rawOut, cxt);
    }

    private void sendImpl(String portName, Object rawOut, TransformContext cxt) throws NamingException, RemoteException, TransformException {
        OutputPortDef port = this.getOutputPort(portName);
        if (port == null) {
            throw new TransformException("Undefined port '" + portName + "' in Send Activity");
        }
        this.sendImpl(port.getProtocol(), port.getOutputDevice(), rawOut, cxt);
    }

    private OutputPortDef getOutputPort(String portName) {
        for (int i = 0; i < this.outputPorts.size(); ++i) {
            OutputPortDef outputPortDef = (OutputPortDef)this.outputPorts.get(i);
            if (!outputPortDef.getName().equals(portName)) continue;
            return outputPortDef;
        }
        return null;
    }

    protected DeviceOutputMessage createBatchedMessage(String activity, String portName, TransformContext cxt) throws NamingException, RemoteException, TransformException {
        OutputPortDef port = this.getOutputPort(portName);
        if (port == null) {
            throw new TransformException("Undefined port '" + portName + "' in Batch Send Activity");
        }
        OutputProtocol protocol = this.lookupOutputProtocol(port.getProtocol(), cxt);
        DeviceOutputMessage outputMessage = new DeviceOutputMessage(protocol, port.getOutputDevice(), cxt);
        this.batchedData.put(activity, outputMessage);
        return outputMessage;
    }

    protected void closeBatchSend(String activity, String portName, TransformContext cxt) throws NamingException, RemoteException, TransformException {
        OutputPortDef port = this.getOutputPort(portName);
        if (port == null) {
            throw new TransformException("Undefined port '" + portName + "' in Batch Send Activity");
        }
        DeviceOutputMessage device = (DeviceOutputMessage)this.batchedData.get(activity);
        if (device != null) {
            device.close();
            this.batchedData.remove(activity);
        } else {
            System.out.println("Missing batch for activity " + activity);
        }
    }

    protected void writeBatchMessage(String activityName, BatchMessage message, DataObject obj, RawMessage out, boolean cascade, TransformContext cxt) throws RemoteException, TransformException {
        ExceptionHandler.CascadingExceptionHandler cascadingExceptionHandler;
        BatchWriter writer = (BatchWriter)this.batchedData.get(activityName);
        if (writer == null) {
            writer = message.getBatchWriter();
            writer.startBatch(this.toDevice(out), cxt);
            this.batchedData.put(activityName, writer);
        }
        ExceptionHandler exceptionHandler = ExceptionHandler.DRACONIAN_EXCEPTION_HANDLER;
        if (cascade) {
            exceptionHandler = new ExceptionHandler.CascadingExceptionHandler();
        }
        writer.setExceptionHandler(exceptionHandler);
        writer.writeMessage((ExternalObject)obj, this.toDevice(out), cxt);
        if (cascade && (cascadingExceptionHandler = (ExceptionHandler.CascadingExceptionHandler)exceptionHandler).hasExceptions()) {
            this.handleExceptionList(cascadingExceptionHandler.getExceptions());
        }
    }

    protected void writePhasedMessage(String activityName, Message message, DataObject obj, RawMessage out, boolean cascade, TransformContext cxt) throws RemoteException, TransformException {
        ExceptionHandler.CascadingExceptionHandler cascadingExceptionHandler;
        PhasedWriter writer = (PhasedWriter)this.batchedData.get(activityName);
        if (writer == null) {
            writer = message.getPhasedWriter();
            this.batchedData.put(activityName, writer);
        }
        ExceptionHandler exceptionHandler = ExceptionHandler.DRACONIAN_EXCEPTION_HANDLER;
        if (cascade) {
            exceptionHandler = new ExceptionHandler.CascadingExceptionHandler();
        }
        writer.setExceptionHandler(exceptionHandler);
        writer.writePhased(obj, "", this.toDevice(out), cxt);
        if (cascade && (cascadingExceptionHandler = (ExceptionHandler.CascadingExceptionHandler)exceptionHandler).hasExceptions()) {
            this.handleExceptionList(cascadingExceptionHandler.getExceptions());
        }
    }

    private OutputDevice toDevice(final RawMessage out) {
        if (out instanceof OutputDevice) {
            return (OutputDevice)((Object)out);
        }
        return new OutputDevice(){

            public DeviceInfo getDeviceInfo() throws RemoteException {
                return null;
            }

            public void write(Object toSend) throws RemoteException, TransformException {
                if (toSend instanceof byte[]) {
                    out.append((byte[])toSend);
                } else if (toSend instanceof String) {
                    out.append((String)toSend);
                } else if (toSend instanceof StringBuffer) {
                    out.append(toSend.toString());
                } else if (toSend instanceof RawMessage) {
                    out.append((RawMessage)toSend);
                }
            }

            public void close() throws RemoteException, TransformException {
                out.dispose();
            }
        };
    }

    protected void finishBatch(String activityName, BatchMessage message, RawMessage out, TransformContext cxt) throws RemoteException, TransformException {
        BatchWriter writer = (BatchWriter)this.batchedData.get(activityName);
        if (writer != null) {
            writer.endBatch(this.toDevice(out), cxt);
            this.batchedData.remove(activityName);
        }
    }

    protected Object invokeCustomExternalClass(String className, Object[] args, TransformContext cxt) throws TransformException {
        if (this.customExternalClassSupport == null) {
            this.customExternalClassSupport = new CustomExternalClassSupport(this.getClass().getClassLoader());
        }
        return this.customExternalClassSupport.invoke(className, args, cxt);
    }

    protected void ensureVariableCount(Object[] values, int count) {
        if (count != values.length) {
            throw TransformRuntimeException.createFormatted("SRT526", new Object[]{this.getEntityName(), String.valueOf(count), String.valueOf(values.length)});
        }
    }

    private void clearVariablesImpl() {
        AbstractNormalizedObject variables = (AbstractNormalizedObject)this.getVariables();
        variables.resetToNull();
    }

    protected void clearVariables() {
        AbstractNormalizedObject variables = (AbstractNormalizedObject)this.getVariables();
        variables.reset();
    }

    protected static DataObjectMetaInfo prepareDataObjectMetaInfo(DesignerType[] types) throws NamingException, RemoteException, TransformException {
        return AbstractMessageMapping.prepareDataObjectMetaInfo(types);
    }

    protected static DataObjectMetaInfo prepareDataObjectMetaInfo(String[] args, DesignerType[] types) throws NamingException, RemoteException, TransformException {
        return AbstractMessageMapping.prepareDataObjectMetaInfo(args, types);
    }

    protected static DataObject createDataObject(DataObjectMetaInfo metaInfo, Object[] fieldValues) {
        return AbstractMessageMapping.createDataObject(metaInfo, fieldValues);
    }

    protected DataObject createMessageObject(String name) throws NamingException, RemoteException {
        return this.lookupMessage(name).createObject();
    }

    LookupCache getLookupCache() throws NamingException {
        if (this.lookupCache == null) {
            this.lookupCache = new LookupCache(this, this.getLookupContext());
        }
        return this.lookupCache;
    }

    public void cleanup() {
        if (this.lookupCache != null) {
            this.lookupCache.cleanup();
        }
    }

    public void start() throws TransformException {
    }

    public void stop() throws TransformException {
        this.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EntityInfo prepareEntityInfo() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            EntityInfo entityInfo = (EntityInfo)staticEntityInfo.get(this.getClass());
            if (entityInfo == null) {
                entityInfo = new EntityInfo(this.getEntityName(), this.getEntityType(), this.getClass());
                OperationInfo runOperationInfo = new OperationInfo(entityInfo, RUN_OPERATION);
                entityInfo.addOperation(runOperationInfo);
                List locations = this.instanceLocationManager.getLocations();
                runOperationInfo.addLocations(locations);
                staticEntityInfo.put(this.getClass(), entityInfo);
            }
            this.instanceEntityInfo = entityInfo;
            this.runOperationInfo = entityInfo.getOperationInfo(RUN_OPERATION);
            return entityInfo;
        }
    }

    public static final void setCurrentDestinationField(DataObject currentObject, int currentFieldIndex) {
    }

    class MessageFlowStateManager {
        List statefulFields;
        List cachedFields;
        List cachedValues;
        private boolean initialized;

        MessageFlowStateManager() {
        }

        void computeVariableScopes(DataObject variables) {
            if (!this.initialized) {
                int i;
                DataObjectMetaInfo info = variables.getMetaInfo();
                for (i = 0; i < variables.getFieldCount(); ++i) {
                    FieldMetaInfo fieldInfo = info.getFieldMetaInfo(i);
                    String scope = fieldInfo.getStringProperty(AbstractMessageFlow.SCOPE_PROPERTY);
                    if (scope.equals(AbstractMessageFlow.CACHED_SCOPE)) {
                        if (this.cachedFields == null) {
                            this.cachedFields = new ArrayList();
                        }
                        this.cachedFields.add(fieldInfo);
                    }
                    if (!scope.equals(AbstractMessageFlow.STATEFUL_SCOPE)) continue;
                    if (this.statefulFields == null) {
                        this.statefulFields = new ArrayList();
                    }
                    this.statefulFields.add(fieldInfo);
                }
                if (this.cachedFields != null && this.cachedFields.size() > 0) {
                    this.cachedValues = new ArrayList();
                    for (i = 0; i < this.cachedFields.size(); ++i) {
                        this.cachedValues.add(null);
                    }
                }
                this.initialized = true;
            }
        }

        void loadState(TransformContext cxt) {
            DataObject variables;
            if (this.statefulFields != null) {
                variables = AbstractMessageFlow.this.getVariables();
                String stateProperty = this.getStatePropertyName();
                List state = (List)cxt.getProperty(stateProperty);
                if (state != null) {
                    for (int i = 0; i < this.statefulFields.size(); ++i) {
                        FieldMetaInfo fieldMetaInfo = (FieldMetaInfo)this.statefulFields.get(i);
                        Object value = state.size() > i ? state.get(i) : null;
                        variables.setField(fieldMetaInfo.getIndex(), value);
                    }
                }
            }
            if (this.cachedFields != null) {
                variables = AbstractMessageFlow.this.getVariables();
                for (int i = 0; i < this.cachedFields.size(); ++i) {
                    FieldMetaInfo fieldMetaInfo = (FieldMetaInfo)this.cachedFields.get(i);
                    Object cachedValue = this.cachedValues.get(i);
                    if (cachedValue == null) continue;
                    variables.setField(fieldMetaInfo.getIndex(), cachedValue);
                }
            }
        }

        void saveState(TransformContext cxt) {
            DataObject variables;
            if (this.statefulFields != null) {
                variables = AbstractMessageFlow.this.getVariables();
                String stateProperty = this.getStatePropertyName();
                ArrayList<Object> state = (ArrayList<Object>)cxt.getProperty(stateProperty);
                if (state == null) {
                    state = new ArrayList<Object>();
                    cxt.setProperty(stateProperty, state);
                } else {
                    state.clear();
                }
                for (int i = 0; i < this.statefulFields.size(); ++i) {
                    FieldMetaInfo fieldMetaInfo = (FieldMetaInfo)this.statefulFields.get(i);
                    state.add(variables.getField(fieldMetaInfo.getIndex()));
                }
            }
            if (this.cachedFields != null) {
                variables = AbstractMessageFlow.this.getVariables();
                this.cachedValues.clear();
                for (int i = 0; i < this.cachedFields.size(); ++i) {
                    FieldMetaInfo fieldMetaInfo = (FieldMetaInfo)this.cachedFields.get(i);
                    this.cachedValues.add(variables.getField(fieldMetaInfo.getIndex()));
                }
            }
        }

        private String getStatePropertyName() {
            return "__messageflow." + AbstractMessageFlow.this.messageFlowName + ".state";
        }

        private boolean isStateful(FieldMetaInfo fieldInfo) {
            String scope = fieldInfo.getStringProperty(AbstractMessageFlow.SCOPE_PROPERTY);
            return Boolean.TRUE.equals(fieldInfo.getProperty(AbstractMessageFlow.SCOPE_PROPERTY));
        }
    }

    static class SimpleGenericDataObject2
    extends SimpleGenericDataObject
    implements NormalizedObject,
    InvocationObject {
        public SimpleGenericDataObject2(DataObjectMetaInfo info) {
            super(info);
        }
    }
}

