/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.AbstractServiceElement;
import com.tplus.transform.runtime.CascadedOperation;
import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DataObjectMetaInfo;
import com.tplus.transform.runtime.DataObjectMetaInfoImpl;
import com.tplus.transform.runtime.DesignerType;
import com.tplus.transform.runtime.DesignerTypes;
import com.tplus.transform.runtime.ExceptionHandler;
import com.tplus.transform.runtime.FieldMetaInfo;
import com.tplus.transform.runtime.FieldMetaInfoImpl;
import com.tplus.transform.runtime.InvocationObject;
import com.tplus.transform.runtime.MappingRules;
import com.tplus.transform.runtime.MessageMapping;
import com.tplus.transform.runtime.NormalizedObject;
import com.tplus.transform.runtime.OperationExecutor;
import com.tplus.transform.runtime.Result;
import com.tplus.transform.runtime.SectionMetaInfoImpl;
import com.tplus.transform.runtime.SimpleGenericDataObject;
import com.tplus.transform.runtime.TransformContext;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.WeakClassLocal;
import com.tplus.transform.runtime.log.LogFactory;
import com.tplus.transform.runtime.vm.EntityInfo;
import com.tplus.transform.runtime.vm.OperationInfo;
import java.rmi.RemoteException;
import java.util.List;

public abstract class AbstractMessageMapping
extends AbstractServiceElement
implements MessageMapping {
    private String mappingName;
    private static final String MAP_OPERATION = "map";
    protected String sourceMessageName;
    protected String destinationMessageName;
    OperationInfo mapOperationInfo;
    static WeakClassLocal staticEntityInfo = new WeakClassLocal();
    private static final String ARG_PREFIX = "arg";

    public AbstractMessageMapping(String mappingName) {
        super(mappingName, "Message Mapping");
        this.mappingName = mappingName;
        this.setLogger(LogFactory.getMappingLog(this, mappingName));
    }

    protected void init() {
        this.prepareEntityInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataObject map(DataObject src, DataObject dest, TransformContext cxt) throws TransformException, RemoteException {
        this.trace("mapping");
        this.onOperationEnter(this.mapOperationInfo, "Source", src, "Destination", dest, cxt);
        try {
            DataObject dataObject = this.map0(src, dest, cxt);
            return dataObject;
        }
        catch (Throwable e) {
            this.handleTransformException(e);
            DataObject dataObject = null;
            return dataObject;
        }
        finally {
            this.onOperationExit(this.mapOperationInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result map2(final DataObject src, final DataObject dest, final TransformContext cxt) throws TransformException, RemoteException {
        this.trace("mapping");
        this.onOperationEnter(this.mapOperationInfo, "Source", src, "Destination", dest, cxt);
        try {
            Result result = OperationExecutor.execute(this, new CascadedOperation(){

                public Object run(ExceptionHandler exceptionHandler) throws TransformException, RemoteException {
                    return AbstractMessageMapping.this.map0(src, dest, cxt);
                }
            });
            return result;
        }
        finally {
            this.onOperationExit(this.mapOperationInfo);
        }
    }

    protected abstract DataObject map0(DataObject var1, DataObject var2, TransformContext var3) throws TransformException, RemoteException;

    public String getSourceMessageName() {
        return this.sourceMessageName;
    }

    public void setSourceMessageName(String sourceMessageName) {
        this.sourceMessageName = sourceMessageName;
    }

    public String getDestinationMessageName() {
        return this.destinationMessageName;
    }

    public void setDestinationMessageName(String destinationMessageName) {
        this.destinationMessageName = destinationMessageName;
    }

    protected abstract MappingRules getMappingRules();

    public DataObject createInputDataObject() throws TransformException {
        return this.getMappingRules().createInputDataObject();
    }

    public DataObject createOutputDataObject() throws TransformException {
        return this.getMappingRules().createOutputDataObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EntityInfo prepareEntityInfo() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            EntityInfo entityInfo = (EntityInfo)staticEntityInfo.get(this.getClass());
            if (entityInfo == null) {
                entityInfo = new EntityInfo(this.getEntityName(), this.getEntityType(), this.getClass());
                OperationInfo mapOperationInfo = new OperationInfo(entityInfo, MAP_OPERATION);
                entityInfo.addOperation(mapOperationInfo);
                MappingRules mappingRules = this.getMappingRules();
                List locations = mappingRules.getLocations();
                mapOperationInfo.addLocations(locations);
                staticEntityInfo.put(this.getClass(), entityInfo);
            }
            this.instanceEntityInfo = entityInfo;
            this.mapOperationInfo = entityInfo.getOperationInfo(MAP_OPERATION);
        }
        return null;
    }

    public static DataObjectMetaInfo prepareDataObjectMetaInfo(DesignerType[] types) {
        String[] args = new String[types.length];
        for (int i = 0; i < args.length; ++i) {
            args[i] = ARG_PREFIX + i;
        }
        return AbstractMessageMapping.prepareDataObjectMetaInfo(args, types);
    }

    public static DataObjectMetaInfo prepareDataObjectMetaInfo(String[] args, DesignerType[] types) {
        FieldMetaInfo[] fields = new FieldMetaInfo[types.length];
        for (int i = 0; i < types.length; ++i) {
            DesignerType type = types[i];
            String argName = args[i];
            fields[i] = type == DesignerType.DESIGNER_SECTION_TYPE ? new SectionMetaInfoImpl(null, argName, 0, -1) : (type == DesignerType.DESIGNER_DATAOBJECT_TYPE ? new SectionMetaInfoImpl(null, DesignerTypes.DATAOBJECT_TYPE, argName, 0, 1, false) : new FieldMetaInfoImpl(argName, type, false));
        }
        DataObjectMetaInfoImpl info = new DataObjectMetaInfoImpl("mapInput", fields);
        return info;
    }

    public static DataObject createDataObject(DataObjectMetaInfo metaInfo, Object[] fieldValues) {
        SimpleGenericDataObject2 object = new SimpleGenericDataObject2(metaInfo);
        for (int i = 0; i < fieldValues.length; ++i) {
            Object o = fieldValues[i];
            object.setField(i, o);
        }
        return object;
    }

    static class SimpleGenericDataObject2
    extends SimpleGenericDataObject
    implements NormalizedObject,
    InvocationObject {
        public SimpleGenericDataObject2(DataObjectMetaInfo info) {
            super(info);
        }
    }
}

