/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.AbstractServiceElement;
import com.tplus.transform.runtime.AbstractValidationRules;
import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.ExceptionHandler;
import com.tplus.transform.runtime.MessageValidation;
import com.tplus.transform.runtime.TransformContext;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.WeakClassLocal;
import com.tplus.transform.runtime.log.LogFactory;
import com.tplus.transform.runtime.vm.EntityInfo;
import com.tplus.transform.runtime.vm.OperationInfo;
import java.util.List;

public abstract class AbstractMessageValidation
extends AbstractServiceElement
implements MessageValidation {
    private static final String VALIDATE_OPERATION = "validate";
    private final String validationName;
    OperationInfo validationOperationInfo;
    static WeakClassLocal staticEntityInfo = new WeakClassLocal();

    public AbstractMessageValidation(String validationName) {
        super(validationName, "Message Validation");
        this.validationName = validationName;
        this.setLogger(LogFactory.getMappingLog(this, validationName));
    }

    protected void init() {
        this.prepareEntityInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(DataObject no, ExceptionHandler exceptionHandler, TransformContext cxt) throws TransformException {
        this.trace("mapping");
        this.onOperationEnter(this.validationOperationInfo, "Source", no, cxt);
        try {
            this.getValidationRules().validate(no, exceptionHandler, cxt);
        }
        catch (Throwable e) {
            this.handleTransformException(e);
        }
        finally {
            this.onOperationExit(this.validationOperationInfo);
        }
    }

    public abstract AbstractValidationRules getValidationRules();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EntityInfo prepareEntityInfo() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            EntityInfo entityInfo = (EntityInfo)staticEntityInfo.get(this.getClass());
            if (entityInfo == null) {
                entityInfo = new EntityInfo(this.getEntityName(), this.getEntityType(), this.getClass());
                OperationInfo mapOperationInfo = new OperationInfo(entityInfo, VALIDATE_OPERATION);
                entityInfo.addOperation(mapOperationInfo);
                AbstractValidationRules mappingRules = this.getValidationRules();
                List locations = mappingRules.getLocations();
                mapOperationInfo.addLocations(locations);
                staticEntityInfo.put(this.getClass(), entityInfo);
            }
            this.instanceEntityInfo = entityInfo;
            this.validationOperationInfo = entityInfo.getOperationInfo(VALIDATE_OPERATION);
        }
        return null;
    }
}

