/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.AbstractServiceElement;
import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DeviceInfo;
import com.tplus.transform.runtime.ExceptionHandler;
import com.tplus.transform.runtime.ExternalMessageValidationRules;
import com.tplus.transform.runtime.ExternalObject;
import com.tplus.transform.runtime.MappingInfo;
import com.tplus.transform.runtime.MappingRules;
import com.tplus.transform.runtime.NormalizedObject;
import com.tplus.transform.runtime.OutputDevice;
import com.tplus.transform.runtime.OutputFormat;
import com.tplus.transform.runtime.OutputMappingRules;
import com.tplus.transform.runtime.OutputProtocol;
import com.tplus.transform.runtime.OutputWriter;
import com.tplus.transform.runtime.TransformContext;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.log.LogFactory;
import com.tplus.transform.util.log.Log;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import javax.naming.NamingException;

public abstract class AbstractOutputFormat
extends AbstractServiceElement
implements OutputFormat {
    Map outputProtocols = new HashMap();
    String formatSuffix = ".out";
    protected OutputMappingRules mappingRules;
    protected ExternalMessageValidationRules validator;
    protected OutputWriter writer;
    protected static final Log log = LogFactory.getRuntimeLog("OutputFormat");

    protected AbstractOutputFormat() {
        super("", "");
    }

    protected OutputProtocol getOutputProtocol(TransformContext cxt) throws TransformException {
        String name = (String)cxt.getProperty("output.protocol");
        if (name == null) {
            throw TransformException.createFormatted("SRT250");
        }
        try {
            OutputProtocol outputProtocol = (OutputProtocol)this.outputProtocols.get(name);
            if (outputProtocol == null) {
                outputProtocol = this.getLookupContext().lookupOutputProtocol(name);
                this.outputProtocols.put(name, outputProtocol);
            }
            return outputProtocol;
        }
        catch (NamingException e) {
            TransformException te = TransformException.createFormatted("SRT251", name);
            te.setDetail(e);
            throw te;
        }
    }

    protected static String getOutputName(TransformContext tcxt) {
        String outputName = (String)tcxt.getProperty("output.destination");
        if (outputName == null) {
            outputName = "default";
        }
        return outputName;
    }

    protected DeviceInfo createDeviceInfo(TransformContext tcxt) throws TransformException {
        return AbstractOutputFormat.createDeviceInfo(tcxt, this.getEncoding());
    }

    public static DeviceInfo createDeviceInfo(TransformContext tcxt, String encoding) throws TransformException {
        String outputDeviceName = (String)tcxt.getProperty("output.device");
        String outputFormatName = (String)tcxt.getProperty("output.format");
        String messageIdentifier = (String)tcxt.getProperty("input.source");
        if (outputDeviceName == null) {
            outputDeviceName = "";
        }
        DeviceInfo deviceInfo = new DeviceInfo(outputDeviceName, messageIdentifier, outputFormatName, encoding);
        return deviceInfo;
    }

    protected String getEncoding() {
        return null;
    }

    protected String getFormatSuffix() {
        return this.formatSuffix;
    }

    protected DataObject createRecordData() {
        return null;
    }

    protected DataObject createHeader() {
        return null;
    }

    protected DataObject createTrailer() {
        return null;
    }

    public MappingInfo getMappingInfo() {
        return this.getMappingRules().getMappingInfo();
    }

    protected MappingRules getMappingRules() {
        return this.mappingRules;
    }

    public void mapHeader(NormalizedObject nobj, DataObject header, TransformContext cxt) throws TransformException {
        ExternalObject externalObject = null;
        this.mappingRules.mapHeaderFields(nobj, header, externalObject, cxt);
        this.validator.validateHeader(header, externalObject, ExceptionHandler.DRACONIAN_EXCEPTION_HANDLER, cxt);
    }

    public void mapData(NormalizedObject nobj, DataObject header, DataObject record, TransformContext cxt) throws TransformException {
        ExternalObject externalObject = null;
        this.mappingRules.mapDataFields(nobj, record, externalObject, cxt);
        this.validator.validateData(header, record, externalObject, ExceptionHandler.DRACONIAN_EXCEPTION_HANDLER, cxt);
    }

    public void mapTrailer(NormalizedObject nobj, DataObject recordData, DataObject trailer, TransformContext cxt) throws TransformException {
        ExternalObject externalObject = null;
        this.mappingRules.mapTrailerFields(nobj, recordData, trailer, externalObject, cxt);
        this.validator.validateTrailer(trailer, externalObject, ExceptionHandler.DRACONIAN_EXCEPTION_HANDLER, cxt);
    }

    protected OutputWriter getOutputWriter() {
        return this.writer;
    }

    protected static void writeOutput(Object output, OutputDevice device) throws TransformException, RemoteException {
        AbstractOutputFormat.writeToDevice(output, device);
        device.close();
    }

    public static void writeToDevice(Object obj, OutputDevice device) throws TransformException, RemoteException {
        if (obj instanceof Object[]) {
            Object[] messageParts = (Object[])obj;
            for (int i = 0; i < messageParts.length; ++i) {
                if (messageParts[i] == null) continue;
                AbstractOutputFormat.writeToDevice(messageParts[i], device);
            }
        } else {
            device.write(obj);
        }
    }
}

