/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.lang.ScaledDecimal;
import com.tplus.transform.runtime.AbstractQueryDef;
import com.tplus.transform.runtime.AbstractServiceElement;
import com.tplus.transform.runtime.ByteArrayInputSource;
import com.tplus.transform.runtime.DBDialect;
import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DataObjectCollectionImpl;
import com.tplus.transform.runtime.DataObjectMetaInfo;
import com.tplus.transform.runtime.DataObjectSection;
import com.tplus.transform.runtime.DatabaseFieldMetaInfo;
import com.tplus.transform.runtime.DatabaseMetaInfo;
import com.tplus.transform.runtime.DynamicQuery;
import com.tplus.transform.runtime.ExceptionHandler;
import com.tplus.transform.runtime.FieldMetaInfo;
import com.tplus.transform.runtime.MessageHandler;
import com.tplus.transform.runtime.MessageXMLSupport;
import com.tplus.transform.runtime.NormalizedObject;
import com.tplus.transform.runtime.NormalizedObjectCollection;
import com.tplus.transform.runtime.PersistenceManager;
import com.tplus.transform.runtime.PersistenceSession;
import com.tplus.transform.runtime.Query;
import com.tplus.transform.runtime.QueryDef;
import com.tplus.transform.runtime.QueryDefImpl;
import com.tplus.transform.runtime.RawMessage;
import com.tplus.transform.runtime.StandardRuntimeResource;
import com.tplus.transform.runtime.StaticQuery;
import com.tplus.transform.runtime.StreamInputSource;
import com.tplus.transform.runtime.StringInputSource;
import com.tplus.transform.runtime.TransformContext;
import com.tplus.transform.runtime.TransformContextImpl;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.TransformRuntimeException;
import com.tplus.transform.runtime.TransformSQLException;
import com.tplus.transform.runtime.formula.DateFunctions;
import com.tplus.transform.runtime.keygen.KeyGenerationException;
import com.tplus.transform.runtime.keygen.KeyGenerator;
import com.tplus.transform.runtime.keygen.KeyGeneratorInfo;
import com.tplus.transform.runtime.keygen.TableKeyGenerator;
import com.tplus.transform.runtime.log.LogFactory;
import com.tplus.transform.runtime.persistence.expression.Expression;
import com.tplus.transform.util.StringUtils;
import com.tplus.transform.util.sql.connection.ConnectionPool;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Map;
import javax.naming.NamingException;

public abstract class AbstractPersistenceManager
extends AbstractServiceElement
implements PersistenceManager {
    protected String currentDataSourceName;
    protected String connectionPoolDataSourceName;
    protected ConnectionPool connectionPool;
    protected Connection connection;
    public static final String SELECTION_ALL_STATEMENT_NAME = "All";
    public static final String SELECTION_BY_PRIMARY_KEY_NAME = "ByPK";
    PersistenceManager keyGenPM = this;
    KeyGenerator keyGen;
    private String name;
    private static final int DEFAULT_BATCH_SIZE = 20;
    private static final String BATCH_SIZE = "batch.size";
    private static final String DATASOURCE_NAME = "datasource.name";
    MessageXMLSupport messageXMLSupport = new MessageXMLSupport(this);
    private boolean isFlatStructuredTable;
    PersistenceSession session;

    public AbstractPersistenceManager(String name) {
        super(name, "PersistenceManager");
        this.name = name;
        this.setLogger(LogFactory.getRuntimeLog(this, "persistence." + name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    DBDialect getDialect() throws TransformException {
        block20: {
            block21: {
                connectionPool = this.getConnectionPool();
                dialect = connectionPool.getDialect();
                if (dialect != null) {
                    return DBDialect.valueOf(dialect);
                }
                isNewConnection = false;
                con = null;
                try {
                    dialects = new String[]{"hsql", "oracle", "mysql", "db2", "postgres"};
                    if (this.connection == null) {
                        con = this.getConnectionPool().getConnection();
                        isNewConnection = true;
                    } else {
                        con = this.connection;
                    }
                    databaseProductName = con.getMetaData().getDatabaseProductName();
                    if (databaseProductName == null) break block20;
                    databaseProductName = databaseProductName.toLowerCase();
                    i = 0;
lbl18:
                    // 2 sources

                    while (i < dialects.length) {
                        if (databaseProductName.contains(dialects[i])) {
                            var8_12 = DBDialect.valueOf(dialects[i]);
                            if (isNewConnection == false) return var8_12;
                            break block21;
                        }
                        ** GOTO lbl-1000
                    }
                    ** GOTO lbl49
                }
                catch (Exception e) {
                    if (isNewConnection == false) return null;
                    try {
                        connectionPool.releaseConnection(con);
                        return null;
                    }
                    catch (SQLException e) {
                        return null;
                    }
                    catch (Throwable var10_15) {
                        if (isNewConnection == false) throw var10_15;
                        try {
                            connectionPool.releaseConnection(con);
                            throw var10_15;
                        }
                        catch (SQLException e) {
                            // empty catch block
                        }
                        throw var10_15;
                    }
                }
            }
            try {
                connectionPool.releaseConnection(con);
                return var8_12;
            }
            catch (SQLException e) {
                // empty catch block
            }
            return var8_12;
lbl-1000:
            // 1 sources

            {
                ++i;
                ** GOTO lbl18
lbl49:
                // 1 sources

                if (!databaseProductName.contains("microsoft") || !databaseProductName.contains("sql") || !databaseProductName.contains("server")) break block20;
                var7_11 = DBDialect.valueOf("mssql");
                if (isNewConnection == false) return var7_11;
            }
            try {
                connectionPool.releaseConnection(con);
                return var7_11;
            }
            catch (SQLException e) {
                // empty catch block
            }
            return var7_11;
        }
        if (isNewConnection == false) return null;
        try {
            connectionPool.releaseConnection(con);
            return null;
        }
        catch (SQLException e) {
            return null;
        }
    }

    ConnectionPool getConnectionPool() throws TransformException {
        if (!this.isConnectionPoolValid()) {
            this.closeConnectionPool();
        }
        if (this.connectionPool == null) {
            try {
                this.connectionPool = this.getLookupContext().lookupDataSource(this.currentDataSourceName);
                this.connectionPoolDataSourceName = this.currentDataSourceName;
            }
            catch (NamingException e) {
                TransformException te = TransformException.createFormatted("SRT220", this.currentDataSourceName);
                te.setDetail(e);
                this.getLogger().error(te.getMessage(), e);
                throw te;
            }
            catch (RemoteException e) {
                throw TransformRuntimeException.createFormatted("SRT221");
            }
        }
        return this.connectionPool;
    }

    private boolean isConnectionPoolValid() {
        return this.currentDataSourceName.equals(this.connectionPoolDataSourceName);
    }

    private void closeConnectionPool() {
        if (this.connectionPool != null) {
            this.connectionPool = null;
            this.connectionPoolDataSourceName = null;
        }
    }

    protected KeyGenerator getKeyGen(String dataSourceName) throws KeyGenerationException {
        this.currentDataSourceName = dataSourceName;
        String uniqueKeyGenTableName = this.getMetaInfo().getUniqueKeyGenTableName();
        if (!this.isConnectionPoolValid()) {
            this.keyGen = null;
        }
        if (this.keyGen == null) {
            try {
                this.keyGen = new TableKeyGenerator(this.getConnectionPool(), uniqueKeyGenTableName);
            }
            catch (TransformException e) {
                KeyGenerationException kge = KeyGenerationException.createKeyGenerationExceptionFormatted("SRT630");
                kge.setDetail(e);
                throw kge;
            }
        }
        return this.keyGen;
    }

    protected PreparedStatement createPreparedStatement(String stmt) throws TransformException {
        try {
            if (this.connection == null) {
                throw TransformException.createFormatted("SRT222");
            }
            this.logSQL(stmt);
            PreparedStatement ps = this.session.createPreparedStatement(stmt);
            return ps;
        }
        catch (SQLException e) {
            TransformSQLException tsqle = TransformSQLException.createTransformSQLExceptionFormatted("SRT635", stmt);
            tsqle.setStatement(stmt);
            tsqle.setDetail(e);
            throw tsqle;
        }
    }

    protected void closePreparedStatement(PreparedStatement ps) throws SQLException {
        this.session.closePreparedStatement(ps);
    }

    protected void executeInsert(PreparedStatement ps, String sqlCommand) throws SQLException {
        this.session.executeInsert(ps, sqlCommand);
    }

    protected int executeUpdate(PreparedStatement ps, String sqlCommand) throws TransformSQLException {
        return this.session.executeUpdate(ps, sqlCommand);
    }

    public void flushEntity(String sqlCommand) throws SQLException {
        this.session.flush(sqlCommand);
    }

    public void setPersistenceManager(PersistenceManager pm) {
        this.keyGenPM = pm;
    }

    protected int getNextAutoGenInt(String tableName, String columnName) throws TransformException {
        try {
            return this.keyGenPM.getNextInt(new KeyGeneratorInfo(tableName, columnName, this.currentDataSourceName));
        }
        catch (RemoteException e) {
            TransformException te = TransformException.createFormatted("SRT217", e.getMessage());
            te.setDetail(e);
            throw te;
        }
    }

    protected long getNextAutoGenLong(String tableName, String columnName) throws TransformException {
        try {
            return this.keyGenPM.getNextLong(new KeyGeneratorInfo(tableName, columnName, this.currentDataSourceName));
        }
        catch (RemoteException e) {
            TransformRuntimeException tre = TransformRuntimeException.createFormatted("SRT217", e.getMessage());
            tre.setDetail(e);
            throw tre;
        }
    }

    protected String getNextAutoGenString(String tableName, String columnName) throws TransformException {
        try {
            KeyGeneratorInfo keyGeneratorInfo = new KeyGeneratorInfo(tableName, columnName, this.currentDataSourceName);
            String toRet = this.hasFreeKeys(keyGeneratorInfo) ? this.getNextString(keyGeneratorInfo) : this.keyGenPM.getNextString(keyGeneratorInfo);
            return toRet;
        }
        catch (RemoteException e) {
            TransformRuntimeException tre = TransformRuntimeException.createFormatted("SRT217", e.getMessage());
            tre.setDetail(e);
            throw tre;
        }
    }

    public boolean hasFreeKeys(KeyGeneratorInfo keyGeneratorInfo) {
        if (!keyGeneratorInfo.dataSource.equals(this.currentDataSourceName)) {
            return false;
        }
        if (this.keyGen != null) {
            return this.keyGen.hasFreeKeys(keyGeneratorInfo);
        }
        return false;
    }

    PersistenceSession initSession(TransformContext cxt) throws TransformException {
        this.reinitializeDataSource(cxt);
        int batchSize = 1;
        String sizeStr = (String)cxt.getProperty(BATCH_SIZE);
        if (sizeStr != null) {
            try {
                batchSize = Integer.parseInt(sizeStr);
            }
            catch (IllegalArgumentException e) {
                this.getLogger().error("Invalid batch.size property " + batchSize);
            }
        }
        Connection connection = this.initConnection();
        this.session = new PersistenceSession(connection, batchSize, this.getDialect(), this.getLogger());
        return this.session;
    }

    private String getDataSourceName(TransformContext cxt) {
        String dataSourceName = (String)cxt.getProperty(DATASOURCE_NAME);
        if (StringUtils.isEmpty(dataSourceName)) {
            dataSourceName = this.getMetaInfo().getDataSourceName();
        }
        return dataSourceName;
    }

    void commitSession() throws TransformException, SQLException {
        this.session.finishSession();
        this.getConnectionPool().commit(this.session.getConnection());
    }

    void rollbackSession(SQLException e) throws TransformException {
        this.handleSQLException(e, "SRT636", this.session.getConnection());
    }

    void finishSession() throws TransformException {
        try {
            this.session.closeSession();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.exitConnection(this.session.sqlError);
        this.session = null;
    }

    private TransformContext createEmptyContext() {
        return new TransformContextImpl();
    }

    public NormalizedObject persist(NormalizedObject nobj) throws TransformException, RemoteException {
        return this.persist(nobj, this.createEmptyContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NormalizedObject persist(NormalizedObject nobj, TransformContext cxt) throws TransformException, RemoteException {
        this.initSession(cxt);
        try {
            NormalizedObject cloneObject = (NormalizedObject)nobj.clone();
            this.store(cloneObject);
            this.commitSession();
            NormalizedObject normalizedObject = cloneObject;
            return normalizedObject;
        }
        catch (SQLException e) {
            this.rollbackSession(e);
            NormalizedObject normalizedObject = null;
            return normalizedObject;
        }
        finally {
            this.finishSession();
        }
    }

    private void reinitializeDataSource(TransformContext cxt) {
        this.currentDataSourceName = this.getDataSourceName(cxt);
    }

    public DataObjectSection persist(DataObjectSection nobjs) throws TransformException, RemoteException {
        return this.persist(nobjs, this.createEmptyContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataObjectSection persist(DataObjectSection nobjs, TransformContext cxt) throws TransformException, RemoteException {
        this.initSession(cxt);
        try {
            DataObjectCollectionImpl toRet;
            NormalizedObject[] cloneObjects = new NormalizedObject[nobjs.size()];
            for (int i = 0; i < nobjs.size(); ++i) {
                NormalizedObject normalizedObject = (NormalizedObject)nobjs.get(i);
                cloneObjects[i] = (NormalizedObject)normalizedObject.clone();
            }
            this.storeBatch(cloneObjects);
            this.commitSession();
            DataObjectCollectionImpl dataObjectCollectionImpl = toRet = new DataObjectCollectionImpl(Arrays.asList(cloneObjects));
            return dataObjectCollectionImpl;
        }
        catch (SQLException e) {
            this.rollbackSession(e);
            DataObjectSection dataObjectSection = null;
            return dataObjectSection;
        }
        finally {
            this.finishSession();
        }
    }

    public NormalizedObject persistOrUpdate(NormalizedObject nobj) throws TransformException, RemoteException {
        return this.persistOrUpdate(nobj, this.createEmptyContext());
    }

    public NormalizedObject persistOrUpdate(NormalizedObject nobj, TransformContext cxt) throws TransformException, RemoteException {
        this.reinitializeDataSource(cxt);
        if (this.canDelete(nobj, cxt)) {
            return this.update(nobj, cxt);
        }
        return this.persist(nobj, cxt);
    }

    private boolean canDelete(NormalizedObject nobj, TransformContext cxt) throws TransformException {
        this.initSession(cxt);
        try {
            boolean bl = this.isPersistent(nobj);
            return bl;
        }
        catch (SQLException e) {
            this.rollbackSession(e);
            this.getLogger().error("Error updating normalized object", e);
            TransformSQLException tsqle = TransformSQLException.createTransformSQLExceptionFormatted("SRT637");
            tsqle.setDetail(e);
            throw tsqle;
        }
        finally {
            this.finishSession();
        }
    }

    public NormalizedObject update(NormalizedObject nobj) throws TransformException, RemoteException {
        return this.update(nobj, this.createEmptyContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NormalizedObject update(NormalizedObject nobj, TransformContext cxt) throws TransformException, RemoteException {
        this.initSession(cxt);
        try {
            NormalizedObject cloneObject = (NormalizedObject)nobj.clone();
            if (this.isFlatStructuredTable) {
                this.updateAndCheck(cloneObject);
            } else {
                this.deleteAndCheck(cloneObject);
                this.store(cloneObject);
            }
            this.commitSession();
            NormalizedObject normalizedObject = cloneObject;
            return normalizedObject;
        }
        catch (SQLException e) {
            this.rollbackSession(e);
            NormalizedObject normalizedObject = null;
            return normalizedObject;
        }
        finally {
            this.finishSession();
        }
    }

    public void setFlatStructuredTable(boolean flatStructuredTable) {
        this.isFlatStructuredTable = flatStructuredTable;
    }

    protected void updateExisting(NormalizedObject nobj) throws TransformException, SQLException {
        throw new TransformException("updateExisting is not implemented in " + nobj.getQualifiedName());
    }

    protected int updateExistingObj(NormalizedObject nobj) throws TransformException, SQLException {
        this.updateExisting(nobj);
        return 1;
    }

    protected void updateAndCheck(NormalizedObject nobj) throws TransformException, SQLException {
        int updated = this.updateExistingObj(nobj);
        if (updated != 1) {
            if (updated == 0) {
                throw StandardRuntimeResource.createSQLExceptionFormatted("SRT229");
            }
            throw StandardRuntimeResource.createSQLExceptionFormatted("SRT230");
        }
    }

    public void remove(NormalizedObject nobj) throws TransformException, RemoteException {
        this.removeMessage(nobj);
    }

    public void removeMessage(NormalizedObject nobj) throws TransformException, RemoteException {
        this.removeMessage(nobj, this.createEmptyContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessage(NormalizedObject nobj, TransformContext cxt) throws TransformException, RemoteException {
        this.initSession(cxt);
        try {
            this.deleteAndCheck(nobj);
            this.commitSession();
        }
        catch (SQLException e) {
            this.rollbackSession(e);
        }
        finally {
            this.finishSession();
        }
    }

    private void deleteAndCheck(NormalizedObject nobj) throws TransformException, SQLException {
        int removed = this.delete(nobj);
        if (removed != 1) {
            if (removed == 0) {
                throw StandardRuntimeResource.createSQLExceptionFormatted("SRT227");
            }
            throw StandardRuntimeResource.createSQLExceptionFormatted("SRT228");
        }
    }

    public int removeMessages(Query query) throws TransformException, RemoteException {
        return this.removeMessages(query, this.createEmptyContext());
    }

    public int removeMessages(Query query, TransformContext cxt) throws TransformException, RemoteException {
        return this.remove(query, cxt);
    }

    int remove(Query query, TransformContext cxt) throws TransformException, RemoteException {
        this.initSession(cxt);
        try {
            AbstractQueryDef def = this.getQueryImpl(query);
            Object[] translatedParams = def.translateParams(query.getParameters());
            NormalizedObjectCollection nobjs = new NormalizedObjectCollection();
            this.selectCollection0(def.getSQL(), translatedParams, new CollectionHandler(nobjs));
            for (int i = 0; i < nobjs.getElementCount(); ++i) {
                NormalizedObject nobj = (NormalizedObject)nobjs.getElement(i);
                this.deleteAndCheck(nobj);
            }
            this.commitSession();
            int n = nobjs.size();
            return n;
        }
        catch (SQLException e) {
            this.rollbackSession(e);
            TransformSQLException tsqle = TransformSQLException.createTransformSQLExceptionFormatted("SRT638");
            tsqle.setDetail(e);
            throw tsqle;
        }
        finally {
            this.finishSession();
        }
    }

    protected NormalizedObjectCollection toNormalizedObjectCollection(Collection collection) throws RemoteException {
        NormalizedObjectCollection normalizedObjects = new NormalizedObjectCollection(collection);
        return normalizedObjects;
    }

    public NormalizedObjectCollection findAll() throws TransformException, RemoteException {
        return this.findAll(this.createEmptyContext());
    }

    public NormalizedObjectCollection findAll(TransformContext cxt) throws TransformException, RemoteException {
        return this.find(SELECTION_ALL_STATEMENT_NAME, null);
    }

    NormalizedObject findByPrimaryKey(Object primaryKeys) throws TransformException, RemoteException {
        Object[] pks = null;
        pks = primaryKeys instanceof Object[] ? (Object[])primaryKeys : new Object[]{primaryKeys};
        NormalizedObjectCollection nos = this.find(SELECTION_BY_PRIMARY_KEY_NAME, pks);
        if (nos.size() != 1) {
            if (nos.size() == 0) {
                throw TransformException.createFormatted("SRT223");
            }
            throw TransformException.createFormatted("SRT224");
        }
        return (NormalizedObject)nos.get(0);
    }

    public NormalizedObjectCollection find(NormalizedObject obj) throws TransformException, RemoteException {
        Query query = this.constructQuery(obj);
        return this.find(query);
    }

    public NormalizedObjectCollection findSQL(String querySQL, Object[] parameters) throws TransformException, RemoteException {
        StaticQuery query = new StaticQuery(querySQL, parameters);
        return this.find(query);
    }

    public NormalizedObjectCollection findSQL(String querySQL, Object[] parameters, TransformContext cxt) throws TransformException, RemoteException {
        StaticQuery query = new StaticQuery(querySQL, parameters);
        return this.find(query, cxt);
    }

    public NormalizedObjectCollection findSQL(String querySQL, int start, int count, Object[] parameters) throws TransformException, RemoteException {
        StaticQuery query = new StaticQuery(querySQL, parameters);
        return this.find(query, start, count, (TransformContext)new TransformContextImpl());
    }

    public NormalizedObjectCollection findSQL(String querySQL, int start, int count, Object[] parameters, TransformContext cxt) throws TransformException, RemoteException {
        StaticQuery query = new StaticQuery(querySQL, parameters);
        return this.find(query, start, count, cxt);
    }

    private Query constructQuery(NormalizedObject obj) {
        DynamicQuery dynamicQuery = new DynamicQuery();
        int count = obj.getFieldCount();
        DatabaseMetaInfo databaseMetaInfo = this.getMetaInfo();
        DataObjectMetaInfo info = obj.getMetaInfo();
        for (int i = 0; i < count; ++i) {
            FieldMetaInfo metaInfo = info.getFieldMetaInfo(i);
            if (!metaInfo.getDesignerType().isPrimitiveType() || obj.isNull(i)) continue;
            Object value = obj.getField(i);
            String noFieldName = metaInfo.getName();
            DatabaseFieldMetaInfo dbField = databaseMetaInfo.getDataFieldForNormalizedField(noFieldName);
            if (dbField == null) continue;
            value = dbField.normalizedValueToDBValue(value);
            dynamicQuery.add(Expression.eq(dbField.getName(), value));
        }
        return dynamicQuery;
    }

    public NormalizedObjectCollection find(Query query) throws TransformException, RemoteException {
        return this.find(query, this.createEmptyContext());
    }

    public NormalizedObjectCollection find(Query query, TransformContext cxt) throws TransformException, RemoteException {
        AbstractQueryDef def = this.getQueryImpl(query);
        Object[] translatedParams = def.translateParams(query.getParameters());
        NormalizedObjectCollection toRet = new NormalizedObjectCollection();
        this.selectCollection(def.getSQL(), translatedParams, new CollectionHandler(toRet), cxt);
        return toRet;
    }

    public NormalizedObjectCollection find(Query query, int start, int count, TransformContext cxt) throws TransformException, RemoteException {
        cxt = this.fixTransformContext(cxt);
        this.reinitializeDataSource(cxt);
        AbstractQueryDef def = this.getQueryImpl(query);
        Object[] translatedParams = def.translateParams(query.getParameters());
        NormalizedObjectCollection toRet = new NormalizedObjectCollection();
        DatabaseMetaData databaseMetaData = null;
        DBDialect dialect = this.getDialect();
        if (dialect == DBDialect.MSSQL) {
            databaseMetaData = this.getDatabaseMetaData();
        }
        this.selectCollection(def.getSQLRange(start, count, dialect, databaseMetaData), translatedParams, new CollectionHandler(toRet), cxt);
        return toRet;
    }

    public void find(String name, Object[] params, MessageHandler messageHandler) throws TransformException, RemoteException {
        this.find(name, params, messageHandler, this.createEmptyContext());
    }

    public void find(String name, Object[] params, MessageHandler messageHandler, TransformContext cxt) throws TransformException, RemoteException {
        this.reinitializeDataSource(cxt);
        AbstractQueryDef def = this.getQueryImpl(name);
        Object[] translatedParams = def.translateParams(params);
        String sql = def.getSQL();
        this.selectCollection(sql, translatedParams, messageHandler, cxt);
    }

    public void find(String name, Object[] params, int start, int count, MessageHandler messageHandler, TransformContext cxt) throws TransformException, RemoteException {
        cxt = this.fixTransformContext(cxt);
        this.reinitializeDataSource(cxt);
        AbstractQueryDef def = this.getQueryImpl(name);
        Object[] translatedParams = def.translateParams(params);
        DatabaseMetaData databaseMetaData = null;
        DBDialect dialect = this.getDialect();
        if (dialect == DBDialect.MSSQL) {
            databaseMetaData = this.getDatabaseMetaData();
        }
        String sql = def.getSQLRange(start, count, dialect, databaseMetaData);
        this.selectCollection(sql, translatedParams, messageHandler, cxt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabaseMetaData getDatabaseMetaData() {
        DatabaseMetaData databaseMetaData = null;
        Connection connection1 = null;
        try {
            connection1 = this.getConnectionPool().getConnection();
            databaseMetaData = connection1.getMetaData();
        }
        catch (SQLException e) {
        }
        catch (TransformException e) {
        }
        finally {
            try {
                this.getConnectionPool().releaseConnection(connection1);
            }
            catch (SQLException e) {
            }
            catch (TransformException e) {}
        }
        return databaseMetaData;
    }

    public int countSQL(String querySQL, Object[] params, TransformContext cxt) throws TransformException, RemoteException {
        cxt = this.fixTransformContext(cxt);
        this.reinitializeDataSource(cxt);
        StaticQuery query = new StaticQuery(querySQL, params);
        AbstractQueryDef def = this.getQueryImpl(query);
        Object[] translatedParams = def.translateParams(query.getParameters());
        String sql = def.getCountSQL();
        return this.countCollection0(sql, translatedParams, cxt);
    }

    public int count(String name, Object[] params, TransformContext cxt) throws TransformException, RemoteException {
        cxt = this.fixTransformContext(cxt);
        this.reinitializeDataSource(cxt);
        AbstractQueryDef def = this.getQueryImpl(name);
        Object[] translatedParams = def.translateParams(params);
        String sql = def.getCountSQL();
        return this.countCollection0(sql, translatedParams, cxt, true);
    }

    public NormalizedObjectCollection find(String name, Object[] params) throws TransformException, RemoteException {
        return this.find(name, params, this.createEmptyContext());
    }

    public NormalizedObjectCollection find(String name, Object[] params, TransformContext cxt) throws TransformException, RemoteException {
        cxt = this.fixTransformContext(cxt);
        NormalizedObjectCollection normalizedObjectCollection = new NormalizedObjectCollection();
        this.find(name, params, new CollectionHandler(normalizedObjectCollection), cxt);
        return normalizedObjectCollection;
    }

    public NormalizedObjectCollection find(String name, Object[] params, int start, int count, TransformContext cxt) throws TransformException, RemoteException {
        cxt = this.fixTransformContext(cxt);
        NormalizedObjectCollection normalizedObjectCollection = new NormalizedObjectCollection();
        this.find(name, params, start, count, new CollectionHandler(normalizedObjectCollection), cxt);
        return normalizedObjectCollection;
    }

    private TransformContext fixTransformContext(TransformContext cxt) {
        if (cxt == null) {
            cxt = new TransformContextImpl();
        }
        return cxt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void selectCollection(String stmt, Object[] arguments, MessageHandler messageHandler, TransformContext cxt) throws TransformException, RemoteException {
        this.initSession(cxt);
        try {
            this.selectCollection0(stmt, arguments, messageHandler);
            this.commitSession();
        }
        catch (SQLException e) {
            this.rollbackSession(e);
        }
        finally {
            this.finishSession();
        }
    }

    protected int countCollection0(String stmt, Object[] arguments, TransformContext cxt) throws TransformException, RemoteException {
        return this.countCollection0(stmt, arguments, cxt, false);
    }

    /*
     * Loose catch block
     */
    protected int countCollection0(String stmt, Object[] arguments, TransformContext cxt, boolean isCount) throws TransformException, RemoteException {
        this.initSession(cxt);
        try {
            PreparedStatement selectPS = this.createPreparedStatement(stmt);
            try {
                this.populateArgs(selectPS, arguments);
                ResultSet rs = selectPS.executeQuery();
                int count = 0;
                while (rs.next()) {
                    if (isCount) {
                        int n = rs.getInt(1);
                        return n;
                    }
                    ++count;
                }
                int n = count;
                return n;
            }
            catch (SQLException e) {
                TransformSQLException tsqle = TransformSQLException.createTransformSQLExceptionFormatted("SRT641", e.getMessage());
                tsqle.setStatement(stmt);
                tsqle.setDetail(e);
                throw tsqle;
            }
            finally {
                try {
                    this.closePreparedStatement(selectPS);
                }
                catch (SQLException e) {}
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.finishSession();
        }
    }

    protected void selectCollection0(String stmt, Object[] arguments, MessageHandler messageHandler) throws TransformException, RemoteException {
        PreparedStatement selectPS = this.createPreparedStatement(stmt);
        try {
            this.populateArgs(selectPS, arguments);
            ResultSet rs = selectPS.executeQuery();
            while (rs.next()) {
                NormalizedObject nobj = this.createNormalizedObject();
                this.load(rs, nobj);
                if (messageHandler.handleMessage(nobj, null)) continue;
                break;
            }
        }
        catch (SQLException e) {
            TransformSQLException tsqle = TransformSQLException.createTransformSQLExceptionFormatted("SRT641", e.getMessage());
            tsqle.setStatement(stmt);
            tsqle.setDetail(e);
            throw tsqle;
        }
        finally {
            try {
                this.closePreparedStatement(selectPS);
            }
            catch (SQLException e) {}
        }
    }

    protected int selectCount0(String stmt, Object[] arguments) throws TransformException, RemoteException {
        PreparedStatement selectPS = this.createPreparedStatement(stmt);
        try {
            this.populateArgs(selectPS, arguments);
            ResultSet rs = selectPS.executeQuery();
            if (rs.next()) {
                int count;
                int n = count = rs.getInt(1);
                return n;
            }
            try {
                TransformSQLException tsqle = TransformSQLException.createTransformSQLExceptionFormatted("SRT641", "Unexpected result executing count query");
                throw tsqle;
            }
            catch (SQLException e) {
                TransformSQLException tsqle = TransformSQLException.createTransformSQLExceptionFormatted("SRT641", e.getMessage());
                tsqle.setDetail(e);
                throw tsqle;
            }
        }
        finally {
            try {
                this.closePreparedStatement(selectPS);
            }
            catch (SQLException e) {}
        }
    }

    private void populateArgs(PreparedStatement selectPS, Object[] arguments) throws SQLException {
        if (arguments != null) {
            for (int i = 0; i < arguments.length; ++i) {
                selectPS.setObject(i + 1, arguments[i]);
            }
        }
    }

    private AbstractQueryDef getQueryImpl(Query query) throws TransformException {
        String name = query.getName();
        if (name.equals("Dynamic") && query instanceof DynamicQuery) {
            AbstractQueryDef allDef = this.getQueryImpl(SELECTION_ALL_STATEMENT_NAME);
            DynamicQuery dq = (DynamicQuery)query;
            String sqlCondition = dq.getCondition();
            sqlCondition = " where " + sqlCondition;
            final Object[] values = dq.getParameterValues();
            return new QueryDefImpl(name, allDef.getTableName(), allDef.getDatabaseMetaInfo(), sqlCondition, new String[0], new String[0], new int[0]){

                public Object[] translateParams(Map params) throws TransformException {
                    return values;
                }

                public Object[] translateParams(Object[] params) throws TransformException {
                    return values;
                }
            };
        }
        if (name.equals("Static") && query instanceof StaticQuery) {
            AbstractQueryDef allDef = this.getQueryImpl(SELECTION_ALL_STATEMENT_NAME);
            final StaticQuery dq = (StaticQuery)query;
            final Object[] values = dq.getParameterValues();
            return new AbstractQueryDef(name, allDef.getTableName(), allDef.getDatabaseMetaInfo()){

                public Object[] translateParams(Map params) throws TransformException {
                    return values;
                }

                public Object[] translateParams(Object[] params) throws TransformException {
                    return values;
                }

                public String getSQL() {
                    return dq.getSQL();
                }

                public String getCountSQL() {
                    return dq.getSQL();
                }

                public String getSQLRange(int start, int count, DBDialect dialect, DatabaseMetaData databaseMetaData) throws TransformException {
                    String selectRangeClause = QueryDefImpl.getSelectRangeClause(start, count, dq.getSQL(), dialect, databaseMetaData);
                    return selectRangeClause;
                }
            };
        }
        return this.getQueryImpl(query.getName());
    }

    public QueryDef getQuery(String name) throws TransformException {
        return this.getMetaInfo().getQueryImpl(name);
    }

    AbstractQueryDef getQueryImpl(String name) throws TransformException {
        return this.getMetaInfo().getQueryImpl(name);
    }

    public QueryDef[] getQueries() {
        return this.getMetaInfo().getQueries();
    }

    private Connection initConnection() throws TransformException {
        try {
            Connection con = this.getConnection();
            return con;
        }
        catch (SQLException e) {
            this.handleSQLException(e, "SRT226", null);
            return null;
        }
    }

    private void exitConnection(boolean sqlError) throws TransformException {
        try {
            this.releaseConnection(sqlError);
        }
        catch (SQLException ex) {
            this.handleSQLException(ex, "SRT642", null);
        }
    }

    private Connection getConnection() throws SQLException, TransformException {
        if (!this.isConnectionPoolValid()) {
            this.closeConnectionPool();
        }
        if (this.connection == null) {
            this.connection = this.getConnectionPool().getConnection();
        }
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseConnection(boolean sqlError) throws SQLException, TransformException {
        try {
            if (this.connection != null) {
                this.getConnectionPool().releaseConnection(this.connection, sqlError);
            }
        }
        finally {
            this.connection = null;
        }
    }

    public String getNextString(KeyGeneratorInfo keyGeneratorInfo) throws TransformException {
        String toRet = this.getKeyGen(keyGeneratorInfo.dataSource).getNextString(keyGeneratorInfo);
        return toRet;
    }

    public long getNextLong(KeyGeneratorInfo keyGeneratorInfo) throws TransformException {
        return this.getKeyGen(keyGeneratorInfo.dataSource).getNextLong(keyGeneratorInfo);
    }

    public int getNextInt(KeyGeneratorInfo keyGeneratorInfo) throws TransformException {
        return this.getKeyGen(keyGeneratorInfo.dataSource).getNextInt(keyGeneratorInfo);
    }

    protected abstract NormalizedObject store(NormalizedObject var1) throws TransformException, SQLException;

    protected abstract void storeBatch(NormalizedObject[] var1) throws TransformException, SQLException;

    protected abstract int delete(NormalizedObject var1) throws TransformException, SQLException;

    protected abstract void load(ResultSet var1, NormalizedObject var2) throws TransformException, SQLException;

    public abstract NormalizedObject createNormalizedObject();

    protected abstract boolean isPersistent(NormalizedObject var1) throws TransformException, SQLException;

    protected void logSQL(String statement) {
        if (this.isTraceEnabled()) {
            this.getLogger().trace("[datasource=" + this.currentDataSourceName + "]" + "Executing " + statement);
        }
    }

    protected abstract DatabaseMetaInfo getMetaInfo();

    protected void checkBatchStatus(int[] results) throws TransformException, SQLException {
    }

    private void handleSQLException(SQLException e, String messageId, Connection con) throws TransformException {
        try {
            if (this.session != null) {
                this.session.sqlError = true;
            }
            if (con != null) {
                this.getConnectionPool().rollback(con);
            }
        }
        catch (SQLException ex) {
            // empty catch block
        }
        TransformSQLException tsqle = TransformSQLException.createTransformSQLExceptionFormatted(messageId, e.getMessage());
        tsqle.setDetail(e);
        tsqle.setContextProperty("Entity", this.name);
        throw tsqle;
    }

    public static String toSQLChar(char c) {
        return c + "";
    }

    public static String toSQLChar(Character c) {
        if (c != null) {
            return c + "";
        }
        return null;
    }

    public static Time toSQLTime(java.util.Date date) {
        if (date != null) {
            return new Time(date.getTime());
        }
        return null;
    }

    public static Timestamp toSQLTimestamp(java.util.Date date) {
        if (date != null) {
            return new Timestamp(date.getTime());
        }
        return null;
    }

    public static Date toSQLDate(Calendar date) {
        if (date != null) {
            return new Date(date.getTime().getTime());
        }
        return null;
    }

    public static Time toSQLTime(Calendar date) {
        if (date != null) {
            return new Time(date.getTime().getTime());
        }
        return null;
    }

    public static Timestamp toSQLTimestamp(Calendar date) {
        if (date != null) {
            return new Timestamp(date.getTime().getTime());
        }
        return null;
    }

    public static Date toSQLDate(java.util.Date date) {
        if (date != null) {
            return new Date(date.getTime());
        }
        return null;
    }

    public static BigDecimal toBigDecimal(BigInteger bigInteger) {
        if (bigInteger != null) {
            return new BigDecimal(bigInteger);
        }
        return null;
    }

    public static BigDecimal toBigDecimal(long longValue) {
        return BigDecimal.valueOf(longValue);
    }

    public static BigDecimal toBigDecimal(ScaledDecimal scaledDecimal) {
        if (scaledDecimal != null) {
            return scaledDecimal.bigDecimalValue();
        }
        return null;
    }

    public static BigInteger fromBigDecimaltoBigInteger(BigDecimal bigDecimal) {
        if (bigDecimal != null) {
            return bigDecimal.toBigInteger();
        }
        return null;
    }

    public static ScaledDecimal fromBigDecimaltoScaledDecimal(BigDecimal bigDecimal) {
        if (bigDecimal != null) {
            return ScaledDecimal.valueOf(bigDecimal);
        }
        return null;
    }

    protected static long fromBigDecimaltoLong(BigDecimal bigDecimal) {
        if (bigDecimal != null) {
            return bigDecimal.longValue();
        }
        return 0L;
    }

    protected static java.util.Date fromSQLDate(Date date) {
        if (date != null) {
            return new java.util.Date(date.getTime());
        }
        return null;
    }

    protected static java.util.Date fromSQLTime(Time date) {
        if (date != null) {
            return new java.util.Date(date.getTime());
        }
        return null;
    }

    protected static java.util.Date fromSQLTimestamp(Timestamp date) {
        if (date != null) {
            return new java.util.Date(date.getTime());
        }
        return null;
    }

    protected static Calendar fromSQLDateToISODate(Date date) {
        if (date != null) {
            return DateFunctions.toISODate(AbstractPersistenceManager.fromSQLDate(date));
        }
        return null;
    }

    protected static Calendar fromSQLTimeToISODate(Time date) {
        if (date != null) {
            return DateFunctions.toISODate(AbstractPersistenceManager.fromSQLTime(date));
        }
        return null;
    }

    protected static Calendar fromSQLTimestampToISODate(Timestamp date) {
        if (date != null) {
            return DateFunctions.toISODate(AbstractPersistenceManager.fromSQLTimestamp(date));
        }
        return null;
    }

    protected static char fromSQLChar(String sqlChar) {
        if (sqlChar != null && sqlChar.length() > 0) {
            return sqlChar.charAt(0);
        }
        return ' ';
    }

    protected static RawMessage toRawMessage(InputStream is) throws TransformException {
        try {
            if (is == null) {
                return null;
            }
            StreamInputSource inputSource = new StreamInputSource(is);
            return new ByteArrayInputSource(inputSource.getAsBytes());
        }
        catch (IOException ioe) {
            throw new TransformException(ioe.getMessage(), ioe);
        }
    }

    protected static byte[] fromInputStream(InputStream is) throws TransformException {
        try {
            if (is == null) {
                return null;
            }
            StreamInputSource inputSource = new StreamInputSource(is);
            return inputSource.getAsBytes();
        }
        catch (IOException ioe) {
            throw new TransformException(ioe.getMessage(), ioe);
        }
    }

    protected static void setBytes(PreparedStatement ps, int index, byte[] bytes) throws SQLException {
        ps.setBinaryStream(index, (InputStream)new ByteArrayInputStream(bytes), bytes.length);
    }

    protected static void setBlob(PreparedStatement ps, int index, byte[] bytes) throws SQLException {
        ps.setBinaryStream(index, (InputStream)new ByteArrayInputStream(bytes), bytes.length);
    }

    protected static void setBytes(PreparedStatement ps, int index, RawMessage bytes) throws SQLException {
        try {
            ps.setBinaryStream(index, bytes.getAsStream(), bytes.getLength());
        }
        catch (TransformException e) {
            SQLException sqlException = new SQLException("Error persisting Raw Message");
            sqlException.initCause(e);
            throw sqlException;
        }
    }

    protected static void setBlob(PreparedStatement ps, int index, RawMessage bytes) throws SQLException {
        try {
            ps.setBinaryStream(index, bytes.getAsStream(), bytes.getLength());
        }
        catch (TransformException e) {
            SQLException sqlException = new SQLException("Error persisting Raw Message");
            sqlException.initCause(e);
            throw sqlException;
        }
    }

    protected static String fromInputReader(Reader is) throws TransformException {
        try {
            if (is == null) {
                return null;
            }
            String str = AbstractPersistenceManager.readReader(is);
            return str;
        }
        catch (IOException ioe) {
            throw new TransformException(ioe.getMessage(), ioe);
        }
    }

    private static String readReader(Reader is) throws IOException {
        int read;
        int total = 0;
        int alloc = 2048;
        char[] bytes = new char[alloc];
        while ((read = is.read(bytes, total, alloc - total)) != -1) {
            if (alloc - (total += read) != 0) continue;
            char[] expandedBytes = new char[alloc *= 2];
            System.arraycopy(bytes, 0, expandedBytes, 0, total);
            bytes = expandedBytes;
        }
        return new String(bytes, 0, total);
    }

    protected static void setClobString(PreparedStatement ps, int index, String str) throws SQLException {
        ps.setCharacterStream(index, (Reader)new StringReader(str), str.length());
    }

    protected final void parse(DataObject obj, byte[] bytes) throws TransformException {
        this.messageXMLSupport.parse(obj, ExceptionHandler.DRACONIAN_EXCEPTION_HANDLER, new ByteArrayInputSource(bytes), this.createEmptyContext());
    }

    protected final void parse(DataObject obj, String str) throws TransformException {
        this.messageXMLSupport.parse(obj, ExceptionHandler.DRACONIAN_EXCEPTION_HANDLER, new StringInputSource(str), this.createEmptyContext());
    }

    protected byte[] serialize(DataObject dataObj) throws TransformException {
        RawMessage message = this.messageXMLSupport.write(dataObj, ExceptionHandler.DRACONIAN_EXCEPTION_HANDLER, this.createEmptyContext());
        return message.getAsBytes();
    }

    protected String serializeToString(DataObject dataObj) throws TransformException {
        RawMessage message = this.messageXMLSupport.write(dataObj, ExceptionHandler.DRACONIAN_EXCEPTION_HANDLER, this.createEmptyContext());
        return message.getAsString();
    }

    static class CollectionHandler
    implements MessageHandler {
        private Collection collection;

        CollectionHandler(Collection collection) {
            this.collection = collection;
        }

        public boolean handleMessage(DataObject obj, TransformContext cxt) throws TransformException {
            this.collection.add(obj);
            return true;
        }
    }
}

