/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.lang.CharBinaryBuffer;
import com.tplus.transform.lang.FastStringBuffer;
import com.tplus.transform.runtime.Binary;
import com.tplus.transform.runtime.DeviceInfo;
import com.tplus.transform.runtime.PropertyMapDelegate;
import com.tplus.transform.runtime.RawMessage;
import com.tplus.transform.runtime.StandardRuntimeResource;
import com.tplus.transform.runtime.SubRawMessage;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.TransformRuntimeException;
import com.tplus.transform.runtime.collection.RawMessageList;
import com.tplus.transform.runtime.collection.StringList;
import com.tplus.transform.runtime.log.LogFactory;
import com.tplus.transform.util.StringUtils;
import com.tplus.transform.util.UUID;
import com.tplus.transform.util.log.Log;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

public abstract class AbstractRawMessage
extends PropertyMapDelegate
implements RawMessage {
    protected static Log log = LogFactory.getRuntimeLog();
    private Map _attachments;
    protected String specifiedEncoding;
    protected String encoding = PLATFORM_DEFAULT_ENCODING;
    String messageName = null;
    protected String id;
    protected static final String ATTEMPT_TO_MODIFY_A_READ_ONLY_MESSAGE = "Attempt to modify a read only message";
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProperties(Map props) {
        if (props != null) {
            Map map = props;
            synchronized (map) {
                for (Map.Entry entry : props.entrySet()) {
                    this.setProperty((String)entry.getKey(), entry.getValue());
                }
            }
        }
    }

    public String getName() {
        return this.messageName;
    }

    public void setName(String inputSourceName) {
        this.messageName = inputSourceName;
    }

    public int getLength() throws TransformException {
        Object o = this.getAsObject();
        if (o instanceof Binary) {
            return ((Binary)o).getLength();
        }
        if (o instanceof byte[]) {
            return ((byte[])o).length;
        }
        if (o instanceof String) {
            return ((String)o).length();
        }
        return this.getAsBytes().length;
    }

    public long getLongLength() throws TransformException {
        return this.getLength();
    }

    public String getUniqueId() {
        if (this.id == null) {
            this.id = UUID.randomUUID().toString();
        }
        return this.id;
    }

    public InputStream getAsStream() throws TransformException {
        return new ByteArrayInputStream(this.getAsBytes());
    }

    public Object getReplyTo() {
        return this.getProperty("replyTo");
    }

    public RawMessage subMessage(long start_index, int num_chars) throws TransformException {
        return new SubRawMessage(this, start_index, num_chars);
    }

    public void setReplyTo(Object replyTo) {
        if (replyTo != null) {
            this.setProperty("replyTo", replyTo);
        } else {
            this.removeProperty("replyTo");
        }
    }

    public String getCorrelationId() {
        return (String)this.getProperty("correlationId");
    }

    public void setCorrelationId(String correlationId) {
        if (StringUtils.isEmpty(correlationId)) {
            this.setProperty("correlationId", correlationId);
        } else {
            this.removeProperty("correlationId");
        }
    }

    public void addAttachment(String name, RawMessage rawMessage) {
        this.getAttachmentMap().put(name, rawMessage);
    }

    public void removeAttachment(String name) {
        this.getAttachmentMap().remove(name);
    }

    public void removeAllAttachments() {
        this.getAttachmentMap().clear();
    }

    public RawMessage getAttachment(String name) {
        return (RawMessage)this.getAttachmentMap().get(name);
    }

    public boolean hasAttachment(String name) {
        return this.getAttachmentMap().get(name) != null;
    }

    public Set getAttachmentNames() {
        return this.getAttachmentMap().keySet();
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.specifiedEncoding = encoding;
        this.encoding = encoding;
    }

    public String getSpecifiedEncoding() {
        return this.specifiedEncoding;
    }

    public boolean isBinary() {
        return true;
    }

    public int getByte(long at) throws TransformException {
        byte[] oneByte = new byte[1];
        int count = this.getBytes(at, oneByte, 0, 1);
        if (count >= 1) {
            return oneByte[0] & 0xFF;
        }
        return -1;
    }

    public int getBytes(long start_index, byte[] toRet, int destLocation, int num_chars) throws TransformException {
        byte[] bytes = this.getAsBytes();
        int length = bytes.length;
        start_index = Math.min(Math.max(0L, start_index), (long)length);
        num_chars = (int)Math.min((long)length - start_index, (long)num_chars);
        System.arraycopy(bytes, (int)start_index, toRet, destLocation, num_chars);
        return num_chars;
    }

    public void append(byte[] bytes) throws TransformException {
        throw StandardRuntimeResource.createUnsupportedOperationException("SRT668");
    }

    public void append(byte[] bytes, int start, int byteLength) throws TransformException {
        throw StandardRuntimeResource.createUnsupportedOperationException("SRT668");
    }

    public void append(char c) throws TransformException {
    }

    public void append(CharSequence csq, int start, int end) throws IOException {
    }

    public void append(String bytes) throws TransformException {
        throw StandardRuntimeResource.createUnsupportedOperationException("SRT668");
    }

    public void append(RawMessage message) throws TransformException {
        throw StandardRuntimeResource.createUnsupportedOperationException("SRT668");
    }

    public String getAsString() throws TransformException {
        return this.getAsString(this.getEncoding());
    }

    public byte[] getAsBytes() throws TransformException {
        Object asObject = this.getAsObject();
        return this.convertToBytes(asObject);
    }

    public final Binary getAsBinary() throws TransformException {
        Object asObject = this.getAsObject();
        return this.convertToBinary(asObject);
    }

    public String getAsString(String encoding) throws TransformException {
        Object asObject = this.getAsObject();
        return this.convertToString(asObject, encoding);
    }

    protected byte[] convertToBytes(Object object) throws TransformException {
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        if (object instanceof Binary) {
            Binary binary = (Binary)object;
            return binary.getAsBytes();
        }
        if (object instanceof String) {
            try {
                return CharBinaryBuffer.stringToBytes((String)object, this.getEncoding());
            }
            catch (UnsupportedEncodingException e) {
                TransformException te = TransformException.createFormatted("SRT669");
                te.setDetail(e);
                throw te;
            }
        }
        throw TransformException.createFormatted("SRT670", new Object[]{object.getClass().getName(), Serializable.class.getName()});
    }

    protected Binary convertToBinary(Object object) throws TransformException {
        if (object instanceof Binary) {
            return (Binary)object;
        }
        if (object instanceof byte[]) {
            return new Binary((byte[])object);
        }
        if (object instanceof String) {
            try {
                if (log.isTraceEnabled()) {
                    log.trace("Converting string to bytes using encoding " + this.getEncoding());
                }
                return new Binary(CharBinaryBuffer.stringToBytes((String)object, this.getEncoding()));
            }
            catch (UnsupportedEncodingException e) {
                TransformException te = TransformException.createFormatted("SRT669");
                te.setDetail(e);
                throw te;
            }
        }
        throw TransformException.createFormatted("SRT670", new Object[]{object.getClass().getName(), Serializable.class.getName()});
    }

    protected String convertToString(Object object, String encoding) throws TransformException {
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Binary) {
            Binary binary = (Binary)object;
            return binary.bytesToString(encoding);
        }
        if (object instanceof byte[]) {
            try {
                return CharBinaryBuffer.bytesToString((byte[])object, encoding);
            }
            catch (UnsupportedEncodingException e) {
                TransformException te = TransformException.createFormatted("SRT669");
                te.setDetail(e);
                throw te;
            }
        }
        throw new TransformException("Conversion error found class " + object.getClass().getName() + ". Expected byte[] or String");
    }

    protected String convertToString(Object object, String encoding, int start, int length) throws TransformException {
        if (object instanceof String) {
            return ((String)object).substring(start, start + length);
        }
        if (object instanceof Binary) {
            Binary binary = (Binary)object;
            binary = binary.sub(start + start + length);
            return binary.bytesToString(encoding);
        }
        if (object instanceof byte[]) {
            try {
                return CharBinaryBuffer.bytesToString((byte[])object, encoding);
            }
            catch (UnsupportedEncodingException e) {
                TransformException te = TransformException.createFormatted("SRT669");
                te.setDetail(e);
                throw te;
            }
        }
        throw new TransformException("Conversion error " + object.getClass().getName() + "byte[] or " + String.class.getName());
    }

    public RawMessageList getAttachments() {
        RawMessageList toRet = new RawMessageList();
        if (this._attachments != null) {
            toRet.addAll(this._attachments.values());
        }
        return toRet;
    }

    private Map getAttachmentMap() {
        if (this._attachments == null) {
            this._attachments = new Hashtable();
        }
        return this._attachments;
    }

    public String toString() {
        try {
            StringBuffer toRet = new StringBuffer();
            if (this._properties != null) {
                for (String string : this._properties.getPropertyNames()) {
                    toRet.append(string).append(":").append(this._properties.getProperty(string)).append('\n');
                }
            }
            toRet.append(this.getAsString());
            if (this._attachments != null) {
                toRet.append("\n");
                for (Map.Entry entry : this._attachments.entrySet()) {
                    String s = (String)entry.getKey();
                    RawMessage attachedMessage = (RawMessage)entry.getValue();
                    toRet.append("-----=").append(s).append('\n');
                    toRet.append(attachedMessage.toString());
                }
            }
            return toRet.toString();
        }
        catch (TransformException e) {
            return "ToString error" + e.toXMLString();
        }
    }

    public Object clone() {
        AbstractRawMessage cloned = (AbstractRawMessage)super.clone();
        if (this._attachments != null) {
            cloned._attachments = new Hashtable();
            for (Map.Entry entry : this._attachments.entrySet()) {
                String s = (String)entry.getKey();
                RawMessage attachedMessage = (RawMessage)entry.getValue();
                cloned._attachments.put(s, attachedMessage.clone());
            }
        }
        return cloned;
    }

    public void dispose() throws TransformException {
    }

    public DeviceInfo getDeviceInfo() {
        return new DeviceInfo("", "", "", null);
    }

    public static void copyProperties(RawMessage source, RawMessage dest) {
        StringList propertyNames = source.getPropertyNames();
        for (int i = 0; i < propertyNames.size(); ++i) {
            String name = (String)propertyNames.get(i);
            Object value = source.getProperty(name);
            dest.setProperty(name, value);
        }
    }

    public void write(Object toSend) throws TransformException {
        if (toSend instanceof byte[]) {
            this.append((byte[])toSend);
        } else if (toSend instanceof String) {
            this.append((String)toSend);
        } else if (toSend instanceof StringBuffer) {
            this.append(toSend.toString());
        } else if (toSend instanceof RawMessage) {
            this.append((RawMessage)toSend);
        }
    }

    public static void writeObject(RawMessage rawMessage, Object toSend) throws TransformException {
        if (toSend instanceof Object[]) {
            Object[] objects = (Object[])toSend;
            for (int i = 0; i < objects.length; ++i) {
                Object object = objects[i];
                AbstractRawMessage.writeObject(rawMessage, object);
            }
            return;
        }
        if (toSend == null) {
            return;
        }
        if (toSend instanceof byte[]) {
            rawMessage.append((byte[])toSend);
        } else if (toSend instanceof String) {
            rawMessage.append((String)toSend);
        } else if (toSend instanceof StringBuffer || toSend instanceof FastStringBuffer) {
            rawMessage.append(toSend.toString());
        } else if (toSend instanceof RawMessage) {
            rawMessage.append((RawMessage)toSend);
        } else {
            throw TransformException.createFormatted("SRT425", rawMessage.getClass().getName());
        }
    }

    public void close() throws TransformException {
        this.dispose();
    }

    public static void verifyEncoding(String encodingForMessage) {
        try {
            CharBinaryBuffer.verifyEncoding(encodingForMessage);
        }
        catch (UnsupportedEncodingException e) {
            throw new TransformRuntimeException("Unsupported encoding " + encodingForMessage, e);
        }
    }

    public static Object getAsBytesOrString(RawMessage raw) throws TransformException {
        Object asObject = raw.getAsObject();
        if (asObject instanceof Binary) {
            Binary binary = (Binary)asObject;
            return binary.getAsBytes();
        }
        return asObject;
    }
}

