/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.ExceptionObject;
import com.tplus.transform.runtime.LookupContext;
import com.tplus.transform.runtime.LookupContextFactory;
import com.tplus.transform.runtime.ServiceElement;
import com.tplus.transform.runtime.TransformContext;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.TransformRuntimeException;
import com.tplus.transform.runtime.log.LogFactory;
import com.tplus.transform.runtime.vm.EntityInfo;
import com.tplus.transform.runtime.vm.Location;
import com.tplus.transform.runtime.vm.OperationInfo;
import com.tplus.transform.runtime.vm.StackFrame;
import com.tplus.transform.runtime.vm.VolanteVM;
import com.tplus.transform.runtime.vm.VolanteVMImpl;
import com.tplus.transform.util.log.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import javax.naming.NamingException;

public abstract class AbstractServiceElement
implements ServiceElement {
    transient VolanteVM vm = VolanteVMImpl.getInstance();
    String entityName;
    String entityType;
    private LookupContext lcxt;
    protected EntityInfo instanceEntityInfo;
    private Log log;
    private boolean traceEnabled;
    private static final int VARIABLE_UPDATE_LOCATION_INDEX = -100;
    StackFrame currentFrame;
    private boolean entered;
    OperationInfo currentOperationInfo;

    protected AbstractServiceElement(String entityName, String entityType) {
        this.entityName = entityName;
        this.entityType = entityType;
    }

    public Log getLogger() {
        if (this.log == null) {
            return LogFactory.getRuntimeLog();
        }
        return this.log;
    }

    protected void setLogger(Log log) {
        this.log = log;
        this.traceEnabled = log.isTraceEnabled();
    }

    protected boolean isTraceEnabled() {
        return this.traceEnabled;
    }

    protected boolean isInfoEnabled() {
        return this.getLogger().isInfoEnabled();
    }

    protected boolean isDebugEnabled() {
        return this.getLogger().isDebugEnabled();
    }

    protected boolean isWarnEnabled() {
        return this.getLogger().isWarnEnabled();
    }

    protected boolean isLogEnabled() {
        return this.getLogger() != null;
    }

    protected boolean isFatalEnabled() {
        return this.getLogger().isFatalEnabled();
    }

    protected boolean isErrorEnabled() {
        return this.getLogger().isErrorEnabled();
    }

    protected void onStartOperation() {
        this.traceEnabled = this.log.isTraceEnabled();
    }

    protected void trace(String operation) {
        if (this.traceEnabled) {
            this.log.trace(operation + " " + this.getEntityName());
        }
    }

    protected void trace(String operation, String variant) {
        if (this.traceEnabled) {
            this.log.trace(operation + variant + " " + this.getEntityName());
        }
    }

    protected void trace(String operation, String variant, String suboperation) {
        if (this.traceEnabled) {
            this.log.trace(operation + variant + "(" + suboperation + ")" + " " + this.getEntityName());
        }
    }

    protected void addTraceToException(ExceptionObject e) {
        e.addTrace(this.entityType, this.entityName, this.getActiveElementName());
    }

    protected void addTraceToException(TransformRuntimeException e) {
        e.addTrace(this.entityType, this.entityName, this.getActiveElementName());
    }

    protected List updateExceptionTrace(List exceptions) {
        return TransformException.updateExceptionTrace(exceptions, this.entityType, this.entityName, this.getActiveElementName());
    }

    protected Object handleTransformException(Throwable e) throws TransformException {
        if (e instanceof TransformException) {
            TransformException transformException = (TransformException)e;
            this.addTraceToException(transformException);
            throw transformException;
        }
        if (e instanceof TransformRuntimeException) {
            TransformRuntimeException transformException = (TransformRuntimeException)e;
            this.addTraceToException(transformException);
            throw transformException;
        }
        if (e instanceof Error) {
            Error error = (Error)e;
            throw error;
        }
        if (e instanceof RuntimeException) {
            RuntimeException error = (RuntimeException)e;
            throw error;
        }
        TransformRuntimeException tre = TransformRuntimeException.createFormatted("SRT625", e.getMessage());
        tre.setDetail(e);
        throw tre;
    }

    public String getActiveElementName() {
        if (this.currentOperationInfo != null) {
            return this.currentOperationInfo.getName();
        }
        return null;
    }

    protected LookupContext getLookupContext() throws NamingException {
        if (this.lcxt == null) {
            Hashtable props = new Hashtable();
            this.lcxt = LookupContextFactory.getLookupContext(this.getClass(), props);
        }
        return this.lcxt;
    }

    public void setLookupContext(LookupContext lcxt) {
        this.lcxt = lcxt;
    }

    public String getEntityName() {
        return this.entityName;
    }

    protected void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public String getEntityType() {
        return this.entityType;
    }

    protected void setEntityType(String entityType) {
        this.entityType = entityType;
    }

    protected void onOperationEnter(OperationInfo operationInfo, String variableName1, Object variable1, TransformContext cxt) {
        if (this.vm.hasListeners()) {
            List<Object> list = Collections.singletonList(this.vm.createVariableInfo(variableName1, variable1));
            this.onOperationEnter(operationInfo, list);
        } else {
            this.onOperationEnter(operationInfo, Collections.EMPTY_LIST);
        }
    }

    protected void onOperationEnter(OperationInfo operationInfo, String[] variableNames, Object[] variables, TransformContext cxt) {
        if (this.vm.hasListeners()) {
            ArrayList<Object> variableInfos = new ArrayList<Object>();
            for (int i = 0; i < variableNames.length; ++i) {
                String variableName = variableNames[i];
                Object variableInfo = this.vm.createVariableInfo(variableName, variables[i]);
                variableInfos.add(variableInfo);
            }
            this.onOperationEnter(operationInfo, variableInfos);
        } else {
            this.onOperationEnter(operationInfo, Collections.EMPTY_LIST);
        }
    }

    protected void onOperationEnter(OperationInfo operationInfo, TransformContext cxt) {
        List list = Collections.EMPTY_LIST;
        this.onOperationEnter(operationInfo, list);
    }

    protected void onOperationEnter(OperationInfo operationInfo, String variableName1, Object variable1, String variableName2, Object variable2, TransformContext cxt) {
        if (this.vm.hasListeners()) {
            List variables = this.createNameValues(variableName1, variable1, variableName2, variable2);
            this.onOperationEnter(operationInfo, variables);
        } else {
            this.onOperationEnter(operationInfo, Collections.EMPTY_LIST);
        }
    }

    private List createNameValues(String variableName1, Object variable1, String variableName2, Object variable2) {
        ArrayList<Object> list = new ArrayList<Object>(2);
        list.add(this.vm.createVariableInfo(variableName1, variable1));
        list.add(this.vm.createVariableInfo(variableName2, variable2));
        return list;
    }

    protected void onOperationEnter(OperationInfo operationInfo, List list) {
        this.currentOperationInfo = operationInfo;
        if (this.vm.hasListeners()) {
            this.entered = true;
            this.currentFrame = this.vm.onEnter(operationInfo, null, list);
        }
    }

    public boolean isEntered() {
        return this.currentFrame != null;
    }

    protected void onOperationExit(OperationInfo operationInfo) {
        this.currentOperationInfo = null;
        if (this.currentFrame != null) {
            this.vm.onExit(this.currentFrame);
            this.entered = false;
            this.currentFrame = null;
        }
    }

    public void onStatement(Location location) {
        if (this.isEntered()) {
            this.currentFrame.onStatement(location);
        }
    }

    public void onStatement(Location location, String[] names, Object[] values) {
        if (this.isEntered()) {
            this.currentFrame.onStatement(location, names, values);
        }
    }

    public void onStatement(int index) {
        Location location;
        if (this.isEntered() && (location = this.currentFrame.getOperationInfo().getLocation(index)) != null) {
            this.currentFrame.onStatement(location);
        }
    }

    public void onSubstatement(int index, String[] names, Object[] values) {
        Location location;
        if (this.isEntered() && (location = this.currentFrame.getOperationInfo().getLocation(index)) != null) {
            this.currentFrame.onSubstatement(location, names, values);
        }
    }

    public void onSubstatementDelta(int index) {
        Location location;
        if (this.isEntered() && (location = this.currentFrame.getOperationInfo().getLocation(index)) != null) {
            this.currentFrame.onSubstatementDelta(location);
        }
    }

    public void onSubstatementDelta(int index, String[] names, Object[] values) {
        Location location;
        if (this.isEntered() && ((location = this.currentFrame.getOperationInfo().getLocation(index)) != null || index == -100)) {
            this.currentFrame.onSubstatementDelta(location, names, values);
        }
    }

    public void onSubstatementDelta(Location location, String[] names, Object[] values) {
        if (this.isEntered()) {
            this.currentFrame.onSubstatementDelta(location, names, values);
        }
    }

    public void onSubstatement(Location location, String[] names, Object[] values) {
        if (this.isEntered()) {
            this.currentFrame.onSubstatement(location, names, values);
        }
    }

    public void onVariableUpdate(String varName, Object value) {
        this.vm.onVariableUpdate(this.currentFrame, varName, value);
    }

    protected void registerEntity(EntityInfo entityInfo) {
        this.vm.registerEntity(entityInfo);
    }
}

