/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.AbstractOutputFormat;
import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DeviceInfo;
import com.tplus.transform.runtime.ExceptionHandler;
import com.tplus.transform.runtime.ExternalObjectImpl;
import com.tplus.transform.runtime.NormalizedObject;
import com.tplus.transform.runtime.OutputDevice;
import com.tplus.transform.runtime.OutputProtocol;
import com.tplus.transform.runtime.OutputWriter;
import com.tplus.transform.runtime.SimpleOutputWriter;
import com.tplus.transform.runtime.TransformContext;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.TransformRuntimeException;
import com.tplus.transform.runtime.io.OutputMessageDevice;
import java.rmi.RemoteException;

public abstract class AbstractSimpleOutputFormat
extends AbstractOutputFormat {
    private SimpleOutputWriter getSimpleOutputWriter() throws TransformException {
        OutputWriter writer = this.getOutputWriter();
        if (writer instanceof SimpleOutputWriter) {
            return (SimpleOutputWriter)writer;
        }
        throw TransformException.createFormatted("SRT215");
    }

    public final void writeBatchStart(TransformContext tcxt) throws TransformException, RemoteException {
    }

    public final void writeBatchEnd(TransformContext tcxt) throws TransformException, RemoteException {
    }

    public Object map(NormalizedObject no, TransformContext tcxt) throws TransformException, RemoteException {
        tcxt.setProperty("output.device", "local");
        Object output = this.prepareOutput(no, tcxt);
        OutputMessageDevice device = new OutputMessageDevice(this.createDeviceInfo(tcxt));
        AbstractSimpleOutputFormat.writeOutput(output, device);
        return device.getAsBytes();
    }

    public void write(NormalizedObject no, TransformContext tcxt) throws TransformException, RemoteException {
        try {
            OutputProtocol outputProtocol = this.getOutputProtocol(tcxt);
            DeviceInfo deviceInfo = this.createDeviceInfo(tcxt);
            Object output = this.prepareOutput(no, tcxt);
            OutputDevice device = outputProtocol.createDevice(deviceInfo, tcxt);
            AbstractSimpleOutputFormat.writeOutput(output, device);
        }
        catch (TransformException e) {
            e.setErrorPhase("Output");
            throw e;
        }
        catch (TransformRuntimeException re) {
            TransformException e = TransformException.createFormatted("SRT216", re.getMessage());
            e.setErrorPhase("Output");
            e.setDetail(re);
            throw e;
        }
        catch (RemoteException e) {
            log.remotingError(e);
            TransformException ex = TransformException.createFormatted("SRT217", e.getMessage());
            ex.setErrorPhase("Output");
            ex.setDetail(e);
            throw ex;
        }
        catch (Exception re) {
            TransformException e = TransformException.createFormatted("SRT216", re.getMessage());
            e.setErrorPhase("Output");
            e.setDetail(re);
            throw e;
        }
    }

    protected Object prepareOutput(NormalizedObject no, TransformContext tcxt) throws TransformException, RemoteException {
        boolean writeASXML = false;
        DataObject header = this.createHeader();
        this.mapHeader(no, header, tcxt);
        DataObject recordData = this.createRecordData();
        this.mapData(no, header, recordData, tcxt);
        DataObject trailer = this.createTrailer();
        this.mapTrailer(no, recordData, trailer, tcxt);
        ExternalObjectImpl outputObject = new ExternalObjectImpl("", header, recordData, trailer);
        SimpleOutputWriter writer = this.getSimpleOutputWriter();
        if (writeASXML) {
            return outputObject.toXMLString();
        }
        return writer.write(outputObject, ExceptionHandler.DRACONIAN_EXCEPTION_HANDLER, tcxt);
    }
}

