/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.AbstractRawMessage;
import com.tplus.transform.runtime.AbstractServiceElement;
import com.tplus.transform.runtime.ExceptionHandler;
import com.tplus.transform.runtime.ExternalObject;
import com.tplus.transform.runtime.OperationNode;
import com.tplus.transform.runtime.RawMessage;
import com.tplus.transform.runtime.SimpleOutputWriter;
import com.tplus.transform.runtime.SimpleOutputWriter2;
import com.tplus.transform.runtime.TransformContext;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.log.LogFactory;

public abstract class AbstractSimpleOutputWriterBase
extends OperationNode
implements SimpleOutputWriter,
SimpleOutputWriter2 {
    private TransformContext transformContext;
    private ExceptionHandler exceptionHandler = ExceptionHandler.DRACONIAN_EXCEPTION_HANDLER;
    protected RawMessage outputMessage;

    public AbstractSimpleOutputWriterBase(AbstractServiceElement serviceElement) {
        super(serviceElement);
        if (serviceElement != null) {
            String name = serviceElement.getEntityName();
            this.setLogger(LogFactory.getParserLog(name));
        } else {
            this.setLogger(LogFactory.getRuntimeLog());
        }
    }

    public TransformContext getTransformContext() {
        return this.transformContext;
    }

    protected void setup(TransformContext cxt) {
        this.transformContext = cxt;
    }

    protected void teardown(TransformContext cxt) {
        this.transformContext = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object write(ExternalObject externalObject, ExceptionHandler exceptionHandler, TransformContext tcxt) throws TransformException {
        this.setExceptionHandler(exceptionHandler);
        this.setup(tcxt);
        try {
            Object object = this.write(externalObject, tcxt);
            return object;
        }
        finally {
            this.teardown(tcxt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(ExternalObject externalObject, RawMessage rawMessage, ExceptionHandler exceptionHandler, TransformContext tcxt) throws TransformException {
        try {
            this.outputMessage = rawMessage;
            Object output = this.write(externalObject, exceptionHandler, tcxt);
            if (output != null) {
                AbstractRawMessage.writeObject(this.outputMessage, output);
            }
            this.outputMessage = null;
        }
        finally {
            this.teardown(tcxt);
        }
    }

    public abstract Object write(ExternalObject var1, TransformContext var2) throws TransformException;

    protected final ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public final void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }
}

