/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime;

import com.tplus.transform.runtime.BusinessTransaction;
import com.tplus.transform.runtime.OutputFormat;
import com.tplus.transform.runtime.TransformContext;
import com.tplus.transform.runtime.TransformContextWrapper;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.handler.ITrigger;
import com.tplus.transform.runtime.handler.TriggerContext;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.naming.NamingException;

public abstract class AbstractTrigger
implements ITrigger {
    protected TriggerContext cxt;
    protected Map outputFormats = new HashMap();
    protected Map businessTransactions = new HashMap();
    protected TransformContextWrapper overridingContext;

    protected AbstractTrigger() {
    }

    protected TriggerContext getTriggerContext() {
        return this.cxt;
    }

    public void setContext(TriggerContext cxt) {
        this.cxt = cxt;
        this.overridingContext = new TransformContextWrapper();
        this.overridingContext.putAll(cxt.getProperties());
        this.overridingContext.setProperty("output.destination", cxt.getIdentity());
    }

    protected TransformContext getTransformContext(TransformContext tcxt) {
        this.overridingContext.setTransformContext(tcxt);
        return this.overridingContext;
    }

    public Object execute(Properties props) throws TransformException {
        throw TransformException.createFormatted("SRT114");
    }

    protected OutputFormat getOutputFormat(String name) throws TransformException {
        if (name == null) {
            throw TransformException.createFormatted("SRT210");
        }
        try {
            OutputFormat outputFormat = (OutputFormat)this.outputFormats.get(name);
            if (outputFormat == null) {
                outputFormat = this.cxt.lookupOutputFormat(name);
                this.outputFormats.put(name, outputFormat);
            }
            return outputFormat;
        }
        catch (NamingException e) {
            TransformException te = TransformException.createFormatted("SRT211", new Object[]{name});
            te.setDetail(e);
            throw te;
        }
    }

    protected BusinessTransaction getBusinessTransaction(String name) throws TransformException {
        if (name == null) {
            throw TransformException.createFormatted("SRT210");
        }
        try {
            BusinessTransaction bt = (BusinessTransaction)this.businessTransactions.get(name);
            if (bt == null) {
                bt = this.cxt.lookupBusinessTransaction(name);
                this.businessTransactions.put(name, bt);
            }
            return bt;
        }
        catch (NamingException e) {
            TransformException te = TransformException.createFormatted("SRT212", new Object[]{name});
            te.setDetail(e);
            throw te;
        }
    }
}

